/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util;

import com.appoptics.ext.io.netty.util.Constant;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConstantPool<T extends Constant<T>> {
    private final ConcurrentMap<String, T> constants = PlatformDependent.newConcurrentHashMap();
    private final AtomicInteger nextId = new AtomicInteger(1);

    public T valueOf(Class<?> clazz, String string) {
        return this.valueOf(ObjectUtil.checkNotNull(clazz, "firstNameComponent").getName() + '#' + ObjectUtil.checkNotNull(string, "secondNameComponent"));
    }

    public T valueOf(String string) {
        ConstantPool.checkNotNullAndNotEmpty(string);
        return this.getOrCreate(string);
    }

    private T getOrCreate(String string) {
        Constant constant = (Constant)this.constants.get(string);
        if (constant == null) {
            ConstantPool constantPool = this;
            T t2 = constantPool.newConstant(constantPool.nextId(), string);
            constant = (Constant)this.constants.putIfAbsent(string, t2);
            if (constant == null) {
                return t2;
            }
        }
        return (T)constant;
    }

    public T newInstance(String string) {
        ConstantPool.checkNotNullAndNotEmpty(string);
        return this.createOrThrow(string);
    }

    private T createOrThrow(String string) {
        Constant constant = (Constant)this.constants.get(string);
        if (constant == null) {
            ConstantPool constantPool = this;
            T t2 = constantPool.newConstant(constantPool.nextId(), string);
            constant = (Constant)this.constants.putIfAbsent(string, t2);
            if (constant == null) {
                return t2;
            }
        }
        throw new IllegalArgumentException(String.format("'%s' is already in use", string));
    }

    private static String checkNotNullAndNotEmpty(String string) {
        ObjectUtil.checkNotNull(string, "name");
        if (string.isEmpty()) {
            throw new IllegalArgumentException("empty name");
        }
        return string;
    }

    protected abstract T newConstant(int var1, String var2);

    @Deprecated
    public final int nextId() {
        return this.nextId.getAndIncrement();
    }
}

