/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.handler.ssl.ApplicationProtocolAccessor;
import com.appoptics.ext.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.appoptics.ext.io.netty.handler.ssl.CipherSuiteConverter;
import com.appoptics.ext.io.netty.handler.ssl.ClientAuth;
import com.appoptics.ext.io.netty.handler.ssl.ExtendedOpenSslSession;
import com.appoptics.ext.io.netty.handler.ssl.Java7SslParametersUtils;
import com.appoptics.ext.io.netty.handler.ssl.Java8SslUtils;
import com.appoptics.ext.io.netty.handler.ssl.OpenSsl;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslEngineMap;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslJavaxX509Certificate;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslSession;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslSessionContext;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslX509Certificate;
import com.appoptics.ext.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import com.appoptics.ext.io.netty.handler.ssl.SignatureAlgorithmConverter;
import com.appoptics.ext.io.netty.handler.ssl.SslUtils;
import com.appoptics.ext.io.netty.internal.tcnative.Buffer;
import com.appoptics.ext.io.netty.internal.tcnative.SSL;
import com.appoptics.ext.io.netty.util.AbstractReferenceCounted;
import com.appoptics.ext.io.netty.util.CharsetUtil;
import com.appoptics.ext.io.netty.util.ReferenceCounted;
import com.appoptics.ext.io.netty.util.ResourceLeakDetector;
import com.appoptics.ext.io.netty.util.ResourceLeakDetectorFactory;
import com.appoptics.ext.io.netty.util.ResourceLeakTracker;
import com.appoptics.ext.io.netty.util.internal.EmptyArrays;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.ThrowableUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.X509Certificate;

public class ReferenceCountedOpenSslEngine
extends SSLEngine
implements ApplicationProtocolAccessor,
ReferenceCounted {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslEngine.class);
    private static final ResourceLeakDetector<ReferenceCountedOpenSslEngine> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ReferenceCountedOpenSslEngine.class);
    private static final int[] OPENSSL_OP_NO_PROTOCOLS = new int[]{SSL.SSL_OP_NO_SSLv2, SSL.SSL_OP_NO_SSLv3, SSL.SSL_OP_NO_TLSv1, SSL.SSL_OP_NO_TLSv1_1, SSL.SSL_OP_NO_TLSv1_2, SSL.SSL_OP_NO_TLSv1_3};
    static final int MAX_PLAINTEXT_LENGTH = SSL.SSL_MAX_PLAINTEXT_LENGTH;
    private static final int MAX_RECORD_SIZE = SSL.SSL_MAX_RECORD_LENGTH;
    private static final SSLEngineResult NEED_UNWRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult NEED_UNWRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult NEED_WRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
    private static final SSLEngineResult NEED_WRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
    private static final SSLEngineResult CLOSED_NOT_HANDSHAKING = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
    private long ssl;
    private long networkBIO;
    private HandshakeState handshakeState = HandshakeState.NOT_STARTED;
    private boolean receivedShutdown;
    private volatile boolean destroyed;
    private volatile String applicationProtocol;
    private volatile boolean needTask;
    private final ResourceLeakTracker<ReferenceCountedOpenSslEngine> leak;
    private final AbstractReferenceCounted refCnt = new AbstractReferenceCounted(){

        public ReferenceCounted touch(Object object) {
            if (ReferenceCountedOpenSslEngine.this.leak != null) {
                ReferenceCountedOpenSslEngine.this.leak.record(object);
            }
            return ReferenceCountedOpenSslEngine.this;
        }

        protected void deallocate() {
            ReferenceCountedOpenSslEngine.this.shutdown();
            if (ReferenceCountedOpenSslEngine.this.leak != null) {
                boolean bl = ReferenceCountedOpenSslEngine.this.leak.close(ReferenceCountedOpenSslEngine.this);
                assert (bl);
            }
            ReferenceCountedOpenSslEngine.this.parentContext.release();
        }
    };
    private volatile ClientAuth clientAuth = ClientAuth.NONE;
    private volatile Certificate[] localCertificateChain;
    private volatile long lastAccessed = -1L;
    private String endPointIdentificationAlgorithm;
    private Object algorithmConstraints;
    private List<String> sniHostNames;
    private volatile Collection<?> matchers;
    private boolean isInboundDone;
    private boolean outboundClosed;
    final boolean jdkCompatibilityMode;
    private final boolean clientMode;
    final ByteBufAllocator alloc;
    private final OpenSslEngineMap engineMap;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final ReferenceCountedOpenSslContext parentContext;
    private final OpenSslSession session;
    private final ByteBuffer[] singleSrcBuffer = new ByteBuffer[1];
    private final ByteBuffer[] singleDstBuffer = new ByteBuffer[1];
    private final boolean enableOcsp;
    private int maxWrapOverhead;
    private int maxWrapBufferSize;
    private Throwable pendingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceCountedOpenSslEngine(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, ByteBufAllocator object, String string, int n2, boolean bl, boolean bl2) {
        super(string, n2);
        long l2;
        OpenSsl.ensureAvailability();
        this.alloc = ObjectUtil.checkNotNull(object, "alloc");
        this.apn = (OpenSslApplicationProtocolNegotiator)referenceCountedOpenSslContext.applicationProtocolNegotiator();
        this.clientMode = referenceCountedOpenSslContext.isClient();
        this.session = PlatformDependent.javaVersion() >= 7 ? new ExtendedOpenSslSession(new DefaultOpenSslSession(referenceCountedOpenSslContext.sessionContext())){
            private String[] peerSupportedSignatureAlgorithms;
            private List requestedServerNames;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List getRequestedServerNames() {
                if (ReferenceCountedOpenSslEngine.this.clientMode) {
                    return Java8SslUtils.getSniHostNames(ReferenceCountedOpenSslEngine.this.sniHostNames);
                }
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
                synchronized (referenceCountedOpenSslEngine) {
                    if (this.requestedServerNames == null) {
                        String string;
                        this.requestedServerNames = ReferenceCountedOpenSslEngine.this.isDestroyed() ? Collections.emptyList() : ((string = SSL.getSniHostname((long)ReferenceCountedOpenSslEngine.this.ssl)) == null ? Collections.emptyList() : Java8SslUtils.getSniHostName(SSL.getSniHostname((long)ReferenceCountedOpenSslEngine.this.ssl).getBytes(CharsetUtil.UTF_8)));
                    }
                    return this.requestedServerNames;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getPeerSupportedSignatureAlgorithms() {
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
                synchronized (referenceCountedOpenSslEngine) {
                    if (this.peerSupportedSignatureAlgorithms == null) {
                        if (ReferenceCountedOpenSslEngine.this.isDestroyed()) {
                            this.peerSupportedSignatureAlgorithms = EmptyArrays.EMPTY_STRINGS;
                        } else {
                            String[] stringArray = SSL.getSigAlgs((long)ReferenceCountedOpenSslEngine.this.ssl);
                            if (stringArray == null) {
                                this.peerSupportedSignatureAlgorithms = EmptyArrays.EMPTY_STRINGS;
                            } else {
                                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(stringArray.length);
                                for (String string : stringArray) {
                                    if ((string = SignatureAlgorithmConverter.toJavaName(string)) == null) continue;
                                    linkedHashSet.add(string);
                                }
                                this.peerSupportedSignatureAlgorithms = linkedHashSet.toArray(new String[0]);
                            }
                        }
                    }
                    return (String[])this.peerSupportedSignatureAlgorithms.clone();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<byte[]> getStatusResponses() {
                byte[] byArray = null;
                if (ReferenceCountedOpenSslEngine.this.enableOcsp && ReferenceCountedOpenSslEngine.this.clientMode) {
                    ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
                    synchronized (referenceCountedOpenSslEngine) {
                        if (!ReferenceCountedOpenSslEngine.this.isDestroyed()) {
                            byArray = SSL.getOcspResponse((long)ReferenceCountedOpenSslEngine.this.ssl);
                        }
                    }
                }
                if (byArray == null) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(byArray);
            }
        } : new DefaultOpenSslSession(referenceCountedOpenSslContext.sessionContext());
        this.engineMap = referenceCountedOpenSslContext.engineMap;
        this.enableOcsp = referenceCountedOpenSslContext.enableOcsp;
        if (!referenceCountedOpenSslContext.sessionContext().useKeyManager()) {
            this.localCertificateChain = referenceCountedOpenSslContext.keyCertChain;
        }
        this.jdkCompatibilityMode = bl;
        object = referenceCountedOpenSslContext.ctxLock.readLock();
        object.lock();
        try {
            l2 = SSL.newSSL((long)referenceCountedOpenSslContext.ctx, (!referenceCountedOpenSslContext.isClient() ? 1 : 0) != 0);
        }
        finally {
            object.unlock();
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            this.ssl = l2;
            try {
                this.networkBIO = SSL.bioNewByteBuffer((long)this.ssl, (int)referenceCountedOpenSslContext.getBioNonApplicationBufferSize());
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine2 = this;
                referenceCountedOpenSslEngine2.setClientAuth(referenceCountedOpenSslEngine2.clientMode ? ClientAuth.NONE : referenceCountedOpenSslContext.clientAuth);
                if (referenceCountedOpenSslContext.protocols != null) {
                    this.setEnabledProtocols(referenceCountedOpenSslContext.protocols);
                }
                if (this.clientMode && SslUtils.isValidHostNameForSNI(string)) {
                    SSL.setTlsExtHostName((long)this.ssl, (String)string);
                    this.sniHostNames = Collections.singletonList(string);
                }
                if (this.enableOcsp) {
                    SSL.enableOcsp((long)this.ssl);
                }
                if (!bl) {
                    SSL.setMode((long)this.ssl, (int)(SSL.getMode((long)this.ssl) | SSL.SSL_MODE_ENABLE_PARTIAL_WRITE));
                }
                this.calculateMaxWrapOverhead();
            }
            catch (Throwable throwable) {
                this.shutdown();
                PlatformDependent.throwException(throwable);
            }
        }
        this.parentContext = referenceCountedOpenSslContext;
        this.parentContext.retain();
        this.leak = bl2 ? leakDetector.track(this) : null;
    }

    public final int refCnt() {
        return this.refCnt.refCnt();
    }

    public final ReferenceCounted retain() {
        this.refCnt.retain();
        return this;
    }

    public final ReferenceCounted touch() {
        this.refCnt.touch();
        return this;
    }

    public final ReferenceCounted touch(Object object) {
        this.refCnt.touch(object);
        return this;
    }

    public final boolean release() {
        return this.refCnt.release();
    }

    public final synchronized SSLSession getHandshakeSession() {
        switch (this.handshakeState) {
            case NOT_STARTED: 
            case FINISHED: {
                return null;
            }
        }
        return this.session;
    }

    public final synchronized long sslPointer() {
        return this.ssl;
    }

    public final synchronized void shutdown() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.engineMap.remove(this.ssl);
            SSL.freeSSL((long)this.ssl);
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            referenceCountedOpenSslEngine.networkBIO = 0L;
            referenceCountedOpenSslEngine.ssl = 0L;
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine2 = this;
            referenceCountedOpenSslEngine2.outboundClosed = true;
            referenceCountedOpenSslEngine2.isInboundDone = true;
        }
        SSL.clearError();
    }

    private int writePlaintextData(ByteBuffer byteBuffer, int n2) {
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        if (byteBuffer.isDirect()) {
            n2 = SSL.writeToSSL((long)this.ssl, (long)(ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)n3), (int)n2);
            if (n2 > 0) {
                byteBuffer.position(n3 + n2);
            }
        } else {
            ByteBuf byteBuf = this.alloc.directBuffer(n2);
            try {
                byteBuffer.limit(n3 + n2);
                byteBuf.setBytes(0, byteBuffer);
                byteBuffer.limit(n4);
                n2 = SSL.writeToSSL((long)this.ssl, (long)OpenSsl.memoryAddress(byteBuf), (int)n2);
                if (n2 > 0) {
                    byteBuffer.position(n3 + n2);
                } else {
                    byteBuffer.position(n3);
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n2;
    }

    private ByteBuf writeEncryptedData(ByteBuffer byteBuffer, int n2) {
        int n3 = byteBuffer.position();
        if (byteBuffer.isDirect()) {
            SSL.bioSetByteBuffer((long)this.networkBIO, (long)(ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)n3), (int)n2, (boolean)false);
        } else {
            ByteBuf byteBuf = this.alloc.directBuffer(n2);
            try {
                int n4 = byteBuffer.limit();
                byteBuffer.limit(n3 + n2);
                byteBuf.writeBytes(byteBuffer);
                byteBuffer.position(n3);
                byteBuffer.limit(n4);
                SSL.bioSetByteBuffer((long)this.networkBIO, (long)OpenSsl.memoryAddress(byteBuf), (int)n2, (boolean)false);
                return byteBuf;
            }
            catch (Throwable throwable) {
                byteBuf.release();
                PlatformDependent.throwException(throwable);
            }
        }
        return null;
    }

    private int readPlaintextData(ByteBuffer byteBuffer) {
        int n2;
        int n3 = byteBuffer.position();
        if (byteBuffer.isDirect()) {
            n2 = SSL.readFromSSL((long)this.ssl, (long)(ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)n3), (int)(byteBuffer.limit() - n3));
            if (n2 > 0) {
                byteBuffer.position(n3 + n2);
            }
        } else {
            int n4 = byteBuffer.limit();
            n2 = Math.min(this.maxEncryptedPacketLength0(), n4 - n3);
            ByteBuf byteBuf = this.alloc.directBuffer(n2);
            try {
                n2 = SSL.readFromSSL((long)this.ssl, (long)OpenSsl.memoryAddress(byteBuf), (int)n2);
                if (n2 > 0) {
                    byteBuffer.limit(n3 + n2);
                    ByteBuf byteBuf2 = byteBuf;
                    byteBuf2.getBytes(byteBuf2.readerIndex(), byteBuffer);
                    byteBuffer.limit(n4);
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n2;
    }

    final synchronized int maxEncryptedPacketLength() {
        return this.maxEncryptedPacketLength0();
    }

    final int maxEncryptedPacketLength0() {
        return this.maxWrapOverhead + MAX_PLAINTEXT_LENGTH;
    }

    final int calculateMaxLengthForWrap(int n2, int n3) {
        return (int)Math.min((long)this.maxWrapBufferSize, (long)n2 + (long)this.maxWrapOverhead * (long)n3);
    }

    final synchronized int sslPending() {
        return this.sslPending0();
    }

    private void calculateMaxWrapOverhead() {
        this.maxWrapOverhead = SSL.getMaxWrapOverhead((long)this.ssl);
        this.maxWrapBufferSize = this.jdkCompatibilityMode ? this.maxEncryptedPacketLength0() : this.maxEncryptedPacketLength0() << 4;
    }

    private int sslPending0() {
        if (this.handshakeState != HandshakeState.FINISHED) {
            return 0;
        }
        return SSL.sslPending((long)this.ssl);
    }

    private boolean isBytesAvailableEnoughForWrap(int n2, int n3, int n4) {
        return (long)n2 - (long)this.maxWrapOverhead * (long)n4 >= (long)n3;
    }

    /*
     * Exception decompiling
     */
    public final SSLEngineResult wrap(ByteBuffer[] var1_1, int var2_11, int var3_12, ByteBuffer var4_19) throws SSLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[TRYBLOCK]], but top level block is 47[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SSLEngineResult newResult(SSLEngineResult.HandshakeStatus handshakeStatus, int n2, int n3) {
        return this.newResult(SSLEngineResult.Status.OK, handshakeStatus, n2, n3);
    }

    private SSLEngineResult newResult(SSLEngineResult.Status status, SSLEngineResult.HandshakeStatus handshakeStatus, int n2, int n3) {
        if (this.isOutboundDone()) {
            if (this.isInboundDone()) {
                handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                this.shutdown();
            }
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, handshakeStatus, n2, n3);
        }
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.needTask = true;
        }
        return new SSLEngineResult(status, handshakeStatus, n2, n3);
    }

    private SSLEngineResult newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus handshakeStatus, int n2, int n3) throws SSLException {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        return referenceCountedOpenSslEngine.newResult(referenceCountedOpenSslEngine.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? this.getHandshakeStatus() : SSLEngineResult.HandshakeStatus.FINISHED), n2, n3);
    }

    private SSLEngineResult newResultMayFinishHandshake(SSLEngineResult.Status status, SSLEngineResult.HandshakeStatus handshakeStatus, int n2, int n3) throws SSLException {
        return this.newResult(status, this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? this.getHandshakeStatus() : SSLEngineResult.HandshakeStatus.FINISHED), n2, n3);
    }

    private SSLException shutdownWithError(String string, int n2) {
        return this.shutdownWithError(string, n2, SSL.getLastErrorNumber());
    }

    private SSLException shutdownWithError(String object, int n2, int n3) {
        String string = SSL.getErrorString((long)n3);
        if (logger.isDebugEnabled()) {
            logger.debug("{} failed with {}: OpenSSL error: {} {}", object, n2, n3, string);
        }
        this.shutdown();
        if (this.handshakeState == HandshakeState.FINISHED) {
            return new SSLException(string);
        }
        object = new SSLHandshakeException(string);
        if (this.pendingException != null) {
            ((Throwable)object).initCause(this.pendingException);
            this.pendingException = null;
        }
        return object;
    }

    /*
     * Exception decompiling
     */
    public final SSLEngineResult unwrap(ByteBuffer[] var1_1, int var2_5, int var3_6, ByteBuffer[] var4_8, int var5_9, int var6_10) throws SSLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 27[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SSLEngineResult sslReadErrorResult(int n2, int n3, int n4, int n5) throws SSLException {
        if (SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
            Object object = SSL.getErrorString((long)n3);
            Object object2 = object = this.handshakeState == HandshakeState.FINISHED ? new SSLException((String)object) : new SSLHandshakeException((String)object);
            if (this.pendingException == null) {
                this.pendingException = object;
            } else {
                ThrowableUtil.addSuppressed(this.pendingException, (Throwable)object);
            }
            SSL.clearError();
            return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, n4, n5);
        }
        throw this.shutdownWithError("SSL_read", n2, n3);
    }

    private void closeAll() throws SSLException {
        this.receivedShutdown = true;
        this.closeOutbound();
        this.closeInbound();
    }

    private void rejectRemoteInitiatedRenegotiation() throws SSLHandshakeException {
        if (!this.isDestroyed() && SSL.getHandshakeCount((long)this.ssl) > 1 && !"TLSv1.3".equals(this.session.getProtocol()) && this.handshakeState == HandshakeState.FINISHED) {
            this.shutdown();
            throw new SSLHandshakeException("remote-initiated renegotiation not allowed");
        }
    }

    public final SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) throws SSLException {
        return this.unwrap(byteBufferArray, 0, byteBufferArray.length, byteBufferArray2, 0, byteBufferArray2.length);
    }

    private ByteBuffer[] singleSrcBuffer(ByteBuffer byteBuffer) {
        this.singleSrcBuffer[0] = byteBuffer;
        return this.singleSrcBuffer;
    }

    private void resetSingleSrcBuffer() {
        this.singleSrcBuffer[0] = null;
    }

    private ByteBuffer[] singleDstBuffer(ByteBuffer byteBuffer) {
        this.singleDstBuffer[0] = byteBuffer;
        return this.singleDstBuffer;
    }

    private void resetSingleDstBuffer() {
        this.singleDstBuffer[0] = null;
    }

    public final synchronized SSLEngineResult unwrap(ByteBuffer object, ByteBuffer[] byteBufferArray, int n2, int n3) throws SSLException {
        try {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            object = referenceCountedOpenSslEngine.unwrap(referenceCountedOpenSslEngine.singleSrcBuffer((ByteBuffer)object), 0, 1, byteBufferArray, n2, n3);
            return object;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    public final synchronized SSLEngineResult wrap(ByteBuffer object, ByteBuffer byteBuffer) throws SSLException {
        try {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            object = referenceCountedOpenSslEngine.wrap(referenceCountedOpenSslEngine.singleSrcBuffer((ByteBuffer)object), byteBuffer);
            return object;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    public final synchronized SSLEngineResult unwrap(ByteBuffer object, ByteBuffer byteBuffer) throws SSLException {
        try {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            object = referenceCountedOpenSslEngine.unwrap(referenceCountedOpenSslEngine.singleSrcBuffer((ByteBuffer)object), this.singleDstBuffer(byteBuffer));
            return object;
        }
        finally {
            this.resetSingleSrcBuffer();
            this.resetSingleDstBuffer();
        }
    }

    public final synchronized SSLEngineResult unwrap(ByteBuffer object, ByteBuffer[] byteBufferArray) throws SSLException {
        try {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            object = referenceCountedOpenSslEngine.unwrap(referenceCountedOpenSslEngine.singleSrcBuffer((ByteBuffer)object), byteBufferArray);
            return object;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    public final synchronized Runnable getDelegatedTask() {
        if (this.isDestroyed()) {
            return null;
        }
        final Runnable runnable = SSL.getTask((long)this.ssl);
        if (runnable == null) {
            return null;
        }
        return new Runnable(){

            public void run() {
                if (ReferenceCountedOpenSslEngine.this.isDestroyed()) {
                    return;
                }
                try {
                    runnable.run();
                    return;
                }
                finally {
                    ReferenceCountedOpenSslEngine.this.needTask = false;
                }
            }
        };
    }

    public final synchronized void closeInbound() throws SSLException {
        if (this.isInboundDone) {
            return;
        }
        this.isInboundDone = true;
        if (this.isOutboundDone()) {
            this.shutdown();
        }
        if (this.handshakeState != HandshakeState.NOT_STARTED && !this.receivedShutdown) {
            throw new SSLException("Inbound closed before receiving peer's close_notify: possible truncation attack?");
        }
    }

    public final synchronized boolean isInboundDone() {
        return this.isInboundDone;
    }

    public final synchronized void closeOutbound() {
        if (this.outboundClosed) {
            return;
        }
        this.outboundClosed = true;
        if (this.handshakeState != HandshakeState.NOT_STARTED && !this.isDestroyed()) {
            int n2 = SSL.getShutdown((long)this.ssl);
            if ((n2 & SSL.SSL_SENT_SHUTDOWN) != SSL.SSL_SENT_SHUTDOWN) {
                this.doSSLShutdown();
            }
            return;
        }
        this.shutdown();
    }

    private boolean doSSLShutdown() {
        if (SSL.isInInit((long)this.ssl) != 0) {
            return false;
        }
        int n2 = SSL.shutdownSSL((long)this.ssl);
        if (n2 < 0) {
            if ((n2 = SSL.getError((long)this.ssl, (int)n2)) == SSL.SSL_ERROR_SYSCALL || n2 == SSL.SSL_ERROR_SSL) {
                if (logger.isDebugEnabled()) {
                    n2 = SSL.getLastErrorNumber();
                    logger.debug("SSL_shutdown failed: OpenSSL error: {} {}", (Object)n2, (Object)SSL.getErrorString((long)n2));
                }
                this.shutdown();
                return false;
            }
            SSL.clearError();
        }
        return true;
    }

    public final synchronized boolean isOutboundDone() {
        return this.outboundClosed && (this.networkBIO == 0L || SSL.bioLengthNonApplication((long)this.networkBIO) == 0);
    }

    public final String[] getSupportedCipherSuites() {
        return OpenSsl.AVAILABLE_CIPHER_SUITES.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getEnabledCipherSuites() {
        String[] stringArray;
        String[] stringArray2;
        Object object = this;
        synchronized (object) {
            if (!this.isDestroyed()) {
                stringArray2 = SSL.getCiphers((long)this.ssl);
                int n2 = SSL.getOptions((long)this.ssl);
                stringArray = ReferenceCountedOpenSslEngine.isProtocolEnabled(n2, SSL.SSL_OP_NO_TLSv1_3, "TLSv1.3") ? OpenSsl.EXTRA_SUPPORTED_TLS_1_3_CIPHERS : EmptyArrays.EMPTY_STRINGS;
            } else {
                return EmptyArrays.EMPTY_STRINGS;
            }
        }
        if (stringArray2 == null) {
            return EmptyArrays.EMPTY_STRINGS;
        }
        object = new LinkedHashSet(stringArray2.length + stringArray.length);
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                String string = this.toJavaCipherSuite(stringArray2[i2]);
                String string2 = string = string == null ? stringArray2[i2] : string;
                if (!OpenSsl.isTlsv13Supported() && SslUtils.isTLSv13Cipher(string)) continue;
                object.add(string);
            }
            Collections.addAll(object, stringArray);
        }
        return object.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setEnabledCipherSuites(String[] object) {
        ObjectUtil.checkNotNull(object, "cipherSuites");
        CharSequence charSequence = new StringBuilder();
        Object object2 = new StringBuilder();
        CipherSuiteConverter.convertToCipherStrings(Arrays.asList(object), (StringBuilder)charSequence, (StringBuilder)object2, OpenSsl.isBoringSSL());
        String string = ((StringBuilder)charSequence).toString();
        charSequence = ((StringBuilder)object2).toString();
        if (!OpenSsl.isTlsv13Supported() && !((String)charSequence).isEmpty()) {
            throw new IllegalArgumentException("TLSv1.3 is not supported by this java version.");
        }
        object2 = this;
        synchronized (object2) {
            if (this.isDestroyed()) throw new IllegalStateException("failed to enable cipher suites: " + string);
            try {
                SSL.setCipherSuites((long)this.ssl, (String)string, (boolean)false);
                if (OpenSsl.isTlsv13Supported()) {
                    SSL.setCipherSuites((long)this.ssl, (String)charSequence, (boolean)true);
                }
            }
            catch (Exception exception) {
                throw new IllegalStateException("failed to enable cipher suites: " + string, exception);
            }
            return;
        }
    }

    public final String[] getSupportedProtocols() {
        return OpenSsl.SUPPORTED_PROTOCOLS_SET.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getEnabledProtocols() {
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>(6);
        arrayList.add("SSLv2Hello");
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.isDestroyed()) {
                return arrayList.toArray(new String[0]);
            }
            n2 = SSL.getOptions((long)this.ssl);
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n2, SSL.SSL_OP_NO_TLSv1, "TLSv1")) {
            arrayList.add("TLSv1");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n2, SSL.SSL_OP_NO_TLSv1_1, "TLSv1.1")) {
            arrayList.add("TLSv1.1");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n2, SSL.SSL_OP_NO_TLSv1_2, "TLSv1.2")) {
            arrayList.add("TLSv1.2");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n2, SSL.SSL_OP_NO_TLSv1_3, "TLSv1.3")) {
            arrayList.add("TLSv1.3");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n2, SSL.SSL_OP_NO_SSLv2, "SSLv2")) {
            arrayList.add("SSLv2");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n2, SSL.SSL_OP_NO_SSLv3, "SSLv3")) {
            arrayList.add("SSLv3");
        }
        return arrayList.toArray(new String[0]);
    }

    private static boolean isProtocolEnabled(int n2, int n3, String string) {
        return (n2 & n3) == 0 && OpenSsl.SUPPORTED_PROTOCOLS_SET.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setEnabledProtocols(String[] stringArray) {
        int n2;
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        int n3 = OPENSSL_OP_NO_PROTOCOLS.length;
        int n4 = 0;
        Object object = stringArray;
        int n5 = stringArray.length;
        for (n2 = 0; n2 < n5; ++n2) {
            String string = object[n2];
            if (!OpenSsl.SUPPORTED_PROTOCOLS_SET.contains(string)) {
                throw new IllegalArgumentException("Protocol " + string + " is not supported.");
            }
            if (string.equals("SSLv2")) {
                if (n3 > 0) {
                    n3 = 0;
                }
                if (n4 >= 0) continue;
                n4 = 0;
                continue;
            }
            if (string.equals("SSLv3")) {
                if (n3 > 1) {
                    n3 = 1;
                }
                if (n4 > 0) continue;
                n4 = 1;
                continue;
            }
            if (string.equals("TLSv1")) {
                if (n3 > 2) {
                    n3 = 2;
                }
                if (n4 >= 2) continue;
                n4 = 2;
                continue;
            }
            if (string.equals("TLSv1.1")) {
                if (n3 > 3) {
                    n3 = 3;
                }
                if (n4 >= 3) continue;
                n4 = 3;
                continue;
            }
            if (string.equals("TLSv1.2")) {
                if (n3 > 4) {
                    n3 = 4;
                }
                if (n4 >= 4) continue;
                n4 = 4;
                continue;
            }
            if (!string.equals("TLSv1.3")) continue;
            if (n3 > 5) {
                n3 = 5;
            }
            if (n4 >= 5) continue;
            n4 = 5;
        }
        object = this;
        synchronized (object) {
            if (!this.isDestroyed()) {
                SSL.clearOptions((long)this.ssl, (int)(SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_NO_TLSv1_2 | SSL.SSL_OP_NO_TLSv1_3));
                n5 = 0;
                for (n2 = 0; n2 < n3; ++n2) {
                    n5 |= OPENSSL_OP_NO_PROTOCOLS[n2];
                }
                assert (n4 != Integer.MAX_VALUE);
                for (n2 = n4 + 1; n2 < OPENSSL_OP_NO_PROTOCOLS.length; ++n2) {
                    n5 |= OPENSSL_OP_NO_PROTOCOLS[n2];
                }
            } else {
                throw new IllegalStateException("failed to enable protocols: " + Arrays.asList(stringArray));
            }
            SSL.setOptions((long)this.ssl, (int)n5);
            return;
        }
    }

    public final SSLSession getSession() {
        return this.session;
    }

    public final synchronized void beginHandshake() throws SSLException {
        switch (this.handshakeState) {
            case STARTED_IMPLICITLY: {
                this.checkEngineClosed();
                this.handshakeState = HandshakeState.STARTED_EXPLICITLY;
                this.calculateMaxWrapOverhead();
                return;
            }
            case STARTED_EXPLICITLY: {
                return;
            }
            case FINISHED: {
                throw new SSLException("renegotiation unsupported");
            }
            case NOT_STARTED: {
                this.handshakeState = HandshakeState.STARTED_EXPLICITLY;
                if (this.handshake() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.needTask = true;
                }
                this.calculateMaxWrapOverhead();
                return;
            }
        }
        throw new Error();
    }

    private void checkEngineClosed() throws SSLException {
        if (this.isDestroyed()) {
            throw new SSLException("engine closed");
        }
    }

    private static SSLEngineResult.HandshakeStatus pendingStatus(int n2) {
        if (n2 > 0) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
    }

    private static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    private static boolean isEmpty(byte[] byArray) {
        return byArray == null || byArray.length == 0;
    }

    private SSLEngineResult.HandshakeStatus handshakeException() throws SSLException {
        if (SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        Throwable throwable = this.pendingException;
        assert (throwable != null);
        this.pendingException = null;
        this.shutdown();
        if (throwable instanceof SSLHandshakeException) {
            throw (SSLHandshakeException)throwable;
        }
        SSLHandshakeException sSLHandshakeException = new SSLHandshakeException("General OpenSslEngine problem");
        sSLHandshakeException.initCause(throwable);
        throw sSLHandshakeException;
    }

    private SSLEngineResult.HandshakeStatus handshake() throws SSLException {
        int n2;
        if (this.needTask) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        if (this.handshakeState == HandshakeState.FINISHED) {
            return SSLEngineResult.HandshakeStatus.FINISHED;
        }
        this.checkEngineClosed();
        if (this.pendingException != null) {
            if (SSL.doHandshake((long)this.ssl) <= 0) {
                SSL.clearError();
            }
            return this.handshakeException();
        }
        this.engineMap.add(this);
        if (this.lastAccessed == -1L) {
            this.lastAccessed = System.currentTimeMillis();
        }
        if ((n2 = SSL.doHandshake((long)this.ssl)) <= 0) {
            if ((n2 = SSL.getError((long)this.ssl, (int)n2)) == SSL.SSL_ERROR_WANT_READ || n2 == SSL.SSL_ERROR_WANT_WRITE) {
                return ReferenceCountedOpenSslEngine.pendingStatus(SSL.bioLengthNonApplication((long)this.networkBIO));
            }
            if (n2 == SSL.SSL_ERROR_WANT_X509_LOOKUP || n2 == SSL.SSL_ERROR_WANT_CERTIFICATE_VERIFY || n2 == SSL.SSL_ERROR_WANT_PRIVATE_KEY_OPERATION) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            if (this.pendingException != null) {
                return this.handshakeException();
            }
            throw this.shutdownWithError("SSL_do_handshake", n2);
        }
        if (SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        this.session.handshakeFinished();
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    private SSLEngineResult.HandshakeStatus mayFinishHandshake(SSLEngineResult.HandshakeStatus handshakeStatus) throws SSLException {
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && this.handshakeState != HandshakeState.FINISHED) {
            return this.handshake();
        }
        return handshakeStatus;
    }

    public final synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (this.needPendingStatus()) {
            if (this.needTask) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            return ReferenceCountedOpenSslEngine.pendingStatus(SSL.bioLengthNonApplication((long)this.networkBIO));
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private SSLEngineResult.HandshakeStatus getHandshakeStatus(int n2) {
        if (this.needPendingStatus()) {
            if (this.needTask) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            return ReferenceCountedOpenSslEngine.pendingStatus(n2);
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private boolean needPendingStatus() {
        return this.handshakeState != HandshakeState.NOT_STARTED && !this.isDestroyed() && (this.handshakeState != HandshakeState.FINISHED || this.isInboundDone() || this.isOutboundDone());
    }

    private String toJavaCipherSuite(String string) {
        if (string == null) {
            return null;
        }
        String string2 = SSL.getVersion((long)this.ssl);
        string2 = ReferenceCountedOpenSslEngine.toJavaCipherSuitePrefix(string2);
        return CipherSuiteConverter.toJava(string, string2);
    }

    private static String toJavaCipherSuitePrefix(String string) {
        int n2 = string == null || string.isEmpty() ? 0 : (int)string.charAt(0);
        switch (n2) {
            case 84: {
                return "TLS";
            }
            case 83: {
                return "SSL";
            }
        }
        return "UNKNOWN";
    }

    public final void setUseClientMode(boolean bl) {
        if (bl != this.clientMode) {
            throw new UnsupportedOperationException();
        }
    }

    public final boolean getUseClientMode() {
        return this.clientMode;
    }

    public final void setNeedClientAuth(boolean bl) {
        this.setClientAuth(bl ? ClientAuth.REQUIRE : ClientAuth.NONE);
    }

    public final boolean getNeedClientAuth() {
        return this.clientAuth == ClientAuth.REQUIRE;
    }

    public final void setWantClientAuth(boolean bl) {
        this.setClientAuth(bl ? ClientAuth.OPTIONAL : ClientAuth.NONE);
    }

    public final boolean getWantClientAuth() {
        return this.clientAuth == ClientAuth.OPTIONAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClientAuth(ClientAuth clientAuth) {
        if (this.clientMode) {
            return;
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.clientAuth == clientAuth) {
                return;
            }
            if (!this.isDestroyed()) {
                switch (clientAuth) {
                    case NONE: {
                        SSL.setVerify((long)this.ssl, (int)0, (int)10);
                        break;
                    }
                    case REQUIRE: {
                        SSL.setVerify((long)this.ssl, (int)2, (int)10);
                        break;
                    }
                    case OPTIONAL: {
                        SSL.setVerify((long)this.ssl, (int)1, (int)10);
                        break;
                    }
                    default: {
                        throw new Error(clientAuth.toString());
                    }
                }
            }
            this.clientAuth = clientAuth;
            return;
        }
    }

    public final void setEnableSessionCreation(boolean bl) {
        if (bl) {
            throw new UnsupportedOperationException();
        }
    }

    public final boolean getEnableSessionCreation() {
        return false;
    }

    public final synchronized SSLParameters getSSLParameters() {
        SSLParameters sSLParameters = super.getSSLParameters();
        int n2 = PlatformDependent.javaVersion();
        if (n2 >= 7) {
            sSLParameters.setEndpointIdentificationAlgorithm(this.endPointIdentificationAlgorithm);
            Java7SslParametersUtils.setAlgorithmConstraints(sSLParameters, this.algorithmConstraints);
            if (n2 >= 8) {
                if (this.sniHostNames != null) {
                    Java8SslUtils.setSniHostNames(sSLParameters, this.sniHostNames);
                }
                if (!this.isDestroyed()) {
                    Java8SslUtils.setUseCipherSuitesOrder(sSLParameters, (SSL.getOptions((long)this.ssl) & SSL.SSL_OP_CIPHER_SERVER_PREFERENCE) != 0);
                }
                Java8SslUtils.setSNIMatchers(sSLParameters, this.matchers);
            }
        }
        return sSLParameters;
    }

    public final synchronized void setSSLParameters(SSLParameters sSLParameters) {
        int n2 = PlatformDependent.javaVersion();
        if (n2 >= 7) {
            if (sSLParameters.getAlgorithmConstraints() != null) {
                throw new IllegalArgumentException("AlgorithmConstraints are not supported.");
            }
            boolean bl = this.isDestroyed();
            if (n2 >= 8) {
                if (!bl) {
                    if (this.clientMode) {
                        List<String> list = Java8SslUtils.getSniHostNames(sSLParameters);
                        for (String string : list) {
                            SSL.setTlsExtHostName((long)this.ssl, (String)string);
                        }
                        this.sniHostNames = list;
                    }
                    if (Java8SslUtils.getUseCipherSuitesOrder(sSLParameters)) {
                        SSL.setOptions((long)this.ssl, (int)SSL.SSL_OP_CIPHER_SERVER_PREFERENCE);
                    } else {
                        SSL.clearOptions((long)this.ssl, (int)SSL.SSL_OP_CIPHER_SERVER_PREFERENCE);
                    }
                }
                this.matchers = sSLParameters.getSNIMatchers();
            }
            String string = sSLParameters.getEndpointIdentificationAlgorithm();
            if (!bl && this.clientMode && ReferenceCountedOpenSslEngine.isEndPointVerificationEnabled(string)) {
                SSL.setVerify((long)this.ssl, (int)2, (int)-1);
            }
            this.endPointIdentificationAlgorithm = string;
            this.algorithmConstraints = sSLParameters.getAlgorithmConstraints();
        }
        super.setSSLParameters(sSLParameters);
    }

    private static boolean isEndPointVerificationEnabled(String string) {
        return string != null && !string.isEmpty();
    }

    private boolean isDestroyed() {
        return this.destroyed;
    }

    public String getNegotiatedApplicationProtocol() {
        return this.applicationProtocol;
    }

    private static long bufferAddress(ByteBuffer byteBuffer) {
        assert (byteBuffer.isDirect());
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.directBufferAddress(byteBuffer);
        }
        return Buffer.address((ByteBuffer)byteBuffer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DefaultOpenSslSession
    implements OpenSslSession {
        private final OpenSslSessionContext sessionContext;
        private X509Certificate[] x509PeerCerts;
        private Certificate[] peerCerts;
        private String protocol;
        private String cipher;
        private byte[] id;
        private long creationTime;
        private volatile int applicationBufferSize = MAX_PLAINTEXT_LENGTH;
        private Map<String, Object> values;

        DefaultOpenSslSession(OpenSslSessionContext openSslSessionContext) {
            this.sessionContext = openSslSessionContext;
        }

        private SSLSessionBindingEvent newSSLSessionBindingEvent(String string) {
            return new SSLSessionBindingEvent(ReferenceCountedOpenSslEngine.this.session, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final byte[] getId() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (this.id == null) {
                    return EmptyArrays.EMPTY_BYTES;
                }
                return (byte[])this.id.clone();
            }
        }

        @Override
        public final SSLSessionContext getSessionContext() {
            return this.sessionContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final long getCreationTime() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (this.creationTime == 0L && !ReferenceCountedOpenSslEngine.this.isDestroyed()) {
                    this.creationTime = SSL.getTime((long)ReferenceCountedOpenSslEngine.this.ssl) * 1000L;
                }
            }
            return this.creationTime;
        }

        @Override
        public final long getLastAccessedTime() {
            long l2 = ReferenceCountedOpenSslEngine.this.lastAccessed;
            if (l2 == -1L) {
                return this.getCreationTime();
            }
            return l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void invalidate() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (!ReferenceCountedOpenSslEngine.this.isDestroyed()) {
                    SSL.setTimeout((long)ReferenceCountedOpenSslEngine.this.ssl, (long)0L);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean isValid() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (!ReferenceCountedOpenSslEngine.this.isDestroyed()) {
                    return System.currentTimeMillis() - SSL.getTimeout((long)ReferenceCountedOpenSslEngine.this.ssl) * 1000L < SSL.getTime((long)ReferenceCountedOpenSslEngine.this.ssl) * 1000L;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void putValue(String string, Object object) {
            HashMap<String, Object> hashMap;
            ObjectUtil.checkNotNull(string, "name");
            ObjectUtil.checkNotNull(object, "value");
            DefaultOpenSslSession defaultOpenSslSession = this;
            synchronized (defaultOpenSslSession) {
                hashMap = this.values;
                if (hashMap == null) {
                    this.values = new HashMap<String, Object>(2);
                    hashMap = this.values;
                }
                hashMap = hashMap.put(string, object);
            }
            if (object instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)object).valueBound(this.newSSLSessionBindingEvent(string));
            }
            this.notifyUnbound(hashMap, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Object getValue(String string) {
            ObjectUtil.checkNotNull(string, "name");
            DefaultOpenSslSession defaultOpenSslSession = this;
            synchronized (defaultOpenSslSession) {
                if (this.values == null) {
                    return null;
                }
                return this.values.get(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void removeValue(String string) {
            Object object;
            ObjectUtil.checkNotNull(string, "name");
            DefaultOpenSslSession defaultOpenSslSession = this;
            synchronized (defaultOpenSslSession) {
                object = this.values;
                if (object == null) {
                    return;
                }
                object = object.remove(string);
            }
            this.notifyUnbound(object, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final String[] getValueNames() {
            DefaultOpenSslSession defaultOpenSslSession = this;
            synchronized (defaultOpenSslSession) {
                Map<String, Object> map = this.values;
                if (map == null || map.isEmpty()) {
                    return EmptyArrays.EMPTY_STRINGS;
                }
                return map.keySet().toArray(new String[0]);
            }
        }

        private void notifyUnbound(Object object, String string) {
            if (object instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)object).valueUnbound(this.newSSLSessionBindingEvent(string));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void handshakeFinished() throws SSLException {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (ReferenceCountedOpenSslEngine.this.isDestroyed()) {
                    throw new SSLException("Already closed");
                }
                this.id = SSL.getSessionId((long)ReferenceCountedOpenSslEngine.this.ssl);
                this.cipher = ReferenceCountedOpenSslEngine.this.toJavaCipherSuite(SSL.getCipherForSSL((long)ReferenceCountedOpenSslEngine.this.ssl));
                this.protocol = SSL.getVersion((long)ReferenceCountedOpenSslEngine.this.ssl);
                this.initPeerCerts();
                this.selectApplicationProtocol();
                ReferenceCountedOpenSslEngine.this.calculateMaxWrapOverhead();
                ReferenceCountedOpenSslEngine.this.handshakeState = HandshakeState.FINISHED;
                return;
            }
        }

        private void initPeerCerts() {
            byte[][] byArray = SSL.getPeerCertChain((long)ReferenceCountedOpenSslEngine.this.ssl);
            if (ReferenceCountedOpenSslEngine.this.clientMode) {
                if (ReferenceCountedOpenSslEngine.isEmpty((Object[])byArray)) {
                    this.peerCerts = EmptyArrays.EMPTY_CERTIFICATES;
                    this.x509PeerCerts = EmptyArrays.EMPTY_JAVAX_X509_CERTIFICATES;
                    return;
                }
                this.peerCerts = new Certificate[byArray.length];
                this.x509PeerCerts = new X509Certificate[byArray.length];
                this.initCerts(byArray, 0);
                return;
            }
            byte[] byArray2 = SSL.getPeerCertificate((long)ReferenceCountedOpenSslEngine.this.ssl);
            if (ReferenceCountedOpenSslEngine.isEmpty(byArray2)) {
                this.peerCerts = EmptyArrays.EMPTY_CERTIFICATES;
                this.x509PeerCerts = EmptyArrays.EMPTY_JAVAX_X509_CERTIFICATES;
                return;
            }
            if (ReferenceCountedOpenSslEngine.isEmpty((Object[])byArray)) {
                this.peerCerts = new Certificate[]{new OpenSslX509Certificate(byArray2)};
                this.x509PeerCerts = new X509Certificate[]{new OpenSslJavaxX509Certificate(byArray2)};
                return;
            }
            this.peerCerts = new Certificate[byArray.length + 1];
            this.x509PeerCerts = new X509Certificate[byArray.length + 1];
            this.peerCerts[0] = new OpenSslX509Certificate(byArray2);
            this.x509PeerCerts[0] = new OpenSslJavaxX509Certificate(byArray2);
            this.initCerts(byArray, 1);
        }

        private void initCerts(byte[][] byArray, int n2) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                int n3 = n2 + i2;
                this.peerCerts[n3] = new OpenSslX509Certificate(byArray[i2]);
                this.x509PeerCerts[n3] = new OpenSslJavaxX509Certificate(byArray[i2]);
            }
        }

        private void selectApplicationProtocol() throws SSLException {
            ApplicationProtocolConfig.SelectedListenerFailureBehavior selectedListenerFailureBehavior = ReferenceCountedOpenSslEngine.this.apn.selectedListenerFailureBehavior();
            List<String> list = ReferenceCountedOpenSslEngine.this.apn.protocols();
            switch (ReferenceCountedOpenSslEngine.this.apn.protocol()) {
                case NONE: {
                    return;
                }
                case ALPN: {
                    String string = SSL.getAlpnSelected((long)ReferenceCountedOpenSslEngine.this.ssl);
                    if (string == null) break;
                    ReferenceCountedOpenSslEngine.this.applicationProtocol = this.selectApplicationProtocol(list, selectedListenerFailureBehavior, string);
                    return;
                }
                case NPN: {
                    String string = SSL.getNextProtoNegotiated((long)ReferenceCountedOpenSslEngine.this.ssl);
                    if (string == null) break;
                    ReferenceCountedOpenSslEngine.this.applicationProtocol = this.selectApplicationProtocol(list, selectedListenerFailureBehavior, string);
                    return;
                }
                case NPN_AND_ALPN: {
                    String string = SSL.getAlpnSelected((long)ReferenceCountedOpenSslEngine.this.ssl);
                    if (string == null) {
                        string = SSL.getNextProtoNegotiated((long)ReferenceCountedOpenSslEngine.this.ssl);
                    }
                    if (string == null) break;
                    ReferenceCountedOpenSslEngine.this.applicationProtocol = this.selectApplicationProtocol(list, selectedListenerFailureBehavior, string);
                    return;
                }
                default: {
                    throw new Error();
                }
            }
        }

        private String selectApplicationProtocol(List<String> list, ApplicationProtocolConfig.SelectedListenerFailureBehavior selectedListenerFailureBehavior, String string) throws SSLException {
            if (selectedListenerFailureBehavior == ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT) {
                return string;
            }
            int n2 = list.size();
            assert (n2 > 0);
            if (list.contains(string)) {
                return string;
            }
            if (selectedListenerFailureBehavior == ApplicationProtocolConfig.SelectedListenerFailureBehavior.CHOOSE_MY_LAST_PROTOCOL) {
                return list.get(n2 - 1);
            }
            throw new SSLException("unknown protocol " + string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (ReferenceCountedOpenSslEngine.isEmpty(this.peerCerts)) {
                    throw new SSLPeerUnverifiedException("peer not verified");
                }
                return (Certificate[])this.peerCerts.clone();
            }
        }

        @Override
        public final Certificate[] getLocalCertificates() {
            Certificate[] certificateArray = ReferenceCountedOpenSslEngine.this.localCertificateChain;
            if (certificateArray == null) {
                return null;
            }
            return (Certificate[])certificateArray.clone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (ReferenceCountedOpenSslEngine.isEmpty(this.x509PeerCerts)) {
                    throw new SSLPeerUnverifiedException("peer not verified");
                }
                return (X509Certificate[])this.x509PeerCerts.clone();
            }
        }

        @Override
        public final Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
            Certificate[] certificateArray = this.getPeerCertificates();
            return ((java.security.cert.X509Certificate)certificateArray[0]).getSubjectX500Principal();
        }

        @Override
        public final Principal getLocalPrincipal() {
            Certificate[] certificateArray = ReferenceCountedOpenSslEngine.this.localCertificateChain;
            if (certificateArray == null || certificateArray.length == 0) {
                return null;
            }
            return ((java.security.cert.X509Certificate)certificateArray[0]).getIssuerX500Principal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final String getCipherSuite() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (this.cipher == null) {
                    return "SSL_NULL_WITH_NULL_NULL";
                }
                return this.cipher;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final String getProtocol() {
            String string = this.protocol;
            if (string == null) {
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
                synchronized (referenceCountedOpenSslEngine) {
                    string = !ReferenceCountedOpenSslEngine.this.isDestroyed() ? SSL.getVersion((long)ReferenceCountedOpenSslEngine.this.ssl) : "";
                }
            }
            return string;
        }

        @Override
        public final String getPeerHost() {
            return ReferenceCountedOpenSslEngine.this.getPeerHost();
        }

        @Override
        public final int getPeerPort() {
            return ReferenceCountedOpenSslEngine.this.getPeerPort();
        }

        @Override
        public final int getPacketBufferSize() {
            return ReferenceCountedOpenSslEngine.this.maxEncryptedPacketLength();
        }

        @Override
        public final int getApplicationBufferSize() {
            return this.applicationBufferSize;
        }

        @Override
        public final void tryExpandApplicationBufferSize(int n2) {
            if (n2 > MAX_PLAINTEXT_LENGTH && this.applicationBufferSize != MAX_RECORD_SIZE) {
                this.applicationBufferSize = MAX_RECORD_SIZE;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HandshakeState {
        NOT_STARTED,
        STARTED_IMPLICITLY,
        STARTED_EXPLICITLY,
        FINISHED;

    }
}

