/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.handler.codec.base64.Base64;
import com.appoptics.ext.io.netty.util.CharsetUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PemReader {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PemReader.class);
    private static final Pattern CERT_PATTERN = Pattern.compile("-+BEGIN\\s+.*CERTIFICATE[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*CERTIFICATE[^-]*-+", 2);
    private static final Pattern KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*PRIVATE\\s+KEY[^-]*-+", 2);

    static ByteBuf[] readCertificates(File file) throws CertificateException {
        ByteBuf[] byteBufArray;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            byteBufArray = PemReader.readCertificates(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                PemReader.safeClose(fileInputStream);
                throw throwable;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CertificateException("could not find certificate file: " + file);
            }
        }
        PemReader.safeClose(fileInputStream);
        return byteBufArray;
    }

    static ByteBuf[] readCertificates(InputStream object) throws CertificateException {
        try {
            object = PemReader.readContent((InputStream)object);
        }
        catch (IOException iOException) {
            throw new CertificateException("failed to read certificate input stream", iOException);
        }
        ArrayList<ByteBuf> arrayList = new ArrayList<ByteBuf>();
        object = CERT_PATTERN.matcher((CharSequence)object);
        int n2 = 0;
        while (((Matcher)object).find(n2)) {
            ByteBuf byteBuf = Unpooled.copiedBuffer(((Matcher)object).group(1), CharsetUtil.US_ASCII);
            ByteBuf byteBuf2 = Base64.decode(byteBuf);
            byteBuf.release();
            arrayList.add(byteBuf2);
            n2 = ((Matcher)object).end();
        }
        if (arrayList.isEmpty()) {
            throw new CertificateException("found no certificates in input stream");
        }
        return arrayList.toArray(new ByteBuf[0]);
    }

    static ByteBuf readPrivateKey(File file) throws KeyException {
        ByteBuf byteBuf;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            byteBuf = PemReader.readPrivateKey(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                PemReader.safeClose(fileInputStream);
                throw throwable;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new KeyException("could not find key file: " + file);
            }
        }
        PemReader.safeClose(fileInputStream);
        return byteBuf;
    }

    static ByteBuf readPrivateKey(InputStream object) throws KeyException {
        try {
            object = PemReader.readContent((InputStream)object);
        }
        catch (IOException iOException) {
            throw new KeyException("failed to read key input stream", iOException);
        }
        object = KEY_PATTERN.matcher((CharSequence)object);
        if (!((Matcher)object).find()) {
            throw new KeyException("could not find a PKCS #8 private key in input stream (see https://netty.io/wiki/sslcontextbuilder-and-private-key.html for more information)");
        }
        object = Unpooled.copiedBuffer(((Matcher)object).group(1), CharsetUtil.US_ASCII);
        ByteBuf byteBuf = Base64.decode((ByteBuf)object);
        object.release();
        return byteBuf;
    }

    private static String readContent(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n2;
            byte[] byArray = new byte[8192];
            while ((n2 = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            String string = byteArrayOutputStream.toString(CharsetUtil.US_ASCII.name());
            return string;
        }
        finally {
            PemReader.safeClose(byteArrayOutputStream);
        }
    }

    private static void safeClose(InputStream inputStream) {
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            logger.warn("Failed to close a stream.", iOException);
            return;
        }
    }

    private static void safeClose(OutputStream outputStream) {
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {
            logger.warn("Failed to close a stream.", iOException);
            return;
        }
    }

    private PemReader() {
    }
}

