/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.UnpooledByteBufAllocator;
import com.appoptics.ext.io.netty.handler.ssl.DefaultOpenSslKeyMaterial;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslKeyMaterial;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslPrivateKey;
import com.appoptics.ext.io.netty.handler.ssl.PemEncoded;
import com.appoptics.ext.io.netty.handler.ssl.PemX509Certificate;
import com.appoptics.ext.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import com.appoptics.ext.io.netty.internal.tcnative.SSL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509KeyManager;

class OpenSslKeyMaterialProvider {
    private final X509KeyManager keyManager;
    private final String password;

    OpenSslKeyMaterialProvider(X509KeyManager x509KeyManager, String string) {
        this.keyManager = x509KeyManager;
        this.password = string;
    }

    static void validateKeyMaterialSupported(X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string) throws SSLException {
        OpenSslKeyMaterialProvider.validateSupported(x509CertificateArray);
        OpenSslKeyMaterialProvider.validateSupported(privateKey, string);
    }

    private static void validateSupported(PrivateKey privateKey, String string) throws SSLException {
        long l2;
        if (privateKey == null) {
            return;
        }
        long l3 = 0L;
        try {
            l3 = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, privateKey);
            l2 = SSL.parsePrivateKey((long)l3, (String)string);
        }
        catch (Exception exception) {
            try {
                throw new SSLException("PrivateKey type not supported " + privateKey.getFormat(), exception);
            }
            catch (Throwable throwable) {
                SSL.freeBIO((long)l3);
                if (0L != 0L) {
                    SSL.freePrivateKey((long)0L);
                }
                throw throwable;
            }
        }
        SSL.freeBIO((long)l3);
        if (l2 != 0L) {
            SSL.freePrivateKey((long)l2);
            return;
        }
    }

    private static void validateSupported(X509Certificate[] x509CertificateArray) throws SSLException {
        long l2;
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return;
        }
        long l3 = 0L;
        PemEncoded pemEncoded = null;
        try {
            pemEncoded = PemX509Certificate.toPEM(UnpooledByteBufAllocator.DEFAULT, true, x509CertificateArray);
            l3 = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, pemEncoded.retain());
            l2 = SSL.parseX509Chain((long)l3);
        }
        catch (Exception exception) {
            try {
                throw new SSLException("Certificate type not supported", exception);
            }
            catch (Throwable throwable) {
                SSL.freeBIO((long)l3);
                if (0L != 0L) {
                    SSL.freeX509Chain((long)0L);
                }
                if (pemEncoded != null) {
                    pemEncoded.release();
                }
                throw throwable;
            }
        }
        SSL.freeBIO((long)l3);
        if (l2 != 0L) {
            SSL.freeX509Chain((long)l2);
        }
        if (pemEncoded != null) {
            pemEncoded.release();
            return;
        }
    }

    OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator object, String object2) throws Exception {
        X509Certificate[] x509CertificateArray = this.keyManager.getCertificateChain((String)object2);
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return null;
        }
        object2 = this.keyManager.getPrivateKey((String)object2);
        PemEncoded pemEncoded = PemX509Certificate.toPEM((ByteBufAllocator)object, true, x509CertificateArray);
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        try {
            l2 = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)object, pemEncoded.retain());
            l4 = SSL.parseX509Chain((long)l2);
            if (object2 instanceof OpenSslPrivateKey) {
                object = ((OpenSslPrivateKey)object2).newKeyMaterial(l4, x509CertificateArray);
            } else {
                l3 = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)object, (PrivateKey)object2);
                l5 = object2 == null ? 0L : SSL.parsePrivateKey((long)l3, (String)this.password);
                object = new DefaultOpenSslKeyMaterial(l4, l5, x509CertificateArray);
            }
            l4 = 0L;
            l5 = 0L;
        }
        catch (Throwable throwable) {
            SSL.freeBIO((long)l2);
            SSL.freeBIO((long)l3);
            if (l4 != 0L) {
                SSL.freeX509Chain((long)l4);
            }
            if (l5 != 0L) {
                SSL.freePrivateKey((long)l5);
            }
            pemEncoded.release();
            throw throwable;
        }
        SSL.freeBIO((long)l2);
        SSL.freeBIO((long)l3);
        if (0L != 0L) {
            SSL.freeX509Chain((long)0L);
        }
        if (0L != 0L) {
            SSL.freePrivateKey((long)0L);
        }
        pemEncoded.release();
        return object;
    }

    void destroy() {
    }
}

