/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Date;
import javax.security.cert.CertificateException;
import javax.security.cert.CertificateExpiredException;
import javax.security.cert.CertificateNotYetValidException;
import javax.security.cert.X509Certificate;

final class OpenSslJavaxX509Certificate
extends X509Certificate {
    private final byte[] bytes;
    private X509Certificate wrapped;

    OpenSslJavaxX509Certificate(byte[] byArray) {
        this.bytes = byArray;
    }

    public final void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.unwrap().checkValidity();
    }

    public final void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        this.unwrap().checkValidity(date);
    }

    public final int getVersion() {
        return this.unwrap().getVersion();
    }

    public final BigInteger getSerialNumber() {
        return this.unwrap().getSerialNumber();
    }

    public final Principal getIssuerDN() {
        return this.unwrap().getIssuerDN();
    }

    public final Principal getSubjectDN() {
        return this.unwrap().getSubjectDN();
    }

    public final Date getNotBefore() {
        return this.unwrap().getNotBefore();
    }

    public final Date getNotAfter() {
        return this.unwrap().getNotAfter();
    }

    public final String getSigAlgName() {
        return this.unwrap().getSigAlgName();
    }

    public final String getSigAlgOID() {
        return this.unwrap().getSigAlgOID();
    }

    public final byte[] getSigAlgParams() {
        return this.unwrap().getSigAlgParams();
    }

    public final byte[] getEncoded() {
        return (byte[])this.bytes.clone();
    }

    public final void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.unwrap().verify(publicKey);
    }

    public final void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.unwrap().verify(publicKey, string);
    }

    public final String toString() {
        return this.unwrap().toString();
    }

    public final PublicKey getPublicKey() {
        return this.unwrap().getPublicKey();
    }

    private X509Certificate unwrap() {
        X509Certificate x509Certificate = this.wrapped;
        if (x509Certificate == null) {
            try {
                x509Certificate = this.wrapped = X509Certificate.getInstance(this.bytes);
            }
            catch (CertificateException certificateException) {
                throw new IllegalStateException(certificateException);
            }
        }
        return x509Certificate;
    }
}

