/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.appoptics.ext.io.netty.handler.ssl.CipherSuiteFilter;
import com.appoptics.ext.io.netty.handler.ssl.ClientAuth;
import com.appoptics.ext.io.netty.handler.ssl.IdentityCipherSuiteFilter;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslContext;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslSessionContext;
import com.appoptics.ext.io.netty.handler.ssl.ReferenceCountedOpenSslClientContext;
import java.io.File;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenSslClientContext
extends OpenSslContext {
    private final OpenSslSessionContext sessionContext;

    @Deprecated
    public OpenSslClientContext() throws SSLException {
        this(null, null, null, null, null, null, null, IdentityCipherSuiteFilter.INSTANCE, null, 0L, 0L);
    }

    @Deprecated
    public OpenSslClientContext(File file, TrustManagerFactory trustManagerFactory, File file2, File file3, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3) throws SSLException {
        this(OpenSslClientContext.toX509CertificatesInternal(file), trustManagerFactory, OpenSslClientContext.toX509CertificatesInternal(file2), OpenSslClientContext.toPrivateKeyInternal(file3, string), string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, null, l2, l3, false, KeyStore.getDefaultType());
    }

    OpenSslClientContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, String[] stringArray, long l2, long l3, boolean bl, String string2) throws SSLException {
        super(iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3, 0, (Certificate[])x509CertificateArray2, ClientAuth.NONE, stringArray, false, bl);
        try {
            OpenSslKeyMaterialProvider.validateKeyMaterialSupported(x509CertificateArray2, privateKey, string);
            this.sessionContext = ReferenceCountedOpenSslClientContext.newSessionContext(this, this.ctx, this.engineMap, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, string2);
            return;
        }
        catch (Throwable throwable) {
            this.release();
            throw throwable;
        }
    }

    @Override
    public final OpenSslSessionContext sessionContext() {
        return this.sessionContext;
    }
}

