/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.proxy;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelInboundHandler;
import com.appoptics.ext.io.netty.channel.ChannelOutboundHandler;
import com.appoptics.ext.io.netty.channel.ChannelPipeline;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.handler.codec.base64.Base64;
import com.appoptics.ext.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.appoptics.ext.io.netty.handler.codec.http.HttpClientCodec;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaderNames;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaders;
import com.appoptics.ext.io.netty.handler.codec.http.HttpMethod;
import com.appoptics.ext.io.netty.handler.codec.http.HttpResponse;
import com.appoptics.ext.io.netty.handler.codec.http.HttpResponseStatus;
import com.appoptics.ext.io.netty.handler.codec.http.HttpUtil;
import com.appoptics.ext.io.netty.handler.codec.http.HttpVersion;
import com.appoptics.ext.io.netty.handler.codec.http.LastHttpContent;
import com.appoptics.ext.io.netty.handler.proxy.ProxyConnectException;
import com.appoptics.ext.io.netty.handler.proxy.ProxyHandler;
import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.CharsetUtil;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public final class HttpProxyHandler
extends ProxyHandler {
    private final HttpClientCodecWrapper codecWrapper = new HttpClientCodecWrapper();
    private final String username;
    private final String password;
    private final CharSequence authorization;
    private final HttpHeaders outboundHeaders;
    private final boolean ignoreDefaultPortsInConnectHostHeader;
    private HttpResponseStatus status;
    private HttpHeaders inboundHeaders;

    public HttpProxyHandler(SocketAddress socketAddress) {
        this(socketAddress, null);
    }

    public HttpProxyHandler(SocketAddress socketAddress, HttpHeaders httpHeaders) {
        this(socketAddress, httpHeaders, false);
    }

    public HttpProxyHandler(SocketAddress socketAddress, HttpHeaders httpHeaders, boolean bl) {
        super(socketAddress);
        this.username = null;
        this.password = null;
        this.authorization = null;
        this.outboundHeaders = httpHeaders;
        this.ignoreDefaultPortsInConnectHostHeader = bl;
    }

    public HttpProxyHandler(SocketAddress socketAddress, String string, String string2) {
        this(socketAddress, string, string2, null);
    }

    public HttpProxyHandler(SocketAddress socketAddress, String string, String string2, HttpHeaders httpHeaders) {
        this(socketAddress, string, string2, httpHeaders, false);
    }

    public HttpProxyHandler(SocketAddress object, String object2, String string, HttpHeaders httpHeaders, boolean bl) {
        super((SocketAddress)object);
        this.username = ObjectUtil.checkNotNull(object2, "username");
        this.password = ObjectUtil.checkNotNull(string, "password");
        object = Unpooled.copiedBuffer((String)object2 + ':' + string, CharsetUtil.UTF_8);
        try {
            object2 = Base64.encode((ByteBuf)object, false);
        }
        finally {
            object.release();
        }
        try {
            this.authorization = new AsciiString("Basic " + ((ByteBuf)object2).toString(CharsetUtil.US_ASCII));
        }
        finally {
            object2.release();
        }
        this.outboundHeaders = httpHeaders;
        this.ignoreDefaultPortsInConnectHostHeader = bl;
    }

    public final String protocol() {
        return "http";
    }

    public final String authScheme() {
        if (this.authorization != null) {
            return "basic";
        }
        return "none";
    }

    protected final void addCodec(ChannelHandlerContext object) throws Exception {
        ChannelPipeline channelPipeline = object.pipeline();
        object = object.name();
        channelPipeline.addBefore((String)object, null, this.codecWrapper);
    }

    protected final void removeEncoder(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.codecWrapper.codec.removeOutboundHandler();
    }

    protected final void removeDecoder(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.codecWrapper.codec.removeInboundHandler();
    }

    protected final Object newInitialMessage(ChannelHandlerContext object) throws Exception {
        object = (InetSocketAddress)this.destinationAddress();
        Object object2 = HttpUtil.formatHostnameForHttp((InetSocketAddress)object);
        int n2 = ((InetSocketAddress)object).getPort();
        String string = (String)object2 + ":" + n2;
        String string2 = this.ignoreDefaultPortsInConnectHostHeader && (n2 == 80 || n2 == 443) ? object2 : string;
        object2 = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.CONNECT, string, Unpooled.EMPTY_BUFFER, false);
        object2.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)string2);
        if (this.authorization != null) {
            object2.headers().set((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, (Object)this.authorization);
        }
        if (this.outboundHeaders != null) {
            object2.headers().add(this.outboundHeaders);
        }
        return object2;
    }

    protected final boolean handleResponse(ChannelHandlerContext object, Object object2) throws Exception {
        boolean bl;
        if (object2 instanceof HttpResponse) {
            if (this.status != null) {
                throw new HttpProxyConnectException(this.exceptionMessage("too many responses"), null);
            }
            object = (HttpResponse)object2;
            this.status = object.status();
            this.inboundHeaders = object.headers();
        }
        if (bl = object2 instanceof LastHttpContent) {
            if (this.status == null) {
                throw new HttpProxyConnectException(this.exceptionMessage("missing response"), this.inboundHeaders);
            }
            if (this.status.code() != 200) {
                throw new HttpProxyConnectException(this.exceptionMessage("status: " + this.status), this.inboundHeaders);
            }
        }
        return bl;
    }

    private static final class HttpClientCodecWrapper
    implements ChannelInboundHandler,
    ChannelOutboundHandler {
        final HttpClientCodec codec = new HttpClientCodec();

        private HttpClientCodecWrapper() {
        }

        public final void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.handlerAdded(channelHandlerContext);
        }

        public final void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.handlerRemoved(channelHandlerContext);
        }

        public final void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
            this.codec.exceptionCaught(channelHandlerContext, throwable);
        }

        public final void channelRegistered(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.channelRegistered(channelHandlerContext);
        }

        public final void channelUnregistered(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.channelUnregistered(channelHandlerContext);
        }

        public final void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.channelActive(channelHandlerContext);
        }

        public final void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.channelInactive(channelHandlerContext);
        }

        public final void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            this.codec.channelRead(channelHandlerContext, object);
        }

        public final void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.channelReadComplete(channelHandlerContext);
        }

        public final void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            this.codec.userEventTriggered(channelHandlerContext, object);
        }

        public final void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.channelWritabilityChanged(channelHandlerContext);
        }

        public final void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) throws Exception {
            this.codec.connect(channelHandlerContext, socketAddress, socketAddress2, channelPromise);
        }

        public final void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
            this.codec.disconnect(channelHandlerContext, channelPromise);
        }

        public final void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
            this.codec.close(channelHandlerContext, channelPromise);
        }

        public final void read(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.read(channelHandlerContext);
        }

        public final void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
            this.codec.write(channelHandlerContext, object, channelPromise);
        }

        public final void flush(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.flush(channelHandlerContext);
        }
    }

    public static final class HttpProxyConnectException
    extends ProxyConnectException {
        private static final long serialVersionUID = -8824334609292146066L;
        private final HttpHeaders headers;

        public HttpProxyConnectException(String string, HttpHeaders httpHeaders) {
            super(string);
            this.headers = httpHeaders;
        }
    }
}

