/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufUtil;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.handler.codec.http2.DecoratingHttp2ConnectionEncoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionAdapter;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Settings;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Stream;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.TreeMap;

public class StreamBufferingEncoder
extends DecoratingHttp2ConnectionEncoder {
    private final TreeMap<Integer, PendingStream> pendingStreams = new TreeMap();
    private int maxConcurrentStreams;
    private boolean closed;

    public StreamBufferingEncoder(Http2ConnectionEncoder http2ConnectionEncoder) {
        this(http2ConnectionEncoder, 100);
    }

    public StreamBufferingEncoder(Http2ConnectionEncoder http2ConnectionEncoder, int n2) {
        super(http2ConnectionEncoder);
        this.maxConcurrentStreams = n2;
        this.connection().addListener(new Http2ConnectionAdapter(){

            public void onGoAwayReceived(int n2, long l2, ByteBuf byteBuf) {
                StreamBufferingEncoder.this.cancelGoAwayStreams(n2, l2, byteBuf);
            }

            public void onStreamClosed(Http2Stream http2Stream) {
                StreamBufferingEncoder.this.tryCreatePendingStreams();
            }
        });
    }

    public int numBufferedStreams() {
        return this.pendingStreams.size();
    }

    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, boolean bl, ChannelPromise channelPromise) {
        return this.writeHeaders(channelHandlerContext, n2, http2Headers, 0, (short)16, false, n3, bl, channelPromise);
    }

    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, short s2, boolean bl, int n4, boolean bl2, ChannelPromise channelPromise) {
        if (this.closed) {
            return channelPromise.setFailure(new Http2ChannelClosedException());
        }
        if (this.isExistingStream(n2) || this.connection().goAwayReceived()) {
            return super.writeHeaders(channelHandlerContext, n2, http2Headers, n3, s2, bl, n4, bl2, channelPromise);
        }
        if (this.canCreateStream()) {
            return super.writeHeaders(channelHandlerContext, n2, http2Headers, n3, s2, bl, n4, bl2, channelPromise);
        }
        PendingStream pendingStream = this.pendingStreams.get(n2);
        if (pendingStream == null) {
            pendingStream = new PendingStream(channelHandlerContext, n2);
            this.pendingStreams.put(n2, pendingStream);
        }
        pendingStream.frames.add(new HeadersFrame(http2Headers, n3, s2, bl, n4, bl2, channelPromise));
        return channelPromise;
    }

    public ChannelFuture writeRstStream(ChannelHandlerContext object, int n2, long l2, ChannelPromise channelPromise) {
        if (this.isExistingStream(n2)) {
            return super.writeRstStream((ChannelHandlerContext)object, n2, l2, channelPromise);
        }
        object = this.pendingStreams.remove(n2);
        if (object != null) {
            ((PendingStream)object).close(null);
            channelPromise.setSuccess();
        } else {
            channelPromise.setFailure(Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream does not exist %d", n2));
        }
        return channelPromise;
    }

    public ChannelFuture writeData(ChannelHandlerContext object, int n2, ByteBuf byteBuf, int n3, boolean bl, ChannelPromise channelPromise) {
        if (this.isExistingStream(n2)) {
            return super.writeData((ChannelHandlerContext)object, n2, byteBuf, n3, bl, channelPromise);
        }
        object = this.pendingStreams.get(n2);
        if (object != null) {
            ((PendingStream)object).frames.add(new DataFrame(byteBuf, n3, bl, channelPromise));
        } else {
            ReferenceCountUtil.safeRelease(byteBuf);
            channelPromise.setFailure(Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream does not exist %d", n2));
        }
        return channelPromise;
    }

    public void remoteSettings(Http2Settings http2Settings) throws Http2Exception {
        super.remoteSettings(http2Settings);
        this.maxConcurrentStreams = this.connection().local().maxActiveStreams();
        this.tryCreatePendingStreams();
    }

    public void close() {
        try {
            if (!this.closed) {
                this.closed = true;
                Http2ChannelClosedException http2ChannelClosedException = new Http2ChannelClosedException();
                while (!this.pendingStreams.isEmpty()) {
                    PendingStream pendingStream = this.pendingStreams.pollFirstEntry().getValue();
                    pendingStream.close(http2ChannelClosedException);
                }
            }
            return;
        }
        finally {
            super.close();
        }
    }

    private void tryCreatePendingStreams() {
        while (!this.pendingStreams.isEmpty() && this.canCreateStream()) {
            Object object = this.pendingStreams.pollFirstEntry();
            object = object.getValue();
            try {
                ((PendingStream)object).sendFrames();
            }
            catch (Throwable throwable) {
                ((PendingStream)object).close(throwable);
            }
        }
    }

    private void cancelGoAwayStreams(int n2, long l2, ByteBuf byteBuf) {
        Iterator<PendingStream> iterator = this.pendingStreams.values().iterator();
        Http2GoAwayException http2GoAwayException = new Http2GoAwayException(n2, l2, ByteBufUtil.getBytes(byteBuf));
        while (iterator.hasNext()) {
            PendingStream pendingStream = iterator.next();
            if (pendingStream.streamId <= n2) continue;
            iterator.remove();
            pendingStream.close(http2GoAwayException);
        }
    }

    private boolean canCreateStream() {
        return this.connection().local().numActiveStreams() < this.maxConcurrentStreams;
    }

    private boolean isExistingStream(int n2) {
        return n2 <= this.connection().local().lastStreamCreated();
    }

    private final class DataFrame
    extends Frame {
        final ByteBuf data;
        final int padding;
        final boolean endOfStream;

        DataFrame(ByteBuf byteBuf, int n2, boolean bl, ChannelPromise channelPromise) {
            super(channelPromise);
            this.data = byteBuf;
            this.padding = n2;
            this.endOfStream = bl;
        }

        final void release(Throwable throwable) {
            super.release(throwable);
            ReferenceCountUtil.safeRelease(this.data);
        }

        final void send(ChannelHandlerContext channelHandlerContext, int n2) {
            StreamBufferingEncoder.this.writeData(channelHandlerContext, n2, this.data, this.padding, this.endOfStream, this.promise);
        }
    }

    private final class HeadersFrame
    extends Frame {
        final Http2Headers headers;
        final int streamDependency;
        final short weight;
        final boolean exclusive;
        final int padding;
        final boolean endOfStream;

        HeadersFrame(Http2Headers http2Headers, int n2, short s2, boolean bl, int n3, boolean bl2, ChannelPromise channelPromise) {
            super(channelPromise);
            this.headers = http2Headers;
            this.streamDependency = n2;
            this.weight = s2;
            this.exclusive = bl;
            this.padding = n3;
            this.endOfStream = bl2;
        }

        final void send(ChannelHandlerContext channelHandlerContext, int n2) {
            StreamBufferingEncoder.this.writeHeaders(channelHandlerContext, n2, this.headers, this.streamDependency, this.weight, this.exclusive, this.padding, this.endOfStream, this.promise);
        }
    }

    private static abstract class Frame {
        final ChannelPromise promise;

        Frame(ChannelPromise channelPromise) {
            this.promise = channelPromise;
        }

        void release(Throwable throwable) {
            if (throwable == null) {
                this.promise.setSuccess();
                return;
            }
            this.promise.setFailure(throwable);
        }

        abstract void send(ChannelHandlerContext var1, int var2);
    }

    private static final class PendingStream {
        final ChannelHandlerContext ctx;
        final int streamId;
        final Queue<Frame> frames = new ArrayDeque<Frame>(2);

        PendingStream(ChannelHandlerContext channelHandlerContext, int n2) {
            this.ctx = channelHandlerContext;
            this.streamId = n2;
        }

        final void sendFrames() {
            for (Frame frame : this.frames) {
                frame.send(this.ctx, this.streamId);
            }
        }

        final void close(Throwable throwable) {
            for (Frame frame : this.frames) {
                frame.release(throwable);
            }
        }
    }

    public static final class Http2GoAwayException
    extends Http2Exception {
        private static final long serialVersionUID = 1326785622777291198L;
        private final int lastStreamId;
        private final long errorCode;
        private final byte[] debugData;

        public Http2GoAwayException(int n2, long l2, byte[] byArray) {
            super(Http2Error.STREAM_CLOSED);
            this.lastStreamId = n2;
            this.errorCode = l2;
            this.debugData = byArray;
        }

        public final long errorCode() {
            return this.errorCode;
        }

        public final byte[] debugData() {
            return this.debugData;
        }
    }

    public static final class Http2ChannelClosedException
    extends Http2Exception {
        private static final long serialVersionUID = 4768543442094476971L;

        public Http2ChannelClosedException() {
            super(Http2Error.REFUSED_STREAM, "Connection closed");
        }
    }
}

