/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelInboundHandlerAdapter;
import com.appoptics.ext.io.netty.handler.codec.http.FullHttpMessage;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaders;
import com.appoptics.ext.io.netty.handler.codec.http.HttpScheme;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Connection;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameListener;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Stream;
import com.appoptics.ext.io.netty.handler.codec.http2.HttpConversionUtil;

public class InboundHttpToHttp2Adapter
extends ChannelInboundHandlerAdapter {
    private final Http2Connection connection;
    private final Http2FrameListener listener;

    private static int getStreamId(Http2Connection http2Connection, HttpHeaders httpHeaders) {
        return httpHeaders.getInt(HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), http2Connection.remote().incrementAndGetNextStreamId());
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (object instanceof FullHttpMessage) {
            InboundHttpToHttp2Adapter.handle(channelHandlerContext, this.connection, this.listener, (FullHttpMessage)object);
            return;
        }
        super.channelRead(channelHandlerContext, object);
    }

    static void handle(ChannelHandlerContext channelHandlerContext, Http2Connection object, Http2FrameListener http2FrameListener, FullHttpMessage fullHttpMessage) throws Http2Exception {
        try {
            int n2 = InboundHttpToHttp2Adapter.getStreamId((Http2Connection)object, fullHttpMessage.headers());
            Http2Stream http2Stream = object.stream(n2);
            if (http2Stream == null) {
                http2Stream = object.remote().createStream(n2, false);
            }
            fullHttpMessage.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)HttpScheme.HTTP.name());
            object = HttpConversionUtil.toHttp2Headers(fullHttpMessage, true);
            boolean bl = fullHttpMessage.content().isReadable();
            boolean bl2 = !fullHttpMessage.trailingHeaders().isEmpty();
            http2FrameListener.onHeadersRead(channelHandlerContext, n2, (Http2Headers)object, 0, !bl && !bl2);
            if (bl) {
                http2FrameListener.onDataRead(channelHandlerContext, n2, fullHttpMessage.content(), 0, !bl2);
            }
            if (bl2) {
                object = HttpConversionUtil.toHttp2Headers(fullHttpMessage.trailingHeaders(), true);
                http2FrameListener.onHeadersRead(channelHandlerContext, n2, (Http2Headers)object, 0, true);
            }
            http2Stream.closeRemoteSide();
            return;
        }
        finally {
            fullHttpMessage.release();
        }
    }
}

