/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.handler.codec.DefaultHeaders;
import com.appoptics.ext.io.netty.handler.codec.UnsupportedValueConverter;
import com.appoptics.ext.io.netty.handler.codec.ValueConverter;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaderNames;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaderValues;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaders;
import com.appoptics.ext.io.netty.handler.codec.http.HttpMessage;
import com.appoptics.ext.io.netty.handler.codec.http.HttpMethod;
import com.appoptics.ext.io.netty.handler.codec.http.HttpRequest;
import com.appoptics.ext.io.netty.handler.codec.http.HttpResponse;
import com.appoptics.ext.io.netty.handler.codec.http.HttpResponseStatus;
import com.appoptics.ext.io.netty.handler.codec.http.HttpScheme;
import com.appoptics.ext.io.netty.handler.codec.http.HttpUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.CharSequenceMap;
import com.appoptics.ext.io.netty.handler.codec.http2.DefaultHttp2Headers;
import com.appoptics.ext.io.netty.handler.codec.http2.EmptyHttp2Headers;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.ByteProcessor;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpConversionUtil {
    private static final CharSequenceMap<AsciiString> HTTP_TO_HTTP2_HEADER_BLACKLIST = new CharSequenceMap<AsciiString>();
    public static final HttpMethod OUT_OF_MESSAGE_SEQUENCE_METHOD;
    public static final HttpResponseStatus OUT_OF_MESSAGE_SEQUENCE_RETURN_CODE;
    private static final AsciiString EMPTY_REQUEST_PATH;

    public static Http2Headers toHttp2Headers(HttpMessage object, boolean bl) {
        HttpHeaders httpHeaders = object.headers();
        DefaultHttp2Headers defaultHttp2Headers = new DefaultHttp2Headers(bl, httpHeaders.size());
        if (object instanceof HttpRequest) {
            object = (HttpRequest)object;
            URI uRI = URI.create(object.uri());
            defaultHttp2Headers.path(HttpConversionUtil.toHttp2Path(uRI));
            defaultHttp2Headers.method(object.method().asciiName());
            HttpConversionUtil.setHttp2Scheme(httpHeaders, uRI, defaultHttp2Headers);
            if (!HttpUtil.isOriginForm(uRI) && !HttpUtil.isAsteriskForm(uRI)) {
                object = httpHeaders.getAsString(HttpHeaderNames.HOST);
                HttpConversionUtil.setHttp2Authority((String)(object == null || ((String)object).isEmpty() ? uRI.getAuthority() : object), defaultHttp2Headers);
            }
        } else if (object instanceof HttpResponse) {
            object = (HttpResponse)object;
            defaultHttp2Headers.status(object.status().codeAsText());
        }
        HttpConversionUtil.toHttp2Headers(httpHeaders, defaultHttp2Headers);
        return defaultHttp2Headers;
    }

    public static Http2Headers toHttp2Headers(HttpHeaders httpHeaders, boolean bl) {
        if (httpHeaders.isEmpty()) {
            return EmptyHttp2Headers.INSTANCE;
        }
        DefaultHttp2Headers defaultHttp2Headers = new DefaultHttp2Headers(bl, httpHeaders.size());
        HttpConversionUtil.toHttp2Headers(httpHeaders, defaultHttp2Headers);
        return defaultHttp2Headers;
    }

    private static CharSequenceMap<AsciiString> toLowercaseMap(Iterator<? extends CharSequence> iterator, int n2) {
        Object object = UnsupportedValueConverter.instance();
        CharSequenceMap<AsciiString> charSequenceMap = new CharSequenceMap<AsciiString>(true, (ValueConverter<AsciiString>)object, n2);
        while (iterator.hasNext()) {
            object = AsciiString.of(iterator.next()).toLowerCase();
            try {
                int n3 = ((AsciiString)object).forEachByte(ByteProcessor.FIND_COMMA);
                if (n3 != -1) {
                    int n4 = 0;
                    do {
                        charSequenceMap.add(((AsciiString)object).subSequence(n4, n3, false).trim(), AsciiString.EMPTY_STRING);
                    } while ((n4 = n3 + 1) < ((AsciiString)object).length() && (n3 = ((AsciiString)object).forEachByte(n4, ((AsciiString)object).length() - n4, ByteProcessor.FIND_COMMA)) != -1);
                    charSequenceMap.add(((AsciiString)object).subSequence(n4, ((AsciiString)object).length(), false).trim(), AsciiString.EMPTY_STRING);
                    continue;
                }
                charSequenceMap.add(((AsciiString)object).trim(), AsciiString.EMPTY_STRING);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return charSequenceMap;
    }

    private static void toHttp2HeadersFilterTE(Map.Entry<CharSequence, CharSequence> iterator, Http2Headers http2Headers) {
        if (AsciiString.indexOf(iterator.getValue(), ',', 0) == -1) {
            if (AsciiString.contentEqualsIgnoreCase(AsciiString.trim(iterator.getValue()), HttpHeaderValues.TRAILERS)) {
                http2Headers.add(HttpHeaderNames.TE, HttpHeaderValues.TRAILERS);
                return;
            }
        } else {
            iterator = StringUtil.unescapeCsvFields(iterator.getValue());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                CharSequence charSequence = iterator.next();
                if (!AsciiString.contentEqualsIgnoreCase(AsciiString.trim(charSequence), HttpHeaderValues.TRAILERS)) continue;
                http2Headers.add(HttpHeaderNames.TE, HttpHeaderValues.TRAILERS);
                return;
            }
        }
    }

    public static void toHttp2Headers(HttpHeaders iterable, Http2Headers http2Headers) {
        Iterator<Map.Entry<CharSequence, CharSequence>> iterator = ((HttpHeaders)iterable).iteratorCharSequence();
        iterable = HttpConversionUtil.toLowercaseMap(((HttpHeaders)iterable).valueCharSequenceIterator(HttpHeaderNames.CONNECTION), 8);
        while (iterator.hasNext()) {
            Map.Entry<CharSequence, CharSequence> entry = iterator.next();
            AsciiString asciiString = AsciiString.of(entry.getKey()).toLowerCase();
            if (HTTP_TO_HTTP2_HEADER_BLACKLIST.contains(asciiString) || ((DefaultHeaders)iterable).contains(asciiString)) continue;
            if (asciiString.contentEqualsIgnoreCase(HttpHeaderNames.TE)) {
                HttpConversionUtil.toHttp2HeadersFilterTE(entry, http2Headers);
                continue;
            }
            if (asciiString.contentEqualsIgnoreCase(HttpHeaderNames.COOKIE)) {
                entry = AsciiString.of(entry.getValue());
                try {
                    int n2 = ((AsciiString)((Object)entry)).forEachByte(ByteProcessor.FIND_SEMI_COLON);
                    if (n2 != -1) {
                        int n3 = 0;
                        do {
                            http2Headers.add(HttpHeaderNames.COOKIE, ((AsciiString)((Object)entry)).subSequence(n3, n2, false));
                        } while ((n3 = n2 + 2) < ((AsciiString)((Object)entry)).length() && (n2 = ((AsciiString)((Object)entry)).forEachByte(n3, ((AsciiString)((Object)entry)).length() - n3, ByteProcessor.FIND_SEMI_COLON)) != -1);
                        if (n3 >= ((AsciiString)((Object)entry)).length()) {
                            throw new IllegalArgumentException("cookie value is of unexpected format: " + entry);
                        }
                        http2Headers.add(HttpHeaderNames.COOKIE, ((AsciiString)((Object)entry)).subSequence(n3, ((AsciiString)((Object)entry)).length(), false));
                        continue;
                    }
                    http2Headers.add(HttpHeaderNames.COOKIE, entry);
                    continue;
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
            }
            http2Headers.add(asciiString, entry.getValue());
        }
    }

    private static AsciiString toHttp2Path(URI object) {
        StringBuilder stringBuilder = new StringBuilder(StringUtil.length(((URI)object).getRawPath()) + StringUtil.length(((URI)object).getRawQuery()) + StringUtil.length(((URI)object).getRawFragment()) + 2);
        if (!StringUtil.isNullOrEmpty(((URI)object).getRawPath())) {
            stringBuilder.append(((URI)object).getRawPath());
        }
        if (!StringUtil.isNullOrEmpty(((URI)object).getRawQuery())) {
            stringBuilder.append('?');
            stringBuilder.append(((URI)object).getRawQuery());
        }
        if (!StringUtil.isNullOrEmpty(((URI)object).getRawFragment())) {
            stringBuilder.append('#');
            stringBuilder.append(((URI)object).getRawFragment());
        }
        if (((String)(object = stringBuilder.toString())).isEmpty()) {
            return EMPTY_REQUEST_PATH;
        }
        return new AsciiString((CharSequence)object);
    }

    static void setHttp2Authority(String string, Http2Headers http2Headers) {
        if (string != null) {
            if (string.isEmpty()) {
                http2Headers.authority(AsciiString.EMPTY_STRING);
                return;
            }
            int n2 = string.indexOf(64) + 1;
            int n3 = string.length() - n2;
            if (n3 == 0) {
                throw new IllegalArgumentException("authority: " + string);
            }
            http2Headers.authority(new AsciiString(string, n2, n3));
        }
    }

    private static void setHttp2Scheme(HttpHeaders object, URI uRI, Http2Headers http2Headers) {
        String string = uRI.getScheme();
        if (string != null) {
            http2Headers.scheme(new AsciiString(string));
            return;
        }
        if ((object = ((HttpHeaders)object).get(ExtensionHeaderNames.SCHEME.text())) != null) {
            http2Headers.scheme(AsciiString.of((CharSequence)object));
            return;
        }
        if (uRI.getPort() == HttpScheme.HTTPS.port()) {
            http2Headers.scheme(HttpScheme.HTTPS.name());
            return;
        }
        if (uRI.getPort() == HttpScheme.HTTP.port()) {
            http2Headers.scheme(HttpScheme.HTTP.name());
            return;
        }
        throw new IllegalArgumentException(":scheme must be specified. see https://tools.ietf.org/html/rfc7540#section-8.1.2.3");
    }

    static {
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.CONNECTION, AsciiString.EMPTY_STRING);
        AsciiString asciiString = HttpHeaderNames.KEEP_ALIVE;
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(asciiString, AsciiString.EMPTY_STRING);
        asciiString = HttpHeaderNames.PROXY_CONNECTION;
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(asciiString, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.TRANSFER_ENCODING, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.HOST, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.UPGRADE, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(ExtensionHeaderNames.STREAM_ID.text(), AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(ExtensionHeaderNames.SCHEME.text(), AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(ExtensionHeaderNames.PATH.text(), AsciiString.EMPTY_STRING);
        OUT_OF_MESSAGE_SEQUENCE_METHOD = HttpMethod.OPTIONS;
        OUT_OF_MESSAGE_SEQUENCE_RETURN_CODE = HttpResponseStatus.OK;
        EMPTY_REQUEST_PATH = AsciiString.cached("/");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExtensionHeaderNames {
        STREAM_ID("x-http2-stream-id"),
        SCHEME("x-http2-scheme"),
        PATH("x-http2-path"),
        STREAM_PROMISE_ID("x-http2-stream-promise-id"),
        STREAM_DEPENDENCY_ID("x-http2-stream-dependency-id"),
        STREAM_WEIGHT("x-http2-stream-weight");

        private final AsciiString text;

        private ExtensionHeaderNames(String string2) {
            this.text = AsciiString.cached(string2);
        }

        public final AsciiString text() {
            return this.text;
        }
    }
}

