/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.channel.ChannelId;

final class Http2StreamChannelId
implements ChannelId {
    private static final long serialVersionUID = -6642338822166867585L;
    private final int id;
    private final ChannelId parentId;

    Http2StreamChannelId(ChannelId channelId, int n2) {
        this.parentId = channelId;
        this.id = n2;
    }

    public final String asShortText() {
        return this.parentId.asShortText() + '/' + this.id;
    }

    public final String asLongText() {
        return this.parentId.asLongText() + '/' + this.id;
    }

    public final int compareTo(ChannelId channelId) {
        if (channelId instanceof Http2StreamChannelId) {
            channelId = (Http2StreamChannelId)channelId;
            int n2 = this.parentId.compareTo(((Http2StreamChannelId)channelId).parentId);
            if (n2 == 0) {
                return this.id - ((Http2StreamChannelId)channelId).id;
            }
            return n2;
        }
        return this.parentId.compareTo(channelId);
    }

    public final int hashCode() {
        return this.id * 31 + this.parentId.hashCode();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Http2StreamChannelId)) {
            return false;
        }
        object = (Http2StreamChannelId)object;
        return this.id == ((Http2StreamChannelId)object).id && this.parentId.equals(((Http2StreamChannelId)object).parentId);
    }

    public final String toString() {
        return this.asShortText();
    }
}

