/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufUtil;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.channel.DefaultChannelPromise;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Flags;
import com.appoptics.ext.io.netty.handler.codec.http2.StreamByteDistributor;
import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.CharsetUtil;
import com.appoptics.ext.io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.TimeUnit;

public final class Http2CodecUtil {
    public static final CharSequence HTTP_UPGRADE_SETTINGS_HEADER = AsciiString.cached("HTTP2-Settings");
    public static final CharSequence HTTP_UPGRADE_PROTOCOL_NAME = "h2c";
    public static final CharSequence TLS_UPGRADE_PROTOCOL_NAME = "h2";
    private static final ByteBuf CONNECTION_PREFACE = Unpooled.unreleasableBuffer(Unpooled.directBuffer(24).writeBytes("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes(CharsetUtil.UTF_8))).asReadOnly();
    public static final long DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT_MILLIS = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);

    public static long calculateMaxHeaderListSizeGoAway(long l2) {
        long l3 = l2;
        return l3 + (l3 >>> 2);
    }

    public static boolean isStreamIdValid(int n2) {
        return n2 >= 0;
    }

    static boolean isStreamIdValid(int n2, boolean bl) {
        return Http2CodecUtil.isStreamIdValid(n2) && bl == ((n2 & 1) == 0);
    }

    public static boolean isMaxFrameSizeValid(int n2) {
        return n2 >= 16384 && n2 <= 0xFFFFFF;
    }

    public static ByteBuf connectionPrefaceBuf() {
        return CONNECTION_PREFACE.retainedDuplicate();
    }

    public static Http2Exception getEmbeddedHttp2Exception(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof Http2Exception) {
                return (Http2Exception)throwable;
            }
            throwable = throwable.getCause();
        }
        return null;
    }

    public static ByteBuf toByteBuf(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (throwable == null || throwable.getMessage() == null) {
            return Unpooled.EMPTY_BUFFER;
        }
        return ByteBufUtil.writeUtf8(channelHandlerContext.alloc(), (CharSequence)throwable.getMessage());
    }

    public static int readUnsignedInt(ByteBuf byteBuf) {
        return byteBuf.readInt() & Integer.MAX_VALUE;
    }

    public static int streamableBytes(StreamByteDistributor.StreamState streamState) {
        return Math.max(0, (int)Math.min(streamState.pendingBytes(), (long)streamState.windowSize()));
    }

    public static void headerListSizeExceeded(int n2, long l2, boolean bl) throws Http2Exception {
        throw Http2Exception.headerListSizeError(n2, Http2Error.PROTOCOL_ERROR, bl, "Header size exceeded max allowed size (%d)", l2);
    }

    public static void headerListSizeExceeded(long l2) throws Http2Exception {
        throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header size exceeded max allowed size (%d)", l2);
    }

    static void writeFrameHeaderInternal(ByteBuf byteBuf, int n2, byte by, Http2Flags http2Flags, int n3) {
        byteBuf.writeMedium(n2);
        byteBuf.writeByte(by);
        byteBuf.writeByte(http2Flags.value());
        byteBuf.writeInt(n3);
    }

    public static void verifyPadding(int n2) {
        if (n2 < 0 || n2 > 256) {
            throw new IllegalArgumentException(String.format("Invalid padding '%d'. Padding must be between 0 and %d (inclusive).", n2, 256));
        }
    }

    private Http2CodecUtil() {
    }

    static final class SimpleChannelPromiseAggregator
    extends DefaultChannelPromise {
        private final ChannelPromise promise;
        private int expectedCount;
        private int doneCount;
        private Throwable lastFailure;
        private boolean doneAllocating;

        SimpleChannelPromiseAggregator(ChannelPromise channelPromise, Channel channel, EventExecutor eventExecutor) {
            super(channel, eventExecutor);
            assert (channelPromise != null && !channelPromise.isDone());
            this.promise = channelPromise;
        }

        public final ChannelPromise newPromise() {
            assert (!this.doneAllocating) : "Done allocating. No more promises can be allocated.";
            ++this.expectedCount;
            return this;
        }

        public final ChannelPromise doneAllocatingPromises() {
            if (!this.doneAllocating) {
                this.doneAllocating = true;
                if (this.doneCount == this.expectedCount || this.expectedCount == 0) {
                    return this.setPromise();
                }
            }
            return this;
        }

        public final boolean tryFailure(Throwable throwable) {
            if (this.allowFailure()) {
                ++this.doneCount;
                this.lastFailure = throwable;
                if (this.allPromisesDone()) {
                    return this.tryPromise();
                }
                return true;
            }
            return false;
        }

        public final ChannelPromise setFailure(Throwable throwable) {
            if (this.allowFailure()) {
                ++this.doneCount;
                this.lastFailure = throwable;
                if (this.allPromisesDone()) {
                    return this.setPromise();
                }
            }
            return this;
        }

        public final ChannelPromise setSuccess(Void void_) {
            if (this.awaitingPromises()) {
                ++this.doneCount;
                if (this.allPromisesDone()) {
                    this.setPromise();
                }
            }
            return this;
        }

        public final boolean trySuccess(Void void_) {
            if (this.awaitingPromises()) {
                ++this.doneCount;
                if (this.allPromisesDone()) {
                    return this.tryPromise();
                }
                return true;
            }
            return false;
        }

        private boolean allowFailure() {
            return this.awaitingPromises() || this.expectedCount == 0;
        }

        private boolean awaitingPromises() {
            return this.doneCount < this.expectedCount;
        }

        private boolean allPromisesDone() {
            return this.doneCount == this.expectedCount && this.doneAllocating;
        }

        private ChannelPromise setPromise() {
            if (this.lastFailure == null) {
                this.promise.setSuccess();
                return super.setSuccess(null);
            }
            this.promise.setFailure(this.lastFailure);
            SimpleChannelPromiseAggregator simpleChannelPromiseAggregator = this;
            return super.setFailure(simpleChannelPromiseAggregator.lastFailure);
        }

        private boolean tryPromise() {
            if (this.lastFailure == null) {
                this.promise.trySuccess();
                return super.trySuccess(null);
            }
            this.promise.tryFailure(this.lastFailure);
            SimpleChannelPromiseAggregator simpleChannelPromiseAggregator = this;
            return super.tryFailure(simpleChannelPromiseAggregator.lastFailure);
        }
    }
}

