/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.handler.codec.http2.HpackUtil;
import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.ByteProcessor;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;

final class HpackHuffmanEncoder {
    private final int[] codes;
    private final byte[] lengths;
    private final EncodedLengthProcessor encodedLengthProcessor = new EncodedLengthProcessor();
    private final EncodeProcessor encodeProcessor = new EncodeProcessor();

    HpackHuffmanEncoder() {
        this(HpackUtil.HUFFMAN_CODES, HpackUtil.HUFFMAN_CODE_LENGTHS);
    }

    private HpackHuffmanEncoder(int[] nArray, byte[] byArray) {
        this.codes = nArray;
        this.lengths = byArray;
    }

    public final void encode(ByteBuf object, CharSequence charSequence) {
        ObjectUtil.checkNotNull(object, "out");
        if (charSequence instanceof AsciiString) {
            charSequence = (AsciiString)charSequence;
            try {
                this.encodeProcessor.out = object;
                ((AsciiString)charSequence).forEachByte(this.encodeProcessor);
            }
            catch (Exception exception) {
                object = exception;
                PlatformDependent.throwException(exception);
            }
            finally {
                this.encodeProcessor.end();
            }
        } else {
            this.encodeSlowPath((ByteBuf)object, charSequence);
        }
    }

    private void encodeSlowPath(ByteBuf byteBuf, CharSequence charSequence) {
        long l2 = 0L;
        int n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            int n3 = charSequence.charAt(i2) & 0xFF;
            int n4 = this.codes[n3];
            n3 = this.lengths[n3];
            l2 <<= n3;
            l2 |= (long)n4;
            n2 += n3;
            while (n2 >= 8) {
                byteBuf.writeByte((int)(l2 >> (n2 -= 8)));
            }
        }
        if (n2 > 0) {
            l2 <<= 8 - n2;
            byteBuf.writeByte((int)(l2 |= (long)(255 >>> n2)));
        }
    }

    final int getEncodedLength(CharSequence object) {
        if (object instanceof AsciiString) {
            object = (AsciiString)object;
            try {
                this.encodedLengthProcessor.reset();
                ((AsciiString)object).forEachByte(this.encodedLengthProcessor);
                return this.encodedLengthProcessor.length();
            }
            catch (Exception exception) {
                object = exception;
                PlatformDependent.throwException(exception);
                return -1;
            }
        }
        return this.getEncodedLengthSlowPath((CharSequence)object);
    }

    private int getEncodedLengthSlowPath(CharSequence charSequence) {
        long l2 = 0L;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            l2 += (long)this.lengths[charSequence.charAt(i2) & 0xFF];
        }
        return (int)(l2 + 7L >> 3);
    }

    private final class EncodedLengthProcessor
    implements ByteProcessor {
        private long len;

        private EncodedLengthProcessor() {
        }

        public final boolean process(byte by) {
            this.len += (long)HpackHuffmanEncoder.this.lengths[by & 0xFF];
            return true;
        }

        final void reset() {
            this.len = 0L;
        }

        final int length() {
            return (int)(this.len + 7L >> 3);
        }
    }

    private final class EncodeProcessor
    implements ByteProcessor {
        ByteBuf out;
        private long current;
        private int n;

        private EncodeProcessor() {
        }

        public final boolean process(byte by) {
            by = (byte)(by & 0xFF);
            byte by2 = HpackHuffmanEncoder.this.lengths[by];
            this.current <<= by2;
            this.current |= (long)HpackHuffmanEncoder.this.codes[by];
            this.n += by2;
            while (this.n >= 8) {
                this.n -= 8;
                this.out.writeByte((int)(this.current >> this.n));
            }
            return true;
        }

        final void end() {
            try {
                if (this.n > 0) {
                    this.current <<= 8 - this.n;
                    this.current |= (long)(255 >>> this.n);
                    this.out.writeByte((int)this.current);
                }
                return;
            }
            finally {
                this.out = null;
                this.current = 0L;
                this.n = 0;
            }
        }
    }
}

