/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.handler.codec.http2.HpackHeaderField;
import com.appoptics.ext.io.netty.handler.codec.http2.HpackHuffmanEncoder;
import com.appoptics.ext.io.netty.handler.codec.http2.HpackStaticTable;
import com.appoptics.ext.io.netty.handler.codec.http2.HpackUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2CodecUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2HeadersEncoder;
import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.CharsetUtil;
import com.appoptics.ext.io.netty.util.internal.MathUtil;
import java.util.Arrays;
import java.util.Map;

final class HpackEncoder {
    private final HeaderEntry[] headerFields;
    private final HeaderEntry head;
    private final HpackHuffmanEncoder hpackHuffmanEncoder;
    private final byte hashMask;
    private final boolean ignoreMaxHeaderListSize;
    private final int huffCodeThreshold;
    private long size;
    private long maxHeaderTableSize;
    private long maxHeaderListSize;

    HpackEncoder() {
        this(false);
    }

    HpackEncoder(boolean bl) {
        this(bl, 16, 512);
    }

    HpackEncoder(boolean bl, int n2, int n3) {
        AsciiString asciiString = AsciiString.EMPTY_STRING;
        this.head = new HeaderEntry(-1, asciiString, asciiString, Integer.MAX_VALUE, null);
        this.hpackHuffmanEncoder = new HpackHuffmanEncoder();
        this.ignoreMaxHeaderListSize = bl;
        this.maxHeaderTableSize = 4096L;
        this.maxHeaderListSize = 0xFFFFFFFFL;
        this.headerFields = new HeaderEntry[MathUtil.findNextPositivePowerOfTwo(Math.max(2, Math.min(n2, 128)))];
        this.hashMask = (byte)(this.headerFields.length - 1);
        this.head.before = this.head.after = this.head;
        this.huffCodeThreshold = n3;
    }

    public final void encodeHeaders(int n2, ByteBuf byteBuf, Http2Headers http2Headers, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) throws Http2Exception {
        if (this.ignoreMaxHeaderListSize) {
            this.encodeHeadersIgnoreMaxHeaderListSize(byteBuf, http2Headers, sensitivityDetector);
            return;
        }
        this.encodeHeadersEnforceMaxHeaderListSize(n2, byteBuf, http2Headers, sensitivityDetector);
    }

    private void encodeHeadersEnforceMaxHeaderListSize(int n2, ByteBuf byteBuf, Http2Headers http2Headers, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) throws Http2Exception {
        long l2 = 0L;
        for (Object object : http2Headers) {
            CharSequence charSequence = object.getKey();
            if ((l2 += HpackHeaderField.sizeOf(charSequence, (CharSequence)(object = object.getValue()))) <= this.maxHeaderListSize) continue;
            Http2CodecUtil.headerListSizeExceeded(n2, this.maxHeaderListSize, false);
        }
        this.encodeHeadersIgnoreMaxHeaderListSize(byteBuf, http2Headers, sensitivityDetector);
    }

    private void encodeHeadersIgnoreMaxHeaderListSize(ByteBuf byteBuf, Http2Headers object, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) throws Http2Exception {
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Map.Entry)object.next();
            CharSequence charSequence = (CharSequence)object2.getKey();
            object2 = (CharSequence)object2.getValue();
            this.encodeHeader(byteBuf, charSequence, (CharSequence)object2, sensitivityDetector.isSensitive(charSequence, (CharSequence)object2), HpackHeaderField.sizeOf(charSequence, (CharSequence)object2));
        }
    }

    private void encodeHeader(ByteBuf byteBuf, CharSequence charSequence, CharSequence charSequence2, boolean n2, long l2) {
        if (n2) {
            n2 = this.getNameIndex(charSequence);
            this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.NEVER, n2);
            return;
        }
        if (this.maxHeaderTableSize == 0L) {
            n2 = HpackStaticTable.getIndexInsensitive(charSequence, charSequence2);
            if (n2 == -1) {
                n2 = HpackStaticTable.getIndex(charSequence);
                this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.NONE, n2);
                return;
            }
            HpackEncoder.encodeInteger(byteBuf, 128, 7, n2);
            return;
        }
        if (l2 > this.maxHeaderTableSize) {
            n2 = this.getNameIndex(charSequence);
            this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.NONE, n2);
            return;
        }
        HeaderEntry headerEntry = this.getEntryInsensitive(charSequence, charSequence2);
        if (headerEntry != null) {
            int n3 = this.getIndex(headerEntry.index) + HpackStaticTable.length;
            HpackEncoder.encodeInteger(byteBuf, 128, 7, n3);
            return;
        }
        int n4 = HpackStaticTable.getIndexInsensitive(charSequence, charSequence2);
        if (n4 != -1) {
            HpackEncoder.encodeInteger(byteBuf, 128, 7, n4);
            return;
        }
        this.ensureCapacity(l2);
        this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.INCREMENTAL, this.getNameIndex(charSequence));
        this.add(charSequence, charSequence2, l2);
    }

    public final void setMaxHeaderTableSize(ByteBuf byteBuf, long l2) throws Http2Exception {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l2);
        }
        if (this.maxHeaderTableSize == l2) {
            return;
        }
        this.maxHeaderTableSize = l2;
        this.ensureCapacity(0L);
        HpackEncoder.encodeInteger(byteBuf, 32, 5, l2);
    }

    public final void setMaxHeaderListSize(long l2) throws Http2Exception {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header List Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l2);
        }
        this.maxHeaderListSize = l2;
    }

    private static void encodeInteger(ByteBuf byteBuf, int n2, int n3, int n4) {
        HpackEncoder.encodeInteger(byteBuf, n2, n3, (long)n4);
    }

    private static void encodeInteger(ByteBuf byteBuf, int n2, int n3, long l2) {
        assert (n3 >= 0 && n3 <= 8) : "N: " + n3;
        if (l2 < (long)(n3 = 255 >>> 8 - n3)) {
            byteBuf.writeByte((int)((long)n2 | l2));
            return;
        }
        byteBuf.writeByte(n2 | n3);
        long l3 = l2 - (long)n3;
        while ((l3 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            byteBuf.writeByte((int)(l3 & 0x7FL | 0x80L));
            l3 >>>= 7;
        }
        byteBuf.writeByte((int)l3);
    }

    private void encodeStringLiteral(ByteBuf byteBuf, CharSequence charSequence) {
        int n2;
        if (charSequence.length() >= this.huffCodeThreshold && (n2 = this.hpackHuffmanEncoder.getEncodedLength(charSequence)) < charSequence.length()) {
            HpackEncoder.encodeInteger(byteBuf, 128, 7, n2);
            this.hpackHuffmanEncoder.encode(byteBuf, charSequence);
            return;
        }
        HpackEncoder.encodeInteger(byteBuf, 0, 7, charSequence.length());
        if (charSequence instanceof AsciiString) {
            charSequence = (AsciiString)charSequence;
            byteBuf.writeBytes(((AsciiString)charSequence).array(), ((AsciiString)charSequence).arrayOffset(), ((AsciiString)charSequence).length());
            return;
        }
        byteBuf.writeCharSequence(charSequence, CharsetUtil.ISO_8859_1);
    }

    private void encodeLiteral(ByteBuf byteBuf, CharSequence charSequence, CharSequence charSequence2, HpackUtil.IndexType indexType, int n2) {
        boolean bl = n2 != -1;
        switch (indexType) {
            case INCREMENTAL: {
                HpackEncoder.encodeInteger(byteBuf, 64, 6, bl ? n2 : 0);
                break;
            }
            case NONE: {
                HpackEncoder.encodeInteger(byteBuf, 0, 4, bl ? n2 : 0);
                break;
            }
            case NEVER: {
                HpackEncoder.encodeInteger(byteBuf, 16, 4, bl ? n2 : 0);
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        if (!bl) {
            this.encodeStringLiteral(byteBuf, charSequence);
        }
        this.encodeStringLiteral(byteBuf, charSequence2);
    }

    private int getNameIndex(CharSequence charSequence) {
        int n2 = HpackStaticTable.getIndex(charSequence);
        if (n2 == -1 && (n2 = this.getIndex(charSequence)) >= 0) {
            n2 += HpackStaticTable.length;
        }
        return n2;
    }

    private void ensureCapacity(long l2) {
        int n2;
        while (this.maxHeaderTableSize - this.size < l2 && (n2 = this.length()) != 0) {
            this.remove();
        }
    }

    final int length() {
        if (this.size == 0L) {
            return 0;
        }
        return this.head.after.index - this.head.before.index + 1;
    }

    private HeaderEntry getEntryInsensitive(CharSequence charSequence, CharSequence charSequence2) {
        if (this.length() == 0 || charSequence == null || charSequence2 == null) {
            return null;
        }
        int n2 = AsciiString.hashCode(charSequence);
        int n3 = this.index(n2);
        HeaderEntry headerEntry = this.headerFields[n3];
        while (headerEntry != null) {
            if (headerEntry.hash == n2 && HpackUtil.equalsVariableTime(charSequence2, headerEntry.value) && HpackUtil.equalsVariableTime(charSequence, headerEntry.name)) {
                return headerEntry;
            }
            headerEntry = headerEntry.next;
        }
        return null;
    }

    private int getIndex(CharSequence charSequence) {
        if (this.length() == 0 || charSequence == null) {
            return -1;
        }
        int n2 = AsciiString.hashCode(charSequence);
        int n3 = this.index(n2);
        HeaderEntry headerEntry = this.headerFields[n3];
        while (headerEntry != null) {
            if (headerEntry.hash == n2 && HpackUtil.equalsConstantTime(charSequence, headerEntry.name) != 0) {
                return this.getIndex(headerEntry.index);
            }
            headerEntry = headerEntry.next;
        }
        return -1;
    }

    private int getIndex(int n2) {
        if (n2 == -1) {
            return -1;
        }
        return n2 - this.head.before.index + 1;
    }

    private void add(CharSequence object, CharSequence charSequence, long l2) {
        if (l2 > this.maxHeaderTableSize) {
            this.clear();
            return;
        }
        while (this.maxHeaderTableSize - this.size < l2) {
            this.remove();
        }
        int n2 = AsciiString.hashCode((CharSequence)object);
        int n3 = this.index(n2);
        HeaderEntry headerEntry = this.headerFields[n3];
        this.headerFields[n3] = object = new HeaderEntry(n2, (CharSequence)object, charSequence, this.head.before.index - 1, headerEntry);
        ((HeaderEntry)object).addBefore(this.head);
        this.size += l2;
    }

    private HpackHeaderField remove() {
        HeaderEntry headerEntry;
        if (this.size == 0L) {
            return null;
        }
        HeaderEntry headerEntry2 = this.head.after;
        int n2 = headerEntry2.hash;
        n2 = this.index(n2);
        HeaderEntry headerEntry3 = headerEntry = this.headerFields[n2];
        while (headerEntry3 != null) {
            HeaderEntry headerEntry4 = headerEntry3.next;
            if (headerEntry3 == headerEntry2) {
                if (headerEntry == headerEntry2) {
                    this.headerFields[n2] = headerEntry4;
                } else {
                    headerEntry.next = headerEntry4;
                }
                headerEntry2.remove();
                this.size -= (long)headerEntry2.size();
                return headerEntry2;
            }
            headerEntry = headerEntry3;
            headerEntry3 = headerEntry4;
        }
        return null;
    }

    private void clear() {
        Arrays.fill(this.headerFields, null);
        this.head.before = this.head.after = this.head;
        this.size = 0L;
    }

    private int index(int n2) {
        return n2 & this.hashMask;
    }

    private static final class HeaderEntry
    extends HpackHeaderField {
        HeaderEntry before;
        HeaderEntry after;
        HeaderEntry next;
        int hash;
        int index;

        HeaderEntry(int n2, CharSequence charSequence, CharSequence charSequence2, int n3, HeaderEntry headerEntry) {
            super(charSequence, charSequence2);
            this.index = n3;
            this.hash = n2;
            this.next = headerEntry;
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
            this.before = null;
            this.after = null;
            this.next = null;
        }

        private void addBefore(HeaderEntry headerEntry) {
            this.after = headerEntry;
            this.before = headerEntry.before;
            this.before.after = this;
            this.after.before = this;
        }
    }
}

