/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.handler.codec.http2.HpackDynamicTable;
import com.appoptics.ext.io.netty.handler.codec.http2.HpackHeaderField;
import com.appoptics.ext.io.netty.handler.codec.http2.HpackHuffmanDecoder;
import com.appoptics.ext.io.netty.handler.codec.http2.HpackStaticTable;
import com.appoptics.ext.io.netty.handler.codec.http2.HpackUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2CodecUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.ThrowableUtil;

final class HpackDecoder {
    private static final Http2Exception DECODE_ULE_128_DECOMPRESSION_EXCEPTION = ThrowableUtil.unknownStackTrace(Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - decompression failure", Http2Exception.ShutdownHint.HARD_SHUTDOWN), HpackDecoder.class, "decodeULE128(..)");
    private static final Http2Exception DECODE_ULE_128_TO_LONG_DECOMPRESSION_EXCEPTION = ThrowableUtil.unknownStackTrace(Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - long overflow", Http2Exception.ShutdownHint.HARD_SHUTDOWN), HpackDecoder.class, "decodeULE128(..)");
    private static final Http2Exception DECODE_ULE_128_TO_INT_DECOMPRESSION_EXCEPTION = ThrowableUtil.unknownStackTrace(Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - int overflow", Http2Exception.ShutdownHint.HARD_SHUTDOWN), HpackDecoder.class, "decodeULE128ToInt(..)");
    private static final Http2Exception DECODE_ILLEGAL_INDEX_VALUE = ThrowableUtil.unknownStackTrace(Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", Http2Exception.ShutdownHint.HARD_SHUTDOWN), HpackDecoder.class, "decode(..)");
    private static final Http2Exception INDEX_HEADER_ILLEGAL_INDEX_VALUE = ThrowableUtil.unknownStackTrace(Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", Http2Exception.ShutdownHint.HARD_SHUTDOWN), HpackDecoder.class, "indexHeader(..)");
    private static final Http2Exception READ_NAME_ILLEGAL_INDEX_VALUE = ThrowableUtil.unknownStackTrace(Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", Http2Exception.ShutdownHint.HARD_SHUTDOWN), HpackDecoder.class, "readName(..)");
    private static final Http2Exception INVALID_MAX_DYNAMIC_TABLE_SIZE = ThrowableUtil.unknownStackTrace(Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - invalid max dynamic table size", Http2Exception.ShutdownHint.HARD_SHUTDOWN), HpackDecoder.class, "setDynamicTableSize(..)");
    private static final Http2Exception MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED = ThrowableUtil.unknownStackTrace(Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - max dynamic table size change required", Http2Exception.ShutdownHint.HARD_SHUTDOWN), HpackDecoder.class, "decode(..)");
    private final HpackHuffmanDecoder huffmanDecoder = new HpackHuffmanDecoder();
    private final HpackDynamicTable hpackDynamicTable;
    private long maxHeaderListSize;
    private long maxDynamicTableSize;
    private long encoderMaxDynamicTableSize;
    private boolean maxDynamicTableSizeChangeRequired;

    HpackDecoder(long l2) {
        this(l2, 4096);
    }

    HpackDecoder(long l2, int n2) {
        this.maxHeaderListSize = ObjectUtil.checkPositive(l2, "maxHeaderListSize");
        HpackDecoder hpackDecoder = this;
        hpackDecoder.maxDynamicTableSize = hpackDecoder.encoderMaxDynamicTableSize = (long)n2;
        this.maxDynamicTableSizeChangeRequired = false;
        this.hpackDynamicTable = new HpackDynamicTable(n2);
    }

    public final void decode(int n2, ByteBuf byteBuf, Http2Headers http2Headers, boolean bl) throws Http2Exception {
        Http2HeadersSink http2HeadersSink = new Http2HeadersSink(n2, http2Headers, this.maxHeaderListSize, bl);
        this.decode(byteBuf, http2HeadersSink);
        http2HeadersSink.finish();
    }

    private void decode(ByteBuf byteBuf, Sink sink) throws Http2Exception {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        CharSequence charSequence = null;
        HpackUtil.IndexType indexType = HpackUtil.IndexType.NONE;
        block28: while (byteBuf.isReadable()) {
            switch (n5) {
                case 0: {
                    HpackHeaderField hpackHeaderField;
                    n2 = byteBuf.readByte();
                    if (this.maxDynamicTableSizeChangeRequired && (n2 & 0xE0) != 32) {
                        throw MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED;
                    }
                    if (n2 < 0) {
                        switch (n2 &= 0x7F) {
                            case 0: {
                                throw DECODE_ILLEGAL_INDEX_VALUE;
                            }
                            case 127: {
                                n5 = 2;
                                continue block28;
                            }
                        }
                        hpackHeaderField = this.getIndexedHeader(n2);
                        sink.appendToHeaderList(hpackHeaderField.name, hpackHeaderField.value);
                        continue block28;
                    }
                    if ((n2 & 0x40) == 64) {
                        indexType = HpackUtil.IndexType.INCREMENTAL;
                        switch (n2 &= 0x3F) {
                            case 0: {
                                n5 = 4;
                                continue block28;
                            }
                            case 63: {
                                n5 = 3;
                                continue block28;
                            }
                        }
                        charSequence = this.readName(n2);
                        n3 = charSequence.length();
                        n5 = 7;
                        continue block28;
                    }
                    if ((n2 & 0x20) == 32) {
                        if ((n2 &= 0x1F) == 31) {
                            n5 = 1;
                            continue block28;
                        }
                        this.setDynamicTableSize(n2);
                        n5 = 0;
                        continue block28;
                    }
                    indexType = (n2 & 0x10) == 16 ? HpackUtil.IndexType.NEVER : HpackUtil.IndexType.NONE;
                    switch (n2 &= 0xF) {
                        case 0: {
                            n5 = 4;
                            continue block28;
                        }
                        case 15: {
                            n5 = 3;
                            continue block28;
                        }
                    }
                    charSequence = this.readName(n2);
                    n3 = charSequence.length();
                    n5 = 7;
                    continue block28;
                }
                case 1: {
                    this.setDynamicTableSize(HpackDecoder.decodeULE128(byteBuf, (long)n2));
                    n5 = 0;
                    continue block28;
                }
                case 2: {
                    HpackHeaderField hpackHeaderField = this.getIndexedHeader(HpackDecoder.decodeULE128(byteBuf, n2));
                    sink.appendToHeaderList(hpackHeaderField.name, hpackHeaderField.value);
                    n5 = 0;
                    continue block28;
                }
                case 3: {
                    charSequence = this.readName(HpackDecoder.decodeULE128(byteBuf, n2));
                    n3 = charSequence.length();
                    n5 = 7;
                    continue block28;
                }
                case 4: {
                    n2 = byteBuf.readByte();
                    boolean bl2 = bl = (n2 & 0x80) == 128;
                    if ((n2 &= 0x7F) == 127) {
                        n5 = 5;
                        continue block28;
                    }
                    n3 = n2;
                    n5 = 6;
                    continue block28;
                }
                case 5: {
                    n3 = HpackDecoder.decodeULE128(byteBuf, n2);
                    n5 = 6;
                    continue block28;
                }
                case 6: {
                    if (byteBuf.readableBytes() < n3) {
                        throw HpackDecoder.notEnoughDataException(byteBuf);
                    }
                    charSequence = this.readStringLiteral(byteBuf, n3, bl);
                    n5 = 7;
                    continue block28;
                }
                case 7: {
                    n2 = byteBuf.readByte();
                    bl = (n2 & 0x80) == 128;
                    switch (n2 &= 0x7F) {
                        case 127: {
                            n5 = 8;
                            continue block28;
                        }
                        case 0: {
                            this.insertHeader(sink, charSequence, AsciiString.EMPTY_STRING, indexType);
                            n5 = 0;
                            continue block28;
                        }
                    }
                    n4 = n2;
                    n5 = 9;
                    continue block28;
                }
                case 8: {
                    n4 = HpackDecoder.decodeULE128(byteBuf, n2);
                    n5 = 9;
                    continue block28;
                }
                case 9: {
                    if (byteBuf.readableBytes() < n4) {
                        throw HpackDecoder.notEnoughDataException(byteBuf);
                    }
                    CharSequence charSequence2 = this.readStringLiteral(byteBuf, n4, bl);
                    this.insertHeader(sink, charSequence, charSequence2, indexType);
                    n5 = 0;
                    continue block28;
                }
            }
            throw new Error("should not reach here state: " + n5);
        }
        if (n5 != 0) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "Incomplete header block fragment.", new Object[0]);
        }
    }

    public final void setMaxHeaderTableSize(long l2) throws Http2Exception {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l2);
        }
        this.maxDynamicTableSize = l2;
        if (this.maxDynamicTableSize < this.encoderMaxDynamicTableSize) {
            this.maxDynamicTableSizeChangeRequired = true;
            this.hpackDynamicTable.setCapacity(this.maxDynamicTableSize);
        }
    }

    public final void setMaxHeaderListSize(long l2) throws Http2Exception {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header List Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l2);
        }
        this.maxHeaderListSize = l2;
    }

    public final long getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public final long getMaxHeaderTableSize() {
        return this.hpackDynamicTable.capacity();
    }

    private void setDynamicTableSize(long l2) throws Http2Exception {
        if (l2 > this.maxDynamicTableSize) {
            throw INVALID_MAX_DYNAMIC_TABLE_SIZE;
        }
        this.encoderMaxDynamicTableSize = l2;
        this.maxDynamicTableSizeChangeRequired = false;
        this.hpackDynamicTable.setCapacity(l2);
    }

    private static HeaderType validate(int n2, CharSequence object, HeaderType headerType) throws Http2Exception {
        if (Http2Headers.PseudoHeaderName.hasPseudoHeaderFormat(object)) {
            if (headerType == HeaderType.REGULAR_HEADER) {
                throw Http2Exception.streamError(n2, Http2Error.PROTOCOL_ERROR, "Pseudo-header field '%s' found after regular header.", object);
            }
            Http2Headers.PseudoHeaderName pseudoHeaderName = Http2Headers.PseudoHeaderName.getPseudoHeader(object);
            if (pseudoHeaderName == null) {
                throw Http2Exception.streamError(n2, Http2Error.PROTOCOL_ERROR, "Invalid HTTP/2 pseudo-header '%s' encountered.", object);
            }
            Object object2 = object = pseudoHeaderName.isRequestOnly() ? HeaderType.REQUEST_PSEUDO_HEADER : HeaderType.RESPONSE_PSEUDO_HEADER;
            if (headerType != null && object != headerType) {
                throw Http2Exception.streamError(n2, Http2Error.PROTOCOL_ERROR, "Mix of request and response pseudo-headers.", new Object[0]);
            }
            return object;
        }
        return HeaderType.REGULAR_HEADER;
    }

    private CharSequence readName(int n2) throws Http2Exception {
        if (n2 <= HpackStaticTable.length) {
            HpackHeaderField hpackHeaderField = HpackStaticTable.getEntry(n2);
            return hpackHeaderField.name;
        }
        if (n2 - HpackStaticTable.length <= this.hpackDynamicTable.length()) {
            HpackHeaderField hpackHeaderField = this.hpackDynamicTable.getEntry(n2 - HpackStaticTable.length);
            return hpackHeaderField.name;
        }
        throw READ_NAME_ILLEGAL_INDEX_VALUE;
    }

    private HpackHeaderField getIndexedHeader(int n2) throws Http2Exception {
        if (n2 <= HpackStaticTable.length) {
            return HpackStaticTable.getEntry(n2);
        }
        if (n2 - HpackStaticTable.length <= this.hpackDynamicTable.length()) {
            return this.hpackDynamicTable.getEntry(n2 - HpackStaticTable.length);
        }
        throw INDEX_HEADER_ILLEGAL_INDEX_VALUE;
    }

    private void insertHeader(Sink sink, CharSequence charSequence, CharSequence charSequence2, HpackUtil.IndexType indexType) {
        sink.appendToHeaderList(charSequence, charSequence2);
        switch (indexType) {
            case NONE: 
            case NEVER: {
                return;
            }
            case INCREMENTAL: {
                this.hpackDynamicTable.add(new HpackHeaderField(charSequence, charSequence2));
                return;
            }
        }
        throw new Error("should not reach here");
    }

    private CharSequence readStringLiteral(ByteBuf byteBuf, int n2, boolean bl) throws Http2Exception {
        if (bl) {
            return this.huffmanDecoder.decode(byteBuf, n2);
        }
        byte[] byArray = new byte[n2];
        byteBuf.readBytes(byArray);
        return new AsciiString(byArray, false);
    }

    private static IllegalArgumentException notEnoughDataException(ByteBuf byteBuf) {
        return new IllegalArgumentException("decode only works with an entire header block! " + byteBuf);
    }

    static int decodeULE128(ByteBuf byteBuf, int n2) throws Http2Exception {
        int n3 = byteBuf.readerIndex();
        long l2 = HpackDecoder.decodeULE128(byteBuf, (long)n2);
        if (l2 > Integer.MAX_VALUE) {
            byteBuf.readerIndex(n3);
            throw DECODE_ULE_128_TO_INT_DECOMPRESSION_EXCEPTION;
        }
        return (int)l2;
    }

    static long decodeULE128(ByteBuf byteBuf, long l2) throws Http2Exception {
        assert (l2 <= 127L && l2 >= 0L);
        boolean bl = l2 == 0L;
        int n2 = byteBuf.writerIndex();
        int n3 = byteBuf.readerIndex();
        int n4 = 0;
        while (n3 < n2) {
            byte by = byteBuf.getByte(n3);
            if (n4 == 56 && ((by & 0x80) != 0 || by == 127 && !bl)) {
                throw DECODE_ULE_128_TO_LONG_DECOMPRESSION_EXCEPTION;
            }
            if ((by & 0x80) == 0) {
                byteBuf.readerIndex(n3 + 1);
                return l2 + (((long)by & 0x7FL) << n4);
            }
            l2 += ((long)by & 0x7FL) << n4;
            ++n3;
            n4 += 7;
        }
        throw DECODE_ULE_128_DECOMPRESSION_EXCEPTION;
    }

    private static final class Http2HeadersSink
    implements Sink {
        private final Http2Headers headers;
        private final long maxHeaderListSize;
        private final int streamId;
        private final boolean validate;
        private long headersLength;
        private boolean exceededMaxLength;
        private HeaderType previousType;
        private Http2Exception validationException;

        Http2HeadersSink(int n2, Http2Headers http2Headers, long l2, boolean bl) {
            this.headers = http2Headers;
            this.maxHeaderListSize = l2;
            this.streamId = n2;
            this.validate = bl;
        }

        public final void finish() throws Http2Exception {
            if (this.exceededMaxLength) {
                Http2CodecUtil.headerListSizeExceeded(this.streamId, this.maxHeaderListSize, true);
                return;
            }
            if (this.validationException != null) {
                throw this.validationException;
            }
        }

        public final void appendToHeaderList(CharSequence charSequence, CharSequence charSequence2) {
            this.headersLength += HpackHeaderField.sizeOf(charSequence, charSequence2);
            this.exceededMaxLength |= this.headersLength > this.maxHeaderListSize;
            if (this.exceededMaxLength || this.validationException != null) {
                return;
            }
            if (this.validate) {
                try {
                    this.previousType = HpackDecoder.validate(this.streamId, charSequence, this.previousType);
                }
                catch (Http2Exception http2Exception) {
                    this.validationException = http2Exception;
                    return;
                }
            }
            this.headers.add(charSequence, charSequence2);
        }
    }

    private static interface Sink {
        public void appendToHeaderList(CharSequence var1, CharSequence var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HeaderType {
        REGULAR_HEADER,
        REQUEST_PSEUDO_HEADER,
        RESPONSE_PSEUDO_HEADER;

    }
}

