/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Connection;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionAdapter;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameWriter;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2LocalFlowController;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Stream;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2StreamVisitor;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;

public class DefaultHttp2LocalFlowController
implements Http2LocalFlowController {
    private final Http2Connection connection;
    private final Http2Connection.PropertyKey stateKey;
    private Http2FrameWriter frameWriter;
    private ChannelHandlerContext ctx;
    private float windowUpdateRatio;
    private int initialWindowSize = 65535;
    private static final FlowState REDUCED_FLOW_STATE = new FlowState(){

        public final int windowSize() {
            return 0;
        }

        public final int initialWindowSize() {
            return 0;
        }

        public final void incrementInitialStreamWindow(int n2) {
        }

        public final boolean writeWindowUpdateIfNeeded() throws Http2Exception {
            throw new UnsupportedOperationException();
        }

        public final boolean consumeBytes(int n2) throws Http2Exception {
            return false;
        }

        public final int unconsumedBytes() {
            return 0;
        }

        public final void receiveFlowControlledFrame(int n2) throws Http2Exception {
            throw new UnsupportedOperationException();
        }

        public final void incrementFlowControlWindows(int n2) throws Http2Exception {
        }

        public final void endOfStream(boolean bl) {
            throw new UnsupportedOperationException();
        }
    };

    public DefaultHttp2LocalFlowController(Http2Connection http2Connection) {
        this(http2Connection, 0.5f, false);
    }

    public DefaultHttp2LocalFlowController(Http2Connection http2Connection, float f2, boolean bl) {
        this.connection = ObjectUtil.checkNotNull(http2Connection, "connection");
        this.windowUpdateRatio(f2);
        this.stateKey = http2Connection.newKey();
        DefaultState defaultState = bl ? new AutoRefillState(http2Connection.connectionStream(), this.initialWindowSize) : new DefaultState(http2Connection.connectionStream(), this.initialWindowSize);
        http2Connection.connectionStream().setProperty(this.stateKey, defaultState);
        http2Connection.addListener(new Http2ConnectionAdapter(){

            public void onStreamAdded(Http2Stream http2Stream) {
                http2Stream.setProperty(DefaultHttp2LocalFlowController.this.stateKey, REDUCED_FLOW_STATE);
            }

            public void onStreamActive(Http2Stream http2Stream) {
                http2Stream.setProperty(DefaultHttp2LocalFlowController.this.stateKey, new DefaultState(http2Stream, DefaultHttp2LocalFlowController.this.initialWindowSize));
            }

            public void onStreamClosed(Http2Stream http2Stream) {
                try {
                    FlowState flowState = DefaultHttp2LocalFlowController.this.state(http2Stream);
                    int n2 = flowState.unconsumedBytes();
                    if (DefaultHttp2LocalFlowController.this.ctx != null && n2 > 0 && DefaultHttp2LocalFlowController.this.consumeAllBytes(flowState, n2)) {
                        DefaultHttp2LocalFlowController.this.ctx.flush();
                    }
                    return;
                }
                catch (Http2Exception http2Exception) {
                    Http2Exception http2Exception2 = http2Exception;
                    PlatformDependent.throwException(http2Exception);
                    return;
                }
                finally {
                    http2Stream.setProperty(DefaultHttp2LocalFlowController.this.stateKey, REDUCED_FLOW_STATE);
                }
            }
        });
    }

    public DefaultHttp2LocalFlowController frameWriter(Http2FrameWriter http2FrameWriter) {
        this.frameWriter = ObjectUtil.checkNotNull(http2FrameWriter, "frameWriter");
        return this;
    }

    public void channelHandlerContext(ChannelHandlerContext channelHandlerContext) {
        this.ctx = ObjectUtil.checkNotNull(channelHandlerContext, "ctx");
    }

    public void initialWindowSize(int n2) throws Http2Exception {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        int n3 = n2 - this.initialWindowSize;
        this.initialWindowSize = n2;
        WindowUpdateVisitor windowUpdateVisitor = new WindowUpdateVisitor(n3);
        this.connection.forEachActiveStream(windowUpdateVisitor);
        windowUpdateVisitor.throwIfError();
    }

    public int initialWindowSize() {
        return this.initialWindowSize;
    }

    public int windowSize(Http2Stream http2Stream) {
        return this.state(http2Stream).windowSize();
    }

    public int initialWindowSize(Http2Stream http2Stream) {
        return this.state(http2Stream).initialWindowSize();
    }

    public void incrementWindowSize(Http2Stream object, int n2) throws Http2Exception {
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        object = this.state((Http2Stream)object);
        object.incrementInitialStreamWindow(n2);
        object.writeWindowUpdateIfNeeded();
    }

    public boolean consumeBytes(Http2Stream http2Stream, int n2) throws Http2Exception {
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        ObjectUtil.checkPositiveOrZero(n2, "numBytes");
        if (n2 == 0) {
            return false;
        }
        if (http2Stream != null && !DefaultHttp2LocalFlowController.isClosed(http2Stream)) {
            if (http2Stream.id() == 0) {
                throw new UnsupportedOperationException("Returning bytes for the connection window is not supported");
            }
            DefaultHttp2LocalFlowController defaultHttp2LocalFlowController = this;
            return defaultHttp2LocalFlowController.consumeAllBytes(defaultHttp2LocalFlowController.state(http2Stream), n2);
        }
        return false;
    }

    private boolean consumeAllBytes(FlowState flowState, int n2) throws Http2Exception {
        return this.connectionState().consumeBytes(n2) | flowState.consumeBytes(n2);
    }

    public int unconsumedBytes(Http2Stream http2Stream) {
        return this.state(http2Stream).unconsumedBytes();
    }

    private static void checkValidRatio(float f2) {
        if (Double.compare(f2, 0.0) <= 0 || Double.compare(f2, 1.0) >= 0) {
            throw new IllegalArgumentException("Invalid ratio: " + f2);
        }
    }

    public void windowUpdateRatio(float f2) {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        DefaultHttp2LocalFlowController.checkValidRatio(f2);
        this.windowUpdateRatio = f2;
    }

    public void receiveFlowControlledFrame(Http2Stream object, ByteBuf byteBuf, int n2, boolean bl) throws Http2Exception {
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        int n3 = byteBuf.readableBytes() + n2;
        FlowState flowState = this.connectionState();
        flowState.receiveFlowControlledFrame(n3);
        if (object != null && !DefaultHttp2LocalFlowController.isClosed((Http2Stream)object)) {
            object = this.state((Http2Stream)object);
            object.endOfStream(bl);
            object.receiveFlowControlledFrame(n3);
            return;
        }
        if (n3 > 0) {
            flowState.consumeBytes(n3);
        }
    }

    private FlowState connectionState() {
        return (FlowState)this.connection.connectionStream().getProperty(this.stateKey);
    }

    private FlowState state(Http2Stream http2Stream) {
        return (FlowState)http2Stream.getProperty(this.stateKey);
    }

    private static boolean isClosed(Http2Stream http2Stream) {
        return http2Stream.state() == Http2Stream.State.CLOSED;
    }

    private final class WindowUpdateVisitor
    implements Http2StreamVisitor {
        private Http2Exception.CompositeStreamException compositeException;
        private final int delta;

        WindowUpdateVisitor(int n2) {
            this.delta = n2;
        }

        public final boolean visit(Http2Stream object) throws Http2Exception {
            try {
                object = DefaultHttp2LocalFlowController.this.state((Http2Stream)object);
                object.incrementFlowControlWindows(this.delta);
                object.incrementInitialStreamWindow(this.delta);
            }
            catch (Http2Exception.StreamException streamException) {
                if (this.compositeException == null) {
                    this.compositeException = new Http2Exception.CompositeStreamException(streamException.error(), 4);
                }
                this.compositeException.add(streamException);
            }
            return true;
        }

        public final void throwIfError() throws Http2Exception.CompositeStreamException {
            if (this.compositeException != null) {
                throw this.compositeException;
            }
        }
    }

    private static interface FlowState {
        public int windowSize();

        public int initialWindowSize();

        public void incrementInitialStreamWindow(int var1);

        public boolean writeWindowUpdateIfNeeded() throws Http2Exception;

        public boolean consumeBytes(int var1) throws Http2Exception;

        public int unconsumedBytes();

        public void receiveFlowControlledFrame(int var1) throws Http2Exception;

        public void incrementFlowControlWindows(int var1) throws Http2Exception;

        public void endOfStream(boolean var1);
    }

    private class DefaultState
    implements FlowState {
        private final Http2Stream stream;
        private int window;
        private int processedWindow;
        private int initialStreamWindowSize;
        private float streamWindowUpdateRatio;
        private int lowerBound;
        private boolean endOfStream;

        DefaultState(Http2Stream http2Stream, int n2) {
            this.stream = http2Stream;
            this.window(n2);
            this.streamWindowUpdateRatio = DefaultHttp2LocalFlowController.this.windowUpdateRatio;
        }

        public void window(int n2) {
            assert (DefaultHttp2LocalFlowController.this.ctx == null || DefaultHttp2LocalFlowController.this.ctx.executor().inEventLoop());
            DefaultState defaultState = this;
            defaultState.processedWindow = this.initialStreamWindowSize = n2;
            defaultState.window = this.initialStreamWindowSize;
        }

        public int windowSize() {
            return this.window;
        }

        public int initialWindowSize() {
            return this.initialStreamWindowSize;
        }

        public void endOfStream(boolean bl) {
            this.endOfStream = bl;
        }

        public void incrementInitialStreamWindow(int n2) {
            n2 = (int)Math.min(Integer.MAX_VALUE, Math.max(0L, (long)this.initialStreamWindowSize + (long)n2));
            this.initialStreamWindowSize += (n2 -= this.initialStreamWindowSize);
        }

        public void incrementFlowControlWindows(int n2) throws Http2Exception {
            if (n2 > 0 && this.window > Integer.MAX_VALUE - n2) {
                throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Flow control window overflowed for stream: %d", this.stream.id());
            }
            this.window += n2;
            this.processedWindow += n2;
            this.lowerBound = n2 < 0 ? n2 : 0;
        }

        public void receiveFlowControlledFrame(int n2) throws Http2Exception {
            assert (n2 >= 0);
            this.window -= n2;
            if (this.window < this.lowerBound) {
                throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Flow control window exceeded for stream: %d", this.stream.id());
            }
        }

        private void returnProcessedBytes(int n2) throws Http2Exception {
            if (this.processedWindow - n2 < this.window) {
                throw Http2Exception.streamError(this.stream.id(), Http2Error.INTERNAL_ERROR, "Attempting to return too many bytes for stream %d", this.stream.id());
            }
            this.processedWindow -= n2;
        }

        public boolean consumeBytes(int n2) throws Http2Exception {
            this.returnProcessedBytes(n2);
            return this.writeWindowUpdateIfNeeded();
        }

        public int unconsumedBytes() {
            return this.processedWindow - this.window;
        }

        public boolean writeWindowUpdateIfNeeded() throws Http2Exception {
            if (this.endOfStream || this.initialStreamWindowSize <= 0 || DefaultHttp2LocalFlowController.isClosed(this.stream)) {
                return false;
            }
            int n2 = (int)((float)this.initialStreamWindowSize * this.streamWindowUpdateRatio);
            if (this.processedWindow <= n2) {
                this.writeWindowUpdate();
                return true;
            }
            return false;
        }

        private void writeWindowUpdate() throws Http2Exception {
            int n2 = this.initialStreamWindowSize - this.processedWindow;
            try {
                this.incrementFlowControlWindows(n2);
            }
            catch (Throwable throwable) {
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, throwable, "Attempting to return too many bytes for stream %d", this.stream.id());
            }
            DefaultHttp2LocalFlowController.this.frameWriter.writeWindowUpdate(DefaultHttp2LocalFlowController.this.ctx, this.stream.id(), n2, DefaultHttp2LocalFlowController.this.ctx.newPromise());
        }
    }

    private final class AutoRefillState
    extends DefaultState {
        AutoRefillState(Http2Stream http2Stream, int n2) {
            super(http2Stream, n2);
        }

        public final void receiveFlowControlledFrame(int n2) throws Http2Exception {
            super.receiveFlowControlledFrame(n2);
            super.consumeBytes(n2);
        }

        public final boolean consumeBytes(int n2) throws Http2Exception {
            return false;
        }
    }
}

