/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.handler.codec.http2.DefaultHttp2HeadersEncoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2CodecUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Flags;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameSizePolicy;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameWriter;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2HeadersEncoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Settings;
import com.appoptics.ext.io.netty.util.ReferenceCounted;
import com.appoptics.ext.io.netty.util.collection.CharObjectHashMap;
import com.appoptics.ext.io.netty.util.collection.CharObjectMap;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;

public class DefaultHttp2FrameWriter
implements Http2FrameSizePolicy,
Http2FrameWriter,
Http2FrameWriter.Configuration {
    private static final ByteBuf ZERO_BUFFER = Unpooled.unreleasableBuffer(Unpooled.directBuffer(255).writeZero(255)).asReadOnly();
    private final Http2HeadersEncoder headersEncoder;
    private int maxFrameSize;

    public DefaultHttp2FrameWriter() {
        this(new DefaultHttp2HeadersEncoder());
    }

    public DefaultHttp2FrameWriter(Http2HeadersEncoder http2HeadersEncoder) {
        this.headersEncoder = http2HeadersEncoder;
        this.maxFrameSize = 16384;
    }

    public Http2FrameWriter.Configuration configuration() {
        return this;
    }

    public Http2HeadersEncoder.Configuration headersConfiguration() {
        return this.headersEncoder.configuration();
    }

    public Http2FrameSizePolicy frameSizePolicy() {
        return this;
    }

    public void maxFrameSize(int n2) throws Http2Exception {
        if (!Http2CodecUtil.isMaxFrameSizeValid(n2)) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Invalid MAX_FRAME_SIZE specified in sent settings: %d", n2);
        }
        this.maxFrameSize = n2;
    }

    public int maxFrameSize() {
        return this.maxFrameSize;
    }

    public void close() {
    }

    public ChannelFuture writeData(ChannelHandlerContext channelHandlerContext, int n2, ByteBuf byteBuf, int n3, boolean bl, ChannelPromise channelPromise) {
        channelPromise = new Http2CodecUtil.SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        ReferenceCounted referenceCounted = null;
        try {
            DefaultHttp2FrameWriter.verifyStreamId(n2, "Stream ID");
            Http2CodecUtil.verifyPadding(n3);
            int n4 = byteBuf.readableBytes();
            Http2Flags http2Flags = new Http2Flags();
            http2Flags.endOfStream(false);
            http2Flags.paddingPresent(false);
            if (n4 > this.maxFrameSize) {
                referenceCounted = channelHandlerContext.alloc().buffer(9);
                Http2CodecUtil.writeFrameHeaderInternal((ByteBuf)referenceCounted, this.maxFrameSize, (byte)0, http2Flags, n2);
                do {
                    channelHandlerContext.write(((ByteBuf)referenceCounted).retainedSlice(), ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).newPromise());
                    channelHandlerContext.write(byteBuf.readRetainedSlice(this.maxFrameSize), ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).newPromise());
                } while ((n4 -= this.maxFrameSize) > this.maxFrameSize);
            }
            if (n3 == 0) {
                if (referenceCounted != null) {
                    referenceCounted.release();
                    referenceCounted = null;
                }
                ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(9);
                http2Flags.endOfStream(bl);
                Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n4, (byte)0, http2Flags, n2);
                channelHandlerContext.write(byteBuf2, ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).newPromise());
                ByteBuf byteBuf3 = byteBuf.readSlice(n4);
                byteBuf = null;
                channelHandlerContext.write(byteBuf3, ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).newPromise());
            } else {
                if (n4 != this.maxFrameSize) {
                    if (referenceCounted != null) {
                        referenceCounted.release();
                        referenceCounted = null;
                    }
                } else {
                    ByteBuf byteBuf4;
                    n4 -= this.maxFrameSize;
                    if (referenceCounted == null) {
                        byteBuf4 = channelHandlerContext.alloc().buffer(9);
                        Http2CodecUtil.writeFrameHeaderInternal(byteBuf4, this.maxFrameSize, (byte)0, http2Flags, n2);
                    } else {
                        byteBuf4 = ((ByteBuf)referenceCounted).slice();
                        referenceCounted = null;
                    }
                    channelHandlerContext.write(byteBuf4, ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).newPromise());
                    byteBuf4 = byteBuf.readableBytes() != this.maxFrameSize ? byteBuf.readSlice(this.maxFrameSize) : byteBuf;
                    byteBuf = null;
                    channelHandlerContext.write(byteBuf4, ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).newPromise());
                }
                do {
                    int n5 = Math.min(n4, this.maxFrameSize);
                    int n6 = Math.min(n3, Math.max(0, this.maxFrameSize - 1 - n5));
                    ByteBuf byteBuf5 = channelHandlerContext.alloc().buffer(10);
                    http2Flags.endOfStream(bl && (n4 -= n5) == 0 && (n3 -= n6) == 0);
                    http2Flags.paddingPresent(n6 > 0);
                    Http2CodecUtil.writeFrameHeaderInternal(byteBuf5, n6 + n5, (byte)0, http2Flags, n2);
                    DefaultHttp2FrameWriter.writePaddingLength(byteBuf5, n6);
                    channelHandlerContext.write(byteBuf5, ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).newPromise());
                    if (n5 != 0) {
                        if (n4 == 0) {
                            ByteBuf byteBuf6 = byteBuf.readSlice(n5);
                            byteBuf = null;
                            channelHandlerContext.write(byteBuf6, ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).newPromise());
                        } else {
                            channelHandlerContext.write(byteBuf.readRetainedSlice(n5), ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).newPromise());
                        }
                    }
                    if (DefaultHttp2FrameWriter.paddingBytes(n6) <= 0) continue;
                    channelHandlerContext.write(ZERO_BUFFER.slice(0, DefaultHttp2FrameWriter.paddingBytes(n6)), ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).newPromise());
                } while (n4 != 0 || n3 != 0);
            }
        }
        catch (Throwable throwable) {
            if (referenceCounted != null) {
                referenceCounted.release();
            }
            try {
                if (byteBuf != null) {
                    byteBuf.release();
                }
            }
            finally {
                ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).setFailure(throwable);
                ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).doneAllocatingPromises();
            }
            return channelPromise;
        }
        return ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).doneAllocatingPromises();
    }

    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, boolean bl, ChannelPromise channelPromise) {
        return this.writeHeadersInternal(channelHandlerContext, n2, http2Headers, n3, bl, false, 0, (short)0, false, channelPromise);
    }

    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, short s2, boolean bl, int n4, boolean bl2, ChannelPromise channelPromise) {
        return this.writeHeadersInternal(channelHandlerContext, n2, http2Headers, n4, bl2, true, n3, s2, bl, channelPromise);
    }

    public ChannelFuture writeRstStream(ChannelHandlerContext channelHandlerContext, int n2, long l2, ChannelPromise channelPromise) {
        try {
            DefaultHttp2FrameWriter.verifyStreamId(n2, "Stream ID");
            DefaultHttp2FrameWriter.verifyErrorCode(l2);
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(13);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 4, (byte)3, new Http2Flags(), n2);
            byteBuf.writeInt((int)l2);
            return channelHandlerContext.write(byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    public ChannelFuture writeSettings(ChannelHandlerContext channelHandlerContext, Http2Settings object, ChannelPromise channelPromise) {
        try {
            ObjectUtil.checkNotNull(object, "settings");
            int n2 = 6 * ((CharObjectHashMap)((Object)object)).size();
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(9 + ((CharObjectHashMap)((Object)object)).size() * 6);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, n2, (byte)4, new Http2Flags(), 0);
            for (CharObjectMap.PrimitiveEntry primitiveEntry : ((CharObjectHashMap)((Object)object)).entries()) {
                byteBuf.writeChar(primitiveEntry.key());
                byteBuf.writeInt(((Long)primitiveEntry.value()).intValue());
            }
            return channelHandlerContext.write(byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    public ChannelFuture writeSettingsAck(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        try {
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(9);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 0, (byte)4, new Http2Flags().ack(true), 0);
            return channelHandlerContext.write(byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    public ChannelFuture writePing(ChannelHandlerContext channelHandlerContext, boolean bl, long l2, ChannelPromise channelPromise) {
        Http2Flags http2Flags = bl ? new Http2Flags().ack(true) : new Http2Flags();
        ByteBuf byteBuf = channelHandlerContext.alloc().buffer(17);
        Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 8, (byte)6, http2Flags, 0);
        byteBuf.writeLong(l2);
        return channelHandlerContext.write(byteBuf, channelPromise);
    }

    public ChannelFuture writeGoAway(ChannelHandlerContext channelHandlerContext, int n2, long l2, ByteBuf byteBuf, ChannelPromise channelPromise) {
        channelPromise = new Http2CodecUtil.SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        try {
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(n2, "Last Stream ID");
            DefaultHttp2FrameWriter.verifyErrorCode(l2);
            int n3 = 8 + byteBuf.readableBytes();
            ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(17);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n3, (byte)7, new Http2Flags(), 0);
            byteBuf2.writeInt(n2);
            byteBuf2.writeInt((int)l2);
            channelHandlerContext.write(byteBuf2, ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).newPromise());
        }
        catch (Throwable throwable) {
            try {
                byteBuf.release();
            }
            finally {
                ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).setFailure(throwable);
                ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).doneAllocatingPromises();
            }
            return channelPromise;
        }
        try {
            channelHandlerContext.write(byteBuf, ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).newPromise());
        }
        catch (Throwable throwable) {
            ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).setFailure(throwable);
        }
        return ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).doneAllocatingPromises();
    }

    public ChannelFuture writeWindowUpdate(ChannelHandlerContext channelHandlerContext, int n2, int n3, ChannelPromise channelPromise) {
        try {
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(n2, "Stream ID");
            DefaultHttp2FrameWriter.verifyWindowSizeIncrement(n3);
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(13);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 4, (byte)8, new Http2Flags(), n2);
            byteBuf.writeInt(n3);
            return channelHandlerContext.write(byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    public ChannelFuture writeFrame(ChannelHandlerContext channelHandlerContext, byte by, int n2, Http2Flags http2Flags, ByteBuf byteBuf, ChannelPromise channelPromise) {
        channelPromise = new Http2CodecUtil.SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        try {
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(n2, "Stream ID");
            ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(9);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, byteBuf.readableBytes(), by, http2Flags, n2);
            channelHandlerContext.write(byteBuf2, ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).newPromise());
        }
        catch (Throwable throwable) {
            try {
                byteBuf.release();
            }
            finally {
                ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).setFailure(throwable);
                ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).doneAllocatingPromises();
            }
            return channelPromise;
        }
        try {
            channelHandlerContext.write(byteBuf, ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).newPromise());
        }
        catch (Throwable throwable) {
            ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).setFailure(throwable);
        }
        return ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).doneAllocatingPromises();
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture writeHeadersInternal(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers object, int n3, boolean bl, boolean bl2, int n4, short s2, boolean bl3, ChannelPromise channelPromise) {
        Http2CodecUtil.SimpleChannelPromiseAggregator simpleChannelPromiseAggregator;
        ReferenceCounted referenceCounted = null;
        simpleChannelPromiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator(simpleChannelPromiseAggregator, channelHandlerContext.channel(), channelHandlerContext.executor());
        try {
            void var8_13;
            void var7_12;
            void var6_11;
            DefaultHttp2FrameWriter.verifyStreamId(n2, "Stream ID");
            if (var6_11 != false) {
                DefaultHttp2FrameWriter.verifyStreamOrConnectionId((int)var7_12, "Stream Dependency");
                Http2CodecUtil.verifyPadding(n3);
                DefaultHttp2FrameWriter.verifyWeight((short)var8_13);
            }
            referenceCounted = channelHandlerContext.alloc().buffer();
            this.headersEncoder.encodeHeaders(n2, (Http2Headers)object, (ByteBuf)referenceCounted);
            object = new Http2Flags().endOfStream(bl).priorityPresent((boolean)var6_11).paddingPresent(n3 > 0);
            int n5 = n3 + ((Http2Flags)object).getNumPriorityBytes();
            int n6 = this.maxFrameSize - n5;
            ReferenceCounted referenceCounted2 = referenceCounted;
            ByteBuf byteBuf = ((ByteBuf)referenceCounted2).readRetainedSlice(Math.min(((ByteBuf)referenceCounted2).readableBytes(), n6));
            ((Http2Flags)object).endOfHeaders(!((ByteBuf)referenceCounted).isReadable());
            int n7 = byteBuf.readableBytes() + n5;
            ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(15);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n7, (byte)1, (Http2Flags)object, n2);
            DefaultHttp2FrameWriter.writePaddingLength(byteBuf2, n3);
            if (var6_11 != false) {
                void var9_14;
                byteBuf2.writeInt(var9_14 != false ? (int)(0x80000000L | (long)var7_12) : var7_12);
                byteBuf2.writeByte((int)(var8_13 - true));
            }
            channelHandlerContext.write(byteBuf2, simpleChannelPromiseAggregator.newPromise());
            channelHandlerContext.write(byteBuf, simpleChannelPromiseAggregator.newPromise());
            if (DefaultHttp2FrameWriter.paddingBytes(n3) > 0) {
                channelHandlerContext.write(ZERO_BUFFER.slice(0, DefaultHttp2FrameWriter.paddingBytes(n3)), simpleChannelPromiseAggregator.newPromise());
            }
            if (!((Http2Flags)object).endOfHeaders()) {
                this.writeContinuationFrames(channelHandlerContext, n2, (ByteBuf)referenceCounted, simpleChannelPromiseAggregator);
            }
        }
        catch (Http2Exception http2Exception) {
            simpleChannelPromiseAggregator.setFailure(http2Exception);
        }
        catch (Throwable throwable) {
            simpleChannelPromiseAggregator.setFailure(throwable);
            simpleChannelPromiseAggregator.doneAllocatingPromises();
            PlatformDependent.throwException(throwable);
        }
        finally {
            if (referenceCounted != null) {
                referenceCounted.release();
            }
        }
        return simpleChannelPromiseAggregator.doneAllocatingPromises();
    }

    private ChannelFuture writeContinuationFrames(ChannelHandlerContext channelHandlerContext, int n2, ByteBuf byteBuf, Http2CodecUtil.SimpleChannelPromiseAggregator simpleChannelPromiseAggregator) {
        Http2Flags http2Flags = new Http2Flags();
        if (byteBuf.isReadable()) {
            int n3 = Math.min(byteBuf.readableBytes(), this.maxFrameSize);
            ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(10);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n3, (byte)9, http2Flags, n2);
            do {
                n3 = Math.min(byteBuf.readableBytes(), this.maxFrameSize);
                ByteBuf byteBuf3 = byteBuf.readRetainedSlice(n3);
                if (byteBuf.isReadable()) {
                    channelHandlerContext.write(byteBuf2.retain(), simpleChannelPromiseAggregator.newPromise());
                } else {
                    http2Flags = http2Flags.endOfHeaders(true);
                    byteBuf2.release();
                    byteBuf2 = channelHandlerContext.alloc().buffer(10);
                    Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n3, (byte)9, http2Flags, n2);
                    channelHandlerContext.write(byteBuf2, simpleChannelPromiseAggregator.newPromise());
                }
                channelHandlerContext.write(byteBuf3, simpleChannelPromiseAggregator.newPromise());
            } while (byteBuf.isReadable());
        }
        return simpleChannelPromiseAggregator;
    }

    private static int paddingBytes(int n2) {
        return n2 - 1;
    }

    private static void writePaddingLength(ByteBuf byteBuf, int n2) {
        if (n2 > 0) {
            byteBuf.writeByte(n2 - 1);
        }
    }

    private static void verifyStreamId(int n2, String string) {
        ObjectUtil.checkPositive(n2, "streamId");
    }

    private static void verifyStreamOrConnectionId(int n2, String string) {
        ObjectUtil.checkPositiveOrZero(n2, "streamId");
    }

    private static void verifyWeight(short s2) {
        if (s2 <= 0 || s2 > 256) {
            throw new IllegalArgumentException("Invalid weight: " + s2);
        }
    }

    private static void verifyErrorCode(long l2) {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid errorCode: " + l2);
        }
    }

    private static void verifyWindowSizeIncrement(int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "windowSizeIncrement");
    }
}

