/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.handler.codec.http.HttpStatusClass;
import com.appoptics.ext.io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2CodecUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Connection;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Flags;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameListener;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameReader;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2HeadersDecoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2LifecycleManager;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2LocalFlowController;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2PromisedRequestVerifier;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2RemoteFlowController;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Settings;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2SettingsReceivedConsumer;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Stream;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttp2ConnectionDecoder
implements Http2ConnectionDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2ConnectionDecoder.class);
    private Http2FrameListener internalFrameListener = new PrefaceFrameListener();
    private final Http2Connection connection;
    private Http2LifecycleManager lifecycleManager;
    private final Http2ConnectionEncoder encoder;
    private final Http2FrameReader frameReader;
    private Http2FrameListener listener;
    private final Http2PromisedRequestVerifier requestVerifier;
    private final Http2SettingsReceivedConsumer settingsReceivedConsumer;
    private final boolean autoAckPing;

    public DefaultHttp2ConnectionDecoder(Http2Connection http2Connection, Http2ConnectionEncoder http2ConnectionEncoder, Http2FrameReader http2FrameReader) {
        this(http2Connection, http2ConnectionEncoder, http2FrameReader, Http2PromisedRequestVerifier.ALWAYS_VERIFY);
    }

    public DefaultHttp2ConnectionDecoder(Http2Connection http2Connection, Http2ConnectionEncoder http2ConnectionEncoder, Http2FrameReader http2FrameReader, Http2PromisedRequestVerifier http2PromisedRequestVerifier) {
        this(http2Connection, http2ConnectionEncoder, http2FrameReader, http2PromisedRequestVerifier, true);
    }

    public DefaultHttp2ConnectionDecoder(Http2Connection http2Connection, Http2ConnectionEncoder http2ConnectionEncoder, Http2FrameReader http2FrameReader, Http2PromisedRequestVerifier http2PromisedRequestVerifier, boolean bl) {
        this(http2Connection, http2ConnectionEncoder, http2FrameReader, http2PromisedRequestVerifier, bl, true);
    }

    public DefaultHttp2ConnectionDecoder(Http2Connection http2Connection, Http2ConnectionEncoder http2ConnectionEncoder, Http2FrameReader http2FrameReader, Http2PromisedRequestVerifier http2PromisedRequestVerifier, boolean bl, boolean bl2) {
        this.autoAckPing = bl2;
        if (bl) {
            this.settingsReceivedConsumer = null;
        } else {
            if (!(http2ConnectionEncoder instanceof Http2SettingsReceivedConsumer)) {
                throw new IllegalArgumentException("disabling autoAckSettings requires the encoder to be a " + Http2SettingsReceivedConsumer.class);
            }
            this.settingsReceivedConsumer = (Http2SettingsReceivedConsumer)((Object)http2ConnectionEncoder);
        }
        this.connection = ObjectUtil.checkNotNull(http2Connection, "connection");
        this.frameReader = ObjectUtil.checkNotNull(http2FrameReader, "frameReader");
        this.encoder = ObjectUtil.checkNotNull(http2ConnectionEncoder, "encoder");
        this.requestVerifier = ObjectUtil.checkNotNull(http2PromisedRequestVerifier, "requestVerifier");
        if (http2Connection.local().flowController() == null) {
            http2Connection.local().flowController(new DefaultHttp2LocalFlowController(http2Connection));
        }
        http2Connection.local().flowController().frameWriter(http2ConnectionEncoder.frameWriter());
    }

    @Override
    public void lifecycleManager(Http2LifecycleManager http2LifecycleManager) {
        this.lifecycleManager = ObjectUtil.checkNotNull(http2LifecycleManager, "lifecycleManager");
    }

    @Override
    public Http2Connection connection() {
        return this.connection;
    }

    @Override
    public final Http2LocalFlowController flowController() {
        return this.connection.local().flowController();
    }

    @Override
    public void frameListener(Http2FrameListener http2FrameListener) {
        this.listener = ObjectUtil.checkNotNull(http2FrameListener, "listener");
    }

    @Override
    public Http2FrameListener frameListener() {
        return this.listener;
    }

    @Override
    public boolean prefaceReceived() {
        return FrameReadListener.class == this.internalFrameListener.getClass();
    }

    @Override
    public void decodeFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Http2Exception {
        this.frameReader.readFrame(channelHandlerContext, byteBuf, this.internalFrameListener);
    }

    @Override
    public Http2Settings localSettings() {
        Http2Settings http2Settings = new Http2Settings();
        Object object = this.frameReader.configuration();
        Http2HeadersDecoder.Configuration configuration = object.headersConfiguration();
        object = object.frameSizePolicy();
        http2Settings.initialWindowSize(this.flowController().initialWindowSize());
        http2Settings.maxConcurrentStreams(this.connection.remote().maxActiveStreams());
        http2Settings.headerTableSize(configuration.maxHeaderTableSize());
        http2Settings.maxFrameSize(object.maxFrameSize());
        http2Settings.maxHeaderListSize(configuration.maxHeaderListSize());
        if (!this.connection.isServer()) {
            http2Settings.pushEnabled(this.connection.local().allowPushTo());
        }
        return http2Settings;
    }

    @Override
    public void close() {
        this.frameReader.close();
    }

    protected long calculateMaxHeaderListSizeGoAway(long l2) {
        return Http2CodecUtil.calculateMaxHeaderListSizeGoAway(l2);
    }

    private int unconsumedBytes(Http2Stream http2Stream) {
        return this.flowController().unconsumedBytes(http2Stream);
    }

    void onGoAwayRead0(ChannelHandlerContext channelHandlerContext, int n2, long l2, ByteBuf byteBuf) throws Http2Exception {
        this.listener.onGoAwayRead(channelHandlerContext, n2, l2, byteBuf);
        this.connection.goAwayReceived(n2, l2, byteBuf);
    }

    void onUnknownFrame0(ChannelHandlerContext channelHandlerContext, byte by, int n2, Http2Flags http2Flags, ByteBuf byteBuf) throws Http2Exception {
        this.listener.onUnknownFrame(channelHandlerContext, by, n2, http2Flags, byteBuf);
    }

    private final class PrefaceFrameListener
    implements Http2FrameListener {
        private PrefaceFrameListener() {
        }

        private void verifyPrefaceReceived() throws Http2Exception {
            if (!DefaultHttp2ConnectionDecoder.this.prefaceReceived()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Received non-SETTINGS as first frame.", new Object[0]);
            }
        }

        public final int onDataRead(ChannelHandlerContext channelHandlerContext, int n2, ByteBuf byteBuf, int n3, boolean bl) throws Http2Exception {
            this.verifyPrefaceReceived();
            return DefaultHttp2ConnectionDecoder.this.internalFrameListener.onDataRead(channelHandlerContext, n2, byteBuf, n3, bl);
        }

        public final void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, boolean bl) throws Http2Exception {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onHeadersRead(channelHandlerContext, n2, http2Headers, n3, bl);
        }

        public final void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, short s2, boolean bl, int n4, boolean bl2) throws Http2Exception {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onHeadersRead(channelHandlerContext, n2, http2Headers, n3, s2, bl, n4, bl2);
        }

        public final void onPriorityRead(ChannelHandlerContext channelHandlerContext, int n2, int n3, short s2, boolean bl) throws Http2Exception {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onPriorityRead(channelHandlerContext, n2, n3, s2, bl);
        }

        public final void onRstStreamRead(ChannelHandlerContext channelHandlerContext, int n2, long l2) throws Http2Exception {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onRstStreamRead(channelHandlerContext, n2, l2);
        }

        public final void onSettingsAckRead(ChannelHandlerContext channelHandlerContext) throws Http2Exception {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onSettingsAckRead(channelHandlerContext);
        }

        public final void onSettingsRead(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) throws Http2Exception {
            if (!DefaultHttp2ConnectionDecoder.this.prefaceReceived()) {
                DefaultHttp2ConnectionDecoder.this.internalFrameListener = new FrameReadListener();
            }
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onSettingsRead(channelHandlerContext, http2Settings);
        }

        public final void onPingRead(ChannelHandlerContext channelHandlerContext, long l2) throws Http2Exception {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onPingRead(channelHandlerContext, l2);
        }

        public final void onPingAckRead(ChannelHandlerContext channelHandlerContext, long l2) throws Http2Exception {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onPingAckRead(channelHandlerContext, l2);
        }

        public final void onPushPromiseRead(ChannelHandlerContext channelHandlerContext, int n2, int n3, Http2Headers http2Headers, int n4) throws Http2Exception {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onPushPromiseRead(channelHandlerContext, n2, n3, http2Headers, n4);
        }

        public final void onGoAwayRead(ChannelHandlerContext channelHandlerContext, int n2, long l2, ByteBuf byteBuf) throws Http2Exception {
            DefaultHttp2ConnectionDecoder.this.onGoAwayRead0(channelHandlerContext, n2, l2, byteBuf);
        }

        public final void onWindowUpdateRead(ChannelHandlerContext channelHandlerContext, int n2, int n3) throws Http2Exception {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onWindowUpdateRead(channelHandlerContext, n2, n3);
        }

        public final void onUnknownFrame(ChannelHandlerContext channelHandlerContext, byte by, int n2, Http2Flags http2Flags, ByteBuf byteBuf) throws Http2Exception {
            DefaultHttp2ConnectionDecoder.this.onUnknownFrame0(channelHandlerContext, by, n2, http2Flags, byteBuf);
        }
    }

    private final class FrameReadListener
    implements Http2FrameListener {
        private FrameReadListener() {
        }

        public final int onDataRead(ChannelHandlerContext channelHandlerContext, int n2, ByteBuf byteBuf, int n3, boolean bl) throws Http2Exception {
            boolean bl2;
            Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.this.connection.stream(n2);
            Http2LocalFlowController http2LocalFlowController = DefaultHttp2ConnectionDecoder.this.flowController();
            int n4 = byteBuf.readableBytes() + n3;
            try {
                bl2 = this.shouldIgnoreHeadersOrDataFrame(channelHandlerContext, n2, http2Stream, "DATA");
            }
            catch (Http2Exception http2Exception) {
                http2LocalFlowController.receiveFlowControlledFrame(http2Stream, byteBuf, n3, bl);
                http2LocalFlowController.consumeBytes(http2Stream, n4);
                throw http2Exception;
            }
            catch (Throwable throwable) {
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, throwable, "Unhandled error on data stream id %d", n2);
            }
            if (bl2) {
                http2LocalFlowController.receiveFlowControlledFrame(http2Stream, byteBuf, n3, bl);
                http2LocalFlowController.consumeBytes(http2Stream, n4);
                this.verifyStreamMayHaveExisted(n2);
                return n4;
            }
            Http2Exception http2Exception = null;
            switch (http2Stream.state()) {
                case OPEN: 
                case HALF_CLOSED_LOCAL: {
                    break;
                }
                case HALF_CLOSED_REMOTE: 
                case CLOSED: {
                    http2Exception = Http2Exception.streamError(http2Stream.id(), Http2Error.STREAM_CLOSED, "Stream %d in unexpected state: %s", new Object[]{http2Stream.id(), http2Stream.state()});
                    break;
                }
                default: {
                    http2Exception = Http2Exception.streamError(http2Stream.id(), Http2Error.PROTOCOL_ERROR, "Stream %d in unexpected state: %s", new Object[]{http2Stream.id(), http2Stream.state()});
                }
            }
            int n5 = DefaultHttp2ConnectionDecoder.this.unconsumedBytes(http2Stream);
            try {
                http2LocalFlowController.receiveFlowControlledFrame(http2Stream, byteBuf, n3, bl);
                n5 = DefaultHttp2ConnectionDecoder.this.unconsumedBytes(http2Stream);
                if (http2Exception != null) {
                    throw http2Exception;
                }
                n2 = n4 = DefaultHttp2ConnectionDecoder.this.listener.onDataRead(channelHandlerContext, n2, byteBuf, n3, bl);
                return n2;
            }
            catch (Http2Exception http2Exception2) {
                int n6 = n5 - DefaultHttp2ConnectionDecoder.this.unconsumedBytes(http2Stream);
                n4 -= n6;
                throw http2Exception2;
            }
            catch (RuntimeException runtimeException) {
                int n7 = n5 - DefaultHttp2ConnectionDecoder.this.unconsumedBytes(http2Stream);
                n4 -= n7;
                throw runtimeException;
            }
            finally {
                http2LocalFlowController.consumeBytes(http2Stream, n4);
                if (bl) {
                    DefaultHttp2ConnectionDecoder.this.lifecycleManager.closeStreamRemote(http2Stream, channelHandlerContext.newSucceededFuture());
                }
            }
        }

        public final void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, boolean bl) throws Http2Exception {
            this.onHeadersRead(channelHandlerContext, n2, http2Headers, 0, (short)16, false, n3, bl);
        }

        public final void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, short s2, boolean bl, int n4, boolean bl2) throws Http2Exception {
            Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.this.connection.stream(n2);
            boolean bl3 = false;
            if (http2Stream == null && !DefaultHttp2ConnectionDecoder.this.connection.streamMayHaveExisted(n2)) {
                http2Stream = DefaultHttp2ConnectionDecoder.this.connection.remote().createStream(n2, bl2);
                boolean bl4 = bl3 = http2Stream.state() == Http2Stream.State.HALF_CLOSED_REMOTE;
            }
            if (this.shouldIgnoreHeadersOrDataFrame(channelHandlerContext, n2, http2Stream, "HEADERS")) {
                return;
            }
            boolean bl5 = !DefaultHttp2ConnectionDecoder.this.connection.isServer() && HttpStatusClass.valueOf(http2Headers.status()) == HttpStatusClass.INFORMATIONAL;
            if ((bl5 || !bl2) && http2Stream.isHeadersReceived() || http2Stream.isTrailersReceived()) {
                throw Http2Exception.streamError(n2, Http2Error.PROTOCOL_ERROR, "Stream %d received too many headers EOS: %s state: %s", new Object[]{n2, bl2, http2Stream.state()});
            }
            switch (http2Stream.state()) {
                case RESERVED_REMOTE: {
                    http2Stream.open(bl2);
                    break;
                }
                case OPEN: 
                case HALF_CLOSED_LOCAL: {
                    break;
                }
                case HALF_CLOSED_REMOTE: {
                    if (bl3) break;
                    throw Http2Exception.streamError(http2Stream.id(), Http2Error.STREAM_CLOSED, "Stream %d in unexpected state: %s", new Object[]{http2Stream.id(), http2Stream.state()});
                }
                case CLOSED: {
                    throw Http2Exception.streamError(http2Stream.id(), Http2Error.STREAM_CLOSED, "Stream %d in unexpected state: %s", new Object[]{http2Stream.id(), http2Stream.state()});
                }
                default: {
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d in unexpected state: %s", new Object[]{http2Stream.id(), http2Stream.state()});
                }
            }
            http2Stream.headersReceived(bl5);
            DefaultHttp2ConnectionDecoder.this.encoder.flowController().updateDependencyTree(n2, n3, s2, bl);
            DefaultHttp2ConnectionDecoder.this.listener.onHeadersRead(channelHandlerContext, n2, http2Headers, n3, s2, bl, n4, bl2);
            if (bl2) {
                DefaultHttp2ConnectionDecoder.this.lifecycleManager.closeStreamRemote(http2Stream, channelHandlerContext.newSucceededFuture());
            }
        }

        public final void onPriorityRead(ChannelHandlerContext channelHandlerContext, int n2, int n3, short s2, boolean bl) throws Http2Exception {
            DefaultHttp2ConnectionDecoder.this.encoder.flowController().updateDependencyTree(n2, n3, s2, bl);
            DefaultHttp2ConnectionDecoder.this.listener.onPriorityRead(channelHandlerContext, n2, n3, s2, bl);
        }

        public final void onRstStreamRead(ChannelHandlerContext channelHandlerContext, int n2, long l2) throws Http2Exception {
            Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.this.connection.stream(n2);
            if (http2Stream == null) {
                this.verifyStreamMayHaveExisted(n2);
                return;
            }
            switch (http2Stream.state()) {
                case IDLE: {
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "RST_STREAM received for IDLE stream %d", n2);
                }
                case CLOSED: {
                    return;
                }
            }
            DefaultHttp2ConnectionDecoder.this.listener.onRstStreamRead(channelHandlerContext, n2, l2);
            DefaultHttp2ConnectionDecoder.this.lifecycleManager.closeStream(http2Stream, channelHandlerContext.newSucceededFuture());
        }

        public final void onSettingsAckRead(ChannelHandlerContext channelHandlerContext) throws Http2Exception {
            Http2Settings http2Settings = DefaultHttp2ConnectionDecoder.this.encoder.pollSentSettings();
            if (http2Settings != null) {
                this.applyLocalSettings(http2Settings);
            }
            DefaultHttp2ConnectionDecoder.this.listener.onSettingsAckRead(channelHandlerContext);
        }

        private void applyLocalSettings(Http2Settings object) throws Http2Exception {
            Comparable<Boolean> comparable = ((Http2Settings)object).pushEnabled();
            Object object2 = DefaultHttp2ConnectionDecoder.this.frameReader.configuration();
            Http2HeadersDecoder.Configuration configuration = object2.headersConfiguration();
            object2 = object2.frameSizePolicy();
            if (comparable != null) {
                if (DefaultHttp2ConnectionDecoder.this.connection.isServer()) {
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server sending SETTINGS frame with ENABLE_PUSH specified", new Object[0]);
                }
                DefaultHttp2ConnectionDecoder.this.connection.local().allowPushTo((Boolean)comparable);
            }
            if ((comparable = ((Http2Settings)object).maxConcurrentStreams()) != null) {
                DefaultHttp2ConnectionDecoder.this.connection.remote().maxActiveStreams((int)Math.min((Long)comparable, Integer.MAX_VALUE));
            }
            if ((comparable = ((Http2Settings)object).headerTableSize()) != null) {
                configuration.maxHeaderTableSize((Long)comparable);
            }
            if ((comparable = ((Http2Settings)object).maxHeaderListSize()) != null) {
                configuration.maxHeaderListSize((Long)comparable, DefaultHttp2ConnectionDecoder.this.calculateMaxHeaderListSizeGoAway((Long)comparable));
            }
            if ((comparable = ((Http2Settings)object).maxFrameSize()) != null) {
                object2.maxFrameSize((Integer)comparable);
            }
            if ((object = ((Http2Settings)object).initialWindowSize()) != null) {
                DefaultHttp2ConnectionDecoder.this.flowController().initialWindowSize((Integer)object);
            }
        }

        public final void onSettingsRead(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) throws Http2Exception {
            if (DefaultHttp2ConnectionDecoder.this.settingsReceivedConsumer == null) {
                ChannelHandlerContext channelHandlerContext2 = channelHandlerContext;
                DefaultHttp2ConnectionDecoder.this.encoder.writeSettingsAck(channelHandlerContext2, channelHandlerContext2.newPromise());
                DefaultHttp2ConnectionDecoder.this.encoder.remoteSettings(http2Settings);
            } else {
                DefaultHttp2ConnectionDecoder.this.settingsReceivedConsumer.consumeReceivedSettings(http2Settings);
            }
            DefaultHttp2ConnectionDecoder.this.listener.onSettingsRead(channelHandlerContext, http2Settings);
        }

        public final void onPingRead(ChannelHandlerContext channelHandlerContext, long l2) throws Http2Exception {
            if (DefaultHttp2ConnectionDecoder.this.autoAckPing) {
                DefaultHttp2ConnectionDecoder.this.encoder.writePing(channelHandlerContext, true, l2, channelHandlerContext.newPromise());
            }
            DefaultHttp2ConnectionDecoder.this.listener.onPingRead(channelHandlerContext, l2);
        }

        public final void onPingAckRead(ChannelHandlerContext channelHandlerContext, long l2) throws Http2Exception {
            DefaultHttp2ConnectionDecoder.this.listener.onPingAckRead(channelHandlerContext, l2);
        }

        public final void onPushPromiseRead(ChannelHandlerContext channelHandlerContext, int n2, int n3, Http2Headers http2Headers, int n4) throws Http2Exception {
            if (DefaultHttp2ConnectionDecoder.this.connection().isServer()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "A client cannot push.", new Object[0]);
            }
            Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.this.connection.stream(n2);
            if (this.shouldIgnoreHeadersOrDataFrame(channelHandlerContext, n2, http2Stream, "PUSH_PROMISE")) {
                return;
            }
            if (http2Stream == null) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d does not exist", n2);
            }
            switch (http2Stream.state()) {
                case OPEN: 
                case HALF_CLOSED_LOCAL: {
                    break;
                }
                default: {
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d in unexpected state for receiving push promise: %s", new Object[]{http2Stream.id(), http2Stream.state()});
                }
            }
            if (!DefaultHttp2ConnectionDecoder.this.requestVerifier.isAuthoritative(channelHandlerContext, http2Headers)) {
                throw Http2Exception.streamError(n3, Http2Error.PROTOCOL_ERROR, "Promised request on stream %d for promised stream %d is not authoritative", n2, n3);
            }
            if (!DefaultHttp2ConnectionDecoder.this.requestVerifier.isCacheable(http2Headers)) {
                throw Http2Exception.streamError(n3, Http2Error.PROTOCOL_ERROR, "Promised request on stream %d for promised stream %d is not known to be cacheable", n2, n3);
            }
            if (!DefaultHttp2ConnectionDecoder.this.requestVerifier.isSafe(http2Headers)) {
                throw Http2Exception.streamError(n3, Http2Error.PROTOCOL_ERROR, "Promised request on stream %d for promised stream %d is not known to be safe", n2, n3);
            }
            DefaultHttp2ConnectionDecoder.this.connection.remote().reservePushStream(n3, http2Stream);
            DefaultHttp2ConnectionDecoder.this.listener.onPushPromiseRead(channelHandlerContext, n2, n3, http2Headers, n4);
        }

        public final void onGoAwayRead(ChannelHandlerContext channelHandlerContext, int n2, long l2, ByteBuf byteBuf) throws Http2Exception {
            DefaultHttp2ConnectionDecoder.this.onGoAwayRead0(channelHandlerContext, n2, l2, byteBuf);
        }

        public final void onWindowUpdateRead(ChannelHandlerContext channelHandlerContext, int n2, int n3) throws Http2Exception {
            Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.this.connection.stream(n2);
            if (http2Stream == null || http2Stream.state() == Http2Stream.State.CLOSED || this.streamCreatedAfterGoAwaySent(n2)) {
                this.verifyStreamMayHaveExisted(n2);
                return;
            }
            DefaultHttp2ConnectionDecoder.this.encoder.flowController().incrementWindowSize(http2Stream, n3);
            DefaultHttp2ConnectionDecoder.this.listener.onWindowUpdateRead(channelHandlerContext, n2, n3);
        }

        public final void onUnknownFrame(ChannelHandlerContext channelHandlerContext, byte by, int n2, Http2Flags http2Flags, ByteBuf byteBuf) throws Http2Exception {
            DefaultHttp2ConnectionDecoder.this.onUnknownFrame0(channelHandlerContext, by, n2, http2Flags, byteBuf);
        }

        private boolean shouldIgnoreHeadersOrDataFrame(ChannelHandlerContext channelHandlerContext, int n2, Http2Stream http2Stream, String string) throws Http2Exception {
            if (http2Stream == null) {
                if (this.streamCreatedAfterGoAwaySent(n2)) {
                    logger.info("{} ignoring {} frame for stream {}. Stream sent after GOAWAY sent", channelHandlerContext.channel(), string, n2);
                    return true;
                }
                this.verifyStreamMayHaveExisted(n2);
                throw Http2Exception.streamError(n2, Http2Error.STREAM_CLOSED, "Received %s frame for an unknown stream %d", string, n2);
            }
            if (http2Stream.isResetSent() || this.streamCreatedAfterGoAwaySent(n2)) {
                if (logger.isInfoEnabled()) {
                    logger.info("{} ignoring {} frame for stream {}", channelHandlerContext.channel(), string, http2Stream.isResetSent() ? "RST_STREAM sent." : "Stream created after GOAWAY sent. Last known stream by peer " + DefaultHttp2ConnectionDecoder.this.connection.remote().lastStreamKnownByPeer());
                }
                return true;
            }
            return false;
        }

        private boolean streamCreatedAfterGoAwaySent(int n2) {
            Http2Connection.Endpoint<Http2RemoteFlowController> endpoint = DefaultHttp2ConnectionDecoder.this.connection.remote();
            return DefaultHttp2ConnectionDecoder.this.connection.goAwaySent() && endpoint.isValidStreamId(n2) && n2 > endpoint.lastStreamKnownByPeer();
        }

        private void verifyStreamMayHaveExisted(int n2) throws Http2Exception {
            if (!DefaultHttp2ConnectionDecoder.this.connection.streamMayHaveExisted(n2)) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d does not exist", n2);
            }
        }
    }
}

