/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Connection;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FlowController;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2LocalFlowController;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2RemoteFlowController;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Stream;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2StreamVisitor;
import com.appoptics.ext.io.netty.util.collection.IntObjectHashMap;
import com.appoptics.ext.io.netty.util.collection.IntObjectMap;
import com.appoptics.ext.io.netty.util.concurrent.Future;
import com.appoptics.ext.io.netty.util.concurrent.Promise;
import com.appoptics.ext.io.netty.util.internal.EmptyArrays;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttp2Connection
implements Http2Connection {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2Connection.class);
    final IntObjectMap<Http2Stream> streamMap = new IntObjectHashMap<Http2Stream>();
    final PropertyKeyRegistry propertyKeyRegistry = new PropertyKeyRegistry();
    final ConnectionStream connectionStream = new ConnectionStream();
    final DefaultEndpoint<Http2LocalFlowController> localEndpoint;
    final DefaultEndpoint<Http2RemoteFlowController> remoteEndpoint;
    final List<Http2Connection.Listener> listeners = new ArrayList<Http2Connection.Listener>(4);
    final ActiveStreams activeStreams;
    Promise<Void> closePromise;

    public DefaultHttp2Connection(boolean bl) {
        this(bl, 100);
    }

    public DefaultHttp2Connection(boolean bl, int n2) {
        DefaultHttp2Connection defaultHttp2Connection = this;
        this.activeStreams = defaultHttp2Connection.new ActiveStreams(defaultHttp2Connection.listeners);
        boolean bl2 = bl;
        this.localEndpoint = new DefaultEndpoint(bl2, bl2 ? Integer.MAX_VALUE : n2);
        this.remoteEndpoint = new DefaultEndpoint(!bl, n2);
        this.streamMap.put(this.connectionStream.id(), (Http2Stream)this.connectionStream);
    }

    final boolean isClosed() {
        return this.closePromise != null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Future<Void> close(Promise<Void> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void addListener(Http2Connection.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean isServer() {
        return this.localEndpoint.isServer();
    }

    @Override
    public Http2Stream connectionStream() {
        return this.connectionStream;
    }

    @Override
    public Http2Stream stream(int n2) {
        return this.streamMap.get(n2);
    }

    @Override
    public boolean streamMayHaveExisted(int n2) {
        return this.remoteEndpoint.mayHaveCreatedStream(n2) || this.localEndpoint.mayHaveCreatedStream(n2);
    }

    @Override
    public int numActiveStreams() {
        return this.activeStreams.size();
    }

    @Override
    public Http2Stream forEachActiveStream(Http2StreamVisitor http2StreamVisitor) throws Http2Exception {
        return this.activeStreams.forEachActiveStream(http2StreamVisitor);
    }

    @Override
    public Http2Connection.Endpoint<Http2LocalFlowController> local() {
        return this.localEndpoint;
    }

    @Override
    public Http2Connection.Endpoint<Http2RemoteFlowController> remote() {
        return this.remoteEndpoint;
    }

    @Override
    public boolean goAwayReceived() {
        return ((DefaultEndpoint)this.localEndpoint).lastStreamKnownByPeer >= 0;
    }

    @Override
    public void goAwayReceived(int n2, long l2, ByteBuf byteBuf) throws Http2Exception {
        if (this.localEndpoint.lastStreamKnownByPeer() >= 0 && this.localEndpoint.lastStreamKnownByPeer() < n2) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "lastStreamId MUST NOT increase. Current value: %d new value: %d", this.localEndpoint.lastStreamKnownByPeer(), n2);
        }
        ((DefaultEndpoint)this.localEndpoint).lastStreamKnownByPeer(n2);
        for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
            try {
                this.listeners.get(i2).onGoAwayReceived(n2, l2, byteBuf);
                continue;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener onGoAwayReceived.", throwable);
            }
        }
        this.closeStreamsGreaterThanLastKnownStreamId(n2, this.localEndpoint);
    }

    @Override
    public boolean goAwaySent() {
        return ((DefaultEndpoint)this.remoteEndpoint).lastStreamKnownByPeer >= 0;
    }

    @Override
    public boolean goAwaySent(int n2, long l2, ByteBuf byteBuf) throws Http2Exception {
        if (this.remoteEndpoint.lastStreamKnownByPeer() >= 0) {
            if (n2 == this.remoteEndpoint.lastStreamKnownByPeer()) {
                return false;
            }
            if (n2 > this.remoteEndpoint.lastStreamKnownByPeer()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Last stream identifier must not increase between sending multiple GOAWAY frames (was '%d', is '%d').", this.remoteEndpoint.lastStreamKnownByPeer(), n2);
            }
        }
        ((DefaultEndpoint)this.remoteEndpoint).lastStreamKnownByPeer(n2);
        for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
            try {
                this.listeners.get(i2).onGoAwaySent(n2, l2, byteBuf);
                continue;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener onGoAwaySent.", throwable);
            }
        }
        this.closeStreamsGreaterThanLastKnownStreamId(n2, this.remoteEndpoint);
        return true;
    }

    private void closeStreamsGreaterThanLastKnownStreamId(final int n2, final DefaultEndpoint<?> defaultEndpoint) throws Http2Exception {
        this.forEachActiveStream(new Http2StreamVisitor(){

            public boolean visit(Http2Stream http2Stream) {
                if (http2Stream.id() > n2 && defaultEndpoint.isValidStreamId(http2Stream.id())) {
                    http2Stream.close();
                }
                return true;
            }
        });
    }

    private boolean isStreamMapEmpty() {
        return this.streamMap.size() == 1;
    }

    void removeStream(DefaultStream defaultStream, Iterator<?> iterator) {
        int n2;
        if (iterator == null) {
            n2 = this.streamMap.remove(defaultStream.id()) != null ? 1 : 0;
        } else {
            iterator.remove();
            n2 = 1;
        }
        if (n2 != 0) {
            for (n2 = 0; n2 < this.listeners.size(); ++n2) {
                try {
                    this.listeners.get(n2).onStreamRemoved(defaultStream);
                    continue;
                }
                catch (Throwable throwable) {
                    logger.error("Caught Throwable from listener onStreamRemoved.", throwable);
                }
            }
            if (this.closePromise != null && this.isStreamMapEmpty()) {
                this.closePromise.trySuccess(null);
            }
        }
    }

    static Http2Stream.State activeState(int n2, Http2Stream.State state, boolean bl, boolean bl2) throws Http2Exception {
        switch (state) {
            case IDLE: {
                if (bl2) {
                    if (bl) {
                        return Http2Stream.State.HALF_CLOSED_LOCAL;
                    }
                    return Http2Stream.State.HALF_CLOSED_REMOTE;
                }
                return Http2Stream.State.OPEN;
            }
            case RESERVED_LOCAL: {
                return Http2Stream.State.HALF_CLOSED_REMOTE;
            }
            case RESERVED_REMOTE: {
                return Http2Stream.State.HALF_CLOSED_LOCAL;
            }
        }
        throw Http2Exception.streamError(n2, Http2Error.PROTOCOL_ERROR, "Attempting to open a stream in an invalid state: " + (Object)((Object)state), new Object[0]);
    }

    void notifyHalfClosed(Http2Stream http2Stream) {
        for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
            try {
                this.listeners.get(i2).onStreamHalfClosed(http2Stream);
                continue;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener onStreamHalfClosed.", throwable);
            }
        }
    }

    void notifyClosed(Http2Stream http2Stream) {
        for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
            try {
                this.listeners.get(i2).onStreamClosed(http2Stream);
                continue;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener onStreamClosed.", throwable);
            }
        }
    }

    @Override
    public Http2Connection.PropertyKey newKey() {
        return this.propertyKeyRegistry.newKey();
    }

    final DefaultPropertyKey verifyKey(Http2Connection.PropertyKey propertyKey) {
        return ObjectUtil.checkNotNull((DefaultPropertyKey)propertyKey, "key").verifyConnection(this);
    }

    private final class PropertyKeyRegistry {
        final List<DefaultPropertyKey> keys = new ArrayList<DefaultPropertyKey>(4);

        private PropertyKeyRegistry() {
        }

        final DefaultPropertyKey newKey() {
            DefaultPropertyKey defaultPropertyKey = new DefaultPropertyKey(this.keys.size());
            this.keys.add(defaultPropertyKey);
            return defaultPropertyKey;
        }

        final int size() {
            return this.keys.size();
        }
    }

    final class DefaultPropertyKey
    implements Http2Connection.PropertyKey {
        final int index;

        DefaultPropertyKey(int n2) {
            this.index = n2;
        }

        final DefaultPropertyKey verifyConnection(Http2Connection http2Connection) {
            if (http2Connection != DefaultHttp2Connection.this) {
                throw new IllegalArgumentException("Using a key that was not created by this connection");
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ActiveStreams {
        private final List<Http2Connection.Listener> listeners;
        private final Queue<Event> pendingEvents = new ArrayDeque<Event>(4);
        private final Set<Http2Stream> streams = new LinkedHashSet<Http2Stream>();
        private int pendingIterations;

        ActiveStreams(List<Http2Connection.Listener> list) {
            this.listeners = list;
        }

        public final int size() {
            return this.streams.size();
        }

        public final void activate(final DefaultStream defaultStream) {
            if (this.allowModifications()) {
                this.addToActiveStreams(defaultStream);
                return;
            }
            this.pendingEvents.add(new Event(){

                public void process() {
                    ActiveStreams.this.addToActiveStreams(defaultStream);
                }
            });
        }

        public final void deactivate(final DefaultStream defaultStream, final Iterator<?> iterator) {
            if (this.allowModifications() || iterator != null) {
                this.removeFromActiveStreams(defaultStream, iterator);
                return;
            }
            this.pendingEvents.add(new Event(){

                public void process() {
                    ActiveStreams.this.removeFromActiveStreams(defaultStream, iterator);
                }
            });
        }

        public final Http2Stream forEachActiveStream(Http2StreamVisitor object) throws Http2Exception {
            this.incrementPendingIterations();
            try {
                for (Http2Stream http2Stream : this.streams) {
                    if (object.visit(http2Stream)) continue;
                    object = http2Stream;
                    return object;
                }
                return null;
            }
            finally {
                this.decrementPendingIterations();
            }
        }

        final void addToActiveStreams(DefaultStream defaultStream) {
            if (this.streams.add(defaultStream)) {
                ++defaultStream.createdBy().numActiveStreams;
                for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
                    try {
                        this.listeners.get(i2).onStreamActive(defaultStream);
                        continue;
                    }
                    catch (Throwable throwable) {
                        logger.error("Caught Throwable from listener onStreamActive.", throwable);
                    }
                }
            }
        }

        final void removeFromActiveStreams(DefaultStream defaultStream, Iterator<?> iterator) {
            if (this.streams.remove(defaultStream)) {
                --defaultStream.createdBy().numActiveStreams;
                DefaultHttp2Connection.this.notifyClosed(defaultStream);
            }
            DefaultHttp2Connection.this.removeStream(defaultStream, iterator);
        }

        final boolean allowModifications() {
            return this.pendingIterations == 0;
        }

        final void incrementPendingIterations() {
            ++this.pendingIterations;
        }

        final void decrementPendingIterations() {
            --this.pendingIterations;
            if (this.allowModifications()) {
                Event event;
                while ((event = this.pendingEvents.poll()) != null) {
                    try {
                        event.process();
                    }
                    catch (Throwable throwable) {
                        logger.error("Caught Throwable while processing pending ActiveStreams$Event.", throwable);
                    }
                }
            }
        }
    }

    static interface Event {
        public void process();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DefaultEndpoint<F extends Http2FlowController>
    implements Http2Connection.Endpoint<F> {
        private final boolean server;
        private int nextStreamIdToCreate;
        private int nextReservationStreamId;
        private int lastStreamKnownByPeer = -1;
        private boolean pushToAllowed = true;
        private F flowController;
        private int maxStreams;
        private int maxActiveStreams;
        private final int maxReservedStreams;
        int numActiveStreams;
        int numStreams;

        DefaultEndpoint(boolean bl, int n2) {
            this.server = bl;
            if (bl) {
                this.nextStreamIdToCreate = 2;
                this.nextReservationStreamId = 0;
            } else {
                this.nextStreamIdToCreate = 1;
                this.nextReservationStreamId = 1;
            }
            this.pushToAllowed = !bl;
            this.maxActiveStreams = Integer.MAX_VALUE;
            this.maxReservedStreams = ObjectUtil.checkPositiveOrZero(n2, "maxReservedStreams");
            this.updateMaxStreams();
        }

        @Override
        public final int incrementAndGetNextStreamId() {
            if (this.nextReservationStreamId >= 0) {
                return this.nextReservationStreamId += 2;
            }
            return this.nextReservationStreamId;
        }

        private void incrementExpectedStreamId(int n2) {
            if (n2 > this.nextReservationStreamId && this.nextReservationStreamId >= 0) {
                this.nextReservationStreamId = n2;
            }
            this.nextStreamIdToCreate = n2 + 2;
            ++this.numStreams;
        }

        @Override
        public final boolean isValidStreamId(int n2) {
            return n2 > 0 && this.server == ((n2 & 1) == 0);
        }

        @Override
        public final boolean mayHaveCreatedStream(int n2) {
            return this.isValidStreamId(n2) && n2 <= this.lastStreamCreated();
        }

        public final boolean canOpenStream() {
            return this.numActiveStreams < this.maxActiveStreams;
        }

        @Override
        public final DefaultStream createStream(int n2, boolean bl) throws Http2Exception {
            Object object = DefaultHttp2Connection.activeState(n2, Http2Stream.State.IDLE, this.isLocal(), bl);
            this.checkNewStreamAllowed(n2, (Http2Stream.State)((Object)object));
            object = new DefaultStream(n2, (Http2Stream.State)((Object)object));
            this.incrementExpectedStreamId(n2);
            this.addStream((DefaultStream)object);
            ((DefaultStream)object).activate();
            return object;
        }

        @Override
        public final boolean created(Http2Stream http2Stream) {
            return http2Stream instanceof DefaultStream && ((DefaultStream)http2Stream).createdBy() == this;
        }

        public final boolean isServer() {
            return this.server;
        }

        @Override
        public final DefaultStream reservePushStream(int n2, Http2Stream object) throws Http2Exception {
            if (object == null) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Parent stream missing", new Object[0]);
            }
            if (this.isLocal() ? !object.state().localSideOpen() : !object.state().remoteSideOpen()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d is not open for sending push promise", object.id());
            }
            if (!this.opposite().allowPushTo()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server push not allowed to opposite endpoint", new Object[0]);
            }
            object = this.isLocal() ? Http2Stream.State.RESERVED_LOCAL : Http2Stream.State.RESERVED_REMOTE;
            this.checkNewStreamAllowed(n2, (Http2Stream.State)((Object)object));
            object = new DefaultStream(n2, (Http2Stream.State)((Object)object));
            this.incrementExpectedStreamId(n2);
            this.addStream((DefaultStream)object);
            return object;
        }

        private void addStream(DefaultStream defaultStream) {
            DefaultHttp2Connection.this.streamMap.put(defaultStream.id(), (Http2Stream)defaultStream);
            for (int i2 = 0; i2 < DefaultHttp2Connection.this.listeners.size(); ++i2) {
                try {
                    DefaultHttp2Connection.this.listeners.get(i2).onStreamAdded(defaultStream);
                    continue;
                }
                catch (Throwable throwable) {
                    logger.error("Caught Throwable from listener onStreamAdded.", throwable);
                }
            }
        }

        @Override
        public final void allowPushTo(boolean bl) {
            if (bl && this.server) {
                throw new IllegalArgumentException("Servers do not allow push");
            }
            this.pushToAllowed = bl;
        }

        @Override
        public final boolean allowPushTo() {
            return this.pushToAllowed;
        }

        @Override
        public final int numActiveStreams() {
            return this.numActiveStreams;
        }

        @Override
        public final int maxActiveStreams() {
            return this.maxActiveStreams;
        }

        @Override
        public final void maxActiveStreams(int n2) {
            this.maxActiveStreams = n2;
            this.updateMaxStreams();
        }

        @Override
        public final int lastStreamCreated() {
            if (this.nextStreamIdToCreate > 1) {
                return this.nextStreamIdToCreate - 2;
            }
            return 0;
        }

        @Override
        public final int lastStreamKnownByPeer() {
            return this.lastStreamKnownByPeer;
        }

        private void lastStreamKnownByPeer(int n2) {
            this.lastStreamKnownByPeer = n2;
        }

        @Override
        public final F flowController() {
            return this.flowController;
        }

        @Override
        public final void flowController(F f2) {
            this.flowController = (Http2FlowController)ObjectUtil.checkNotNull(f2, "flowController");
        }

        public final Http2Connection.Endpoint<? extends Http2FlowController> opposite() {
            if (this.isLocal()) {
                return DefaultHttp2Connection.this.remoteEndpoint;
            }
            return DefaultHttp2Connection.this.localEndpoint;
        }

        private void updateMaxStreams() {
            this.maxStreams = (int)Math.min(Integer.MAX_VALUE, (long)this.maxActiveStreams + (long)this.maxReservedStreams);
        }

        private void checkNewStreamAllowed(int n2, Http2Stream.State state) throws Http2Exception {
            assert (state != Http2Stream.State.IDLE);
            if (this.lastStreamKnownByPeer >= 0 && n2 > this.lastStreamKnownByPeer) {
                throw Http2Exception.streamError(n2, Http2Error.REFUSED_STREAM, "Cannot create stream %d greater than Last-Stream-ID %d from GOAWAY.", n2, this.lastStreamKnownByPeer);
            }
            if (!this.isValidStreamId(n2)) {
                if (n2 < 0) {
                    throw new Http2NoMoreStreamIdsException();
                }
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Request stream %d is not correct for %s connection", n2, this.server ? "server" : "client");
            }
            if (n2 < this.nextStreamIdToCreate) {
                throw Http2Exception.closedStreamError(Http2Error.PROTOCOL_ERROR, "Request stream %d is behind the next expected stream %d", n2, this.nextStreamIdToCreate);
            }
            if (this.nextStreamIdToCreate <= 0) {
                throw Http2Exception.connectionError(Http2Error.REFUSED_STREAM, "Stream IDs are exhausted for this endpoint.", new Object[0]);
            }
            boolean bl = state == Http2Stream.State.RESERVED_LOCAL || state == Http2Stream.State.RESERVED_REMOTE;
            if (!bl && !this.canOpenStream() || bl && this.numStreams >= this.maxStreams) {
                throw Http2Exception.streamError(n2, Http2Error.REFUSED_STREAM, "Maximum active streams violated for this endpoint.", new Object[0]);
            }
            if (DefaultHttp2Connection.this.isClosed()) {
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Attempted to create stream id %d after connection was closed", n2);
            }
        }

        private boolean isLocal() {
            DefaultEndpoint defaultEndpoint = this;
            return defaultEndpoint == defaultEndpoint.DefaultHttp2Connection.this.localEndpoint;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConnectionStream
    extends DefaultStream {
        ConnectionStream() {
            super(0, Http2Stream.State.IDLE);
        }

        @Override
        public final boolean isResetSent() {
            return false;
        }

        @Override
        final DefaultEndpoint<? extends Http2FlowController> createdBy() {
            return null;
        }

        @Override
        public final Http2Stream resetSent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Http2Stream open(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Http2Stream close() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Http2Stream closeLocalSide() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Http2Stream closeRemoteSide() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Http2Stream headersSent(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean isHeadersSent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean isPushPromiseSent() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultStream
    implements Http2Stream {
        private final int id;
        private final PropertyMap properties = new PropertyMap();
        private Http2Stream.State state;
        private byte metaState;

        DefaultStream(int n2, Http2Stream.State state) {
            this.id = n2;
            this.state = state;
        }

        @Override
        public final int id() {
            return this.id;
        }

        @Override
        public final Http2Stream.State state() {
            return this.state;
        }

        @Override
        public boolean isResetSent() {
            return (this.metaState & 1) != 0;
        }

        @Override
        public Http2Stream resetSent() {
            this.metaState = (byte)(this.metaState | 1);
            return this;
        }

        @Override
        public Http2Stream headersSent(boolean bl) {
            if (!bl) {
                this.metaState = (byte)(this.metaState | (this.isHeadersSent() ? 4 : 2));
            }
            return this;
        }

        @Override
        public boolean isHeadersSent() {
            return (this.metaState & 2) != 0;
        }

        @Override
        public boolean isTrailersSent() {
            return (this.metaState & 4) != 0;
        }

        @Override
        public Http2Stream headersReceived(boolean bl) {
            if (!bl) {
                this.metaState = (byte)(this.metaState | (this.isHeadersReceived() ? 32 : 16));
            }
            return this;
        }

        @Override
        public boolean isHeadersReceived() {
            return (this.metaState & 0x10) != 0;
        }

        @Override
        public boolean isTrailersReceived() {
            return (this.metaState & 0x20) != 0;
        }

        @Override
        public boolean isPushPromiseSent() {
            return (this.metaState & 8) != 0;
        }

        @Override
        public final <V> V setProperty(Http2Connection.PropertyKey propertyKey, V v2) {
            return this.properties.add(DefaultHttp2Connection.this.verifyKey(propertyKey), v2);
        }

        @Override
        public final <V> V getProperty(Http2Connection.PropertyKey propertyKey) {
            return this.properties.get(DefaultHttp2Connection.this.verifyKey(propertyKey));
        }

        @Override
        public Http2Stream open(boolean bl) throws Http2Exception {
            this.state = DefaultHttp2Connection.activeState(this.id, this.state, this.isLocal(), bl);
            if (!this.createdBy().canOpenStream()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Maximum active streams violated for this endpoint.", new Object[0]);
            }
            this.activate();
            return this;
        }

        void activate() {
            if (this.state == Http2Stream.State.HALF_CLOSED_LOCAL) {
                this.headersSent(false);
            } else if (this.state == Http2Stream.State.HALF_CLOSED_REMOTE) {
                this.headersReceived(false);
            }
            DefaultHttp2Connection.this.activeStreams.activate(this);
        }

        Http2Stream close(Iterator<?> iterator) {
            if (this.state == Http2Stream.State.CLOSED) {
                return this;
            }
            this.state = Http2Stream.State.CLOSED;
            --this.createdBy().numStreams;
            DefaultHttp2Connection.this.activeStreams.deactivate(this, iterator);
            return this;
        }

        @Override
        public Http2Stream close() {
            return this.close(null);
        }

        @Override
        public Http2Stream closeLocalSide() {
            switch (this.state) {
                case OPEN: {
                    this.state = Http2Stream.State.HALF_CLOSED_LOCAL;
                    DefaultHttp2Connection.this.notifyHalfClosed(this);
                    break;
                }
                case HALF_CLOSED_LOCAL: {
                    break;
                }
                default: {
                    this.close();
                }
            }
            return this;
        }

        @Override
        public Http2Stream closeRemoteSide() {
            switch (this.state) {
                case OPEN: {
                    this.state = Http2Stream.State.HALF_CLOSED_REMOTE;
                    DefaultHttp2Connection.this.notifyHalfClosed(this);
                    break;
                }
                case HALF_CLOSED_REMOTE: {
                    break;
                }
                default: {
                    this.close();
                }
            }
            return this;
        }

        DefaultEndpoint<? extends Http2FlowController> createdBy() {
            if (DefaultHttp2Connection.this.localEndpoint.isValidStreamId(this.id)) {
                return DefaultHttp2Connection.this.localEndpoint;
            }
            return DefaultHttp2Connection.this.remoteEndpoint;
        }

        final boolean isLocal() {
            return DefaultHttp2Connection.this.localEndpoint.isValidStreamId(this.id);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class PropertyMap {
            Object[] values = EmptyArrays.EMPTY_OBJECTS;

            private PropertyMap() {
            }

            <V> V add(DefaultPropertyKey defaultPropertyKey, V v2) {
                this.resizeIfNecessary(defaultPropertyKey.index);
                Object object = this.values[defaultPropertyKey.index];
                this.values[defaultPropertyKey.index] = v2;
                return (V)object;
            }

            <V> V get(DefaultPropertyKey defaultPropertyKey) {
                if (defaultPropertyKey.index >= this.values.length) {
                    return null;
                }
                return (V)this.values[defaultPropertyKey.index];
            }

            void resizeIfNecessary(int n2) {
                if (n2 >= this.values.length) {
                    this.values = Arrays.copyOf(this.values, DefaultHttp2Connection.this.propertyKeyRegistry.size());
                }
            }
        }
    }
}

