/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http;

import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelOutboundHandler;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.handler.codec.http.FullHttpResponse;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaderNames;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaderValues;
import com.appoptics.ext.io.netty.handler.codec.http.HttpObject;
import com.appoptics.ext.io.netty.handler.codec.http.HttpObjectAggregator;
import com.appoptics.ext.io.netty.handler.codec.http.HttpRequest;
import com.appoptics.ext.io.netty.handler.codec.http.HttpResponse;
import com.appoptics.ext.io.netty.handler.codec.http.HttpResponseStatus;
import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientUpgradeHandler
extends HttpObjectAggregator
implements ChannelOutboundHandler {
    private final SourceCodec sourceCodec;
    private final UpgradeCodec upgradeCodec;
    private boolean upgradeRequested;

    public HttpClientUpgradeHandler(SourceCodec sourceCodec, UpgradeCodec upgradeCodec, int n2) {
        super(n2);
        this.sourceCodec = ObjectUtil.checkNotNull(sourceCodec, "sourceCodec");
        this.upgradeCodec = ObjectUtil.checkNotNull(upgradeCodec, "upgradeCodec");
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.disconnect(channelPromise);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.close(channelPromise);
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) throws Exception {
        channelHandlerContext.read();
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        if (!(object instanceof HttpRequest)) {
            channelHandlerContext.write(object, channelPromise);
            return;
        }
        if (this.upgradeRequested) {
            channelPromise.setFailure(new IllegalStateException("Attempting to write HTTP request with upgrade in progress"));
            return;
        }
        this.upgradeRequested = true;
        this.setUpgradeRequestHeaders(channelHandlerContext, (HttpRequest)object);
        channelHandlerContext.write(object, channelPromise);
        channelHandlerContext.fireUserEventTriggered((Object)UpgradeEvent.UPGRADE_ISSUED);
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) throws Exception {
        channelHandlerContext.flush();
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) throws Exception {
        FullHttpResponse fullHttpResponse = null;
        try {
            Object object;
            if (!this.upgradeRequested) {
                throw new IllegalStateException("Read HTTP response without requesting protocol switch");
            }
            if (httpObject instanceof HttpResponse && !HttpResponseStatus.SWITCHING_PROTOCOLS.equals((object = (HttpResponse)httpObject).status())) {
                channelHandlerContext.fireUserEventTriggered((Object)UpgradeEvent.UPGRADE_REJECTED);
                HttpClientUpgradeHandler.removeThisHandler(channelHandlerContext);
                channelHandlerContext.fireChannelRead(httpObject);
                return;
            }
            if (httpObject instanceof FullHttpResponse) {
                fullHttpResponse = (FullHttpResponse)httpObject;
                fullHttpResponse.retain();
                list.add(fullHttpResponse);
            } else {
                super.decode(channelHandlerContext, httpObject, list);
                if (list.isEmpty()) {
                    return;
                }
                assert (list.size() == 1);
                fullHttpResponse = (FullHttpResponse)list.get(0);
            }
            object = fullHttpResponse.headers().get(HttpHeaderNames.UPGRADE);
            if (object != null && !AsciiString.contentEqualsIgnoreCase(this.upgradeCodec.protocol(), (CharSequence)object)) {
                throw new IllegalStateException("Switching Protocols response with unexpected UPGRADE protocol: " + object);
            }
            this.sourceCodec.prepareUpgradeFrom(channelHandlerContext);
            this.upgradeCodec.upgradeTo(channelHandlerContext, fullHttpResponse);
            channelHandlerContext.fireUserEventTriggered((Object)UpgradeEvent.UPGRADE_SUCCESSFUL);
            this.sourceCodec.upgradeFrom(channelHandlerContext);
            fullHttpResponse.release();
            list.clear();
            HttpClientUpgradeHandler.removeThisHandler(channelHandlerContext);
            return;
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(fullHttpResponse);
            channelHandlerContext.fireExceptionCaught(throwable);
            HttpClientUpgradeHandler.removeThisHandler(channelHandlerContext);
            return;
        }
    }

    private static void removeThisHandler(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.pipeline().remove(channelHandlerContext.name());
    }

    private void setUpgradeRequestHeaders(ChannelHandlerContext object, HttpRequest httpRequest) {
        httpRequest.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)this.upgradeCodec.protocol());
        Object object2 = new LinkedHashSet<CharSequence>(2);
        object2.addAll(this.upgradeCodec.setUpgradeHeaders((ChannelHandlerContext)object, httpRequest));
        object = new StringBuilder();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            CharSequence charSequence = (CharSequence)object2.next();
            ((StringBuilder)object).append(charSequence);
            ((StringBuilder)object).append(',');
        }
        ((StringBuilder)object).append(HttpHeaderValues.UPGRADE);
        httpRequest.headers().add(HttpHeaderNames.CONNECTION, (Object)((StringBuilder)object).toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface UpgradeCodec {
        public CharSequence protocol();

        public Collection<CharSequence> setUpgradeHeaders(ChannelHandlerContext var1, HttpRequest var2);

        public void upgradeTo(ChannelHandlerContext var1, FullHttpResponse var2) throws Exception;
    }

    public static interface SourceCodec {
        public void prepareUpgradeFrom(ChannelHandlerContext var1);

        public void upgradeFrom(ChannelHandlerContext var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpgradeEvent {
        UPGRADE_ISSUED,
        UPGRADE_SUCCESSFUL,
        UPGRADE_REJECTED;

    }
}

