/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http;

import com.appoptics.ext.io.netty.handler.codec.DefaultHeaders;
import com.appoptics.ext.io.netty.handler.codec.Headers;
import com.appoptics.ext.io.netty.handler.codec.ValueConverter;
import com.appoptics.ext.io.netty.handler.codec.http.DefaultHttpHeaders;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaderNames;
import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.HashingStrategy;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CombinedHttpHeaders
extends DefaultHttpHeaders {
    public CombinedHttpHeaders(boolean bl) {
        super(new CombinedHttpHeadersImpl(AsciiString.CASE_INSENSITIVE_HASHER, CombinedHttpHeaders.valueConverter(bl), CombinedHttpHeaders.nameValidator(bl)));
    }

    public boolean containsValue(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        return super.containsValue(charSequence, StringUtil.trimOws(charSequence2), bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CombinedHttpHeadersImpl
    extends DefaultHeaders<CharSequence, CharSequence, CombinedHttpHeadersImpl> {
        private CsvValueEscaper<Object> objectEscaper;
        private CsvValueEscaper<CharSequence> charSequenceEscaper;

        private CsvValueEscaper<Object> objectEscaper() {
            if (this.objectEscaper == null) {
                this.objectEscaper = new CsvValueEscaper<Object>(){

                    @Override
                    public CharSequence escape(Object object) {
                        return StringUtil.escapeCsv((CharSequence)CombinedHttpHeadersImpl.this.valueConverter().convertObject(object), true);
                    }
                };
            }
            return this.objectEscaper;
        }

        private CsvValueEscaper<CharSequence> charSequenceEscaper() {
            if (this.charSequenceEscaper == null) {
                this.charSequenceEscaper = new CsvValueEscaper<CharSequence>(){

                    @Override
                    public CharSequence escape(CharSequence charSequence) {
                        return StringUtil.escapeCsv(charSequence, true);
                    }
                };
            }
            return this.charSequenceEscaper;
        }

        CombinedHttpHeadersImpl(HashingStrategy<CharSequence> hashingStrategy, ValueConverter<CharSequence> valueConverter, DefaultHeaders.NameValidator<CharSequence> nameValidator) {
            super(hashingStrategy, valueConverter, nameValidator);
        }

        @Override
        public final Iterator<CharSequence> valueIterator(CharSequence object) {
            Iterator<CharSequence> iterator = super.valueIterator(object);
            if (!iterator.hasNext() || CombinedHttpHeadersImpl.cannotBeCombined((CharSequence)object)) {
                return iterator;
            }
            object = StringUtil.unescapeCsvFields(iterator.next()).iterator();
            if (iterator.hasNext()) {
                throw new IllegalStateException("CombinedHttpHeaders should only have one value");
            }
            return object;
        }

        @Override
        public final List<CharSequence> getAll(CharSequence charSequence) {
            List<CharSequence> list = super.getAll(charSequence);
            if (list.isEmpty() || CombinedHttpHeadersImpl.cannotBeCombined(charSequence)) {
                return list;
            }
            if (list.size() != 1) {
                throw new IllegalStateException("CombinedHttpHeaders should only have one value");
            }
            return StringUtil.unescapeCsvFields(list.get(0));
        }

        @Override
        public final CombinedHttpHeadersImpl add(Headers<? extends CharSequence, ? extends CharSequence, ?> iterator) {
            if (iterator == this) {
                throw new IllegalArgumentException("can't add to itself.");
            }
            if (iterator instanceof CombinedHttpHeadersImpl) {
                if (this.isEmpty()) {
                    this.addImpl(iterator);
                } else {
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        this.addEscapedValue((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                    }
                }
            } else {
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    this.add((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                }
            }
            return this;
        }

        @Override
        public final CombinedHttpHeadersImpl set(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
            if (headers == this) {
                return this;
            }
            this.clear();
            return this.add((Headers)headers);
        }

        @Override
        public final CombinedHttpHeadersImpl add(CharSequence charSequence, CharSequence charSequence2) {
            return this.addEscapedValue(charSequence, this.charSequenceEscaper().escape(charSequence2));
        }

        @Override
        public final CombinedHttpHeadersImpl addObject(CharSequence charSequence, Object object) {
            return this.addEscapedValue(charSequence, CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), object));
        }

        @Override
        public final CombinedHttpHeadersImpl setObject(CharSequence charSequence, Object object) {
            super.set(charSequence, CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), object));
            return this;
        }

        @Override
        public final CombinedHttpHeadersImpl setObject(CharSequence charSequence, Iterable<?> iterable) {
            super.set(charSequence, CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), iterable));
            return this;
        }

        private static boolean cannotBeCombined(CharSequence charSequence) {
            return HttpHeaderNames.SET_COOKIE.contentEqualsIgnoreCase(charSequence);
        }

        private CombinedHttpHeadersImpl addEscapedValue(CharSequence charSequence, CharSequence charSequence2) {
            CharSequence charSequence3 = (CharSequence)super.get(charSequence);
            if (charSequence3 == null || CombinedHttpHeadersImpl.cannotBeCombined(charSequence)) {
                super.add(charSequence, charSequence2);
            } else {
                super.set(charSequence, CombinedHttpHeadersImpl.commaSeparateEscapedValues(charSequence3, charSequence2));
            }
            return this;
        }

        private static <T> CharSequence commaSeparate(CsvValueEscaper<T> csvValueEscaper, T ... TArray) {
            StringBuilder stringBuilder = new StringBuilder(TArray.length * 10);
            if (TArray.length > 0) {
                int n2 = TArray.length - 1;
                for (int i2 = 0; i2 < n2; ++i2) {
                    stringBuilder.append(csvValueEscaper.escape(TArray[i2])).append(',');
                }
                stringBuilder.append(csvValueEscaper.escape(TArray[n2]));
            }
            return stringBuilder;
        }

        private static <T> CharSequence commaSeparate(CsvValueEscaper<T> csvValueEscaper, Iterable<? extends T> object) {
            StringBuilder stringBuilder = object instanceof Collection ? new StringBuilder(((Collection)object).size() * 10) : new StringBuilder();
            if ((object = object.iterator()).hasNext()) {
                Object e2 = object.next();
                while (object.hasNext()) {
                    stringBuilder.append(csvValueEscaper.escape(e2)).append(',');
                    e2 = object.next();
                }
                stringBuilder.append(csvValueEscaper.escape(e2));
            }
            return stringBuilder;
        }

        private static CharSequence commaSeparateEscapedValues(CharSequence charSequence, CharSequence charSequence2) {
            return new StringBuilder(charSequence.length() + 1 + charSequence2.length()).append(charSequence).append(',').append(charSequence2);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static interface CsvValueEscaper<T> {
            public CharSequence escape(T var1);
        }
    }
}

