/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec;

import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelInboundHandlerAdapter;
import com.appoptics.ext.io.netty.handler.codec.CodecOutputList;
import com.appoptics.ext.io.netty.handler.codec.DecoderException;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import com.appoptics.ext.io.netty.util.internal.TypeParameterMatcher;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageToMessageDecoder<I>
extends ChannelInboundHandlerAdapter {
    private final TypeParameterMatcher matcher = TypeParameterMatcher.find(this, MessageToMessageDecoder.class, "I");

    protected MessageToMessageDecoder() {
    }

    public boolean acceptInboundMessage(Object object) throws Exception {
        return this.matcher.match(object);
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        block16: {
            CodecOutputList codecOutputList = CodecOutputList.newInstance();
            try {
                if (this.acceptInboundMessage(object)) {
                    try {
                        this.decode(channelHandlerContext, object, codecOutputList);
                        break block16;
                    }
                    finally {
                        ReferenceCountUtil.release(object);
                    }
                }
                codecOutputList.add(object);
            }
            catch (DecoderException decoderException) {
                object = decoderException;
                throw decoderException;
            }
            catch (Exception exception) {
                throw new DecoderException(exception);
            }
            finally {
                try {
                    int n2 = codecOutputList.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        channelHandlerContext.fireChannelRead(codecOutputList.getUnsafe(i2));
                    }
                }
                finally {
                    codecOutputList.recycle();
                }
            }
        }
    }

    protected abstract void decode(ChannelHandlerContext var1, I var2, List<Object> var3) throws Exception;
}

