/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec;

import com.appoptics.ext.io.netty.handler.codec.Headers;
import com.appoptics.ext.io.netty.handler.codec.HeadersUtils;
import com.appoptics.ext.io.netty.handler.codec.ValueConverter;
import com.appoptics.ext.io.netty.util.HashingStrategy;
import com.appoptics.ext.io.netty.util.internal.MathUtil;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHeaders<K, V, T extends Headers<K, V, T>>
implements Headers<K, V, T> {
    private final HeaderEntry<K, V>[] entries;
    protected final HeaderEntry<K, V> head;
    private final byte hashMask;
    private final ValueConverter<V> valueConverter;
    private final NameValidator<K> nameValidator;
    private final HashingStrategy<K> hashingStrategy;
    int size;

    public DefaultHeaders(HashingStrategy<K> hashingStrategy, ValueConverter<V> valueConverter) {
        this(hashingStrategy, valueConverter, NameValidator.NOT_NULL);
    }

    public DefaultHeaders(HashingStrategy<K> hashingStrategy, ValueConverter<V> valueConverter, NameValidator<K> nameValidator) {
        this(hashingStrategy, valueConverter, nameValidator, 16);
    }

    public DefaultHeaders(HashingStrategy<K> hashingStrategy, ValueConverter<V> valueConverter, NameValidator<K> nameValidator, int n2) {
        this.valueConverter = ObjectUtil.checkNotNull(valueConverter, "valueConverter");
        this.nameValidator = ObjectUtil.checkNotNull(nameValidator, "nameValidator");
        this.hashingStrategy = ObjectUtil.checkNotNull(hashingStrategy, "nameHashingStrategy");
        this.entries = new HeaderEntry[MathUtil.findNextPositivePowerOfTwo(Math.max(2, Math.min(n2, 128)))];
        this.hashMask = (byte)(this.entries.length - 1);
        this.head = new HeaderEntry();
    }

    @Override
    public V get(K k2) {
        ObjectUtil.checkNotNull(k2, "name");
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        HeaderEntry<K, V> headerEntry = this.entries[n3];
        V v2 = null;
        while (headerEntry != null) {
            if (headerEntry.hash == n2 && this.hashingStrategy.equals(k2, headerEntry.key)) {
                v2 = headerEntry.value;
            }
            headerEntry = headerEntry.next;
        }
        return v2;
    }

    public V getAndRemove(K k2) {
        int n2 = this.hashingStrategy.hashCode(k2);
        return this.remove0(n2, this.index(n2), ObjectUtil.checkNotNull(k2, "name"));
    }

    @Override
    public List<V> getAll(K k2) {
        ObjectUtil.checkNotNull(k2, "name");
        LinkedList<V> linkedList = new LinkedList<V>();
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        HeaderEntry<K, V> headerEntry = this.entries[n3];
        while (headerEntry != null) {
            if (headerEntry.hash == n2 && this.hashingStrategy.equals(k2, headerEntry.key)) {
                linkedList.addFirst(headerEntry.getValue());
            }
            headerEntry = headerEntry.next;
        }
        return linkedList;
    }

    public Iterator<V> valueIterator(K k2) {
        return new ValueIterator(k2);
    }

    public boolean contains(K k2) {
        return this.get(k2) != null;
    }

    public final boolean contains(K k2, V v2, HashingStrategy<? super V> hashingStrategy) {
        ObjectUtil.checkNotNull(k2, "name");
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        HeaderEntry<K, V> headerEntry = this.entries[n3];
        while (headerEntry != null) {
            if (headerEntry.hash == n2 && this.hashingStrategy.equals(k2, headerEntry.key) && hashingStrategy.equals(v2, headerEntry.value)) {
                return true;
            }
            headerEntry = headerEntry.next;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    public Set<K> names() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet(this.size());
        HeaderEntry headerEntry = this.head.after;
        while (headerEntry != this.head) {
            linkedHashSet.add(headerEntry.getKey());
            headerEntry = headerEntry.after;
        }
        return linkedHashSet;
    }

    @Override
    public T add(K k2, V v2) {
        this.nameValidator.validateName(k2);
        ObjectUtil.checkNotNull(v2, "value");
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        this.add0(n2, n3, k2, v2);
        return this.thisT();
    }

    public T addObject(K k2, Object object) {
        return this.add(k2, this.valueConverter.convertObject(ObjectUtil.checkNotNull(object, "value")));
    }

    public T add(Headers<? extends K, ? extends V, ?> headers) {
        if (headers == this) {
            throw new IllegalArgumentException("can't add to itself.");
        }
        this.addImpl(headers);
        return this.thisT();
    }

    protected void addImpl(Headers<? extends K, ? extends V, ?> object) {
        if (object instanceof DefaultHeaders) {
            object = (DefaultHeaders)object;
            HeaderEntry headerEntry = ((DefaultHeaders)object).head.after;
            if (((DefaultHeaders)object).hashingStrategy == this.hashingStrategy && ((DefaultHeaders)object).nameValidator == this.nameValidator) {
                while (headerEntry != ((DefaultHeaders)object).head) {
                    this.add0(headerEntry.hash, this.index(headerEntry.hash), headerEntry.key, headerEntry.value);
                    headerEntry = headerEntry.after;
                }
            } else {
                while (headerEntry != ((DefaultHeaders)object).head) {
                    this.add(headerEntry.key, headerEntry.value);
                    headerEntry = headerEntry.after;
                }
            }
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public T set(K k2, V v2) {
        this.nameValidator.validateName(k2);
        ObjectUtil.checkNotNull(v2, "value");
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        this.remove0(n2, n3, k2);
        this.add0(n2, n3, k2, v2);
        return this.thisT();
    }

    public T setObject(K k2, Object object) {
        ObjectUtil.checkNotNull(object, "value");
        object = ObjectUtil.checkNotNull(this.valueConverter.convertObject(object), "convertedValue");
        return this.set(k2, object);
    }

    public T setObject(K k2, Iterable<?> object) {
        Object e2;
        this.nameValidator.validateName(k2);
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        this.remove0(n2, n3, k2);
        object = object.iterator();
        while (object.hasNext() && (e2 = object.next()) != null) {
            this.add0(n2, n3, k2, this.valueConverter.convertObject(e2));
        }
        return this.thisT();
    }

    public T setInt(K k2, int n2) {
        return this.set(k2, this.valueConverter.convertInt(n2));
    }

    public T set(Headers<? extends K, ? extends V, ?> headers) {
        if (headers != this) {
            this.clear();
            this.addImpl(headers);
        }
        return this.thisT();
    }

    public boolean remove(K k2) {
        return this.getAndRemove(k2) != null;
    }

    public T clear() {
        Arrays.fill(this.entries, null);
        this.head.after = this.head;
        this.head.before = this.head.after;
        this.size = 0;
        return this.thisT();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new HeaderIterator();
    }

    public Integer getInt(K object) {
        object = this.get(object);
        try {
            if (object != null) {
                return this.valueConverter.convertToInt(object);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public int getInt(K object, int n2) {
        if ((object = this.getInt(object)) != null) {
            return (Integer)object;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Headers)) {
            return false;
        }
        return this.equals((Headers)object, HashingStrategy.JAVA_HASHER);
    }

    public int hashCode() {
        return this.hashCode(HashingStrategy.JAVA_HASHER);
    }

    public final boolean equals(Headers<K, V, ?> headers, HashingStrategy<V> hashingStrategy) {
        if (headers.size() != this.size()) {
            return false;
        }
        if (this == headers) {
            return true;
        }
        for (Object object : this.names()) {
            List<V> list = headers.getAll(object);
            object = this.getAll(object);
            if (list.size() != object.size()) {
                return false;
            }
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (hashingStrategy.equals(list.get(i2), object.get(i2))) continue;
                return false;
            }
        }
        return true;
    }

    public final int hashCode(HashingStrategy<V> hashingStrategy) {
        int n2 = -1028477387;
        for (Object object : this.names()) {
            n2 = n2 * 31 + this.hashingStrategy.hashCode(object);
            object = this.getAll(object);
            for (int i2 = 0; i2 < object.size(); ++i2) {
                n2 = n2 * 31 + hashingStrategy.hashCode(object.get(i2));
            }
        }
        return n2;
    }

    public String toString() {
        return HeadersUtils.toString(this.getClass(), this.iterator(), this.size());
    }

    protected HeaderEntry<K, V> newHeaderEntry(int n2, K k2, V v2, HeaderEntry<K, V> headerEntry) {
        return new HeaderEntry<K, V>(n2, k2, v2, headerEntry, this.head);
    }

    protected ValueConverter<V> valueConverter() {
        return this.valueConverter;
    }

    private int index(int n2) {
        return n2 & this.hashMask;
    }

    private void add0(int n2, int n3, K k2, V v2) {
        this.entries[n3] = this.newHeaderEntry(n2, k2, v2, this.entries[n3]);
        ++this.size;
    }

    private V remove0(int n2, int n3, K k2) {
        HeaderEntry<K, V> headerEntry = this.entries[n3];
        if (headerEntry == null) {
            return null;
        }
        V v2 = null;
        HeaderEntry headerEntry2 = headerEntry.next;
        while (headerEntry2 != null) {
            if (headerEntry2.hash == n2 && this.hashingStrategy.equals(k2, headerEntry2.key)) {
                v2 = headerEntry2.value;
                headerEntry.next = headerEntry2.next;
                headerEntry2.remove();
                --this.size;
            } else {
                headerEntry = headerEntry2;
            }
            headerEntry2 = headerEntry.next;
        }
        headerEntry = this.entries[n3];
        if (headerEntry.hash == n2 && this.hashingStrategy.equals(k2, headerEntry.key)) {
            if (v2 == null) {
                v2 = headerEntry.value;
            }
            this.entries[n3] = headerEntry.next;
            headerEntry.remove();
            --this.size;
        }
        return v2;
    }

    private HeaderEntry<K, V> remove0(HeaderEntry<K, V> headerEntry, HeaderEntry<K, V> headerEntry2) {
        int n2 = this.index(headerEntry.hash);
        HeaderEntry<K, V> headerEntry3 = this.entries[n2];
        if (headerEntry3 == headerEntry) {
            this.entries[n2] = headerEntry.next;
            headerEntry2 = this.entries[n2];
        } else {
            headerEntry2.next = headerEntry.next;
        }
        headerEntry.remove();
        --this.size;
        return headerEntry2;
    }

    private T thisT() {
        return (T)this;
    }

    public DefaultHeaders<K, V, T> copy() {
        DefaultHeaders<K, V, T> defaultHeaders = new DefaultHeaders<K, V, T>(this.hashingStrategy, this.valueConverter, this.nameValidator, this.entries.length);
        defaultHeaders.addImpl(this);
        return defaultHeaders;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class HeaderEntry<K, V>
    implements Map.Entry<K, V> {
        protected final int hash;
        protected final K key;
        protected V value;
        protected HeaderEntry<K, V> next;
        protected HeaderEntry<K, V> before;
        protected HeaderEntry<K, V> after;

        protected HeaderEntry(int n2, K k2) {
            this.hash = n2;
            this.key = k2;
        }

        HeaderEntry(int n2, K k2, V v2, HeaderEntry<K, V> headerEntry, HeaderEntry<K, V> headerEntry2) {
            this.hash = n2;
            this.key = k2;
            this.value = v2;
            this.next = headerEntry;
            this.after = headerEntry2;
            this.before = headerEntry2.before;
            this.pointNeighborsToThis();
        }

        HeaderEntry() {
            HeaderEntry headerEntry;
            this.hash = -1;
            this.key = null;
            headerEntry = headerEntry.before = (headerEntry.after = this);
        }

        protected final void pointNeighborsToThis() {
            this.before.after = this;
            this.after.before = this;
        }

        public final HeaderEntry<K, V> before() {
            return this.before;
        }

        public final HeaderEntry<K, V> after() {
            return this.after;
        }

        protected void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V v2) {
            ObjectUtil.checkNotNull(v2, "value");
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        public final String toString() {
            return this.key.toString() + '=' + this.value.toString();
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            object = (Map.Entry)object;
            return (this.getKey() == null ? object.getKey() == null : this.getKey().equals(object.getKey())) && (this.getValue() == null ? object.getValue() == null : this.getValue().equals(object.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueIterator
    implements Iterator<V> {
        private final K name;
        private final int hash;
        private HeaderEntry<K, V> removalPrevious;
        private HeaderEntry<K, V> previous;
        private HeaderEntry<K, V> next;

        ValueIterator(K k2) {
            this.name = ObjectUtil.checkNotNull(k2, "name");
            this.hash = DefaultHeaders.this.hashingStrategy.hashCode(k2);
            this.calculateNext(DefaultHeaders.this.entries[DefaultHeaders.this.index(this.hash)]);
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        @Override
        public final V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.previous != null) {
                this.removalPrevious = this.previous;
            }
            this.previous = this.next;
            ValueIterator valueIterator = this;
            valueIterator.calculateNext(valueIterator.next.next);
            return this.previous.value;
        }

        @Override
        public final void remove() {
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            this.removalPrevious = DefaultHeaders.this.remove0(this.previous, this.removalPrevious);
            this.previous = null;
        }

        private void calculateNext(HeaderEntry<K, V> headerEntry) {
            while (headerEntry != null) {
                if (headerEntry.hash == this.hash && DefaultHeaders.this.hashingStrategy.equals(this.name, headerEntry.key)) {
                    this.next = headerEntry;
                    return;
                }
                headerEntry = headerEntry.next;
            }
            this.next = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HeaderIterator
    implements Iterator<Map.Entry<K, V>> {
        private HeaderEntry<K, V> current;

        private HeaderIterator() {
            this.current = DefaultHeaders.this.head;
        }

        @Override
        public final boolean hasNext() {
            return this.current.after != DefaultHeaders.this.head;
        }

        @Override
        public final Map.Entry<K, V> next() {
            this.current = this.current.after;
            if (this.current == DefaultHeaders.this.head) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("read only");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NameValidator<K> {
        public static final NameValidator NOT_NULL = new NameValidator(){

            public final void validateName(Object object) {
                ObjectUtil.checkNotNull(object, "name");
            }
        };

        public void validateName(K var1);
    }
}

