/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec;

import com.appoptics.ext.io.netty.util.concurrent.FastThreadLocal;
import com.appoptics.ext.io.netty.util.internal.MathUtil;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.util.AbstractList;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CodecOutputList
extends AbstractList<Object>
implements RandomAccess {
    private static final CodecOutputListRecycler NOOP_RECYCLER = new CodecOutputListRecycler(){

        public final void recycle(CodecOutputList codecOutputList) {
        }
    };
    private static final FastThreadLocal<CodecOutputLists> CODEC_OUTPUT_LISTS_POOL = new FastThreadLocal<CodecOutputLists>(){

        @Override
        protected final CodecOutputLists initialValue() throws Exception {
            return new CodecOutputLists(16);
        }
    };
    private final CodecOutputListRecycler recycler;
    private int size;
    private Object[] array;
    private boolean insertSinceRecycled;

    static CodecOutputList newInstance() {
        return CODEC_OUTPUT_LISTS_POOL.get().getOrCreate();
    }

    private CodecOutputList(CodecOutputListRecycler codecOutputListRecycler, int n2) {
        this.recycler = codecOutputListRecycler;
        this.array = new Object[n2];
    }

    @Override
    public final Object get(int n2) {
        this.checkIndex(n2);
        return this.array[n2];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean add(Object object) {
        ObjectUtil.checkNotNull(object, "element");
        try {
            CodecOutputList codecOutputList = this;
            codecOutputList.insert(codecOutputList.size, object);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.expandArray();
            CodecOutputList codecOutputList = this;
            codecOutputList.insert(codecOutputList.size, object);
        }
        ++this.size;
        return true;
    }

    @Override
    public final Object set(int n2, Object object) {
        ObjectUtil.checkNotNull(object, "element");
        this.checkIndex(n2);
        Object object2 = this.array[n2];
        this.insert(n2, object);
        return object2;
    }

    @Override
    public final void add(int n2, Object object) {
        ObjectUtil.checkNotNull(object, "element");
        this.checkIndex(n2);
        if (this.size == this.array.length) {
            this.expandArray();
        }
        if (n2 != this.size) {
            System.arraycopy(this.array, n2, this.array, n2 + 1, this.size - n2);
        }
        this.insert(n2, object);
        ++this.size;
    }

    @Override
    public final Object remove(int n2) {
        this.checkIndex(n2);
        Object object = this.array[n2];
        int n3 = this.size - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.array, n2 + 1, this.array, n2, n3);
        }
        this.array[--this.size] = null;
        return object;
    }

    @Override
    public final void clear() {
        this.size = 0;
    }

    final boolean insertSinceRecycled() {
        return this.insertSinceRecycled;
    }

    final void recycle() {
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.array[i2] = null;
        }
        this.size = 0;
        this.insertSinceRecycled = false;
        this.recycler.recycle(this);
    }

    final Object getUnsafe(int n2) {
        return this.array[n2];
    }

    private void checkIndex(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void insert(int n2, Object object) {
        this.array[n2] = object;
        this.insertSinceRecycled = true;
    }

    private void expandArray() {
        int n2 = this.array.length << 1;
        if (n2 < 0) {
            throw new OutOfMemoryError();
        }
        Object[] objectArray = new Object[n2];
        System.arraycopy(this.array, 0, objectArray, 0, this.array.length);
        this.array = objectArray;
    }

    private static final class CodecOutputLists
    implements CodecOutputListRecycler {
        private final CodecOutputList[] elements;
        private final int mask;
        private int currentIdx;
        private int count;

        CodecOutputLists(int n2) {
            this.elements = new CodecOutputList[MathUtil.safeFindNextPositivePowerOfTwo(n2)];
            for (n2 = 0; n2 < this.elements.length; ++n2) {
                this.elements[n2] = new CodecOutputList(this, 16);
            }
            this.count = this.elements.length;
            this.currentIdx = this.elements.length;
            this.mask = this.elements.length - 1;
        }

        public final CodecOutputList getOrCreate() {
            if (this.count == 0) {
                return new CodecOutputList(NOOP_RECYCLER, 4);
            }
            --this.count;
            int n2 = this.currentIdx - 1 & this.mask;
            CodecOutputList codecOutputList = this.elements[n2];
            this.currentIdx = n2;
            return codecOutputList;
        }

        public final void recycle(CodecOutputList codecOutputList) {
            int n2 = this.currentIdx;
            this.elements[n2] = codecOutputList;
            this.currentIdx = n2 + 1 & this.mask;
            ++this.count;
            assert (this.count <= this.elements.length);
        }
    }

    private static interface CodecOutputListRecycler {
        public void recycle(CodecOutputList var1);
    }
}

