/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.CompositeByteBuf;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelInboundHandlerAdapter;
import com.appoptics.ext.io.netty.channel.socket.ChannelInputShutdownEvent;
import com.appoptics.ext.io.netty.handler.codec.CodecOutputList;
import com.appoptics.ext.io.netty.handler.codec.DecoderException;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ByteToMessageDecoder
extends ChannelInboundHandlerAdapter {
    public static final Cumulator MERGE_CUMULATOR = new Cumulator(){

        public final ByteBuf cumulate(ByteBufAllocator object, ByteBuf byteBuf, ByteBuf byteBuf2) {
            if (!byteBuf.isReadable() && byteBuf2.isContiguous()) {
                byteBuf.release();
                return byteBuf2;
            }
            try {
                int n2 = byteBuf2.readableBytes();
                if (n2 > byteBuf.maxWritableBytes() || n2 > byteBuf.maxFastWritableBytes() && byteBuf.refCnt() > 1 || byteBuf.isReadOnly()) {
                    object = ByteToMessageDecoder.expandCumulation((ByteBufAllocator)object, byteBuf, byteBuf2);
                    return object;
                }
                ByteBuf byteBuf3 = byteBuf2;
                byteBuf.writeBytes(byteBuf3, byteBuf3.readerIndex(), n2);
                ByteBuf byteBuf4 = byteBuf2;
                byteBuf4.readerIndex(byteBuf4.writerIndex());
                object = byteBuf;
                return object;
            }
            finally {
                byteBuf2.release();
            }
        }
    };
    public static final Cumulator COMPOSITE_CUMULATOR = new Cumulator(){

        public final ByteBuf cumulate(ByteBufAllocator object, ByteBuf byteBuf, ByteBuf byteBuf2) {
            if (!byteBuf.isReadable()) {
                byteBuf.release();
                return byteBuf2;
            }
            CompositeByteBuf compositeByteBuf = null;
            try {
                if (byteBuf instanceof CompositeByteBuf && byteBuf.refCnt() == 1) {
                    compositeByteBuf = (CompositeByteBuf)byteBuf;
                    if (compositeByteBuf.writerIndex() != compositeByteBuf.capacity()) {
                        CompositeByteBuf compositeByteBuf2 = compositeByteBuf;
                        compositeByteBuf2.capacity(compositeByteBuf2.writerIndex());
                    }
                } else {
                    compositeByteBuf = object.compositeBuffer(Integer.MAX_VALUE).addFlattenedComponents(true, byteBuf);
                }
                compositeByteBuf.addFlattenedComponents(true, byteBuf2);
                byteBuf2 = null;
                object = compositeByteBuf;
                return object;
            }
            catch (Throwable throwable) {
                if (byteBuf2 != null) {
                    byteBuf2.release();
                    if (compositeByteBuf != null && compositeByteBuf != byteBuf) {
                        compositeByteBuf.release();
                    }
                }
                throw throwable;
            }
        }
    };
    ByteBuf cumulation;
    private Cumulator cumulator = MERGE_CUMULATOR;
    private boolean singleDecode;
    private boolean first;
    private boolean firedChannelRead;
    private byte decodeState = 0;
    private int discardAfterReads = 16;
    private int numReads;

    protected ByteToMessageDecoder() {
        this.ensureNotSharable();
    }

    public boolean isSingleDecode() {
        return this.singleDecode;
    }

    public void setCumulator(Cumulator cumulator) {
        this.cumulator = ObjectUtil.checkNotNull(cumulator, "cumulator");
    }

    protected int actualReadableBytes() {
        return this.internalBuffer().readableBytes();
    }

    protected ByteBuf internalBuffer() {
        if (this.cumulation != null) {
            return this.cumulation;
        }
        return Unpooled.EMPTY_BUFFER;
    }

    @Override
    public final void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.decodeState == 1) {
            this.decodeState = (byte)2;
            return;
        }
        ByteBuf byteBuf = this.cumulation;
        if (byteBuf != null) {
            this.cumulation = null;
            this.numReads = 0;
            int n2 = byteBuf.readableBytes();
            if (n2 > 0) {
                channelHandlerContext.fireChannelRead(byteBuf);
                channelHandlerContext.fireChannelReadComplete();
            } else {
                byteBuf.release();
            }
        }
        this.handlerRemoved0(channelHandlerContext);
    }

    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) throws Exception {
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (object instanceof ByteBuf) {
            CodecOutputList codecOutputList = CodecOutputList.newInstance();
            try {
                this.first = this.cumulation == null;
                this.cumulation = this.cumulator.cumulate(channelHandlerContext.alloc(), this.first ? Unpooled.EMPTY_BUFFER : this.cumulation, (ByteBuf)object);
                this.callDecode(channelHandlerContext, this.cumulation, codecOutputList);
            }
            catch (DecoderException decoderException) {
                object = decoderException;
                throw decoderException;
            }
            catch (Exception exception) {
                throw new DecoderException(exception);
            }
            finally {
                try {
                    if (this.cumulation != null && !this.cumulation.isReadable()) {
                        this.numReads = 0;
                        this.cumulation.release();
                        this.cumulation = null;
                    } else if (++this.numReads >= this.discardAfterReads) {
                        this.numReads = 0;
                        this.discardSomeReadBytes();
                    }
                    int n2 = codecOutputList.size();
                    this.firedChannelRead |= codecOutputList.insertSinceRecycled();
                    ByteToMessageDecoder.fireChannelRead(channelHandlerContext, codecOutputList, n2);
                }
                finally {
                    codecOutputList.recycle();
                }
            }
            return;
        }
        channelHandlerContext.fireChannelRead(object);
    }

    static void fireChannelRead(ChannelHandlerContext channelHandlerContext, List<Object> list, int n2) {
        if (list instanceof CodecOutputList) {
            ByteToMessageDecoder.fireChannelRead(channelHandlerContext, (CodecOutputList)list, n2);
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            channelHandlerContext.fireChannelRead(list.get(i2));
        }
    }

    static void fireChannelRead(ChannelHandlerContext channelHandlerContext, CodecOutputList codecOutputList, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            channelHandlerContext.fireChannelRead(codecOutputList.getUnsafe(i2));
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.numReads = 0;
        this.discardSomeReadBytes();
        if (!this.firedChannelRead && !channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
        this.firedChannelRead = false;
        channelHandlerContext.fireChannelReadComplete();
    }

    protected final void discardSomeReadBytes() {
        if (this.cumulation != null && !this.first && this.cumulation.refCnt() == 1) {
            this.cumulation.discardSomeReadBytes();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.channelInputClosed(channelHandlerContext, true);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (object instanceof ChannelInputShutdownEvent) {
            this.channelInputClosed(channelHandlerContext, false);
        }
        super.userEventTriggered(channelHandlerContext, object);
    }

    private void channelInputClosed(ChannelHandlerContext channelHandlerContext, boolean bl) {
        CodecOutputList codecOutputList = CodecOutputList.newInstance();
        try {
            this.channelInputClosed(channelHandlerContext, codecOutputList);
        }
        catch (DecoderException decoderException) {
            DecoderException decoderException2 = decoderException;
            throw decoderException;
        }
        catch (Exception exception) {
            throw new DecoderException(exception);
        }
        finally {
            try {
                if (this.cumulation != null) {
                    this.cumulation.release();
                    this.cumulation = null;
                }
                int n2 = codecOutputList.size();
                ByteToMessageDecoder.fireChannelRead(channelHandlerContext, codecOutputList, n2);
                if (n2 > 0) {
                    channelHandlerContext.fireChannelReadComplete();
                }
                if (bl) {
                    channelHandlerContext.fireChannelInactive();
                }
            }
            finally {
                codecOutputList.recycle();
            }
        }
    }

    void channelInputClosed(ChannelHandlerContext channelHandlerContext, List<Object> list) throws Exception {
        if (this.cumulation != null) {
            this.callDecode(channelHandlerContext, this.cumulation, list);
            this.decodeLast(channelHandlerContext, this.cumulation, list);
            return;
        }
        this.decodeLast(channelHandlerContext, Unpooled.EMPTY_BUFFER, list);
    }

    protected void callDecode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        block7: {
            try {
                while (byteBuf.isReadable()) {
                    int n2 = list.size();
                    if (n2 > 0) {
                        ByteToMessageDecoder.fireChannelRead(channelHandlerContext, list, n2);
                        list.clear();
                        if (channelHandlerContext.isRemoved()) break;
                        n2 = 0;
                    }
                    int n3 = byteBuf.readableBytes();
                    this.decodeRemovalReentryProtection(channelHandlerContext, byteBuf, list);
                    if (channelHandlerContext.isRemoved()) break;
                    if (n2 == list.size()) {
                        if (n3 != byteBuf.readableBytes()) continue;
                        break block7;
                    }
                    if (n3 == byteBuf.readableBytes()) {
                        throw new DecoderException(StringUtil.simpleClassName(this.getClass()) + ".decode() did not read anything but decoded a message.");
                    }
                    if (!this.isSingleDecode()) continue;
                }
                return;
            }
            catch (DecoderException decoderException) {
                DecoderException decoderException2 = decoderException;
                throw decoderException;
            }
            catch (Exception exception) {
                throw new DecoderException(exception);
            }
        }
    }

    protected abstract void decode(ChannelHandlerContext var1, ByteBuf var2, List<Object> var3) throws Exception;

    final void decodeRemovalReentryProtection(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        boolean bl;
        this.decodeState = 1;
        try {
            this.decode(channelHandlerContext, byteBuf, list);
            bl = this.decodeState == 2;
        }
        catch (Throwable throwable) {
            boolean bl2 = this.decodeState == 2;
            this.decodeState = 0;
            if (bl2) {
                List<Object> list2 = list;
                ByteToMessageDecoder.fireChannelRead(channelHandlerContext, list2, list2.size());
                list.clear();
                this.handlerRemoved(channelHandlerContext);
            }
            throw throwable;
        }
        this.decodeState = 0;
        if (bl) {
            List<Object> list3 = list;
            ByteToMessageDecoder.fireChannelRead(channelHandlerContext, list3, list3.size());
            list.clear();
            this.handlerRemoved(channelHandlerContext);
        }
    }

    protected void decodeLast(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (byteBuf.isReadable()) {
            this.decodeRemovalReentryProtection(channelHandlerContext, byteBuf, list);
        }
    }

    static ByteBuf expandCumulation(ByteBufAllocator object, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2 = byteBuf.readableBytes();
        int n3 = byteBuf2.readableBytes();
        int n4 = n2 + n3;
        ByteBufAllocator byteBufAllocator = object;
        object = byteBufAllocator.buffer(byteBufAllocator.calculateNewCapacity(n4, Integer.MAX_VALUE));
        ByteBuf byteBuf3 = object;
        try {
            ByteBuf byteBuf4 = byteBuf;
            ByteBuf byteBuf5 = byteBuf2;
            ((ByteBuf)object).setBytes(0, byteBuf4, byteBuf4.readerIndex(), n2).setBytes(n2, byteBuf5, byteBuf5.readerIndex(), n3).writerIndex(n4);
            ByteBuf byteBuf6 = byteBuf2;
            byteBuf6.readerIndex(byteBuf6.writerIndex());
            byteBuf3 = byteBuf;
            return object;
        }
        finally {
            byteBuf3.release();
        }
    }

    public static interface Cumulator {
        public ByteBuf cumulate(ByteBufAllocator var1, ByteBuf var2, ByteBuf var3);
    }
}

