/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel.socket.nio;

import com.appoptics.ext.io.netty.channel.ChannelException;
import com.appoptics.ext.io.netty.channel.ChannelOption;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.Channel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioChannelOption<T>
extends ChannelOption<T> {
    private final SocketOption<T> option;

    static <T> boolean setOption(Channel channel, NioChannelOption<T> nioChannelOption, T t2) {
        if (!(channel = (NetworkChannel)channel).supportedOptions().contains(nioChannelOption.option)) {
            return false;
        }
        if (channel instanceof ServerSocketChannel && nioChannelOption.option == StandardSocketOptions.IP_TOS) {
            return false;
        }
        try {
            channel.setOption(nioChannelOption.option, t2);
            return true;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    static <T> T getOption(Channel channel, NioChannelOption<T> nioChannelOption) {
        if (!(channel = (NetworkChannel)channel).supportedOptions().contains(nioChannelOption.option)) {
            return null;
        }
        if (channel instanceof ServerSocketChannel && nioChannelOption.option == StandardSocketOptions.IP_TOS) {
            return null;
        }
        try {
            return channel.getOption(nioChannelOption.option);
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }
}

