/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel.nio;

import java.nio.channels.SelectionKey;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SelectedSelectionKeySet
extends AbstractSet<SelectionKey> {
    SelectionKey[] keys = new SelectionKey[1024];
    int size;

    SelectedSelectionKeySet() {
    }

    @Override
    public final boolean add(SelectionKey selectionKey) {
        if (selectionKey == null) {
            return false;
        }
        this.keys[this.size++] = selectionKey;
        if (this.size == this.keys.length) {
            this.increaseCapacity();
        }
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        return false;
    }

    @Override
    public final boolean contains(Object object) {
        return false;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final Iterator<SelectionKey> iterator() {
        return new Iterator<SelectionKey>(){
            private int idx;

            @Override
            public boolean hasNext() {
                return this.idx < SelectedSelectionKeySet.this.size;
            }

            @Override
            public SelectionKey next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return SelectedSelectionKeySet.this.keys[this.idx++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    final void reset() {
        this.reset(0);
    }

    final void reset(int n2) {
        Arrays.fill(this.keys, n2, this.size, null);
        this.size = 0;
    }

    private void increaseCapacity() {
        SelectionKey[] selectionKeyArray = new SelectionKey[this.keys.length << 1];
        System.arraycopy(this.keys, 0, selectionKeyArray, 0, this.size);
        this.keys = selectionKeyArray;
    }
}

