/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel.nio;

import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelConfig;
import com.appoptics.ext.io.netty.channel.ChannelOutboundBuffer;
import com.appoptics.ext.io.netty.channel.ChannelPipeline;
import com.appoptics.ext.io.netty.channel.RecvByteBufAllocator;
import com.appoptics.ext.io.netty.channel.ServerChannel;
import com.appoptics.ext.io.netty.channel.nio.AbstractNioChannel;
import java.io.IOException;
import java.net.PortUnreachableException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNioMessageChannel
extends AbstractNioChannel {
    boolean inputShutdown;

    protected AbstractNioMessageChannel(Channel channel, SelectableChannel selectableChannel, int n2) {
        super(channel, selectableChannel, n2);
    }

    @Override
    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioMessageUnsafe();
    }

    @Override
    protected void doBeginRead() throws Exception {
        if (this.inputShutdown) {
            return;
        }
        super.doBeginRead();
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        SelectionKey selectionKey = this.selectionKey();
        int n2 = selectionKey.interestOps();
        while (true) {
            Object object;
            if ((object = channelOutboundBuffer.current()) == null) {
                if ((n2 & 4) == 0) break;
                selectionKey.interestOps(n2 & 0xFFFFFFFB);
                return;
            }
            try {
                boolean bl = false;
                for (int i2 = this.config().getWriteSpinCount() - 1; i2 >= 0; --i2) {
                    if (!this.doWriteMessage(object, channelOutboundBuffer)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    channelOutboundBuffer.remove();
                    continue;
                }
                if ((n2 & 4) == 0) {
                    selectionKey.interestOps(n2 | 4);
                }
                return;
            }
            catch (Exception exception) {
                if (this.continueOnWriteError()) {
                    channelOutboundBuffer.remove(exception);
                    continue;
                }
                throw exception;
            }
            break;
        }
    }

    protected boolean continueOnWriteError() {
        return false;
    }

    protected boolean closeOnReadError(Throwable throwable) {
        if (!this.isActive()) {
            return true;
        }
        if (throwable instanceof PortUnreachableException) {
            return false;
        }
        if (throwable instanceof IOException) {
            return !(this instanceof ServerChannel);
        }
        return true;
    }

    protected abstract int doReadMessages(List<Object> var1) throws Exception;

    protected abstract boolean doWriteMessage(Object var1, ChannelOutboundBuffer var2) throws Exception;

    private final class NioMessageUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        private final List<Object> readBuf = new ArrayList<Object>();

        private NioMessageUnsafe() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void read() {
            assert (AbstractNioMessageChannel.this.eventLoop().inEventLoop());
            ChannelConfig channelConfig = AbstractNioMessageChannel.this.config();
            ChannelPipeline channelPipeline = AbstractNioMessageChannel.this.pipeline();
            RecvByteBufAllocator.Handle handle = AbstractNioMessageChannel.this.unsafe().recvBufAllocHandle();
            handle.reset(channelConfig);
            boolean bl = false;
            Throwable throwable = null;
            try {
                int n2;
                try {
                    while ((n2 = AbstractNioMessageChannel.this.doReadMessages(this.readBuf)) != 0) {
                        if (n2 < 0) {
                            bl = true;
                        } else {
                            handle.incMessagesRead(n2);
                            if (handle.continueReading()) continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                }
                n2 = this.readBuf.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    AbstractNioMessageChannel.this.readPending = false;
                    channelPipeline.fireChannelRead(this.readBuf.get(i2));
                }
                this.readBuf.clear();
                handle.readComplete();
                channelPipeline.fireChannelReadComplete();
                if (throwable != null) {
                    bl = AbstractNioMessageChannel.this.closeOnReadError(throwable);
                    channelPipeline.fireExceptionCaught(throwable);
                }
                if (bl) {
                    AbstractNioMessageChannel.this.inputShutdown = true;
                    if (AbstractNioMessageChannel.this.isOpen()) {
                        NioMessageUnsafe nioMessageUnsafe = this;
                        nioMessageUnsafe.close(nioMessageUnsafe.voidPromise());
                    }
                }
                if (AbstractNioMessageChannel.this.readPending || channelConfig.isAutoRead()) return;
            }
            catch (Throwable throwable4) {
                if (AbstractNioMessageChannel.this.readPending || channelConfig.isAutoRead()) throw throwable4;
                this.removeReadOp();
                throw throwable4;
            }
            this.removeReadOp();
        }
    }
}

