/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel;

import com.appoptics.ext.io.netty.buffer.ByteBufUtil;
import com.appoptics.ext.io.netty.channel.ChannelId;
import com.appoptics.ext.io.netty.util.internal.EmptyArrays;
import com.appoptics.ext.io.netty.util.internal.MacAddressUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public final class DefaultChannelId
implements ChannelId {
    private static final long serialVersionUID = 3884076183504074063L;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelId.class);
    private static final byte[] MACHINE_ID;
    private static final int PROCESS_ID;
    private static final AtomicInteger nextSequence;
    private final byte[] data = new byte[MACHINE_ID.length + 4 + 4 + 8 + 4];
    private final int hashCode;
    private transient String shortValue;
    private transient String longValue;

    public static DefaultChannelId newInstance() {
        return new DefaultChannelId();
    }

    private static int defaultProcessId() {
        int n2;
        Object object;
        Class<?> clazz;
        ClassLoader classLoader = null;
        try {
            classLoader = PlatformDependent.getClassLoader(DefaultChannelId.class);
            GenericDeclaration genericDeclaration = Class.forName("java.lang.management.ManagementFactory", true, classLoader);
            clazz = Class.forName("java.lang.management.RuntimeMXBean", true, classLoader);
            object = genericDeclaration.getMethod("getRuntimeMXBean", EmptyArrays.EMPTY_CLASSES);
            object = ((Method)object).invoke(null, EmptyArrays.EMPTY_OBJECTS);
            genericDeclaration = clazz.getMethod("getName", EmptyArrays.EMPTY_CLASSES);
            object = (String)((Method)genericDeclaration).invoke(object, EmptyArrays.EMPTY_OBJECTS);
        }
        catch (Throwable throwable) {
            logger.debug("Could not invoke ManagementFactory.getRuntimeMXBean().getName(); Android?", throwable);
            try {
                clazz = Class.forName("android.os.Process", true, classLoader);
                object = clazz.getMethod("myPid", EmptyArrays.EMPTY_CLASSES);
                object = ((Method)object).invoke(null, EmptyArrays.EMPTY_OBJECTS).toString();
            }
            catch (Throwable throwable2) {
                logger.debug("Could not invoke Process.myPid(); not Android?", throwable2);
                object = "";
            }
        }
        int n3 = ((String)object).indexOf(64);
        if (n3 >= 0) {
            object = ((String)object).substring(0, n3);
        }
        try {
            n2 = Integer.parseInt((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        if (n2 < 0) {
            n2 = PlatformDependent.threadLocalRandom().nextInt();
            logger.warn("Failed to find the current process ID from '{}'; using a random value: {}", object, (Object)n2);
        }
        return n2;
    }

    private DefaultChannelId() {
        System.arraycopy(MACHINE_ID, 0, this.data, 0, MACHINE_ID.length);
        int n2 = 0 + MACHINE_ID.length;
        n2 = this.writeInt(n2, PROCESS_ID);
        n2 = this.writeInt(n2, nextSequence.getAndIncrement());
        n2 = this.writeLong(n2, Long.reverse(System.nanoTime()) ^ System.currentTimeMillis());
        int n3 = PlatformDependent.threadLocalRandom().nextInt();
        n2 = this.writeInt(n2, n3);
        assert (n2 == this.data.length);
        this.hashCode = Arrays.hashCode(this.data);
    }

    private int writeInt(int n2, int n3) {
        this.data[n2++] = (byte)(n3 >>> 24);
        this.data[n2++] = (byte)(n3 >>> 16);
        this.data[n2++] = (byte)(n3 >>> 8);
        this.data[n2++] = (byte)n3;
        return n2;
    }

    private int writeLong(int n2, long l2) {
        this.data[n2++] = (byte)(l2 >>> 56);
        this.data[n2++] = (byte)(l2 >>> 48);
        this.data[n2++] = (byte)(l2 >>> 40);
        this.data[n2++] = (byte)(l2 >>> 32);
        this.data[n2++] = (byte)(l2 >>> 24);
        this.data[n2++] = (byte)(l2 >>> 16);
        this.data[n2++] = (byte)(l2 >>> 8);
        this.data[n2++] = (byte)l2;
        return n2;
    }

    public final String asShortText() {
        String string = this.shortValue;
        if (string == null) {
            this.shortValue = string = ByteBufUtil.hexDump(this.data, this.data.length - 4, 4);
        }
        return string;
    }

    public final String asLongText() {
        String string = this.longValue;
        if (string == null) {
            this.longValue = string = this.newLongValue();
        }
        return string;
    }

    private String newLongValue() {
        StringBuilder stringBuilder = new StringBuilder(2 * this.data.length + 5);
        int n2 = this.appendHexDumpField(stringBuilder, 0, MACHINE_ID.length);
        n2 = this.appendHexDumpField(stringBuilder, n2, 4);
        n2 = this.appendHexDumpField(stringBuilder, n2, 4);
        n2 = this.appendHexDumpField(stringBuilder, n2, 8);
        n2 = this.appendHexDumpField(stringBuilder, n2, 4);
        assert (n2 == this.data.length);
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private int appendHexDumpField(StringBuilder stringBuilder, int n2, int n3) {
        stringBuilder.append(ByteBufUtil.hexDump(this.data, n2, n3));
        stringBuilder.append('-');
        return n2 += n3;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final int compareTo(ChannelId object) {
        if (this == object) {
            return 0;
        }
        if (object instanceof DefaultChannelId) {
            object = ((DefaultChannelId)object).data;
            int n2 = this.data.length;
            int n3 = ((Object)object).length;
            int n4 = Math.min(n2, n3);
            for (int i2 = 0; i2 < n4; ++i2) {
                byte by = this.data[i2];
                Object object2 = object[i2];
                if (by == object2) continue;
                return (by & 0xFF) - (object2 & 0xFF);
            }
            return n2 - n3;
        }
        return this.asLongText().compareTo(object.asLongText());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultChannelId)) {
            return false;
        }
        object = (DefaultChannelId)object;
        return this.hashCode == ((DefaultChannelId)object).hashCode && Arrays.equals(this.data, ((DefaultChannelId)object).data);
    }

    public final String toString() {
        return this.asShortText();
    }

    static {
        nextSequence = new AtomicInteger();
        int n2 = -1;
        String string = SystemPropertyUtil.get("com.appoptics.ext.io.netty.processId");
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
            if (n2 < 0) {
                n2 = -1;
                logger.warn("-Dio.netty.processId: {} (malformed)", (Object)string);
            } else if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.processId: {} (user-set)", (Object)n2);
            }
        }
        if (n2 < 0) {
            n2 = DefaultChannelId.defaultProcessId();
            if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.processId: {} (auto-detected)", (Object)n2);
            }
        }
        PROCESS_ID = n2;
        byte[] byArray = null;
        string = SystemPropertyUtil.get("com.appoptics.ext.io.netty.machineId");
        if (string != null) {
            try {
                byArray = MacAddressUtil.parseMAC(string);
            }
            catch (Exception exception) {
                logger.warn("-Dio.netty.machineId: {} (malformed)", (Object)string, (Object)exception);
            }
            if (byArray != null) {
                logger.debug("-Dio.netty.machineId: {} (user-set)", (Object)string);
            }
        }
        if (byArray == null) {
            byArray = MacAddressUtil.defaultMachineId();
            if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.machineId: {} (auto-detected)", (Object)MacAddressUtil.formatAddress(byArray));
            }
        }
        MACHINE_ID = byArray;
    }
}

