/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel;

import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.channel.AdaptiveRecvByteBufAllocator;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelConfig;
import com.appoptics.ext.io.netty.channel.ChannelMetadata;
import com.appoptics.ext.io.netty.channel.ChannelOption;
import com.appoptics.ext.io.netty.channel.DefaultMessageSizeEstimator;
import com.appoptics.ext.io.netty.channel.MaxMessagesRecvByteBufAllocator;
import com.appoptics.ext.io.netty.channel.MessageSizeEstimator;
import com.appoptics.ext.io.netty.channel.RecvByteBufAllocator;
import com.appoptics.ext.io.netty.channel.WriteBufferWaterMark;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultChannelConfig
implements ChannelConfig {
    private static final MessageSizeEstimator DEFAULT_MSG_SIZE_ESTIMATOR = DefaultMessageSizeEstimator.DEFAULT;
    private static final AtomicIntegerFieldUpdater<DefaultChannelConfig> AUTOREAD_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DefaultChannelConfig.class, "autoRead");
    private static final AtomicReferenceFieldUpdater<DefaultChannelConfig, WriteBufferWaterMark> WATERMARK_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultChannelConfig.class, WriteBufferWaterMark.class, "writeBufferWaterMark");
    protected final Channel channel;
    private volatile ByteBufAllocator allocator = ByteBufAllocator.DEFAULT;
    private volatile RecvByteBufAllocator rcvBufAllocator;
    private volatile MessageSizeEstimator msgSizeEstimator = DEFAULT_MSG_SIZE_ESTIMATOR;
    private volatile int connectTimeoutMillis = 30000;
    private volatile int writeSpinCount = 16;
    private volatile int autoRead = 1;
    private volatile boolean autoClose = true;
    private volatile WriteBufferWaterMark writeBufferWaterMark = WriteBufferWaterMark.DEFAULT;
    private volatile boolean pinEventExecutor = true;

    public DefaultChannelConfig(Channel channel) {
        this(channel, new AdaptiveRecvByteBufAllocator());
    }

    protected DefaultChannelConfig(Channel channel, RecvByteBufAllocator recvByteBufAllocator) {
        this.setRecvByteBufAllocator(recvByteBufAllocator, channel.metadata());
        this.channel = channel;
    }

    @Override
    public <T> T getOption(ChannelOption<T> channelOption) {
        ObjectUtil.checkNotNull(channelOption, "option");
        if (channelOption == ChannelOption.CONNECT_TIMEOUT_MILLIS) {
            return (T)Integer.valueOf(this.getConnectTimeoutMillis());
        }
        if (channelOption == ChannelOption.MAX_MESSAGES_PER_READ) {
            return (T)Integer.valueOf(this.getMaxMessagesPerRead());
        }
        if (channelOption == ChannelOption.WRITE_SPIN_COUNT) {
            return (T)Integer.valueOf(this.getWriteSpinCount());
        }
        if (channelOption == ChannelOption.ALLOCATOR) {
            return (T)this.getAllocator();
        }
        if (channelOption == ChannelOption.RCVBUF_ALLOCATOR) {
            return this.getRecvByteBufAllocator();
        }
        if (channelOption == ChannelOption.AUTO_READ) {
            return (T)Boolean.valueOf(this.isAutoRead());
        }
        if (channelOption == ChannelOption.AUTO_CLOSE) {
            return (T)Boolean.valueOf(this.isAutoClose());
        }
        if (channelOption == ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK) {
            return (T)Integer.valueOf(this.getWriteBufferHighWaterMark());
        }
        if (channelOption == ChannelOption.WRITE_BUFFER_LOW_WATER_MARK) {
            return (T)Integer.valueOf(this.getWriteBufferLowWaterMark());
        }
        if (channelOption == ChannelOption.WRITE_BUFFER_WATER_MARK) {
            return (T)this.getWriteBufferWaterMark();
        }
        if (channelOption == ChannelOption.MESSAGE_SIZE_ESTIMATOR) {
            return (T)this.getMessageSizeEstimator();
        }
        if (channelOption == ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP) {
            return (T)Boolean.valueOf(this.getPinEventExecutorPerGroup());
        }
        return null;
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> channelOption, T t2) {
        this.validate(channelOption, t2);
        if (channelOption == ChannelOption.CONNECT_TIMEOUT_MILLIS) {
            this.setConnectTimeoutMillis((Integer)t2);
        } else if (channelOption == ChannelOption.MAX_MESSAGES_PER_READ) {
            this.setMaxMessagesPerRead((Integer)t2);
        } else if (channelOption == ChannelOption.WRITE_SPIN_COUNT) {
            this.setWriteSpinCount((Integer)t2);
        } else if (channelOption == ChannelOption.ALLOCATOR) {
            this.setAllocator((ByteBufAllocator)t2);
        } else if (channelOption == ChannelOption.RCVBUF_ALLOCATOR) {
            this.setRecvByteBufAllocator((RecvByteBufAllocator)t2);
        } else if (channelOption == ChannelOption.AUTO_READ) {
            this.setAutoRead((Boolean)t2);
        } else if (channelOption == ChannelOption.AUTO_CLOSE) {
            this.setAutoClose((Boolean)t2);
        } else if (channelOption == ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK) {
            this.setWriteBufferHighWaterMark((Integer)t2);
        } else if (channelOption == ChannelOption.WRITE_BUFFER_LOW_WATER_MARK) {
            this.setWriteBufferLowWaterMark((Integer)t2);
        } else if (channelOption == ChannelOption.WRITE_BUFFER_WATER_MARK) {
            this.setWriteBufferWaterMark((WriteBufferWaterMark)t2);
        } else if (channelOption == ChannelOption.MESSAGE_SIZE_ESTIMATOR) {
            this.setMessageSizeEstimator((MessageSizeEstimator)t2);
        } else if (channelOption == ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP) {
            this.setPinEventExecutorPerGroup((Boolean)t2);
        } else {
            return false;
        }
        return true;
    }

    protected <T> void validate(ChannelOption<T> channelOption, T t2) {
        ObjectUtil.checkNotNull(channelOption, "option").validate(t2);
    }

    @Override
    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public ChannelConfig setConnectTimeoutMillis(int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "connectTimeoutMillis");
        this.connectTimeoutMillis = n2;
        return this;
    }

    @Deprecated
    public int getMaxMessagesPerRead() {
        try {
            MaxMessagesRecvByteBufAllocator maxMessagesRecvByteBufAllocator = (MaxMessagesRecvByteBufAllocator)this.getRecvByteBufAllocator();
            return maxMessagesRecvByteBufAllocator.maxMessagesPerRead();
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("getRecvByteBufAllocator() must return an object of type MaxMessagesRecvByteBufAllocator", classCastException);
        }
    }

    @Deprecated
    public ChannelConfig setMaxMessagesPerRead(int n2) {
        try {
            MaxMessagesRecvByteBufAllocator maxMessagesRecvByteBufAllocator = (MaxMessagesRecvByteBufAllocator)this.getRecvByteBufAllocator();
            maxMessagesRecvByteBufAllocator.maxMessagesPerRead(n2);
            return this;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("getRecvByteBufAllocator() must return an object of type MaxMessagesRecvByteBufAllocator", classCastException);
        }
    }

    @Override
    public int getWriteSpinCount() {
        return this.writeSpinCount;
    }

    public ChannelConfig setWriteSpinCount(int n2) {
        ObjectUtil.checkPositive(n2, "writeSpinCount");
        if (n2 == Integer.MAX_VALUE) {
            --n2;
        }
        this.writeSpinCount = n2;
        return this;
    }

    @Override
    public ByteBufAllocator getAllocator() {
        return this.allocator;
    }

    public ChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
        this.allocator = ObjectUtil.checkNotNull(byteBufAllocator, "allocator");
        return this;
    }

    @Override
    public <T extends RecvByteBufAllocator> T getRecvByteBufAllocator() {
        return (T)this.rcvBufAllocator;
    }

    public ChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
        this.rcvBufAllocator = ObjectUtil.checkNotNull(recvByteBufAllocator, "allocator");
        return this;
    }

    private void setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator, ChannelMetadata channelMetadata) {
        if (recvByteBufAllocator instanceof MaxMessagesRecvByteBufAllocator) {
            ((MaxMessagesRecvByteBufAllocator)recvByteBufAllocator).maxMessagesPerRead(channelMetadata.defaultMaxMessagesPerRead());
        } else if (recvByteBufAllocator == null) {
            throw new NullPointerException("allocator");
        }
        this.setRecvByteBufAllocator(recvByteBufAllocator);
    }

    @Override
    public boolean isAutoRead() {
        return this.autoRead == 1;
    }

    public ChannelConfig setAutoRead(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = AUTOREAD_UPDATER.getAndSet(this, bl ? 1 : 0) == 1;
        if (bl && !bl2) {
            this.channel.read();
        } else if (!bl && bl2) {
            this.autoReadCleared();
        }
        return this;
    }

    protected void autoReadCleared() {
    }

    @Override
    public boolean isAutoClose() {
        return this.autoClose;
    }

    public ChannelConfig setAutoClose(boolean bl) {
        this.autoClose = bl;
        return this;
    }

    @Override
    public int getWriteBufferHighWaterMark() {
        return this.writeBufferWaterMark.high();
    }

    public ChannelConfig setWriteBufferHighWaterMark(int n2) {
        WriteBufferWaterMark writeBufferWaterMark;
        ObjectUtil.checkPositiveOrZero(n2, "writeBufferHighWaterMark");
        do {
            if (n2 >= (writeBufferWaterMark = this.writeBufferWaterMark).low()) continue;
            throw new IllegalArgumentException("writeBufferHighWaterMark cannot be less than writeBufferLowWaterMark (" + writeBufferWaterMark.low() + "): " + n2);
        } while (!WATERMARK_UPDATER.compareAndSet(this, writeBufferWaterMark, new WriteBufferWaterMark(writeBufferWaterMark.low(), n2, false)));
        return this;
    }

    @Override
    public int getWriteBufferLowWaterMark() {
        return this.writeBufferWaterMark.low();
    }

    public ChannelConfig setWriteBufferLowWaterMark(int n2) {
        WriteBufferWaterMark writeBufferWaterMark;
        ObjectUtil.checkPositiveOrZero(n2, "writeBufferLowWaterMark");
        do {
            if (n2 <= (writeBufferWaterMark = this.writeBufferWaterMark).high()) continue;
            throw new IllegalArgumentException("writeBufferLowWaterMark cannot be greater than writeBufferHighWaterMark (" + writeBufferWaterMark.high() + "): " + n2);
        } while (!WATERMARK_UPDATER.compareAndSet(this, writeBufferWaterMark, new WriteBufferWaterMark(n2, writeBufferWaterMark.high(), false)));
        return this;
    }

    public ChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        this.writeBufferWaterMark = ObjectUtil.checkNotNull(writeBufferWaterMark, "writeBufferWaterMark");
        return this;
    }

    public WriteBufferWaterMark getWriteBufferWaterMark() {
        return this.writeBufferWaterMark;
    }

    @Override
    public MessageSizeEstimator getMessageSizeEstimator() {
        return this.msgSizeEstimator;
    }

    public ChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
        this.msgSizeEstimator = ObjectUtil.checkNotNull(messageSizeEstimator, "estimator");
        return this;
    }

    private ChannelConfig setPinEventExecutorPerGroup(boolean bl) {
        this.pinEventExecutor = bl;
        return this;
    }

    private boolean getPinEventExecutorPerGroup() {
        return this.pinEventExecutor;
    }
}

