/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.CompositeByteBuf;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.channel.AbstractCoalescingBufferQueue;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;

public final class CoalescingBufferQueue
extends AbstractCoalescingBufferQueue {
    private final Channel channel;

    public CoalescingBufferQueue(Channel channel) {
        this(channel, 4);
    }

    public CoalescingBufferQueue(Channel channel, int n2) {
        this(channel, n2, false);
    }

    public CoalescingBufferQueue(Channel channel, int n2, boolean bl) {
        super(bl ? channel : null, n2);
        this.channel = ObjectUtil.checkNotNull(channel, "channel");
    }

    public final ByteBuf remove(int n2, ChannelPromise channelPromise) {
        CoalescingBufferQueue coalescingBufferQueue = this;
        return coalescingBufferQueue.remove(coalescingBufferQueue.channel.alloc(), n2, channelPromise);
    }

    public final void releaseAndFailAll(Throwable throwable) {
        CoalescingBufferQueue coalescingBufferQueue = this;
        coalescingBufferQueue.releaseAndFailAll(coalescingBufferQueue.channel, throwable);
    }

    protected final ByteBuf compose(ByteBufAllocator object, ByteBuf byteBuf, ByteBuf byteBuf2) {
        if (byteBuf instanceof CompositeByteBuf) {
            object = (CompositeByteBuf)byteBuf;
            ((CompositeByteBuf)object).addComponent(true, byteBuf2);
            return object;
        }
        return this.composeIntoComposite((ByteBufAllocator)object, byteBuf, byteBuf2);
    }

    protected final ByteBuf removeEmptyValue() {
        return Unpooled.EMPTY_BUFFER;
    }
}

