/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel;

import com.appoptics.ext.io.netty.channel.DefaultMaxMessagesRecvByteBufAllocator;
import com.appoptics.ext.io.netty.channel.RecvByteBufAllocator;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;

public class AdaptiveRecvByteBufAllocator
extends DefaultMaxMessagesRecvByteBufAllocator {
    private static final int[] SIZE_TABLE;
    @Deprecated
    public static final AdaptiveRecvByteBufAllocator DEFAULT;
    private final int minIndex;
    private final int maxIndex;
    private final int initial;

    private static int getSizeTableIndex(int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = SIZE_TABLE.length - 1;
        while (true) {
            if (n6 < n5) {
                return n5;
            }
            if (n6 == n5) {
                return n6;
            }
            n4 = n5 + n6 >>> 1;
            n3 = SIZE_TABLE[n4];
            int n7 = SIZE_TABLE[n4 + 1];
            if (n2 > n7) {
                n5 = n4 + 1;
                continue;
            }
            if (n2 >= n3) break;
            n6 = n4 - 1;
        }
        if (n2 == n3) {
            return n4;
        }
        return n4 + 1;
    }

    public AdaptiveRecvByteBufAllocator() {
        this(64, 1024, 65536);
    }

    public AdaptiveRecvByteBufAllocator(int n2, int n3, int n4) {
        ObjectUtil.checkPositive(n2, "minimum");
        if (n3 < n2) {
            throw new IllegalArgumentException("initial: " + n3);
        }
        if (n4 < n3) {
            throw new IllegalArgumentException("maximum: " + n4);
        }
        int n5 = AdaptiveRecvByteBufAllocator.getSizeTableIndex(n2);
        this.minIndex = SIZE_TABLE[n5] < n2 ? n5 + 1 : n5;
        n2 = AdaptiveRecvByteBufAllocator.getSizeTableIndex(n4);
        this.maxIndex = SIZE_TABLE[n2] > n4 ? n2 - 1 : n2;
        this.initial = n3;
    }

    public RecvByteBufAllocator.Handle newHandle() {
        AdaptiveRecvByteBufAllocator adaptiveRecvByteBufAllocator = this;
        return adaptiveRecvByteBufAllocator.new HandleImpl(adaptiveRecvByteBufAllocator.minIndex, this.maxIndex, this.initial);
    }

    static {
        int n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n2 = 16; n2 < 512; n2 += 16) {
            arrayList.add(n2);
        }
        for (n2 = 512; n2 > 0; n2 <<= 1) {
            arrayList.add(n2);
        }
        SIZE_TABLE = new int[arrayList.size()];
        for (n2 = 0; n2 < SIZE_TABLE.length; ++n2) {
            AdaptiveRecvByteBufAllocator.SIZE_TABLE[n2] = (Integer)arrayList.get(n2);
        }
        DEFAULT = new AdaptiveRecvByteBufAllocator();
    }

    private final class HandleImpl
    extends DefaultMaxMessagesRecvByteBufAllocator.MaxMessageHandle {
        private final int minIndex;
        private final int maxIndex;
        private int index;
        private int nextReceiveBufferSize;
        private boolean decreaseNow;

        HandleImpl(int n2, int n3, int n4) {
            super(AdaptiveRecvByteBufAllocator.this);
            this.minIndex = n2;
            this.maxIndex = n3;
            this.index = AdaptiveRecvByteBufAllocator.getSizeTableIndex(n4);
            this.nextReceiveBufferSize = SIZE_TABLE[this.index];
        }

        public final void lastBytesRead(int n2) {
            if (n2 == this.attemptedBytesRead()) {
                this.record(n2);
            }
            super.lastBytesRead(n2);
        }

        public final int guess() {
            return this.nextReceiveBufferSize;
        }

        private void record(int n2) {
            if (n2 <= SIZE_TABLE[Math.max(0, this.index - 1)]) {
                if (this.decreaseNow) {
                    this.index = Math.max(this.index - 1, this.minIndex);
                    this.nextReceiveBufferSize = SIZE_TABLE[this.index];
                    this.decreaseNow = false;
                    return;
                }
                this.decreaseNow = true;
                return;
            }
            if (n2 >= this.nextReceiveBufferSize) {
                this.index = Math.min(this.index + 4, this.maxIndex);
                this.nextReceiveBufferSize = SIZE_TABLE[this.index];
                this.decreaseNow = false;
            }
        }

        public final void readComplete() {
            HandleImpl handleImpl = this;
            handleImpl.record(handleImpl.totalBytesRead());
        }
    }
}

