/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.SwappedByteBuf;
import com.appoptics.ext.io.netty.buffer.WrappedByteBuf;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;

final class UnreleasableByteBuf
extends WrappedByteBuf {
    private SwappedByteBuf swappedBuf;

    UnreleasableByteBuf(ByteBuf byteBuf) {
        super(byteBuf instanceof UnreleasableByteBuf ? byteBuf.unwrap() : byteBuf);
    }

    public final ByteBuf order(ByteOrder object) {
        if (ObjectUtil.checkNotNull(object, "endianness") == this.order()) {
            return this;
        }
        object = this.swappedBuf;
        if (object == null) {
            object = new SwappedByteBuf(this);
            this.swappedBuf = object;
        }
        return object;
    }

    public final ByteBuf asReadOnly() {
        if (this.buf.isReadOnly()) {
            return this;
        }
        return new UnreleasableByteBuf(this.buf.asReadOnly());
    }

    public final ByteBuf readSlice(int n2) {
        return new UnreleasableByteBuf(this.buf.readSlice(n2));
    }

    public final ByteBuf readRetainedSlice(int n2) {
        return this.readSlice(n2);
    }

    public final ByteBuf slice() {
        return new UnreleasableByteBuf(this.buf.slice());
    }

    public final ByteBuf retainedSlice() {
        return this.slice();
    }

    public final ByteBuf slice(int n2, int n3) {
        return new UnreleasableByteBuf(this.buf.slice(n2, n3));
    }

    public final ByteBuf duplicate() {
        return new UnreleasableByteBuf(this.buf.duplicate());
    }

    public final ByteBuf retainedDuplicate() {
        return this.duplicate();
    }

    public final ByteBuf retain() {
        return this;
    }

    public final ByteBuf touch() {
        return this;
    }

    public final ByteBuf touch(Object object) {
        return this;
    }

    public final boolean release() {
        return false;
    }
}

