/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.HeapByteBufUtil;
import com.appoptics.ext.io.netty.util.internal.EmptyArrays;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class UnpooledHeapByteBuf
extends AbstractReferenceCountedByteBuf {
    private final ByteBufAllocator alloc;
    byte[] array;
    private ByteBuffer tmpNioBuf;

    public UnpooledHeapByteBuf(ByteBufAllocator byteBufAllocator, int n2, int n3) {
        super(n3);
        if (n2 > n3) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", n2, n3));
        }
        this.alloc = ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        UnpooledHeapByteBuf unpooledHeapByteBuf = this;
        unpooledHeapByteBuf.setArray(unpooledHeapByteBuf.allocateArray(n2));
        this.setIndex(0, 0);
    }

    protected UnpooledHeapByteBuf(ByteBufAllocator byteBufAllocator, byte[] byArray, int n2) {
        super(n2);
        ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        ObjectUtil.checkNotNull(byArray, "initialArray");
        if (byArray.length > n2) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", byArray.length, n2));
        }
        this.alloc = byteBufAllocator;
        this.setArray(byArray);
        this.setIndex(0, byArray.length);
    }

    protected byte[] allocateArray(int n2) {
        return new byte[n2];
    }

    protected void freeArray(byte[] byArray) {
    }

    private void setArray(byte[] byArray) {
        this.array = byArray;
        this.tmpNioBuf = null;
    }

    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public boolean isDirect() {
        return false;
    }

    public int capacity() {
        return this.array.length;
    }

    public ByteBuf capacity(int n2) {
        this.checkNewCapacity(n2);
        byte[] byArray = this.array;
        int n3 = this.array.length;
        if (n2 == n3) {
            return this;
        }
        if (n2 <= n3) {
            this.trimIndicesToCapacity(n2);
            n3 = n2;
        }
        byte[] byArray2 = this.allocateArray(n2);
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        this.setArray(byArray2);
        this.freeArray(byArray);
        return this;
    }

    public boolean hasArray() {
        return true;
    }

    public byte[] array() {
        this.ensureAccessible();
        return this.array;
    }

    public int arrayOffset() {
        return 0;
    }

    public boolean hasMemoryAddress() {
        return false;
    }

    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byteBuf.capacity());
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory(this.array, n2, byteBuf.memoryAddress() + (long)n3, (long)n4);
        } else if (byteBuf.hasArray()) {
            this.getBytes(n2, byteBuf.array(), byteBuf.arrayOffset() + n3, n4);
        } else {
            byteBuf.setBytes(n3, this.array, n2, n4);
        }
        return this;
    }

    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byArray.length);
        System.arraycopy(this.array, n2, byArray, n3, n4);
        return this;
    }

    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        this.ensureAccessible();
        byteBuffer.put(this.array, n2, byteBuffer.remaining());
        return this;
    }

    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) throws IOException {
        this.ensureAccessible();
        return this.getBytes(n2, gatheringByteChannel, n3, false);
    }

    private int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3, boolean bl) throws IOException {
        this.ensureAccessible();
        ByteBuffer byteBuffer = bl ? this.internalNioBuffer() : ByteBuffer.wrap(this.array);
        return gatheringByteChannel.write((ByteBuffer)byteBuffer.clear().position(n2).limit(n2 + n3));
    }

    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) throws IOException {
        this.checkReadableBytes(n2);
        UnpooledHeapByteBuf unpooledHeapByteBuf = this;
        int n3 = unpooledHeapByteBuf.getBytes(unpooledHeapByteBuf.readerIndex, gatheringByteChannel, n2, true);
        this.readerIndex += n3;
        return n3;
    }

    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byteBuf.capacity());
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory(byteBuf.memoryAddress() + (long)n3, this.array, n2, (long)n4);
        } else if (byteBuf.hasArray()) {
            this.setBytes(n2, byteBuf.array(), byteBuf.arrayOffset() + n3, n4);
        } else {
            byteBuf.getBytes(n3, this.array, n2, n4);
        }
        return this;
    }

    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byArray.length);
        System.arraycopy(byArray, n3, this.array, n2, n4);
        return this;
    }

    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        this.ensureAccessible();
        byteBuffer.get(this.array, n2, byteBuffer.remaining());
        return this;
    }

    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) throws IOException {
        this.ensureAccessible();
        try {
            return scatteringByteChannel.read((ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3));
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    public int nioBufferCount() {
        return 1;
    }

    public ByteBuffer nioBuffer(int n2, int n3) {
        this.ensureAccessible();
        return ByteBuffer.wrap(this.array, n2, n3).slice();
    }

    public ByteBuffer[] nioBuffers(int n2, int n3) {
        return new ByteBuffer[]{this.nioBuffer(n2, n3)};
    }

    public ByteBuffer internalNioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return (ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3);
    }

    public final boolean isContiguous() {
        return true;
    }

    public byte getByte(int n2) {
        this.ensureAccessible();
        return this._getByte(n2);
    }

    protected byte _getByte(int n2) {
        return HeapByteBufUtil.getByte(this.array, n2);
    }

    public short getShort(int n2) {
        this.ensureAccessible();
        return this._getShort(n2);
    }

    protected short _getShort(int n2) {
        return HeapByteBufUtil.getShort(this.array, n2);
    }

    public short getShortLE(int n2) {
        this.ensureAccessible();
        return this._getShortLE(n2);
    }

    protected short _getShortLE(int n2) {
        return HeapByteBufUtil.getShortLE(this.array, n2);
    }

    public int getUnsignedMedium(int n2) {
        this.ensureAccessible();
        return this._getUnsignedMedium(n2);
    }

    protected int _getUnsignedMedium(int n2) {
        return HeapByteBufUtil.getUnsignedMedium(this.array, n2);
    }

    public int getInt(int n2) {
        this.ensureAccessible();
        return this._getInt(n2);
    }

    protected int _getInt(int n2) {
        return HeapByteBufUtil.getInt(this.array, n2);
    }

    public int getIntLE(int n2) {
        this.ensureAccessible();
        return this._getIntLE(n2);
    }

    protected int _getIntLE(int n2) {
        return HeapByteBufUtil.getIntLE(this.array, n2);
    }

    public long getLong(int n2) {
        this.ensureAccessible();
        return this._getLong(n2);
    }

    protected long _getLong(int n2) {
        return HeapByteBufUtil.getLong(this.array, n2);
    }

    public ByteBuf setByte(int n2, int n3) {
        this.ensureAccessible();
        this._setByte(n2, n3);
        return this;
    }

    protected void _setByte(int n2, int n3) {
        HeapByteBufUtil.setByte(this.array, n2, n3);
    }

    public ByteBuf setShort(int n2, int n3) {
        this.ensureAccessible();
        this._setShort(n2, n3);
        return this;
    }

    protected void _setShort(int n2, int n3) {
        HeapByteBufUtil.setShort(this.array, n2, n3);
    }

    public ByteBuf setShortLE(int n2, int n3) {
        this.ensureAccessible();
        this._setShortLE(n2, n3);
        return this;
    }

    protected void _setShortLE(int n2, int n3) {
        HeapByteBufUtil.setShortLE(this.array, n2, n3);
    }

    public ByteBuf setMedium(int n2, int n3) {
        this.ensureAccessible();
        this._setMedium(n2, n3);
        return this;
    }

    protected void _setMedium(int n2, int n3) {
        HeapByteBufUtil.setMedium(this.array, n2, n3);
    }

    public ByteBuf setMediumLE(int n2, int n3) {
        this.ensureAccessible();
        this._setMediumLE(n2, n3);
        return this;
    }

    protected void _setMediumLE(int n2, int n3) {
        HeapByteBufUtil.setMediumLE(this.array, n2, n3);
    }

    public ByteBuf setInt(int n2, int n3) {
        this.ensureAccessible();
        this._setInt(n2, n3);
        return this;
    }

    protected void _setInt(int n2, int n3) {
        HeapByteBufUtil.setInt(this.array, n2, n3);
    }

    public ByteBuf setLong(int n2, long l2) {
        this.ensureAccessible();
        this._setLong(n2, l2);
        return this;
    }

    protected void _setLong(int n2, long l2) {
        HeapByteBufUtil.setLong(this.array, n2, l2);
    }

    private ByteBuffer internalNioBuffer() {
        ByteBuffer byteBuffer = this.tmpNioBuf;
        if (byteBuffer == null) {
            this.tmpNioBuf = byteBuffer = ByteBuffer.wrap(this.array);
        }
        return byteBuffer;
    }

    protected void deallocate() {
        UnpooledHeapByteBuf unpooledHeapByteBuf = this;
        unpooledHeapByteBuf.freeArray(unpooledHeapByteBuf.array);
        this.array = EmptyArrays.EMPTY_BYTES;
    }

    public ByteBuf unwrap() {
        return null;
    }
}

