/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.AbstractByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.PoolChunk;
import com.appoptics.ext.io.netty.buffer.PoolThreadCache;
import com.appoptics.ext.io.netty.buffer.PooledByteBuf;
import com.appoptics.ext.io.netty.buffer.SwappedByteBuf;
import com.appoptics.ext.io.netty.buffer.UnsafeByteBufUtil;
import com.appoptics.ext.io.netty.buffer.UnsafeDirectSwappedByteBuf;
import com.appoptics.ext.io.netty.util.internal.ObjectPool;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PooledUnsafeDirectByteBuf
extends PooledByteBuf<ByteBuffer> {
    private static final ObjectPool<PooledUnsafeDirectByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<PooledUnsafeDirectByteBuf>(){

        @Override
        public final PooledUnsafeDirectByteBuf newObject(ObjectPool.Handle<PooledUnsafeDirectByteBuf> handle) {
            return new PooledUnsafeDirectByteBuf(handle, 0);
        }
    });
    private long memoryAddress;

    static PooledUnsafeDirectByteBuf newInstance(int n2) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = RECYCLER.get();
        pooledUnsafeDirectByteBuf.reuse(n2);
        return pooledUnsafeDirectByteBuf;
    }

    private PooledUnsafeDirectByteBuf(ObjectPool.Handle<PooledUnsafeDirectByteBuf> handle, int n2) {
        super(handle, n2);
    }

    @Override
    final void init(PoolChunk<ByteBuffer> poolChunk, ByteBuffer byteBuffer, long l2, int n2, int n3, int n4, PoolThreadCache poolThreadCache) {
        super.init(poolChunk, byteBuffer, l2, n2, n3, n4, poolThreadCache);
        this.initMemoryAddress();
    }

    @Override
    final void initUnpooled(PoolChunk<ByteBuffer> poolChunk, int n2) {
        super.initUnpooled(poolChunk, n2);
        this.initMemoryAddress();
    }

    private void initMemoryAddress() {
        this.memoryAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.memory) + (long)this.offset;
    }

    @Override
    protected final ByteBuffer newInternalNioBuffer(ByteBuffer byteBuffer) {
        return byteBuffer.duplicate();
    }

    @Override
    public final boolean isDirect() {
        return true;
    }

    @Override
    protected final byte _getByte(int n2) {
        return UnsafeByteBufUtil.getByte(this.addr(n2));
    }

    @Override
    protected final short _getShort(int n2) {
        return UnsafeByteBufUtil.getShort(this.addr(n2));
    }

    @Override
    protected final short _getShortLE(int n2) {
        return UnsafeByteBufUtil.getShortLE(this.addr(n2));
    }

    @Override
    protected final int _getUnsignedMedium(int n2) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(n2));
    }

    @Override
    protected final int _getInt(int n2) {
        return UnsafeByteBufUtil.getInt(this.addr(n2));
    }

    @Override
    protected final int _getIntLE(int n2) {
        return UnsafeByteBufUtil.getIntLE(this.addr(n2));
    }

    @Override
    protected final long _getLong(int n2) {
        return UnsafeByteBufUtil.getLong(this.addr(n2));
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n2), n2, byteBuf, n3, n4);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n2), n2, byArray, n3, n4);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes(pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n2), n2, byteBuffer);
        return this;
    }

    @Override
    protected final void _setByte(int n2, int n3) {
        UnsafeByteBufUtil.setByte(this.addr(n2), (byte)n3);
    }

    @Override
    protected final void _setShort(int n2, int n3) {
        UnsafeByteBufUtil.setShort(this.addr(n2), n3);
    }

    @Override
    protected final void _setShortLE(int n2, int n3) {
        UnsafeByteBufUtil.setShortLE(this.addr(n2), n3);
    }

    @Override
    protected final void _setMedium(int n2, int n3) {
        UnsafeByteBufUtil.setMedium(this.addr(n2), n3);
    }

    @Override
    protected final void _setMediumLE(int n2, int n3) {
        UnsafeByteBufUtil.setMediumLE(this.addr(n2), n3);
    }

    @Override
    protected final void _setInt(int n2, int n3) {
        UnsafeByteBufUtil.setInt(this.addr(n2), n3);
    }

    @Override
    protected final void _setLong(int n2, long l2) {
        UnsafeByteBufUtil.setLong(this.addr(n2), l2);
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n2), n2, byteBuf, n3, n4);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n2), n2, byArray, n3, n4);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes(pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n2), n2, byteBuffer);
        return this;
    }

    @Override
    public final boolean hasArray() {
        return false;
    }

    @Override
    public final byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public final int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public final boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public final long memoryAddress() {
        this.ensureAccessible();
        return this.memoryAddress;
    }

    private long addr(int n2) {
        return this.memoryAddress + (long)n2;
    }

    @Override
    protected final SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeDirectSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }

    @Override
    public final ByteBuf setZero(int n2, int n3) {
        this.checkIndex(n2, n3);
        UnsafeByteBufUtil.setZero(this.addr(n2), n3);
        return this;
    }

    @Override
    public final ByteBuf writeZero(int n2) {
        this.ensureWritable(n2);
        int n3 = this.writerIndex;
        UnsafeByteBufUtil.setZero(this.addr(n3), n2);
        this.writerIndex = n3 + n2;
        return this;
    }
}

