/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.PoolArena;
import com.appoptics.ext.io.netty.buffer.PoolChunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PoolSubpage<T> {
    final PoolChunk<T> chunk;
    private final int memoryMapIdx;
    private final int runOffset;
    private final int pageSize;
    private final long[] bitmap;
    PoolSubpage<T> prev;
    PoolSubpage<T> next;
    boolean doNotDestroy;
    int elemSize;
    private int maxNumElems;
    private int bitmapLength;
    private int nextAvail;
    private int numAvail;

    PoolSubpage(int n2) {
        this.chunk = null;
        this.memoryMapIdx = -1;
        this.runOffset = -1;
        this.elemSize = -1;
        this.pageSize = n2;
        this.bitmap = null;
    }

    PoolSubpage(PoolSubpage<T> poolSubpage, PoolChunk<T> poolChunk, int n2, int n3, int n4, int n5) {
        this.chunk = poolChunk;
        this.memoryMapIdx = n2;
        this.runOffset = n3;
        this.pageSize = n4;
        this.bitmap = new long[n4 >>> 10];
        this.init(poolSubpage, n5);
    }

    final void init(PoolSubpage<T> poolSubpage, int n2) {
        this.doNotDestroy = true;
        this.elemSize = n2;
        if (n2 != 0) {
            PoolSubpage poolSubpage2 = this;
            poolSubpage2.maxNumElems = poolSubpage2.numAvail = this.pageSize / n2;
            this.nextAvail = 0;
            this.bitmapLength = this.maxNumElems >>> 6;
            if ((this.maxNumElems & 0x3F) != 0) {
                ++this.bitmapLength;
            }
            for (n2 = 0; n2 < this.bitmapLength; ++n2) {
                this.bitmap[n2] = 0L;
            }
        }
        this.addToPool(poolSubpage);
    }

    final long allocate() {
        if (this.elemSize == 0) {
            return this.toHandle(0);
        }
        if (this.numAvail == 0 || !this.doNotDestroy) {
            return -1L;
        }
        int n2 = this.getNextAvail();
        int n3 = n2 >>> 6;
        int n4 = n2 & 0x3F;
        assert ((this.bitmap[n3] >>> n4 & 1L) == 0L);
        int n5 = n3;
        this.bitmap[n5] = this.bitmap[n5] | 1L << n4;
        if (--this.numAvail == 0) {
            this.removeFromPool();
        }
        return this.toHandle(n2);
    }

    final boolean free(PoolSubpage<T> poolSubpage, int n2) {
        if (this.elemSize == 0) {
            return true;
        }
        int n3 = n2 >>> 6;
        int n4 = n2 & 0x3F;
        assert ((this.bitmap[n3] >>> n4 & 1L) != 0L);
        int n5 = n3;
        this.bitmap[n5] = this.bitmap[n5] ^ 1L << n4;
        this.setNextAvail(n2);
        if (this.numAvail++ == 0) {
            this.addToPool(poolSubpage);
            return true;
        }
        if (this.numAvail != this.maxNumElems) {
            return true;
        }
        if (this.prev == this.next) {
            return true;
        }
        this.doNotDestroy = false;
        this.removeFromPool();
        return false;
    }

    private void addToPool(PoolSubpage<T> poolSubpage) {
        assert (this.prev == null && this.next == null);
        this.prev = poolSubpage;
        this.next = poolSubpage.next;
        this.next.prev = this;
        poolSubpage.next = this;
    }

    private void removeFromPool() {
        assert (this.prev != null && this.next != null);
        this.prev.next = this.next;
        this.next.prev = this.prev;
        this.next = null;
        this.prev = null;
    }

    private void setNextAvail(int n2) {
        this.nextAvail = n2;
    }

    private int getNextAvail() {
        int n2 = this.nextAvail;
        if (n2 >= 0) {
            this.nextAvail = -1;
            return n2;
        }
        return this.findNextAvail();
    }

    private int findNextAvail() {
        long[] lArray = this.bitmap;
        int n2 = this.bitmapLength;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray[i2];
            if ((l2 ^ 0xFFFFFFFFFFFFFFFFL) == 0L) continue;
            return this.findNextAvail0(i2, l2);
        }
        return -1;
    }

    private int findNextAvail0(int n2, long l2) {
        int n3 = this.maxNumElems;
        n2 <<= 6;
        for (int i2 = 0; i2 < 64; ++i2) {
            if ((l2 & 1L) == 0L) {
                if ((n2 |= i2) >= n3) break;
                return n2;
            }
            l2 >>>= 1;
        }
        return -1;
    }

    private long toHandle(int n2) {
        return 0x4000000000000000L | (long)n2 << 32 | (long)this.memoryMapIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        int n2;
        int n3;
        int n4;
        boolean bl;
        if (this.chunk == null) {
            bl = true;
            n4 = 0;
            n3 = 0;
            n2 = -1;
        } else {
            PoolArena poolArena = this.chunk.arena;
            synchronized (poolArena) {
                if (!this.doNotDestroy) {
                    bl = false;
                    n2 = 0;
                    n3 = 0;
                    n4 = 0;
                } else {
                    bl = true;
                    n4 = this.maxNumElems;
                    n3 = this.numAvail;
                    n2 = this.elemSize;
                }
            }
        }
        if (!bl) {
            return "(" + this.memoryMapIdx + ": not in use)";
        }
        return "(" + this.memoryMapIdx + ": " + (n4 - n3) + '/' + n4 + ", offset: " + this.runOffset + ", length: " + this.pageSize + ", elemSize: " + n2 + ')';
    }

    final void destroy() {
        if (this.chunk != null) {
            this.chunk.destroy();
        }
    }
}

