/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.AbstractDerivedByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.DuplicatedByteBuf;
import com.appoptics.ext.io.netty.util.ByteProcessor;
import com.appoptics.ext.io.netty.util.internal.MathUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

abstract class AbstractUnpooledSlicedByteBuf
extends AbstractDerivedByteBuf {
    private final ByteBuf buffer;
    private final int adjustment;

    AbstractUnpooledSlicedByteBuf(ByteBuf byteBuf, int n2, int n3) {
        super(n3);
        AbstractUnpooledSlicedByteBuf.checkSliceOutOfBounds(n2, n3, byteBuf);
        if (byteBuf instanceof AbstractUnpooledSlicedByteBuf) {
            this.buffer = ((AbstractUnpooledSlicedByteBuf)byteBuf).buffer;
            this.adjustment = ((AbstractUnpooledSlicedByteBuf)byteBuf).adjustment + n2;
        } else if (byteBuf instanceof DuplicatedByteBuf) {
            this.buffer = byteBuf.unwrap();
            this.adjustment = n2;
        } else {
            this.buffer = byteBuf;
            this.adjustment = n2;
        }
        this.initLength(n3);
        this.writerIndex(n3);
    }

    void initLength(int n2) {
    }

    public ByteBuf unwrap() {
        return this.buffer;
    }

    public ByteBufAllocator alloc() {
        return this.unwrap().alloc();
    }

    @Deprecated
    public ByteOrder order() {
        return this.unwrap().order();
    }

    public boolean isDirect() {
        return this.unwrap().isDirect();
    }

    public ByteBuf capacity(int n2) {
        throw new UnsupportedOperationException("sliced buffer");
    }

    public boolean hasArray() {
        return this.unwrap().hasArray();
    }

    public byte[] array() {
        return this.unwrap().array();
    }

    public int arrayOffset() {
        AbstractUnpooledSlicedByteBuf abstractUnpooledSlicedByteBuf = this;
        return abstractUnpooledSlicedByteBuf.idx(abstractUnpooledSlicedByteBuf.unwrap().arrayOffset());
    }

    public boolean hasMemoryAddress() {
        return this.unwrap().hasMemoryAddress();
    }

    public long memoryAddress() {
        return this.unwrap().memoryAddress() + (long)this.adjustment;
    }

    public byte getByte(int n2) {
        this.checkIndex0(n2, 1);
        return this.unwrap().getByte(this.idx(n2));
    }

    protected byte _getByte(int n2) {
        return this.unwrap().getByte(this.idx(n2));
    }

    public short getShort(int n2) {
        this.checkIndex0(n2, 2);
        return this.unwrap().getShort(this.idx(n2));
    }

    protected short _getShort(int n2) {
        return this.unwrap().getShort(this.idx(n2));
    }

    public short getShortLE(int n2) {
        this.checkIndex0(n2, 2);
        return this.unwrap().getShortLE(this.idx(n2));
    }

    protected short _getShortLE(int n2) {
        return this.unwrap().getShortLE(this.idx(n2));
    }

    public int getUnsignedMedium(int n2) {
        this.checkIndex0(n2, 3);
        return this.unwrap().getUnsignedMedium(this.idx(n2));
    }

    protected int _getUnsignedMedium(int n2) {
        return this.unwrap().getUnsignedMedium(this.idx(n2));
    }

    public int getInt(int n2) {
        this.checkIndex0(n2, 4);
        return this.unwrap().getInt(this.idx(n2));
    }

    protected int _getInt(int n2) {
        return this.unwrap().getInt(this.idx(n2));
    }

    public int getIntLE(int n2) {
        this.checkIndex0(n2, 4);
        return this.unwrap().getIntLE(this.idx(n2));
    }

    protected int _getIntLE(int n2) {
        return this.unwrap().getIntLE(this.idx(n2));
    }

    public long getLong(int n2) {
        this.checkIndex0(n2, 8);
        return this.unwrap().getLong(this.idx(n2));
    }

    protected long _getLong(int n2) {
        return this.unwrap().getLong(this.idx(n2));
    }

    public ByteBuf duplicate() {
        AbstractUnpooledSlicedByteBuf abstractUnpooledSlicedByteBuf = this;
        AbstractUnpooledSlicedByteBuf abstractUnpooledSlicedByteBuf2 = this;
        return this.unwrap().duplicate().setIndex(abstractUnpooledSlicedByteBuf.idx(abstractUnpooledSlicedByteBuf.readerIndex()), abstractUnpooledSlicedByteBuf2.idx(abstractUnpooledSlicedByteBuf2.writerIndex()));
    }

    public ByteBuf slice(int n2, int n3) {
        this.checkIndex0(n2, n3);
        return this.unwrap().slice(this.idx(n2), n3);
    }

    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkIndex0(n2, n4);
        this.unwrap().getBytes(this.idx(n2), byteBuf, n3, n4);
        return this;
    }

    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkIndex0(n2, n4);
        this.unwrap().getBytes(this.idx(n2), byArray, n3, n4);
        return this;
    }

    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        this.checkIndex0(n2, byteBuffer.remaining());
        this.unwrap().getBytes(this.idx(n2), byteBuffer);
        return this;
    }

    public ByteBuf setByte(int n2, int n3) {
        this.checkIndex0(n2, 1);
        this.unwrap().setByte(this.idx(n2), n3);
        return this;
    }

    protected void _setByte(int n2, int n3) {
        this.unwrap().setByte(this.idx(n2), n3);
    }

    public ByteBuf setShort(int n2, int n3) {
        this.checkIndex0(n2, 2);
        this.unwrap().setShort(this.idx(n2), n3);
        return this;
    }

    protected void _setShort(int n2, int n3) {
        this.unwrap().setShort(this.idx(n2), n3);
    }

    public ByteBuf setShortLE(int n2, int n3) {
        this.checkIndex0(n2, 2);
        this.unwrap().setShortLE(this.idx(n2), n3);
        return this;
    }

    protected void _setShortLE(int n2, int n3) {
        this.unwrap().setShortLE(this.idx(n2), n3);
    }

    public ByteBuf setMedium(int n2, int n3) {
        this.checkIndex0(n2, 3);
        this.unwrap().setMedium(this.idx(n2), n3);
        return this;
    }

    protected void _setMedium(int n2, int n3) {
        this.unwrap().setMedium(this.idx(n2), n3);
    }

    public ByteBuf setMediumLE(int n2, int n3) {
        this.checkIndex0(n2, 3);
        this.unwrap().setMediumLE(this.idx(n2), n3);
        return this;
    }

    protected void _setMediumLE(int n2, int n3) {
        this.unwrap().setMediumLE(this.idx(n2), n3);
    }

    public ByteBuf setInt(int n2, int n3) {
        this.checkIndex0(n2, 4);
        this.unwrap().setInt(this.idx(n2), n3);
        return this;
    }

    protected void _setInt(int n2, int n3) {
        this.unwrap().setInt(this.idx(n2), n3);
    }

    public ByteBuf setLong(int n2, long l2) {
        this.checkIndex0(n2, 8);
        this.unwrap().setLong(this.idx(n2), l2);
        return this;
    }

    protected void _setLong(int n2, long l2) {
        this.unwrap().setLong(this.idx(n2), l2);
    }

    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkIndex0(n2, n4);
        this.unwrap().setBytes(this.idx(n2), byArray, n3, n4);
        return this;
    }

    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkIndex0(n2, n4);
        this.unwrap().setBytes(this.idx(n2), byteBuf, n3, n4);
        return this;
    }

    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        this.checkIndex0(n2, byteBuffer.remaining());
        this.unwrap().setBytes(this.idx(n2), byteBuffer);
        return this;
    }

    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) throws IOException {
        this.checkIndex0(n2, n3);
        return this.unwrap().getBytes(this.idx(n2), gatheringByteChannel, n3);
    }

    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) throws IOException {
        this.checkIndex0(n2, n3);
        return this.unwrap().setBytes(this.idx(n2), scatteringByteChannel, n3);
    }

    public int nioBufferCount() {
        return this.unwrap().nioBufferCount();
    }

    public ByteBuffer nioBuffer(int n2, int n3) {
        this.checkIndex0(n2, n3);
        return this.unwrap().nioBuffer(this.idx(n2), n3);
    }

    public ByteBuffer[] nioBuffers(int n2, int n3) {
        this.checkIndex0(n2, n3);
        return this.unwrap().nioBuffers(this.idx(n2), n3);
    }

    public int forEachByte(int n2, int n3, ByteProcessor byteProcessor) {
        this.checkIndex0(n2, n3);
        n2 = this.unwrap().forEachByte(this.idx(n2), n3, byteProcessor);
        if (n2 >= this.adjustment) {
            return n2 - this.adjustment;
        }
        return -1;
    }

    final int idx(int n2) {
        return n2 + this.adjustment;
    }

    static void checkSliceOutOfBounds(int n2, int n3, ByteBuf byteBuf) {
        if (MathUtil.isOutOfBounds(n2, n3, byteBuf.capacity())) {
            throw new IndexOutOfBoundsException(byteBuf + ".slice(" + n2 + ", " + n3 + ')');
        }
    }
}

