/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.AbstractByteBuf;
import com.appoptics.ext.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.PooledDuplicatedByteBuf;
import com.appoptics.ext.io.netty.buffer.PooledSlicedByteBuf;
import com.appoptics.ext.io.netty.buffer.SimpleLeakAwareByteBuf;
import com.appoptics.ext.io.netty.buffer.UnpooledDuplicatedByteBuf;
import com.appoptics.ext.io.netty.buffer.UnpooledSlicedByteBuf;
import com.appoptics.ext.io.netty.util.ReferenceCounted;
import com.appoptics.ext.io.netty.util.internal.ObjectPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractPooledDerivedByteBuf
extends AbstractReferenceCountedByteBuf {
    private final ObjectPool.Handle<AbstractPooledDerivedByteBuf> recyclerHandle;
    private AbstractByteBuf rootParent;
    private ByteBuf parent;

    AbstractPooledDerivedByteBuf(ObjectPool.Handle<? extends AbstractPooledDerivedByteBuf> handle) {
        super(0);
        this.recyclerHandle = handle;
    }

    final void parent(ByteBuf byteBuf) {
        assert (byteBuf instanceof SimpleLeakAwareByteBuf);
        this.parent = byteBuf;
    }

    @Override
    public final AbstractByteBuf unwrap() {
        return this.rootParent;
    }

    final <U extends AbstractPooledDerivedByteBuf> U init(AbstractByteBuf abstractByteBuf, ByteBuf byteBuf, int n2, int n3, int n4) {
        byteBuf.retain();
        this.parent = byteBuf;
        this.rootParent = abstractByteBuf;
        try {
            this.maxCapacity(n4);
            this.setIndex0(n2, n3);
            this.resetRefCnt();
            abstractByteBuf = this;
            byteBuf = null;
        }
        catch (Throwable throwable) {
            if (byteBuf != null) {
                AbstractPooledDerivedByteBuf abstractPooledDerivedByteBuf = this;
                abstractPooledDerivedByteBuf.rootParent = null;
                abstractPooledDerivedByteBuf.parent = null;
                byteBuf.release();
            }
            throw throwable;
        }
        return (U)abstractByteBuf;
    }

    @Override
    protected final void deallocate() {
        ByteBuf byteBuf = this.parent;
        this.recyclerHandle.recycle(this);
        byteBuf.release();
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.unwrap().alloc();
    }

    @Override
    @Deprecated
    public final ByteOrder order() {
        return this.unwrap().order();
    }

    @Override
    public boolean isReadOnly() {
        return this.unwrap().isReadOnly();
    }

    @Override
    public final boolean isDirect() {
        return this.unwrap().isDirect();
    }

    @Override
    public boolean hasArray() {
        return this.unwrap().hasArray();
    }

    @Override
    public byte[] array() {
        return this.unwrap().array();
    }

    @Override
    public boolean hasMemoryAddress() {
        return this.unwrap().hasMemoryAddress();
    }

    @Override
    public boolean isContiguous() {
        return this.unwrap().isContiguous();
    }

    @Override
    public final int nioBufferCount() {
        return this.unwrap().nioBufferCount();
    }

    @Override
    public final ByteBuffer internalNioBuffer(int n2, int n3) {
        return this.nioBuffer(n2, n3);
    }

    @Override
    public final ByteBuf retainedSlice() {
        int n2 = this.readerIndex();
        return this.retainedSlice(n2, this.writerIndex() - n2);
    }

    @Override
    public ByteBuf slice(int n2, int n3) {
        this.ensureAccessible();
        AbstractPooledDerivedByteBuf abstractPooledDerivedByteBuf = this;
        return new PooledNonRetainedSlicedByteBuf(abstractPooledDerivedByteBuf, abstractPooledDerivedByteBuf.unwrap(), n2, n3);
    }

    final ByteBuf duplicate0() {
        this.ensureAccessible();
        AbstractPooledDerivedByteBuf abstractPooledDerivedByteBuf = this;
        return new PooledNonRetainedDuplicateByteBuf(abstractPooledDerivedByteBuf, abstractPooledDerivedByteBuf.unwrap());
    }

    private static final class PooledNonRetainedSlicedByteBuf
    extends UnpooledSlicedByteBuf {
        private final ReferenceCounted referenceCountDelegate;

        PooledNonRetainedSlicedByteBuf(ReferenceCounted referenceCounted, AbstractByteBuf abstractByteBuf, int n2, int n3) {
            super(abstractByteBuf, n2, n3);
            this.referenceCountDelegate = referenceCounted;
        }

        final int refCnt0() {
            return this.referenceCountDelegate.refCnt();
        }

        final ByteBuf retain0() {
            this.referenceCountDelegate.retain();
            return this;
        }

        final ByteBuf touch0() {
            this.referenceCountDelegate.touch();
            return this;
        }

        final ByteBuf touch0(Object object) {
            this.referenceCountDelegate.touch(object);
            return this;
        }

        final boolean release0() {
            return this.referenceCountDelegate.release();
        }

        public final ByteBuf duplicate() {
            this.ensureAccessible();
            PooledNonRetainedSlicedByteBuf pooledNonRetainedSlicedByteBuf = this;
            PooledNonRetainedSlicedByteBuf pooledNonRetainedSlicedByteBuf2 = this;
            return new PooledNonRetainedDuplicateByteBuf(this.referenceCountDelegate, this.unwrap()).setIndex(pooledNonRetainedSlicedByteBuf.idx(pooledNonRetainedSlicedByteBuf.readerIndex()), pooledNonRetainedSlicedByteBuf2.idx(pooledNonRetainedSlicedByteBuf2.writerIndex()));
        }

        public final ByteBuf retainedDuplicate() {
            PooledNonRetainedSlicedByteBuf pooledNonRetainedSlicedByteBuf = this;
            PooledNonRetainedSlicedByteBuf pooledNonRetainedSlicedByteBuf2 = this;
            return PooledDuplicatedByteBuf.newInstance(this.unwrap(), pooledNonRetainedSlicedByteBuf, pooledNonRetainedSlicedByteBuf.idx(this.readerIndex()), pooledNonRetainedSlicedByteBuf2.idx(pooledNonRetainedSlicedByteBuf2.writerIndex()));
        }

        public final ByteBuf slice(int n2, int n3) {
            this.checkIndex(n2, n3);
            return new PooledNonRetainedSlicedByteBuf(this.referenceCountDelegate, this.unwrap(), this.idx(n2), n3);
        }

        public final ByteBuf retainedSlice() {
            return this.retainedSlice(0, this.capacity());
        }

        public final ByteBuf retainedSlice(int n2, int n3) {
            PooledNonRetainedSlicedByteBuf pooledNonRetainedSlicedByteBuf = this;
            return PooledSlicedByteBuf.newInstance(this.unwrap(), pooledNonRetainedSlicedByteBuf, pooledNonRetainedSlicedByteBuf.idx(n2), n3);
        }
    }

    private static final class PooledNonRetainedDuplicateByteBuf
    extends UnpooledDuplicatedByteBuf {
        private final ReferenceCounted referenceCountDelegate;

        PooledNonRetainedDuplicateByteBuf(ReferenceCounted referenceCounted, AbstractByteBuf abstractByteBuf) {
            super(abstractByteBuf);
            this.referenceCountDelegate = referenceCounted;
        }

        final int refCnt0() {
            return this.referenceCountDelegate.refCnt();
        }

        final ByteBuf retain0() {
            this.referenceCountDelegate.retain();
            return this;
        }

        final ByteBuf touch0() {
            this.referenceCountDelegate.touch();
            return this;
        }

        final ByteBuf touch0(Object object) {
            this.referenceCountDelegate.touch(object);
            return this;
        }

        final boolean release0() {
            return this.referenceCountDelegate.release();
        }

        public final ByteBuf duplicate() {
            this.ensureAccessible();
            return new PooledNonRetainedDuplicateByteBuf(this.referenceCountDelegate, this);
        }

        public final ByteBuf retainedDuplicate() {
            PooledNonRetainedDuplicateByteBuf pooledNonRetainedDuplicateByteBuf = this;
            return PooledDuplicatedByteBuf.newInstance(this.unwrap(), pooledNonRetainedDuplicateByteBuf, pooledNonRetainedDuplicateByteBuf.readerIndex(), this.writerIndex());
        }

        public final ByteBuf slice(int n2, int n3) {
            this.checkIndex(n2, n3);
            return new PooledNonRetainedSlicedByteBuf(this.referenceCountDelegate, this.unwrap(), n2, n3);
        }

        public final ByteBuf retainedSlice() {
            PooledNonRetainedDuplicateByteBuf pooledNonRetainedDuplicateByteBuf = this;
            return pooledNonRetainedDuplicateByteBuf.retainedSlice(pooledNonRetainedDuplicateByteBuf.readerIndex(), this.capacity());
        }

        public final ByteBuf retainedSlice(int n2, int n3) {
            return PooledSlicedByteBuf.newInstance(this.unwrap(), this, n2, n3);
        }
    }
}

