/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.bootstrap;

import com.appoptics.ext.io.netty.bootstrap.AbstractBootstrapConfig;
import com.appoptics.ext.io.netty.bootstrap.ChannelFactory;
import com.appoptics.ext.io.netty.bootstrap.FailedChannel;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelHandler;
import com.appoptics.ext.io.netty.channel.ChannelOption;
import com.appoptics.ext.io.netty.channel.DefaultChannelPromise;
import com.appoptics.ext.io.netty.channel.EventLoopGroup;
import com.appoptics.ext.io.netty.util.AttributeKey;
import com.appoptics.ext.io.netty.util.concurrent.GlobalEventExecutor;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBootstrap<B extends AbstractBootstrap<B, C>, C extends Channel>
implements Cloneable {
    static final Map.Entry<ChannelOption<?>, Object>[] EMPTY_OPTION_ARRAY = new Map.Entry[0];
    static final Map.Entry<AttributeKey<?>, Object>[] EMPTY_ATTRIBUTE_ARRAY = new Map.Entry[0];
    volatile EventLoopGroup group;
    private volatile ChannelFactory<? extends C> channelFactory;
    private volatile SocketAddress localAddress;
    private final Map<ChannelOption<?>, Object> options = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> attrs = new ConcurrentHashMap();
    private volatile ChannelHandler handler;

    AbstractBootstrap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractBootstrap(AbstractBootstrap<B, C> abstractBootstrap) {
        this.group = abstractBootstrap.group;
        this.channelFactory = abstractBootstrap.channelFactory;
        this.handler = abstractBootstrap.handler;
        this.localAddress = abstractBootstrap.localAddress;
        Map<ChannelOption<?>, Object> map = abstractBootstrap.options;
        synchronized (map) {
            this.options.putAll(abstractBootstrap.options);
        }
        this.attrs.putAll(abstractBootstrap.attrs);
    }

    public B group(EventLoopGroup eventLoopGroup) {
        ObjectUtil.checkNotNull(eventLoopGroup, "group");
        if (this.group != null) {
            throw new IllegalStateException("group set already");
        }
        this.group = eventLoopGroup;
        return this.self();
    }

    private B self() {
        return (B)this;
    }

    @Deprecated
    public B channelFactory(ChannelFactory<? extends C> channelFactory) {
        ObjectUtil.checkNotNull(channelFactory, "channelFactory");
        if (this.channelFactory != null) {
            throw new IllegalStateException("channelFactory set already");
        }
        this.channelFactory = channelFactory;
        return this.self();
    }

    public B channelFactory(com.appoptics.ext.io.netty.channel.ChannelFactory<? extends C> channelFactory) {
        return this.channelFactory((ChannelFactory<? extends C>)channelFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> B option(ChannelOption<T> channelOption, T t2) {
        ObjectUtil.checkNotNull(channelOption, "option");
        Map<ChannelOption<?>, Object> map = this.options;
        synchronized (map) {
            if (t2 == null) {
                this.options.remove(channelOption);
            } else {
                this.options.put(channelOption, t2);
            }
        }
        return this.self();
    }

    public <T> B attr(AttributeKey<T> attributeKey, T t2) {
        ObjectUtil.checkNotNull(attributeKey, "key");
        if (t2 == null) {
            this.attrs.remove(attributeKey);
        } else {
            this.attrs.put(attributeKey, t2);
        }
        return this.self();
    }

    public B validate() {
        if (this.group == null) {
            throw new IllegalStateException("group not set");
        }
        if (this.channelFactory == null) {
            throw new IllegalStateException("channel or channelFactory not set");
        }
        return this.self();
    }

    public abstract B clone();

    public ChannelFuture register() {
        this.validate();
        return this.initAndRegister();
    }

    final ChannelFuture initAndRegister() {
        Channel channel = null;
        try {
            channel = (Channel)this.channelFactory.newChannel();
            this.init(channel);
        }
        catch (Throwable throwable) {
            if (channel != null) {
                channel.unsafe().closeForcibly();
                return new DefaultChannelPromise(channel, GlobalEventExecutor.INSTANCE).setFailure(throwable);
            }
            return new DefaultChannelPromise(new FailedChannel(), GlobalEventExecutor.INSTANCE).setFailure(throwable);
        }
        ChannelFuture channelFuture = this.config().group().register(channel);
        if (channelFuture.cause() != null) {
            if (channel.isRegistered()) {
                channel.close();
            } else {
                channel.unsafe().closeForcibly();
            }
        }
        return channelFuture;
    }

    abstract void init(Channel var1) throws Exception;

    public B handler(ChannelHandler channelHandler) {
        this.handler = ObjectUtil.checkNotNull(channelHandler, "handler");
        return this.self();
    }

    @Deprecated
    public final EventLoopGroup group() {
        return this.group;
    }

    public abstract AbstractBootstrapConfig<B, C> config();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Map.Entry<ChannelOption<?>, Object>[] newOptionsArray() {
        Map<ChannelOption<?>, Object> map = this.options;
        synchronized (map) {
            return this.options.entrySet().toArray(EMPTY_OPTION_ARRAY);
        }
    }

    final Map<AttributeKey<?>, Object> attrs0() {
        return this.attrs;
    }

    final SocketAddress localAddress() {
        return this.localAddress;
    }

    final ChannelFactory<? extends C> channelFactory() {
        return this.channelFactory;
    }

    final ChannelHandler handler() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Map<ChannelOption<?>, Object> options() {
        Map<ChannelOption<?>, Object> map = this.options;
        synchronized (map) {
            return AbstractBootstrap.copiedMap(this.options);
        }
    }

    final Map<AttributeKey<?>, Object> attrs() {
        return AbstractBootstrap.copiedMap(this.attrs);
    }

    static <K, V> Map<K, V> copiedMap(Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new HashMap<K, V>(map));
    }

    static void setAttributes(Channel channel, Map.Entry<AttributeKey<?>, Object>[] entryArray) {
        for (Map.Entry<AttributeKey<?>, Object> entry : entryArray) {
            AttributeKey<?> attributeKey = entry.getKey();
            channel.attr(attributeKey).set(entry.getValue());
        }
    }

    static void setChannelOptions(Channel channel, Map.Entry<ChannelOption<?>, Object>[] entryArray, InternalLogger internalLogger) {
        for (Map.Entry<ChannelOption<?>, Object> entry : entryArray) {
            AbstractBootstrap.setChannelOption(channel, entry.getKey(), entry.getValue(), internalLogger);
        }
    }

    private static void setChannelOption(Channel channel, ChannelOption<?> channelOption, Object object, InternalLogger internalLogger) {
        try {
            if (!channel.config().setOption(channelOption, object)) {
                internalLogger.warn("Unknown channel option '{}' for channel '{}'", (Object)channelOption, (Object)channel);
            }
            return;
        }
        catch (Throwable throwable) {
            internalLogger.warn("Failed to set channel option '{}' with value '{}' for channel '{}'", channelOption, object, channel, throwable);
            return;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(StringUtil.simpleClassName(this)).append('(').append(this.config()).append(')');
        return stringBuilder.toString();
    }
}

