/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.netty;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.netty.ProtocolNegotiationEvent;
import com.appoptics.ext.io.grpc.netty.Utils;
import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufUtil;
import com.appoptics.ext.io.netty.channel.ChannelDuplexHandler;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.ChannelHandler;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

final class WriteBufferingAndExceptionHandler
extends ChannelDuplexHandler {
    private static final Logger logger = Logger.getLogger(WriteBufferingAndExceptionHandler.class.getName());
    private final Queue<ChannelWrite> bufferedWrites = new ArrayDeque<ChannelWrite>();
    private final ChannelHandler next;
    private boolean writing;
    private boolean flushRequested;
    private Throwable failCause;

    WriteBufferingAndExceptionHandler(ChannelHandler channelHandler) {
        this.next = b.a(channelHandler, (Object)"next");
    }

    public final void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        channelHandlerContext.pipeline().addBefore(channelHandlerContext.name(), null, this.next);
        super.handlerAdded(channelHandlerContext);
        channelHandlerContext.pipeline().fireUserEventTriggered(ProtocolNegotiationEvent.DEFAULT);
    }

    public final void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (!this.bufferedWrites.isEmpty()) {
            Status status = Status.INTERNAL.withDescription("Buffer removed before draining writes");
            this.failWrites(status.asRuntimeException());
        }
        super.handlerRemoved(channelHandlerContext);
    }

    public final void channelInactive(ChannelHandlerContext object) {
        object = Status.UNAVAILABLE.withDescription("Connection closed while performing protocol negotiation for " + object.pipeline().names());
        this.failWrites(((Status)object).asRuntimeException());
    }

    public final void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable object) {
        assert (object != null);
        Throwable throwable = this.failCause;
        object = Utils.statusFromThrowable((Throwable)object).augmentDescription("Channel Pipeline: " + channelHandlerContext.pipeline().names());
        this.failWrites(((Status)object).asRuntimeException());
        if (channelHandlerContext.channel().isActive() && throwable == null) {
            final class LogOnFailure
            implements ChannelFutureListener {
                LogOnFailure() {
                }

                public final void operationComplete(ChannelFuture channelFuture) {
                    if (!channelFuture.isSuccess()) {
                        logger.log(Level.FINE, "Failed closing channel", channelFuture.cause());
                    }
                }
            }
            channelHandlerContext.close().addListener(new LogOnFailure());
        }
    }

    public final void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (this.failCause != null) {
            channelPromise.setFailure(this.failCause);
            ReferenceCountUtil.release(object);
            return;
        }
        this.bufferedWrites.add(new ChannelWrite(object, channelPromise));
    }

    public final void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) throws Exception {
        super.connect(channelHandlerContext, socketAddress, socketAddress2, channelPromise);
        final class ConnectListener
        implements ChannelFutureListener {
            ConnectListener() {
            }

            public final void operationComplete(ChannelFuture channelFuture) {
                if (!channelFuture.isSuccess()) {
                    WriteBufferingAndExceptionHandler.this.failWrites(channelFuture.cause());
                }
            }
        }
        channelPromise.addListener(new ConnectListener());
    }

    public final void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        try {
            if (logger.isLoggable(Level.FINE)) {
                Object object2 = object instanceof ByteBuf ? ByteBufUtil.hexDump((ByteBuf)object) : object;
                logger.log(Level.FINE, "Unexpected channelRead()->{0} reached end of pipeline {1}", new Object[]{object2, channelHandlerContext.pipeline().names()});
            }
            this.exceptionCaught(channelHandlerContext, Status.INTERNAL.withDescription("channelRead() missed by ProtocolNegotiator handler: " + object).asRuntimeException());
            return;
        }
        finally {
            ReferenceCountUtil.safeRelease(object);
        }
    }

    public final void flush(ChannelHandlerContext channelHandlerContext) {
        this.flushRequested = true;
    }

    public final void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        Status status = Status.UNAVAILABLE.withDescription("Connection closing while performing protocol negotiation for " + channelHandlerContext.pipeline().names());
        this.failWrites(status.asRuntimeException());
        super.close(channelHandlerContext, channelPromise);
    }

    final void writeBufferedAndRemove(ChannelHandlerContext channelHandlerContext) {
        if (!channelHandlerContext.channel().isActive() || this.writing) {
            return;
        }
        this.writing = true;
        while (!this.bufferedWrites.isEmpty()) {
            ChannelWrite channelWrite = this.bufferedWrites.poll();
            channelHandlerContext.write(channelWrite.msg, channelWrite.promise);
        }
        if (this.flushRequested) {
            channelHandlerContext.flush();
        }
        channelHandlerContext.pipeline().remove(this);
    }

    private void failWrites(Throwable throwable) {
        if (this.failCause == null) {
            this.failCause = throwable;
        } else {
            logger.log(Level.FINE, "Ignoring duplicate failure", throwable);
        }
        while (!this.bufferedWrites.isEmpty()) {
            ChannelWrite channelWrite = this.bufferedWrites.poll();
            channelWrite.promise.setFailure(throwable);
            ReferenceCountUtil.release(channelWrite.msg);
        }
    }

    private static final class ChannelWrite {
        final Object msg;
        final ChannelPromise promise;

        ChannelWrite(Object object, ChannelPromise channelPromise) {
            this.msg = object;
            this.promise = channelPromise;
        }
    }
}

