/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.internal.LongCounter;
import com.appoptics.ext.io.grpc.internal.LongCounterFactory;
import com.appoptics.ext.io.grpc.internal.TimeProvider;

public final class TransportTracer {
    private static final Factory DEFAULT_FACTORY = new Factory(TimeProvider.SYSTEM_TIME_PROVIDER);
    private final TimeProvider timeProvider;
    private long streamsStarted;
    private long lastLocalStreamCreatedTimeNanos;
    private long streamsSucceeded;
    private long streamsFailed;
    private long keepAlivesSent;
    private FlowControlReader flowControlWindowReader;
    private long messagesSent;
    private long lastMessageSentTimeNanos;
    private final LongCounter messagesReceived = LongCounterFactory.create();
    private volatile long lastMessageReceivedTimeNanos;

    public TransportTracer() {
        this.timeProvider = TimeProvider.SYSTEM_TIME_PROVIDER;
    }

    private TransportTracer(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    public final void reportLocalStreamStarted() {
        ++this.streamsStarted;
        this.lastLocalStreamCreatedTimeNanos = this.timeProvider.currentTimeNanos();
    }

    public final void reportStreamClosed(boolean bl) {
        if (bl) {
            ++this.streamsSucceeded;
            return;
        }
        ++this.streamsFailed;
    }

    public final void reportMessageSent(int n2) {
        if (n2 == 0) {
            return;
        }
        this.messagesSent += (long)n2;
        this.lastMessageSentTimeNanos = this.timeProvider.currentTimeNanos();
    }

    public final void reportMessageReceived() {
        this.messagesReceived.add(1L);
        this.lastMessageReceivedTimeNanos = this.timeProvider.currentTimeNanos();
    }

    public final void reportKeepAliveSent() {
        ++this.keepAlivesSent;
    }

    public final void setFlowControlWindowReader(FlowControlReader flowControlReader) {
        this.flowControlWindowReader = b.a(flowControlReader);
    }

    public static Factory getDefaultFactory() {
        return DEFAULT_FACTORY;
    }

    public static final class Factory {
        private final TimeProvider timeProvider;

        public Factory(TimeProvider timeProvider) {
            this.timeProvider = timeProvider;
        }

        public final TransportTracer create() {
            return new TransportTracer(this.timeProvider);
        }
    }

    public static interface FlowControlReader {
    }
}

