/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.grpc.InternalMetadata;
import com.appoptics.ext.io.grpc.Metadata;
import com.tracelytics.a.d.a.a.b;
import com.tracelytics.a.d.a.d.a;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public final class TransportFrameUtil {
    private static final Logger logger = Logger.getLogger(TransportFrameUtil.class.getName());
    private static final byte[] binaryHeaderSuffixBytes = "-bin".getBytes(b.a);

    public static byte[][] toHttp2Headers(Metadata object) {
        byte[][] byArray = InternalMetadata.serialize((Metadata)object);
        object = byArray;
        if (byArray == null) {
            return new byte[0][];
        }
        int n2 = 0;
        for (int i2 = 0; i2 < ((Object)object).length; i2 += 2) {
            Object object2 = object[i2];
            Object object3 = object[i2 + 1];
            if (TransportFrameUtil.endsWith((byte[])object2, binaryHeaderSuffixBytes)) {
                object[n2] = object2;
                object[n2 + 1] = InternalMetadata.BASE64_ENCODING_OMIT_PADDING.a((byte[])object3).getBytes(b.a);
                n2 += 2;
                continue;
            }
            if (TransportFrameUtil.isSpecCompliantAscii((byte[])object3)) {
                object[n2] = object2;
                object[n2 + 1] = object3;
                n2 += 2;
                continue;
            }
            object2 = new String((byte[])object2, b.a);
            logger.warning("Metadata key=" + (String)object2 + ", value=" + Arrays.toString((byte[])object3) + " contains invalid ASCII characters");
        }
        if (n2 == ((Object)object).length) {
            return object;
        }
        return (byte[][])Arrays.copyOfRange(object, 0, n2);
    }

    public static byte[][] toRawSerializedHeaders(byte[][] byArray) {
        for (int i2 = 0; i2 < byArray.length; i2 += 2) {
            byte[] byArray2 = byArray[i2];
            byte[] byArray3 = byArray[i2 + 1];
            if (!TransportFrameUtil.endsWith(byArray2, binaryHeaderSuffixBytes)) continue;
            for (int i3 = 0; i3 < byArray3.length; ++i3) {
                if (byArray3[i3] != 44) continue;
                return TransportFrameUtil.serializeHeadersWithCommasInBin(byArray, i2);
            }
            byArray2 = a.b().a(new String(byArray3, b.a));
            byArray[i2 + 1] = byArray2;
        }
        return byArray;
    }

    private static byte[][] serializeHeadersWithCommasInBin(byte[][] byArray, int n2) {
        int n3;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(byArray.length + 10);
        for (n3 = 0; n3 < n2; ++n3) {
            arrayList.add(byArray[n3]);
        }
        for (n3 = n2; n3 < byArray.length; n3 += 2) {
            byte[] byArray2 = byArray[n3];
            byte[] byArray3 = byArray[n3 + 1];
            if (!TransportFrameUtil.endsWith(byArray2, binaryHeaderSuffixBytes)) {
                arrayList.add(byArray2);
                arrayList.add(byArray3);
                continue;
            }
            int n4 = 0;
            for (int i2 = 0; i2 <= byArray3.length; ++i2) {
                if (i2 != byArray3.length && byArray3[i2] != 44) continue;
                byte[] byArray4 = a.b().a(new String(byArray3, n4, i2 - n4, b.a));
                n4 = i2 + 1;
                arrayList.add(byArray2);
                arrayList.add(byArray4);
            }
        }
        return (byte[][])arrayList.toArray((T[])new byte[0][]);
    }

    private static boolean endsWith(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length - byArray2.length;
        if (n2 < 0) {
            return false;
        }
        for (int i2 = n2; i2 < byArray.length; ++i2) {
            if (byArray[i2] == byArray2[i2 - n2]) continue;
            return false;
        }
        return true;
    }

    private static boolean isSpecCompliantAscii(byte[] byArray) {
        for (byte by : byArray) {
            if (by >= 32 && by <= 126) continue;
            return false;
        }
        return true;
    }

    private TransportFrameUtil() {
    }
}

