/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.internal.GrpcUtil;
import com.appoptics.ext.io.grpc.internal.LogExceptionRunnable;
import java.util.IdentityHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SharedResourceHolder {
    private static final SharedResourceHolder holder = new SharedResourceHolder(new ScheduledExecutorFactory(){

        public ScheduledExecutorService createScheduledExecutor() {
            return Executors.newSingleThreadScheduledExecutor(GrpcUtil.getThreadFactory("grpc-shared-destroyer-%d", true));
        }
    });
    private final IdentityHashMap<Resource<?>, Instance> instances = new IdentityHashMap();
    private final ScheduledExecutorFactory destroyerFactory;
    private ScheduledExecutorService destroyer;

    SharedResourceHolder(ScheduledExecutorFactory scheduledExecutorFactory) {
        this.destroyerFactory = scheduledExecutorFactory;
    }

    public static <T> T get(Resource<T> resource) {
        return holder.getInternal(resource);
    }

    public static <T> T release(Resource<T> resource, T t2) {
        return holder.releaseInternal(resource, t2);
    }

    final synchronized <T> T getInternal(Resource<T> resource) {
        Instance instance = this.instances.get(resource);
        if (instance == null) {
            instance = new Instance(resource.create());
            this.instances.put(resource, instance);
        }
        if (instance.destroyTask != null) {
            instance.destroyTask.cancel(false);
            instance.destroyTask = null;
        }
        ++instance.refcount;
        return (T)instance.payload;
    }

    final synchronized <T> T releaseInternal(final Resource<T> resource, final T t2) {
        final Instance instance = this.instances.get(resource);
        if (instance == null) {
            throw new IllegalArgumentException("No cached instance found for " + resource);
        }
        b.a(t2 == instance.payload, (Object)"Releasing the wrong instance");
        b.b(instance.refcount > 0, "Refcount has already reached zero");
        --instance.refcount;
        if (instance.refcount == 0) {
            b.b(instance.destroyTask == null, "Destroy task already scheduled");
            if (this.destroyer == null) {
                this.destroyer = this.destroyerFactory.createScheduledExecutor();
            }
            instance.destroyTask = this.destroyer.schedule(new LogExceptionRunnable(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    SharedResourceHolder sharedResourceHolder = SharedResourceHolder.this;
                    synchronized (sharedResourceHolder) {
                        if (instance.refcount == 0) {
                            try {
                                resource.close(t2);
                            }
                            finally {
                                SharedResourceHolder.this.instances.remove(resource);
                                if (SharedResourceHolder.this.instances.isEmpty()) {
                                    SharedResourceHolder.this.destroyer.shutdown();
                                    SharedResourceHolder.this.destroyer = null;
                                }
                            }
                        }
                        return;
                    }
                }
            }), 1L, TimeUnit.SECONDS);
        }
        return null;
    }

    private static class Instance {
        final Object payload;
        int refcount;
        ScheduledFuture<?> destroyTask;

        Instance(Object object) {
            this.payload = object;
        }
    }

    static interface ScheduledExecutorFactory {
        public ScheduledExecutorService createScheduledExecutor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Resource<T> {
        public T create();

        public void close(T var1);
    }
}

