/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SerializingExecutor
implements Runnable,
Executor {
    private static final Logger log = Logger.getLogger(SerializingExecutor.class.getName());
    private static final AtomicHelper atomicHelper = SerializingExecutor.getAtomicHelper();
    private final Executor executor;
    private final Queue<Runnable> runQueue = new ConcurrentLinkedQueue<Runnable>();
    private volatile int runState = 0;

    private static AtomicHelper getAtomicHelper() {
        AtomicHelper atomicHelper;
        try {
            atomicHelper = new FieldUpdaterAtomicHelper(AtomicIntegerFieldUpdater.newUpdater(SerializingExecutor.class, "runState"));
        }
        catch (Throwable throwable) {
            log.log(Level.SEVERE, "FieldUpdaterAtomicHelper failed", throwable);
            atomicHelper = new SynchronizedAtomicHelper();
        }
        return atomicHelper;
    }

    public SerializingExecutor(Executor executor) {
        b.a(executor, (Object)"'executor' must not be null.");
        this.executor = executor;
    }

    public final void execute(Runnable runnable) {
        this.runQueue.add(b.a(runnable, (Object)"'r' must not be null."));
        this.schedule(runnable);
    }

    private void schedule(Runnable runnable) {
        if (atomicHelper.runStateCompareAndSet(this, 0, -1)) {
            try {
                this.executor.execute(this);
                return;
            }
            catch (Throwable throwable) {
                if (runnable != null) {
                    this.runQueue.remove(runnable);
                }
                atomicHelper.runStateSet(this, 0);
                throw throwable;
            }
        }
    }

    public final void run() {
        try {
            Runnable runnable;
            while ((runnable = this.runQueue.poll()) != null) {
                try {
                    runnable.run();
                }
                catch (RuntimeException runtimeException) {
                    log.log(Level.SEVERE, "Exception while executing runnable " + runnable, runtimeException);
                }
            }
        }
        finally {
            atomicHelper.runStateSet(this, 0);
        }
        if (!this.runQueue.isEmpty()) {
            this.schedule(null);
        }
    }

    private static final class SynchronizedAtomicHelper
    extends AtomicHelper {
        private SynchronizedAtomicHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean runStateCompareAndSet(SerializingExecutor serializingExecutor, int n2, int n3) {
            SerializingExecutor serializingExecutor2 = serializingExecutor;
            synchronized (serializingExecutor2) {
                if (serializingExecutor.runState == n2) {
                    serializingExecutor.runState = n3;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void runStateSet(SerializingExecutor serializingExecutor, int n2) {
            SerializingExecutor serializingExecutor2 = serializingExecutor;
            synchronized (serializingExecutor2) {
                serializingExecutor.runState = n2;
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FieldUpdaterAtomicHelper
    extends AtomicHelper {
        private final AtomicIntegerFieldUpdater<SerializingExecutor> runStateUpdater;

        private FieldUpdaterAtomicHelper(AtomicIntegerFieldUpdater<SerializingExecutor> atomicIntegerFieldUpdater) {
            this.runStateUpdater = atomicIntegerFieldUpdater;
        }

        @Override
        public final boolean runStateCompareAndSet(SerializingExecutor serializingExecutor, int n2, int n3) {
            return this.runStateUpdater.compareAndSet(serializingExecutor, n2, n3);
        }

        @Override
        public final void runStateSet(SerializingExecutor serializingExecutor, int n2) {
            this.runStateUpdater.set(serializingExecutor, n2);
        }
    }

    private static abstract class AtomicHelper {
        private AtomicHelper() {
        }

        public abstract boolean runStateCompareAndSet(SerializingExecutor var1, int var2, int var3);

        public abstract void runStateSet(SerializingExecutor var1, int var2);
    }
}

