/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import java.util.ArrayDeque;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

class SerializeReentrantCallsDirectExecutor
implements Executor {
    private static final Logger log = Logger.getLogger(SerializeReentrantCallsDirectExecutor.class.getName());
    private boolean executing;
    private ArrayDeque<Runnable> taskQueue;

    SerializeReentrantCallsDirectExecutor() {
    }

    public void execute(Runnable runnable) {
        b.a(runnable, (Object)"'task' must not be null.");
        if (!this.executing) {
            this.executing = true;
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                log.log(Level.SEVERE, "Exception while executing runnable " + runnable, throwable);
            }
            finally {
                if (this.taskQueue != null) {
                    this.completeQueuedTasks();
                }
                this.executing = false;
            }
        } else {
            this.enqueue(runnable);
        }
    }

    private void completeQueuedTasks() {
        Runnable runnable;
        while ((runnable = this.taskQueue.poll()) != null) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                log.log(Level.SEVERE, "Exception while executing runnable " + runnable, throwable);
            }
        }
    }

    private void enqueue(Runnable runnable) {
        if (this.taskQueue == null) {
            this.taskQueue = new ArrayDeque(4);
        }
        this.taskQueue.add(runnable);
    }
}

