/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.Attributes;
import com.appoptics.ext.io.grpc.ClientStreamTracer;
import com.appoptics.ext.io.grpc.Compressor;
import com.appoptics.ext.io.grpc.Deadline;
import com.appoptics.ext.io.grpc.DecompressorRegistry;
import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.MethodDescriptor;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.internal.ClientStream;
import com.appoptics.ext.io.grpc.internal.ClientStreamListener;
import com.appoptics.ext.io.grpc.internal.HedgingPolicy;
import com.appoptics.ext.io.grpc.internal.InsightBuilder;
import com.appoptics.ext.io.grpc.internal.NoopClientStream;
import com.appoptics.ext.io.grpc.internal.RetryPolicy;
import com.appoptics.ext.io.grpc.internal.StreamListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RetriableStream<ReqT>
implements ClientStream {
    static final Metadata.Key<String> GRPC_PREVIOUS_RPC_ATTEMPTS = Metadata.Key.of("grpc-previous-rpc-attempts", Metadata.ASCII_STRING_MARSHALLER);
    static final Metadata.Key<String> GRPC_RETRY_PUSHBACK_MS = Metadata.Key.of("grpc-retry-pushback-ms", Metadata.ASCII_STRING_MARSHALLER);
    private static final Status CANCELLED_BECAUSE_COMMITTED = Status.CANCELLED.withDescription("Stream thrown away because RetriableStream committed");
    private final MethodDescriptor<ReqT, ?> method;
    private final Executor callExecutor;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Metadata headers;
    private final RetryPolicy retryPolicy;
    private final HedgingPolicy hedgingPolicy;
    private final boolean isHedging;
    private final Object lock = new Object();
    private final ChannelBufferMeter channelBufferUsed;
    private final long perRpcBufferLimit;
    private final long channelBufferLimit;
    private final Throttle throttle;
    private final InsightBuilder closedSubstreamsInsight = new InsightBuilder();
    private volatile State state = new State(new ArrayList<BufferEntry>(8), Collections.<Substream>emptyList(), null, null, false, false, false, 0);
    private final AtomicBoolean noMoreTransparentRetry = new AtomicBoolean();
    private long perRpcBufferUsed;
    private ClientStreamListener masterListener;
    private FutureCanceller scheduledRetry;
    private FutureCanceller scheduledHedging;
    private long nextBackoffIntervalNanos;
    private static Random random = new Random();

    RetriableStream(MethodDescriptor<ReqT, ?> methodDescriptor, Metadata metadata, ChannelBufferMeter channelBufferMeter, long l2, long l3, Executor executor, ScheduledExecutorService scheduledExecutorService, RetryPolicy retryPolicy, HedgingPolicy hedgingPolicy, Throttle throttle) {
        this.method = methodDescriptor;
        this.channelBufferUsed = channelBufferMeter;
        this.perRpcBufferLimit = l2;
        this.channelBufferLimit = l3;
        this.callExecutor = executor;
        this.scheduledExecutorService = scheduledExecutorService;
        this.headers = metadata;
        this.retryPolicy = retryPolicy;
        if (retryPolicy != null) {
            this.nextBackoffIntervalNanos = retryPolicy.initialBackoffNanos;
        }
        this.hedgingPolicy = hedgingPolicy;
        b.a(retryPolicy == null || hedgingPolicy == null, (Object)"Should not provide both retryPolicy and hedgingPolicy");
        this.isHedging = hedgingPolicy != null;
        this.throttle = throttle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable commit(final Substream substream) {
        Object object = this.lock;
        synchronized (object) {
            Future<?> future;
            Future<?> future2;
            if (this.state.winningSubstream != null) {
                return null;
            }
            final Collection<Substream> collection = this.state.drainedSubstreams;
            this.state = this.state.committed(substream);
            this.channelBufferUsed.addAndGet(-this.perRpcBufferUsed);
            if (this.scheduledRetry != null) {
                future2 = this.scheduledRetry.markCancelled();
                this.scheduledRetry = null;
            } else {
                future2 = null;
            }
            if (this.scheduledHedging != null) {
                future = this.scheduledHedging.markCancelled();
                this.scheduledHedging = null;
            } else {
                future = null;
            }
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class CommitTask
            implements Runnable {
                CommitTask() {
                }

                @Override
                public void run() {
                    for (Substream substream2 : collection) {
                        if (substream2 == substream) continue;
                        substream2.stream.cancel(CANCELLED_BECAUSE_COMMITTED);
                    }
                    if (future2 != null) {
                        future2.cancel(false);
                    }
                    if (future != null) {
                        future.cancel(false);
                    }
                    RetriableStream.this.postCommit();
                }
            }
            return new CommitTask();
        }
    }

    abstract void postCommit();

    private void commitAndRun(Substream object) {
        if ((object = this.commit((Substream)object)) != null) {
            object.run();
        }
    }

    private Substream createSubstream(int n2) {
        Substream substream = new Substream(n2);
        Object object = new BufferSizeTracer(substream);
        object = new ClientStreamTracer.Factory((ClientStreamTracer)object){
            final /* synthetic */ ClientStreamTracer val$bufferSizeTracer;
            {
                this.val$bufferSizeTracer = clientStreamTracer;
            }

            public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo streamInfo, Metadata metadata) {
                return this.val$bufferSizeTracer;
            }
        };
        RetriableStream retriableStream = this;
        Metadata metadata = retriableStream.updateHeaders(retriableStream.headers, n2);
        substream.stream = this.newSubstream((ClientStreamTracer.Factory)object, metadata);
        return substream;
    }

    abstract ClientStream newSubstream(ClientStreamTracer.Factory var1, Metadata var2);

    final Metadata updateHeaders(Metadata metadata, int n2) {
        Metadata metadata2 = new Metadata();
        metadata2.merge(metadata);
        if (n2 > 0) {
            metadata2.put(GRPC_PREVIOUS_RPC_ATTEMPTS, String.valueOf(n2));
        }
        return metadata2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void drain(Substream var1_1) {
        var2_3 = 0;
        var3_4 = null;
        block3: while (true) {
            var5_6 = this.lock;
            synchronized (var5_6) {
                var4_5 = this.state;
                if (var4_5.winningSubstream != null && var4_5.winningSubstream != var1_1) {
                    break;
                }
                if (var2_3 == var4_5.buffer.size()) {
                    this.state = var4_5.substreamDrained(var1_1);
                    return;
                }
                if (var1_1.closed) {
                    return;
                }
                var6_7 = Math.min(var2_3 + 128, var4_5.buffer.size());
                if (var3_4 == null) {
                    var3_4 = new ArrayList<BufferEntry>(var4_5.buffer.subList(var2_3, var6_7));
                } else {
                    var3_4.clear();
                    var3_4.addAll(var4_5.buffer.subList(var2_3, var6_7));
                }
                var2_3 = var6_7;
            }
            var5_6 = var3_4.iterator();
            while (true) {
                if (!var5_6.hasNext()) continue block3;
                var6_8 = (BufferEntry)var5_6.next();
                var4_5 = this.state;
                if (var4_5.winningSubstream == null || var4_5.winningSubstream == var1_1) ** break;
                continue block3;
                if (var4_5.cancelled) {
                    b.b(var4_5.winningSubstream == var1_1, "substream should be CANCELLED_BECAUSE_COMMITTED already");
                    return;
                }
                var6_8.runWith(var1_1);
            }
            break;
        }
        var1_1.stream.cancel(RetriableStream.CANCELLED_BECAUSE_COMMITTED);
    }

    abstract Status prestart();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start(ClientStreamListener object) {
        this.masterListener = object;
        object = this.prestart();
        if (object != null) {
            this.cancel((Status)object);
            return;
        }
        object = this.lock;
        synchronized (object) {
            class StartEntry
            implements BufferEntry {
                StartEntry() {
                }

                public void runWith(Substream substream) {
                    substream.stream.start(new Sublistener(substream));
                }
            }
            this.state.buffer.add(new StartEntry());
        }
        object = this.createSubstream(0);
        if (this.isHedging) {
            FutureCanceller futureCanceller = null;
            Object object2 = this.lock;
            synchronized (object2) {
                this.state = this.state.addActiveHedge((Substream)object);
                RetriableStream retriableStream = this;
                if (retriableStream.hasPotentialHedging(retriableStream.state) && (this.throttle == null || this.throttle.isAboveThreshold())) {
                    this.scheduledHedging = futureCanceller = new FutureCanceller(this.lock);
                }
            }
            if (futureCanceller != null) {
                futureCanceller.setFuture(this.scheduledExecutorService.schedule(new HedgingRunnable(futureCanceller), this.hedgingPolicy.hedgingDelayNanos, TimeUnit.NANOSECONDS));
            }
        }
        this.drain((Substream)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushbackHedging(Integer n2) {
        FutureCanceller futureCanceller;
        Future<?> future;
        if (n2 == null) {
            return;
        }
        if (n2 < 0) {
            this.freezeHedging();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.scheduledHedging == null) {
                return;
            }
            future = this.scheduledHedging.markCancelled();
            this.scheduledHedging = futureCanceller = new FutureCanceller(this.lock);
        }
        if (future != null) {
            future.cancel(false);
        }
        futureCanceller.setFuture(this.scheduledExecutorService.schedule(new HedgingRunnable(futureCanceller), (long)n2.intValue(), TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cancel(Status object) {
        Object object2 = new Substream(0);
        new Substream(0).stream = new NoopClientStream();
        if ((object2 = this.commit((Substream)object2)) != null) {
            this.masterListener.closed((Status)object, new Metadata());
            object2.run();
            return;
        }
        this.state.winningSubstream.stream.cancel((Status)object);
        object = this.lock;
        synchronized (object) {
            this.state = this.state.cancelled();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayOrExecute(BufferEntry bufferEntry) {
        Object object;
        Iterator<Substream> iterator = this.lock;
        synchronized (iterator) {
            if (!this.state.passThrough) {
                this.state.buffer.add(bufferEntry);
            }
            object = this.state.drainedSubstreams;
        }
        iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            bufferEntry.runWith((Substream)object);
        }
    }

    @Override
    public final void writeMessage(InputStream inputStream) {
        throw new IllegalStateException("RetriableStream.writeMessage() should not be called directly");
    }

    final void sendMessage(final ReqT ReqT) {
        State state = this.state;
        if (state.passThrough) {
            state.winningSubstream.stream.writeMessage(this.method.streamRequest(ReqT));
            return;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SendMessageEntry
        implements BufferEntry {
            SendMessageEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.writeMessage(RetriableStream.this.method.streamRequest(ReqT));
            }
        }
        this.delayOrExecute(new SendMessageEntry());
    }

    @Override
    public final void request(final int n2) {
        State state = this.state;
        if (state.passThrough) {
            state.winningSubstream.stream.request(n2);
            return;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class RequestEntry
        implements BufferEntry {
            RequestEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.request(n2);
            }
        }
        this.delayOrExecute(new RequestEntry());
    }

    @Override
    public final void flush() {
        State state = this.state;
        if (state.passThrough) {
            state.winningSubstream.stream.flush();
            return;
        }
        class FlushEntry
        implements BufferEntry {
            FlushEntry() {
            }

            public void runWith(Substream substream) {
                substream.stream.flush();
            }
        }
        this.delayOrExecute(new FlushEntry());
    }

    @Override
    public void optimizeForDirectExecutor() {
        class OptimizeDirectEntry
        implements BufferEntry {
            OptimizeDirectEntry() {
            }

            public void runWith(Substream substream) {
                substream.stream.optimizeForDirectExecutor();
            }
        }
        this.delayOrExecute(new OptimizeDirectEntry());
    }

    @Override
    public final void setCompressor(final Compressor compressor) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CompressorEntry
        implements BufferEntry {
            CompressorEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.setCompressor(compressor);
            }
        }
        this.delayOrExecute(new CompressorEntry());
    }

    @Override
    public final void setFullStreamDecompression(final boolean bl) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class FullStreamDecompressionEntry
        implements BufferEntry {
            FullStreamDecompressionEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.setFullStreamDecompression(bl);
            }
        }
        this.delayOrExecute(new FullStreamDecompressionEntry());
    }

    @Override
    public final void halfClose() {
        class HalfCloseEntry
        implements BufferEntry {
            HalfCloseEntry() {
            }

            public void runWith(Substream substream) {
                substream.stream.halfClose();
            }
        }
        this.delayOrExecute(new HalfCloseEntry());
    }

    @Override
    public final void setAuthority(final String string) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class AuthorityEntry
        implements BufferEntry {
            AuthorityEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.setAuthority(string);
            }
        }
        this.delayOrExecute(new AuthorityEntry());
    }

    @Override
    public final void setDecompressorRegistry(final DecompressorRegistry decompressorRegistry) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DecompressorRegistryEntry
        implements BufferEntry {
            DecompressorRegistryEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.setDecompressorRegistry(decompressorRegistry);
            }
        }
        this.delayOrExecute(new DecompressorRegistryEntry());
    }

    @Override
    public final void setMaxInboundMessageSize(final int n2) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MaxInboundMessageSizeEntry
        implements BufferEntry {
            MaxInboundMessageSizeEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.setMaxInboundMessageSize(n2);
            }
        }
        this.delayOrExecute(new MaxInboundMessageSizeEntry());
    }

    @Override
    public final void setMaxOutboundMessageSize(final int n2) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MaxOutboundMessageSizeEntry
        implements BufferEntry {
            MaxOutboundMessageSizeEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.setMaxOutboundMessageSize(n2);
            }
        }
        this.delayOrExecute(new MaxOutboundMessageSizeEntry());
    }

    @Override
    public final void setDeadline(final Deadline deadline) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DeadlineEntry
        implements BufferEntry {
            DeadlineEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.setDeadline(deadline);
            }
        }
        this.delayOrExecute(new DeadlineEntry());
    }

    @Override
    public final Attributes getAttributes() {
        if (this.state.winningSubstream != null) {
            return this.state.winningSubstream.stream.getAttributes();
        }
        return Attributes.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendTimeoutInsight(InsightBuilder insightBuilder) {
        State state;
        Object object = this.lock;
        synchronized (object) {
            insightBuilder.appendKeyValue("closed", this.closedSubstreamsInsight);
            state = this.state;
        }
        if (state.winningSubstream != null) {
            object = new InsightBuilder();
            state.winningSubstream.stream.appendTimeoutInsight((InsightBuilder)object);
            insightBuilder.appendKeyValue("committed", object);
            return;
        }
        object = new InsightBuilder();
        for (Substream substream : state.drainedSubstreams) {
            InsightBuilder insightBuilder2 = new InsightBuilder();
            substream.stream.appendTimeoutInsight(insightBuilder2);
            ((InsightBuilder)object).append(insightBuilder2);
        }
        insightBuilder.appendKeyValue("open", object);
    }

    private boolean hasPotentialHedging(State state) {
        return state.winningSubstream == null && state.hedgingAttemptCount < this.hedgingPolicy.maxAttempts && !state.hedgingFrozen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freezeHedging() {
        Future<?> future = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.scheduledHedging != null) {
                future = this.scheduledHedging.markCancelled();
                this.scheduledHedging = null;
            }
            this.state = this.state.freezeHedging();
        }
        if (future != null) {
            future.cancel(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FutureCanceller {
        final Object lock;
        Future<?> future;
        boolean cancelled;

        FutureCanceller(Object object) {
            this.lock = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void setFuture(Future<?> future) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.cancelled) {
                    this.future = future;
                }
                return;
            }
        }

        final Future<?> markCancelled() {
            this.cancelled = true;
            return this.future;
        }

        final boolean isCancelled() {
            return this.cancelled;
        }
    }

    private static final class HedgingPlan {
        final boolean isHedgeable;
        final Integer hedgingPushbackMillis;

        public HedgingPlan(boolean bl, Integer n2) {
            this.isHedgeable = bl;
            this.hedgingPushbackMillis = n2;
        }
    }

    private static final class RetryPlan {
        final boolean shouldRetry;
        final long backoffNanos;

        RetryPlan(boolean bl, long l2) {
            this.shouldRetry = bl;
            this.backoffNanos = l2;
        }
    }

    static final class Throttle {
        final int maxTokens;
        final int threshold;
        final int tokenRatio;
        final AtomicInteger tokenCount = new AtomicInteger();

        Throttle(float f2, float f3) {
            this.tokenRatio = (int)(f3 * 1000.0f);
            this.maxTokens = (int)(f2 * 1000.0f);
            this.threshold = this.maxTokens / 2;
            this.tokenCount.set(this.maxTokens);
        }

        final boolean isAboveThreshold() {
            return this.tokenCount.get() > this.threshold;
        }

        final boolean onQualifiedFailureThenCheckIsAboveThreshold() {
            int n2;
            boolean bl;
            do {
                int n3;
                if ((n3 = this.tokenCount.get()) == 0) {
                    return false;
                }
                n2 = n3 - 1000;
                bl = this.tokenCount.compareAndSet(n3, Math.max(n2, 0));
                n3 = bl ? 1 : 0;
            } while (!bl);
            return n2 > this.threshold;
        }

        final void onSuccess() {
            int n2;
            while ((n2 = this.tokenCount.get()) != this.maxTokens) {
                int n3 = n2 + this.tokenRatio;
                boolean bl = this.tokenCount.compareAndSet(n2, Math.min(n3, this.maxTokens));
                n2 = bl ? 1 : 0;
                if (!bl) continue;
            }
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Throttle)) {
                return false;
            }
            object = (Throttle)object;
            return this.maxTokens == ((Throttle)object).maxTokens && this.tokenRatio == ((Throttle)object).tokenRatio;
        }

        public final int hashCode() {
            Object[] objectArray = new Object[]{this.maxTokens, this.tokenRatio};
            return Arrays.hashCode(objectArray);
        }
    }

    static final class ChannelBufferMeter {
        private final AtomicLong bufferUsed = new AtomicLong();

        ChannelBufferMeter() {
        }

        final long addAndGet(long l2) {
            return this.bufferUsed.addAndGet(l2);
        }
    }

    class BufferSizeTracer
    extends ClientStreamTracer {
        private final Substream substream;
        long bufferNeeded;

        BufferSizeTracer(Substream substream) {
            this.substream = substream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void outboundWireSize(long l2) {
            if (((RetriableStream)RetriableStream.this).state.winningSubstream != null) {
                return;
            }
            Runnable runnable = null;
            Object object = RetriableStream.this.lock;
            synchronized (object) {
                if (((RetriableStream)RetriableStream.this).state.winningSubstream != null || this.substream.closed) {
                    return;
                }
                this.bufferNeeded += l2;
                if (this.bufferNeeded <= RetriableStream.this.perRpcBufferUsed) {
                    return;
                }
                if (this.bufferNeeded > RetriableStream.this.perRpcBufferLimit) {
                    this.substream.bufferLimitExceeded = true;
                } else {
                    long l3 = RetriableStream.this.channelBufferUsed.addAndGet(this.bufferNeeded - RetriableStream.this.perRpcBufferUsed);
                    RetriableStream.this.perRpcBufferUsed = this.bufferNeeded;
                    if (l3 > RetriableStream.this.channelBufferLimit) {
                        this.substream.bufferLimitExceeded = true;
                    }
                }
                if (this.substream.bufferLimitExceeded) {
                    runnable = RetriableStream.this.commit(this.substream);
                }
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    private static final class Substream {
        ClientStream stream;
        boolean closed;
        boolean bufferLimitExceeded;
        final int previousAttemptCount;

        Substream(int n2) {
            this.previousAttemptCount = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class State {
        final boolean passThrough;
        final List<BufferEntry> buffer;
        final Collection<Substream> drainedSubstreams;
        final Collection<Substream> activeHedges;
        final int hedgingAttemptCount;
        final Substream winningSubstream;
        final boolean cancelled;
        final boolean hedgingFrozen;

        State(List<BufferEntry> list, Collection<Substream> collection, Collection<Substream> collection2, Substream substream, boolean bl, boolean bl2, boolean bl3, int n2) {
            this.buffer = list;
            this.drainedSubstreams = b.a(collection, (Object)"drainedSubstreams");
            this.winningSubstream = substream;
            this.activeHedges = collection2;
            this.cancelled = bl;
            this.passThrough = bl2;
            this.hedgingFrozen = bl3;
            this.hedgingAttemptCount = n2;
            b.b(!bl2 || list == null, "passThrough should imply buffer is null");
            b.b(!bl2 || substream != null, "passThrough should imply winningSubstream != null");
            b.b(!bl2 || collection.size() == 1 && collection.contains(substream) || collection.size() == 0 && substream.closed, "passThrough should imply winningSubstream is drained");
            b.b(!bl || substream != null, "cancelled should imply committed");
        }

        final State cancelled() {
            return new State(this.buffer, this.drainedSubstreams, this.activeHedges, this.winningSubstream, true, this.passThrough, this.hedgingFrozen, this.hedgingAttemptCount);
        }

        final State substreamDrained(Substream substream) {
            Collection<Substream> collection;
            b.b(!this.passThrough, "Already passThrough");
            if (substream.closed) {
                collection = this.drainedSubstreams;
            } else if (this.drainedSubstreams.isEmpty()) {
                collection = Collections.singletonList(substream);
            } else {
                collection = new ArrayList<Substream>(this.drainedSubstreams);
                collection.add(substream);
                collection = Collections.unmodifiableCollection(collection);
            }
            boolean bl = this.winningSubstream != null;
            List<BufferEntry> list = this.buffer;
            if (bl) {
                b.b(this.winningSubstream == substream, "Another RPC attempt has already committed");
                list = null;
            }
            return new State(list, collection, this.activeHedges, this.winningSubstream, this.cancelled, bl, this.hedgingFrozen, this.hedgingAttemptCount);
        }

        final State substreamClosed(Substream substream) {
            substream.closed = true;
            if (this.drainedSubstreams.contains(substream)) {
                Collection<Substream> collection = new ArrayList<Substream>(this.drainedSubstreams);
                collection.remove(substream);
                collection = Collections.unmodifiableCollection(collection);
                return new State(this.buffer, collection, this.activeHedges, this.winningSubstream, this.cancelled, this.passThrough, this.hedgingFrozen, this.hedgingAttemptCount);
            }
            return this;
        }

        final State committed(Substream substream) {
            Collection<Substream> collection;
            b.b(this.winningSubstream == null, "Already committed");
            boolean bl = false;
            List<BufferEntry> list = this.buffer;
            if (this.drainedSubstreams.contains(substream)) {
                bl = true;
                list = null;
                collection = Collections.singleton(substream);
            } else {
                collection = Collections.emptyList();
            }
            return new State(list, collection, this.activeHedges, substream, this.cancelled, bl, this.hedgingFrozen, this.hedgingAttemptCount);
        }

        final State freezeHedging() {
            if (this.hedgingFrozen) {
                return this;
            }
            return new State(this.buffer, this.drainedSubstreams, this.activeHedges, this.winningSubstream, this.cancelled, this.passThrough, true, this.hedgingAttemptCount);
        }

        final State addActiveHedge(Substream substream) {
            Collection<Substream> collection;
            b.b(!this.hedgingFrozen, "hedging frozen");
            b.b(this.winningSubstream == null, "already committed");
            if (this.activeHedges == null) {
                collection = Collections.singleton(substream);
            } else {
                collection = new ArrayList<Substream>(this.activeHedges);
                collection.add(substream);
                collection = Collections.unmodifiableCollection(collection);
            }
            int n2 = this.hedgingAttemptCount + 1;
            return new State(this.buffer, this.drainedSubstreams, collection, this.winningSubstream, this.cancelled, this.passThrough, this.hedgingFrozen, n2);
        }

        final State removeActiveHedge(Substream substream) {
            Collection<Substream> collection = new ArrayList<Substream>(this.activeHedges);
            collection.remove(substream);
            collection = Collections.unmodifiableCollection(collection);
            return new State(this.buffer, this.drainedSubstreams, collection, this.winningSubstream, this.cancelled, this.passThrough, this.hedgingFrozen, this.hedgingAttemptCount);
        }

        final State replaceActiveHedge(Substream substream, Substream substream2) {
            Collection<Substream> collection = new ArrayList<Substream>(this.activeHedges);
            collection.remove(substream);
            collection.add(substream2);
            collection = Collections.unmodifiableCollection(collection);
            return new State(this.buffer, this.drainedSubstreams, collection, this.winningSubstream, this.cancelled, this.passThrough, this.hedgingFrozen, this.hedgingAttemptCount);
        }
    }

    private final class Sublistener
    implements ClientStreamListener {
        final Substream substream;

        Sublistener(Substream substream) {
            this.substream = substream;
        }

        public final void headersRead(Metadata metadata) {
            RetriableStream.this.commitAndRun(this.substream);
            if (((RetriableStream)RetriableStream.this).state.winningSubstream == this.substream) {
                RetriableStream.this.masterListener.headersRead(metadata);
                if (RetriableStream.this.throttle != null) {
                    RetriableStream.this.throttle.onSuccess();
                }
            }
        }

        public final void closed(Status status, Metadata metadata) {
            this.closed(status, ClientStreamListener.RpcProgress.PROCESSED, metadata);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void closed(Status object, ClientStreamListener.RpcProgress object2, Metadata metadata) {
            Object object3 = RetriableStream.this.lock;
            synchronized (object3) {
                RetriableStream.this.state = RetriableStream.this.state.substreamClosed(this.substream);
                RetriableStream.this.closedSubstreamsInsight.append((Object)((Status)object).getCode());
            }
            if (this.substream.bufferLimitExceeded) {
                RetriableStream.this.commitAndRun(this.substream);
                if (((RetriableStream)RetriableStream.this).state.winningSubstream == this.substream) {
                    RetriableStream.this.masterListener.closed((Status)object, metadata);
                }
                return;
            }
            if (((RetriableStream)RetriableStream.this).state.winningSubstream == null) {
                if (object2 == ClientStreamListener.RpcProgress.REFUSED && RetriableStream.this.noMoreTransparentRetry.compareAndSet(false, true)) {
                    object3 = RetriableStream.this.createSubstream(this.substream.previousAttemptCount);
                    if (RetriableStream.this.isHedging) {
                        boolean bl = false;
                        object = RetriableStream.this.lock;
                        synchronized (object) {
                            RetriableStream.this.state = RetriableStream.this.state.replaceActiveHedge(this.substream, (Substream)object3);
                            if (!RetriableStream.this.hasPotentialHedging(RetriableStream.this.state) && ((RetriableStream)RetriableStream.this).state.activeHedges.size() == 1) {
                                bl = true;
                            }
                        }
                        if (bl) {
                            RetriableStream.this.commitAndRun((Substream)object3);
                        }
                    } else if (RetriableStream.this.retryPolicy == null || ((RetriableStream)RetriableStream.this).retryPolicy.maxAttempts == 1) {
                        RetriableStream.this.commitAndRun((Substream)object3);
                    }
                    RetriableStream.this.callExecutor.execute(new Runnable((Substream)object3){
                        final /* synthetic */ Substream val$newSubstream;
                        {
                            this.val$newSubstream = substream;
                        }

                        public void run() {
                            RetriableStream.this.drain(this.val$newSubstream);
                        }
                    });
                    return;
                }
                if (object2 == ClientStreamListener.RpcProgress.DROPPED) {
                    if (RetriableStream.this.isHedging) {
                        RetriableStream.this.freezeHedging();
                    }
                } else {
                    RetriableStream.this.noMoreTransparentRetry.set(true);
                    if (RetriableStream.this.isHedging) {
                        object3 = this.makeHedgingDecision((Status)object, metadata);
                        if (((HedgingPlan)object3).isHedgeable) {
                            RetriableStream.this.pushbackHedging(((HedgingPlan)object3).hedgingPushbackMillis);
                        }
                        object2 = RetriableStream.this.lock;
                        synchronized (object2) {
                            RetriableStream.this.state = RetriableStream.this.state.removeActiveHedge(this.substream);
                            if (((HedgingPlan)object3).isHedgeable && (RetriableStream.this.hasPotentialHedging(RetriableStream.this.state) || !((RetriableStream)RetriableStream.this).state.activeHedges.isEmpty())) {
                                return;
                            }
                        }
                    }
                    object3 = this.makeRetryDecision((Status)object, metadata);
                    if (((RetryPlan)object3).shouldRetry) {
                        object = RetriableStream.this.lock;
                        synchronized (object) {
                            object2 = new FutureCanceller(RetriableStream.this.lock);
                            RetriableStream.this.scheduledRetry = (FutureCanceller)object2;
                        }
                        ((FutureCanceller)object2).setFuture(RetriableStream.this.scheduledExecutorService.schedule(new Runnable(){

                            public void run() {
                                RetriableStream.this.callExecutor.execute(new Runnable(){

                                    public void run() {
                                        Substream substream = RetriableStream.this.createSubstream(Sublistener.this.substream.previousAttemptCount + 1);
                                        RetriableStream.this.drain(substream);
                                    }
                                });
                            }
                        }, ((RetryPlan)object3).backoffNanos, TimeUnit.NANOSECONDS));
                        return;
                    }
                }
            }
            RetriableStream.this.commitAndRun(this.substream);
            if (((RetriableStream)RetriableStream.this).state.winningSubstream == this.substream) {
                RetriableStream.this.masterListener.closed((Status)object, metadata);
            }
        }

        private RetryPlan makeRetryDecision(Status status, Metadata object) {
            if (RetriableStream.this.retryPolicy == null) {
                return new RetryPlan(false, 0L);
            }
            boolean bl = false;
            long l2 = 0L;
            boolean bl2 = ((RetriableStream)RetriableStream.this).retryPolicy.retryableStatusCodes.contains((Object)status.getCode());
            object = this.getPushbackMills((Metadata)object);
            boolean bl3 = false;
            if (RetriableStream.this.throttle != null && (bl2 || object != null && (Integer)object < 0)) {
                boolean bl4 = bl3 = !RetriableStream.this.throttle.onQualifiedFailureThenCheckIsAboveThreshold();
            }
            if (((RetriableStream)RetriableStream.this).retryPolicy.maxAttempts > this.substream.previousAttemptCount + 1 && !bl3) {
                if (object == null) {
                    if (bl2) {
                        bl = true;
                        l2 = (long)((double)RetriableStream.this.nextBackoffIntervalNanos * random.nextDouble());
                        RetriableStream.this.nextBackoffIntervalNanos = Math.min((long)((double)RetriableStream.this.nextBackoffIntervalNanos * ((RetriableStream)RetriableStream.this).retryPolicy.backoffMultiplier), ((RetriableStream)RetriableStream.this).retryPolicy.maxBackoffNanos);
                    }
                } else if ((Integer)object >= 0) {
                    bl = true;
                    l2 = TimeUnit.MILLISECONDS.toNanos(((Integer)object).intValue());
                    RetriableStream.this.nextBackoffIntervalNanos = ((RetriableStream)RetriableStream.this).retryPolicy.initialBackoffNanos;
                }
            }
            return new RetryPlan(bl, l2);
        }

        private HedgingPlan makeHedgingDecision(Status status, Metadata object) {
            object = this.getPushbackMills((Metadata)object);
            boolean bl = !((RetriableStream)RetriableStream.this).hedgingPolicy.nonFatalStatusCodes.contains((Object)status.getCode());
            boolean bl2 = false;
            if (RetriableStream.this.throttle != null && (!bl || object != null && (Integer)object < 0)) {
                bl2 = !RetriableStream.this.throttle.onQualifiedFailureThenCheckIsAboveThreshold();
            }
            return new HedgingPlan(!bl && !bl2, (Integer)object);
        }

        private Integer getPushbackMills(Metadata object) {
            object = ((Metadata)object).get(GRPC_RETRY_PUSHBACK_MS);
            Integer n2 = null;
            if (object != null) {
                try {
                    n2 = Integer.valueOf((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = -1;
                }
            }
            return n2;
        }

        public final void messagesAvailable(StreamListener.MessageProducer messageProducer) {
            State state = RetriableStream.this.state;
            b.b(state.winningSubstream != null, "Headers should be received prior to messages.");
            if (state.winningSubstream != this.substream) {
                return;
            }
            RetriableStream.this.masterListener.messagesAvailable(messageProducer);
        }

        public final void onReady() {
            RetriableStream.this.masterListener.onReady();
        }
    }

    private static interface BufferEntry {
        public void runWith(Substream var1);
    }

    private final class HedgingRunnable
    implements Runnable {
        final FutureCanceller scheduledHedgingRef;

        HedgingRunnable(FutureCanceller futureCanceller) {
            this.scheduledHedgingRef = futureCanceller;
        }

        public final void run() {
            RetriableStream.this.callExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Substream substream = RetriableStream.this.createSubstream(((RetriableStream)RetriableStream.this).state.hedgingAttemptCount);
                    boolean bl = false;
                    FutureCanceller futureCanceller = null;
                    Object object = RetriableStream.this.lock;
                    synchronized (object) {
                        if (HedgingRunnable.this.scheduledHedgingRef.isCancelled()) {
                            bl = true;
                        } else {
                            RetriableStream.this.state = RetriableStream.this.state.addActiveHedge(substream);
                            if (RetriableStream.this.hasPotentialHedging(RetriableStream.this.state) && (RetriableStream.this.throttle == null || RetriableStream.this.throttle.isAboveThreshold())) {
                                futureCanceller = new FutureCanceller(RetriableStream.this.lock);
                                RetriableStream.this.scheduledHedging = futureCanceller;
                            } else {
                                RetriableStream.this.state = RetriableStream.this.state.freezeHedging();
                                RetriableStream.this.scheduledHedging = null;
                            }
                        }
                    }
                    if (bl) {
                        substream.stream.cancel(Status.CANCELLED.withDescription("Unneeded hedging"));
                        return;
                    }
                    if (futureCanceller != null) {
                        futureCanceller.setFuture(RetriableStream.this.scheduledExecutorService.schedule(new HedgingRunnable(futureCanceller), ((RetriableStream)RetriableStream.this).hedgingPolicy.hedgingDelayNanos, TimeUnit.NANOSECONDS));
                    }
                    RetriableStream.this.drain(substream);
                }
            });
        }
    }
}

