/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.CallCredentials;
import com.appoptics.ext.io.grpc.CallOptions;
import com.appoptics.ext.io.grpc.Context;
import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.MethodDescriptor;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.internal.ClientStream;
import com.appoptics.ext.io.grpc.internal.ClientTransport;
import com.appoptics.ext.io.grpc.internal.DelayedStream;
import com.appoptics.ext.io.grpc.internal.FailingClientStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MetadataApplierImpl
extends CallCredentials.MetadataApplier {
    private final ClientTransport transport;
    private final MethodDescriptor<?, ?> method;
    private final Metadata origHeaders;
    private final CallOptions callOptions;
    private final Context ctx;
    private final Object lock = new Object();
    private ClientStream returnedStream;
    boolean finalized;
    DelayedStream delayedStream;

    MetadataApplierImpl(ClientTransport clientTransport, MethodDescriptor<?, ?> methodDescriptor, Metadata metadata, CallOptions callOptions) {
        this.transport = clientTransport;
        this.method = methodDescriptor;
        this.origHeaders = metadata;
        this.callOptions = callOptions;
        this.ctx = Context.current();
    }

    public final void fail(Status status) {
        b.a(!status.isOk(), (Object)"Cannot fail with OK status");
        b.b(!this.finalized, "apply() or fail() already called");
        this.finalizeWith(new FailingClientStream(status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeWith(ClientStream clientStream) {
        b.b(!this.finalized, "already finalized");
        this.finalized = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.returnedStream == null) {
                this.returnedStream = clientStream;
                return;
            }
        }
        b.b(this.delayedStream != null, "delayedStream is null");
        this.delayedStream.setStream(clientStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ClientStream returnStream() {
        Object object = this.lock;
        synchronized (object) {
            if (this.returnedStream == null) {
                this.delayedStream = new DelayedStream();
                this.returnedStream = this.delayedStream;
                return this.returnedStream;
            }
            return this.returnedStream;
        }
    }
}

