/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.Codec;
import com.appoptics.ext.io.grpc.Decompressor;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.internal.CompositeReadableBuffer;
import com.appoptics.ext.io.grpc.internal.Deframer;
import com.appoptics.ext.io.grpc.internal.GzipInflatingBuffer;
import com.appoptics.ext.io.grpc.internal.ReadableBuffer;
import com.appoptics.ext.io.grpc.internal.ReadableBuffers;
import com.appoptics.ext.io.grpc.internal.StatsTraceContext;
import com.appoptics.ext.io.grpc.internal.StreamListener;
import com.appoptics.ext.io.grpc.internal.TransportTracer;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;

public class MessageDeframer
implements Deframer,
Closeable {
    private Listener listener;
    private int maxInboundMessageSize;
    private final StatsTraceContext statsTraceCtx;
    private final TransportTracer transportTracer;
    private Decompressor decompressor;
    private GzipInflatingBuffer fullStreamDecompressor;
    private byte[] inflatedBuffer;
    private int inflatedIndex;
    private State state = State.HEADER;
    private int requiredLength = 5;
    private boolean compressedFlag;
    private CompositeReadableBuffer nextFrame;
    private CompositeReadableBuffer unprocessed = new CompositeReadableBuffer();
    private long pendingDeliveries;
    private boolean inDelivery = false;
    private int currentMessageSeqNo = -1;
    private int inboundBodyWireSize;
    private boolean closeWhenComplete = false;
    private volatile boolean stopDelivery = false;

    public MessageDeframer(Listener listener, Decompressor decompressor, int n2, StatsTraceContext statsTraceContext, TransportTracer transportTracer) {
        this.listener = b.a(listener, (Object)"sink");
        this.decompressor = b.a(decompressor, (Object)"decompressor");
        this.maxInboundMessageSize = n2;
        this.statsTraceCtx = b.a(statsTraceContext, (Object)"statsTraceCtx");
        this.transportTracer = b.a(transportTracer, (Object)"transportTracer");
    }

    void setListener(Listener listener) {
        this.listener = listener;
    }

    public void setMaxInboundMessageSize(int n2) {
        this.maxInboundMessageSize = n2;
    }

    public void setDecompressor(Decompressor decompressor) {
        b.b(this.fullStreamDecompressor == null, "Already set full stream decompressor");
        this.decompressor = b.a(decompressor, (Object)"Can't pass an empty decompressor");
    }

    public void setFullStreamDecompressor(GzipInflatingBuffer gzipInflatingBuffer) {
        b.b(this.decompressor == Codec.Identity.NONE, "per-message decompressor already set");
        b.b(this.fullStreamDecompressor == null, "full stream decompressor already set");
        this.fullStreamDecompressor = b.a(gzipInflatingBuffer, (Object)"Can't pass a null full stream decompressor");
        this.unprocessed = null;
    }

    public void request(int n2) {
        b.a(n2 > 0, (Object)"numMessages must be > 0");
        if (this.isClosed()) {
            return;
        }
        this.pendingDeliveries += (long)n2;
        this.deliver();
    }

    public void deframe(ReadableBuffer readableBuffer) {
        b.a(readableBuffer, (Object)"data");
        boolean bl = true;
        try {
            if (!this.isClosedOrScheduledToClose()) {
                if (this.fullStreamDecompressor != null) {
                    this.fullStreamDecompressor.addGzippedBytes(readableBuffer);
                } else {
                    this.unprocessed.addBuffer(readableBuffer);
                }
                bl = false;
                this.deliver();
            }
            if (bl) {
                readableBuffer.close();
                return;
            }
        }
        catch (Throwable throwable) {
            if (bl) {
                readableBuffer.close();
            }
            throw throwable;
        }
    }

    public void closeWhenComplete() {
        if (this.isClosed()) {
            return;
        }
        if (this.isStalled()) {
            this.close();
            return;
        }
        this.closeWhenComplete = true;
    }

    void stopDelivery() {
        this.stopDelivery = true;
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        boolean bl = this.nextFrame != null && this.nextFrame.readableBytes() > 0;
        try {
            if (this.fullStreamDecompressor != null) {
                bl = bl || this.fullStreamDecompressor.hasPartialData();
                this.fullStreamDecompressor.close();
            }
            if (this.unprocessed != null) {
                this.unprocessed.close();
            }
            if (this.nextFrame != null) {
                this.nextFrame.close();
            }
        }
        finally {
            this.fullStreamDecompressor = null;
            this.unprocessed = null;
            this.nextFrame = null;
        }
        this.listener.deframerClosed(bl);
    }

    public boolean isClosed() {
        return this.unprocessed == null && this.fullStreamDecompressor == null;
    }

    private boolean isClosedOrScheduledToClose() {
        return this.isClosed() || this.closeWhenComplete;
    }

    private boolean isStalled() {
        if (this.fullStreamDecompressor != null) {
            return this.fullStreamDecompressor.isStalled();
        }
        return this.unprocessed.readableBytes() == 0;
    }

    private void deliver() {
        if (this.inDelivery) {
            return;
        }
        this.inDelivery = true;
        try {
            block8: while (!this.stopDelivery && this.pendingDeliveries > 0L && this.readRequiredBytes()) {
                switch (this.state) {
                    case HEADER: {
                        this.processHeader();
                        continue block8;
                    }
                    case BODY: {
                        this.processBody();
                        --this.pendingDeliveries;
                        continue block8;
                    }
                }
                throw new AssertionError((Object)("Invalid state: " + (Object)((Object)this.state)));
            }
            if (this.stopDelivery) {
                this.close();
                return;
            }
            if (this.closeWhenComplete && this.isStalled()) {
                this.close();
            }
            return;
        }
        finally {
            this.inDelivery = false;
        }
    }

    private boolean readRequiredBytes() {
        int n2 = 0;
        int n3 = 0;
        try {
            int n4;
            if (this.nextFrame == null) {
                this.nextFrame = new CompositeReadableBuffer();
            }
            while ((n4 = this.requiredLength - this.nextFrame.readableBytes()) > 0) {
                if (this.fullStreamDecompressor != null) {
                    block17: {
                        if (this.inflatedBuffer == null || this.inflatedIndex == this.inflatedBuffer.length) {
                            this.inflatedBuffer = new byte[Math.min(n4, 0x200000)];
                            this.inflatedIndex = 0;
                        }
                        n4 = Math.min(n4, this.inflatedBuffer.length - this.inflatedIndex);
                        n4 = this.fullStreamDecompressor.inflateBytes(this.inflatedBuffer, this.inflatedIndex, n4);
                        n2 += this.fullStreamDecompressor.getAndResetBytesConsumed();
                        n3 += this.fullStreamDecompressor.getAndResetDeflatedBytesConsumed();
                        if (n4 != 0) break block17;
                        return false;
                    }
                    try {
                        this.nextFrame.addBuffer(ReadableBuffers.wrap(this.inflatedBuffer, this.inflatedIndex, n4));
                        this.inflatedIndex += n4;
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    catch (DataFormatException dataFormatException) {
                        throw new RuntimeException(dataFormatException);
                    }
                }
            }
            return true;
        }
        finally {
            if (n2 > 0) {
                this.listener.bytesRead(n2);
                if (this.state == State.BODY) {
                    if (this.fullStreamDecompressor != null) {
                        this.statsTraceCtx.inboundWireSize(n3);
                        this.inboundBodyWireSize += n3;
                    } else {
                        this.statsTraceCtx.inboundWireSize(n2);
                        this.inboundBodyWireSize += n2;
                    }
                }
            }
        }
    }

    private void processHeader() {
        int n2 = this.nextFrame.readUnsignedByte();
        if ((n2 & 0xFE) != 0) {
            throw Status.INTERNAL.withDescription("gRPC frame header malformed: reserved bits not zero").asRuntimeException();
        }
        this.compressedFlag = (n2 & 1) != 0;
        this.requiredLength = this.nextFrame.readInt();
        if (this.requiredLength < 0 || this.requiredLength > this.maxInboundMessageSize) {
            throw Status.RESOURCE_EXHAUSTED.withDescription(String.format("gRPC message exceeds maximum size %d: %d", this.maxInboundMessageSize, this.requiredLength)).asRuntimeException();
        }
        ++this.currentMessageSeqNo;
        this.statsTraceCtx.inboundMessage(this.currentMessageSeqNo);
        this.transportTracer.reportMessageReceived();
        this.state = State.BODY;
    }

    private void processBody() {
        this.statsTraceCtx.inboundMessageRead(this.currentMessageSeqNo, this.inboundBodyWireSize, -1L);
        this.inboundBodyWireSize = 0;
        InputStream inputStream = this.compressedFlag ? this.getCompressedBody() : this.getUncompressedBody();
        this.nextFrame = null;
        this.listener.messagesAvailable(new SingleMessageProducer(inputStream));
        this.state = State.HEADER;
        this.requiredLength = 5;
    }

    private InputStream getUncompressedBody() {
        this.statsTraceCtx.inboundUncompressedSize(this.nextFrame.readableBytes());
        return ReadableBuffers.openStream(this.nextFrame, true);
    }

    private InputStream getCompressedBody() {
        if (this.decompressor == Codec.Identity.NONE) {
            throw Status.INTERNAL.withDescription("Can't decode compressed gRPC message as compression not configured").asRuntimeException();
        }
        try {
            InputStream inputStream = this.decompressor.decompress(ReadableBuffers.openStream(this.nextFrame, true));
            return new SizeEnforcingInputStream(inputStream, this.maxInboundMessageSize, this.statsTraceCtx);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static class SingleMessageProducer
    implements StreamListener.MessageProducer {
        private InputStream message;

        private SingleMessageProducer(InputStream inputStream) {
            this.message = inputStream;
        }

        public InputStream next() {
            InputStream inputStream = this.message;
            this.message = null;
            return inputStream;
        }
    }

    static final class SizeEnforcingInputStream
    extends FilterInputStream {
        private final int maxMessageSize;
        private final StatsTraceContext statsTraceCtx;
        private long maxCount;
        private long count;
        private long mark = -1L;

        SizeEnforcingInputStream(InputStream inputStream, int n2, StatsTraceContext statsTraceContext) {
            super(inputStream);
            this.maxMessageSize = n2;
            this.statsTraceCtx = statsTraceContext;
        }

        public final int read() throws IOException {
            int n2 = this.in.read();
            if (n2 != -1) {
                ++this.count;
            }
            this.verifySize();
            this.reportCount();
            return n2;
        }

        public final int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4 = this.in.read(byArray, n2, n3);
            if (n4 != -1) {
                this.count += (long)n4;
            }
            this.verifySize();
            this.reportCount();
            return n4;
        }

        public final long skip(long l2) throws IOException {
            long l3 = this.in.skip(l2);
            this.count += l3;
            this.verifySize();
            this.reportCount();
            return l3;
        }

        public final synchronized void mark(int n2) {
            this.in.mark(n2);
            this.mark = this.count;
        }

        public final synchronized void reset() throws IOException {
            if (!this.in.markSupported()) {
                throw new IOException("Mark not supported");
            }
            if (this.mark == -1L) {
                throw new IOException("Mark not set");
            }
            this.in.reset();
            this.count = this.mark;
        }

        private void reportCount() {
            if (this.count > this.maxCount) {
                this.statsTraceCtx.inboundUncompressedSize(this.count - this.maxCount);
                this.maxCount = this.count;
            }
        }

        private void verifySize() {
            if (this.count > (long)this.maxMessageSize) {
                throw Status.RESOURCE_EXHAUSTED.withDescription(String.format("Compressed gRPC message exceeds maximum size %d: %d bytes read", this.maxMessageSize, this.count)).asRuntimeException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        HEADER,
        BODY;

    }

    public static interface Listener {
        public void bytesRead(int var1);

        public void messagesAvailable(StreamListener.MessageProducer var1);

        public void deframerClosed(boolean var1);

        public void deframeFailed(Throwable var1);
    }
}

