/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.CallOptions;
import com.appoptics.ext.io.grpc.InternalConfigSelector;
import com.appoptics.ext.io.grpc.LoadBalancer;
import com.appoptics.ext.io.grpc.MethodDescriptor;
import com.appoptics.ext.io.grpc.internal.HedgingPolicy;
import com.appoptics.ext.io.grpc.internal.RetriableStream;
import com.appoptics.ext.io.grpc.internal.RetryPolicy;
import com.appoptics.ext.io.grpc.internal.ServiceConfigUtil;
import com.tracelytics.a.d.a.a.d;
import com.tracelytics.a.d.a.a.g;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ManagedChannelServiceConfig {
    private final MethodInfo defaultMethodConfig;
    private final Map<String, MethodInfo> serviceMethodMap;
    private final Map<String, MethodInfo> serviceMap;
    private final RetriableStream.Throttle retryThrottling;
    private final Object loadBalancingConfig;
    private final Map<String, ?> healthCheckingConfig;

    ManagedChannelServiceConfig(MethodInfo methodInfo, Map<String, MethodInfo> map, Map<String, MethodInfo> map2, RetriableStream.Throttle throttle, Object object, Map<String, ?> map3) {
        this.defaultMethodConfig = methodInfo;
        this.serviceMethodMap = Collections.unmodifiableMap(new HashMap<String, MethodInfo>(map));
        this.serviceMap = Collections.unmodifiableMap(new HashMap<String, MethodInfo>(map2));
        this.retryThrottling = throttle;
        this.loadBalancingConfig = object;
        this.healthCheckingConfig = map3 != null ? Collections.unmodifiableMap(new HashMap(map3)) : null;
    }

    static ManagedChannelServiceConfig empty() {
        return new ManagedChannelServiceConfig(null, new HashMap<String, MethodInfo>(), new HashMap<String, MethodInfo>(), null, null, null);
    }

    static ManagedChannelServiceConfig fromServiceConfig(Map<String, ?> map, boolean bl, int n2, int n3, Object object) {
        RetriableStream.Throttle throttle = null;
        if (bl) {
            throttle = ServiceConfigUtil.getThrottlePolicy(map);
        }
        HashMap<String, MethodInfo> hashMap = new HashMap<String, MethodInfo>();
        HashMap<String, MethodInfo> hashMap2 = new HashMap<String, MethodInfo>();
        Map<String, ?> map2 = ServiceConfigUtil.getHealthCheckedService(map);
        List<Map<String, ?>> list = ServiceConfigUtil.getMethodConfigFromServiceConfig(map);
        if (list == null) {
            return new ManagedChannelServiceConfig(null, hashMap, hashMap2, throttle, object, map2);
        }
        MethodInfo methodInfo = null;
        for (Map map3 : list) {
            MethodInfo methodInfo2 = new MethodInfo(map3, bl, n2, n3);
            List<Map<String, ?>> list2 = ServiceConfigUtil.getNameListFromMethodConfig(map3);
            if (list2 == null || list2.isEmpty()) continue;
            for (Object object2 : list2) {
                String string = ServiceConfigUtil.getServiceFromName(object2);
                object2 = ServiceConfigUtil.getMethodFromName(object2);
                if (d.b(string)) {
                    b.a(d.b((String)object2), "missing service name for method %s", object2);
                    b.a(methodInfo == null, "Duplicate default method config in service config %s", map);
                    methodInfo = methodInfo2;
                    continue;
                }
                if (d.b((String)object2)) {
                    b.a(!hashMap2.containsKey(string), "Duplicate service %s", (Object)string);
                    hashMap2.put(string, methodInfo2);
                    continue;
                }
                b.a(!hashMap.containsKey(object2 = MethodDescriptor.generateFullMethodName(string, (String)object2)), "Duplicate method name %s", object2);
                hashMap.put((String)object2, methodInfo2);
            }
        }
        return new ManagedChannelServiceConfig(methodInfo, hashMap, hashMap2, throttle, object, map2);
    }

    final Map<String, ?> getHealthCheckingConfig() {
        return this.healthCheckingConfig;
    }

    final InternalConfigSelector getDefaultConfigSelector() {
        if (this.serviceMap.isEmpty() && this.serviceMethodMap.isEmpty() && this.defaultMethodConfig == null) {
            return null;
        }
        return new InternalConfigSelector(){

            public InternalConfigSelector.Result selectConfig(LoadBalancer.PickSubchannelArgs pickSubchannelArgs) {
                return InternalConfigSelector.Result.newBuilder().setConfig(ManagedChannelServiceConfig.this).setCallOptions(pickSubchannelArgs.getCallOptions()).build();
            }
        };
    }

    final Object getLoadBalancingConfig() {
        return this.loadBalancingConfig;
    }

    final RetriableStream.Throttle getRetryThrottling() {
        return this.retryThrottling;
    }

    final MethodInfo getMethodConfig(MethodDescriptor<?, ?> object) {
        MethodInfo methodInfo = this.serviceMethodMap.get(((MethodDescriptor)object).getFullMethodName());
        if (methodInfo == null) {
            object = ((MethodDescriptor)object).getServiceName();
            methodInfo = this.serviceMap.get(object);
        }
        if (methodInfo == null) {
            methodInfo = this.defaultMethodConfig;
        }
        return methodInfo;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (ManagedChannelServiceConfig)object;
        return d.a(this.serviceMethodMap, ((ManagedChannelServiceConfig)object).serviceMethodMap) && d.a(this.serviceMap, ((ManagedChannelServiceConfig)object).serviceMap) && d.a(this.retryThrottling, (Object)((ManagedChannelServiceConfig)object).retryThrottling) && d.a(this.loadBalancingConfig, ((ManagedChannelServiceConfig)object).loadBalancingConfig);
    }

    public final int hashCode() {
        Object[] objectArray = new Object[]{this.serviceMethodMap, this.serviceMap, this.retryThrottling, this.loadBalancingConfig};
        return Arrays.hashCode(objectArray);
    }

    public final String toString() {
        return g.a(this).a("serviceMethodMap", this.serviceMethodMap).a("serviceMap", this.serviceMap).a("retryThrottling", this.retryThrottling).a("loadBalancingConfig", this.loadBalancingConfig).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MethodInfo {
        static final CallOptions.Key<MethodInfo> KEY = CallOptions.Key.create("com.appoptics.ext.io.grpc.internal.ManagedChannelServiceConfig.MethodInfo");
        final Long timeoutNanos;
        final Boolean waitForReady;
        final Integer maxInboundMessageSize;
        final Integer maxOutboundMessageSize;
        final RetryPolicy retryPolicy;
        final HedgingPolicy hedgingPolicy;

        MethodInfo(Map<String, ?> map, boolean bl, int n2, int n3) {
            this.timeoutNanos = ServiceConfigUtil.getTimeoutFromMethodConfig(map);
            this.waitForReady = ServiceConfigUtil.getWaitForReadyFromMethodConfig(map);
            this.maxInboundMessageSize = ServiceConfigUtil.getMaxResponseMessageBytesFromMethodConfig(map);
            if (this.maxInboundMessageSize != null) {
                b.a(this.maxInboundMessageSize >= 0, "maxInboundMessageSize %s exceeds bounds", (Object)this.maxInboundMessageSize);
            }
            this.maxOutboundMessageSize = ServiceConfigUtil.getMaxRequestMessageBytesFromMethodConfig(map);
            if (this.maxOutboundMessageSize != null) {
                b.a(this.maxOutboundMessageSize >= 0, "maxOutboundMessageSize %s exceeds bounds", (Object)this.maxOutboundMessageSize);
            }
            Map<String, ?> map2 = bl ? ServiceConfigUtil.getRetryPolicyFromMethodConfig(map) : null;
            this.retryPolicy = map2 == null ? null : MethodInfo.retryPolicy(map2, n2);
            map = bl ? ServiceConfigUtil.getHedgingPolicyFromMethodConfig(map) : null;
            this.hedgingPolicy = map == null ? null : MethodInfo.hedgingPolicy(map, n3);
        }

        public final int hashCode() {
            Object[] objectArray = new Object[]{this.timeoutNanos, this.waitForReady, this.maxInboundMessageSize, this.maxOutboundMessageSize, this.retryPolicy, this.hedgingPolicy};
            return Arrays.hashCode(objectArray);
        }

        public final boolean equals(Object object) {
            if (!(object instanceof MethodInfo)) {
                return false;
            }
            object = (MethodInfo)object;
            return d.a(this.timeoutNanos, (Object)((MethodInfo)object).timeoutNanos) && d.a(this.waitForReady, (Object)((MethodInfo)object).waitForReady) && d.a(this.maxInboundMessageSize, (Object)((MethodInfo)object).maxInboundMessageSize) && d.a(this.maxOutboundMessageSize, (Object)((MethodInfo)object).maxOutboundMessageSize) && d.a(this.retryPolicy, (Object)((MethodInfo)object).retryPolicy) && d.a(this.hedgingPolicy, (Object)((MethodInfo)object).hedgingPolicy);
        }

        public final String toString() {
            return g.a(this).a("timeoutNanos", this.timeoutNanos).a("waitForReady", this.waitForReady).a("maxInboundMessageSize", this.maxInboundMessageSize).a("maxOutboundMessageSize", this.maxOutboundMessageSize).a("retryPolicy", this.retryPolicy).a("hedgingPolicy", this.hedgingPolicy).toString();
        }

        private static RetryPolicy retryPolicy(Map<String, ?> map, int n2) {
            double d2;
            int n3 = b.a(ServiceConfigUtil.getMaxAttemptsFromRetryPolicy(map), (Object)"maxAttempts cannot be empty");
            b.a(n3 >= 2, "maxAttempts must be greater than 1: %s", n3);
            n3 = Math.min(n3, n2);
            long l2 = b.a(ServiceConfigUtil.getInitialBackoffNanosFromRetryPolicy(map), (Object)"initialBackoff cannot be empty");
            b.a(l2 > 0L, "initialBackoffNanos must be greater than 0: %s", l2);
            long l3 = b.a(ServiceConfigUtil.getMaxBackoffNanosFromRetryPolicy(map), (Object)"maxBackoff cannot be empty");
            b.a(l3 > 0L, "maxBackoff must be greater than 0: %s", l3);
            double d3 = b.a(ServiceConfigUtil.getBackoffMultiplierFromRetryPolicy(map), (Object)"backoffMultiplier cannot be empty");
            b.a(d2 > 0.0, "backoffMultiplier must be greater than 0: %s", (Object)d3);
            return new RetryPolicy(n3, l2, l3, d3, ServiceConfigUtil.getRetryableStatusCodesFromRetryPolicy(map));
        }

        private static HedgingPolicy hedgingPolicy(Map<String, ?> map, int n2) {
            int n3 = b.a(ServiceConfigUtil.getMaxAttemptsFromHedgingPolicy(map), (Object)"maxAttempts cannot be empty");
            b.a(n3 >= 2, "maxAttempts must be greater than 1: %s", n3);
            n3 = Math.min(n3, n2);
            long l2 = b.a(ServiceConfigUtil.getHedgingDelayNanosFromHedgingPolicy(map), (Object)"hedgingDelay cannot be empty");
            b.a(l2 >= 0L, "hedgingDelay must not be negative: %s", l2);
            return new HedgingPolicy(n3, l2, ServiceConfigUtil.getNonFatalStatusCodesFromHedgingPolicy(map));
        }
    }
}

