/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.BinaryLog;
import com.appoptics.ext.io.grpc.CallCredentials;
import com.appoptics.ext.io.grpc.ClientInterceptor;
import com.appoptics.ext.io.grpc.CompressorRegistry;
import com.appoptics.ext.io.grpc.DecompressorRegistry;
import com.appoptics.ext.io.grpc.InternalChannelz;
import com.appoptics.ext.io.grpc.ManagedChannel;
import com.appoptics.ext.io.grpc.ManagedChannelBuilder;
import com.appoptics.ext.io.grpc.NameResolver;
import com.appoptics.ext.io.grpc.NameResolverRegistry;
import com.appoptics.ext.io.grpc.ProxyDetector;
import com.appoptics.ext.io.grpc.internal.ClientTransportFactory;
import com.appoptics.ext.io.grpc.internal.ExponentialBackoffPolicy;
import com.appoptics.ext.io.grpc.internal.GrpcUtil;
import com.appoptics.ext.io.grpc.internal.ManagedChannelImpl;
import com.appoptics.ext.io.grpc.internal.ManagedChannelOrphanWrapper;
import com.appoptics.ext.io.grpc.internal.ObjectPool;
import com.appoptics.ext.io.grpc.internal.OverrideAuthorityNameResolverFactory;
import com.appoptics.ext.io.grpc.internal.SharedResourcePool;
import com.appoptics.ext.io.grpc.internal.TimeProvider;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ManagedChannelImplBuilder
extends ManagedChannelBuilder<ManagedChannelImplBuilder> {
    private static final Logger log = Logger.getLogger(ManagedChannelImplBuilder.class.getName());
    static final long IDLE_MODE_DEFAULT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(30L);
    static final long IDLE_MODE_MIN_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final ObjectPool<? extends Executor> DEFAULT_EXECUTOR_POOL = SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
    private static final DecompressorRegistry DEFAULT_DECOMPRESSOR_REGISTRY = DecompressorRegistry.getDefaultInstance();
    private static final CompressorRegistry DEFAULT_COMPRESSOR_REGISTRY = CompressorRegistry.getDefaultInstance();
    ObjectPool<? extends Executor> executorPool = DEFAULT_EXECUTOR_POOL;
    ObjectPool<? extends Executor> offloadExecutorPool = DEFAULT_EXECUTOR_POOL;
    private final List<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
    final NameResolverRegistry nameResolverRegistry = NameResolverRegistry.getDefaultRegistry();
    private NameResolver.Factory nameResolverFactory = this.nameResolverRegistry.asFactory();
    final String target;
    final CallCredentials callCredentials;
    private final SocketAddress directServerAddress;
    String userAgent;
    private String authorityOverride;
    String defaultLbPolicy = "pick_first";
    boolean fullStreamDecompression;
    DecompressorRegistry decompressorRegistry = DEFAULT_DECOMPRESSOR_REGISTRY;
    CompressorRegistry compressorRegistry = DEFAULT_COMPRESSOR_REGISTRY;
    long idleTimeoutMillis = IDLE_MODE_DEFAULT_TIMEOUT_MILLIS;
    int maxRetryAttempts = 5;
    int maxHedgedAttempts = 5;
    long retryBufferSize = 0x1000000L;
    long perRpcBufferLimit = 0x100000L;
    boolean retryEnabled = false;
    boolean temporarilyDisableRetry;
    InternalChannelz channelz = InternalChannelz.instance();
    int maxTraceEvents;
    Map<String, ?> defaultServiceConfig;
    boolean lookUpServiceConfig = true;
    BinaryLog binlog;
    ProxyDetector proxyDetector;
    private boolean statsEnabled = true;
    private boolean recordStartedRpcs = true;
    private boolean recordFinishedRpcs = true;
    private boolean recordRealTimeMetrics = false;
    private boolean tracingEnabled = true;
    private final ClientTransportFactoryBuilder clientTransportFactoryBuilder;
    private final ChannelBuilderDefaultPortProvider channelBuilderDefaultPortProvider;

    public ManagedChannelImplBuilder(String string, ClientTransportFactoryBuilder clientTransportFactoryBuilder, ChannelBuilderDefaultPortProvider channelBuilderDefaultPortProvider) {
        this(string, null, clientTransportFactoryBuilder, channelBuilderDefaultPortProvider);
    }

    public ManagedChannelImplBuilder(String string, CallCredentials callCredentials, ClientTransportFactoryBuilder clientTransportFactoryBuilder, ChannelBuilderDefaultPortProvider channelBuilderDefaultPortProvider) {
        this.target = b.a(string, (Object)"target");
        this.callCredentials = callCredentials;
        this.clientTransportFactoryBuilder = b.a(clientTransportFactoryBuilder, (Object)"clientTransportFactoryBuilder");
        this.directServerAddress = null;
        if (channelBuilderDefaultPortProvider != null) {
            this.channelBuilderDefaultPortProvider = channelBuilderDefaultPortProvider;
            return;
        }
        this.channelBuilderDefaultPortProvider = new ManagedChannelDefaultPortProvider();
    }

    @Override
    public final ManagedChannelImplBuilder proxyDetector(ProxyDetector proxyDetector) {
        this.proxyDetector = proxyDetector;
        return this;
    }

    @Override
    public final ManagedChannel build() {
        ManagedChannelImplBuilder managedChannelImplBuilder = this;
        return new ManagedChannelOrphanWrapper(new ManagedChannelImpl(managedChannelImplBuilder, managedChannelImplBuilder.clientTransportFactoryBuilder.buildClientTransportFactory(), new ExponentialBackoffPolicy.Provider(), SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR), GrpcUtil.STOPWATCH_SUPPLIER, this.getEffectiveInterceptors(), TimeProvider.SYSTEM_TIME_PROVIDER));
    }

    final List<ClientInterceptor> getEffectiveInterceptors() {
        GenericDeclaration genericDeclaration;
        ClientInterceptor clientInterceptor;
        ArrayList<ClientInterceptor> arrayList = new ArrayList<ClientInterceptor>(this.interceptors);
        this.temporarilyDisableRetry = false;
        if (this.statsEnabled) {
            this.temporarilyDisableRetry = true;
            clientInterceptor = null;
            try {
                genericDeclaration = Class.forName("com.appoptics.ext.io.grpc.census.InternalCensusStatsAccessor");
                genericDeclaration = genericDeclaration.getDeclaredMethod("getClientInterceptor", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                clientInterceptor = (ClientInterceptor)((Method)genericDeclaration).invoke(null, this.recordStartedRpcs, this.recordFinishedRpcs, this.recordRealTimeMetrics);
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.log(Level.FINE, "Unable to apply census stats", classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                log.log(Level.FINE, "Unable to apply census stats", noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.log(Level.FINE, "Unable to apply census stats", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                log.log(Level.FINE, "Unable to apply census stats", invocationTargetException);
            }
            if (clientInterceptor != null) {
                arrayList.add(0, clientInterceptor);
            }
        }
        if (this.tracingEnabled) {
            this.temporarilyDisableRetry = true;
            clientInterceptor = null;
            try {
                genericDeclaration = Class.forName("com.appoptics.ext.io.grpc.census.InternalCensusTracingAccessor");
                genericDeclaration = genericDeclaration.getDeclaredMethod("getClientInterceptor", new Class[0]);
                clientInterceptor = (ClientInterceptor)((Method)genericDeclaration).invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.log(Level.FINE, "Unable to apply census stats", classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                log.log(Level.FINE, "Unable to apply census stats", noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.log(Level.FINE, "Unable to apply census stats", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                log.log(Level.FINE, "Unable to apply census stats", invocationTargetException);
            }
            if (clientInterceptor != null) {
                arrayList.add(0, clientInterceptor);
            }
        }
        return arrayList;
    }

    final int getDefaultPort() {
        return this.channelBuilderDefaultPortProvider.getDefaultPort();
    }

    final NameResolver.Factory getNameResolverFactory() {
        if (this.authorityOverride == null) {
            return this.nameResolverFactory;
        }
        return new OverrideAuthorityNameResolverFactory(this.nameResolverFactory, this.authorityOverride);
    }

    public final ObjectPool<? extends Executor> getOffloadExecutorPool() {
        return this.offloadExecutorPool;
    }

    private static final class ManagedChannelDefaultPortProvider
    implements ChannelBuilderDefaultPortProvider {
        private ManagedChannelDefaultPortProvider() {
        }

        public final int getDefaultPort() {
            return 443;
        }
    }

    public static interface ChannelBuilderDefaultPortProvider {
        public int getDefaultPort();
    }

    public static interface ClientTransportFactoryBuilder {
        public ClientTransportFactory buildClientTransportFactory();
    }
}

